/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.BgyRequestOrderStatusUpdateApproveAtomService;
import com.tydic.uoc.common.atom.api.UocCoreChgVoucherStateAtomService;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderStatusUpdateApproveAtomReqBo;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderStatusUpdateApproveAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.uoc.common.atom.bo.VoucherStateBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStateChgLogMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStateChgLogPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocCoreChgVoucherStateAtomService")
public class UocCoreChgVoucherStateAtomServiceImpl
implements UocCoreChgVoucherStateAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreChgVoucherStateAtomServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdStateChgLogMapper ordStateChgLogMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Value(value="${sale.purchase.sync:false}")
    private Boolean salePurchaseSync;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private BgyRequestOrderStatusUpdateApproveAtomService bgyRequestOrderStatusUpdateApproveAtomService;

    @Override
    public UocCoreChgVoucherStateRspBO dealCoreChgVoucherState(UocCoreChgVoucherStateReqBO reqBO) {
        this.validParam(reqBO);
        Long orderId = reqBO.getOrderId();
        String operId = reqBO.getOperId();
        UocCoreChgVoucherStateRspBO rspBO = new UocCoreChgVoucherStateRspBO();
        ArrayList<OrdStateChgLogPO> logList = new ArrayList<OrdStateChgLogPO>();
        try {
            for (VoucherStateBO voucherState : reqBO.getVoucherStateList()) {
                OrdStateChgLogPO ordStateChgLogPo = new OrdStateChgLogPO();
                ordStateChgLogPo.setOrderId(orderId);
                ordStateChgLogPo.setOperId(operId);
                StringBuilder extDesc = new StringBuilder();
                extDesc.append("[objType=").append(voucherState.getObjType()).append("\uff0cobjId=").append(voucherState.getObjId()).append("]");
                int updateRow = this.doChangeObjState(orderId, voucherState, ordStateChgLogPo, reqBO);
                if (updateRow == -1) {
                    ordStateChgLogPo.setStateType("unknown");
                    ordStateChgLogPo.setChgDesc(extDesc.insert(0, "objType\u672a\u5b9a\u4e49\uff0c\u8df3\u8fc7\u72b6\u6001\u66f4\u65b0").toString());
                } else if (updateRow == 1 && StringUtils.isNotBlank((CharSequence)reqBO.getDealDesc())) {
                    if (!UocConstant.OBJ_TYPE.REQUEST.equals(voucherState.getObjType())) {
                        OrderPO orderPo = new OrderPO();
                        orderPo.setOrderId(orderId);
                        orderPo.setUpdateTime(new Date());
                        this.orderMapper.updateById(orderPo);
                    }
                    ordStateChgLogPo.setChgDesc(extDesc.insert(0, reqBO.getDealDesc()).toString());
                } else if (updateRow == 0) {
                    ordStateChgLogPo.setChgDesc(extDesc.insert(0, "\u66f4\u65b0\u8be5\u8ba2\u5355\u72b6\u6001\u5931\u8d25").toString());
                }
                ordStateChgLogPo.setId(Long.valueOf(this.sequence.nextId()));
                if (UocConstant.OBJ_TYPE.REQUEST.equals(voucherState.getObjType())) {
                    ordStateChgLogPo.setStateType("A12");
                }
                logList.add(ordStateChgLogPo);
            }
            this.ordStateChgLogMapper.insertBatch(logList);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5355\u636e\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("101026");
            rspBO.setRespDesc("\u66f4\u65b0\u5355\u636e\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u636e\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        return rspBO;
    }

    private void validParam(UocCoreChgVoucherStateReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getOperId()) || reqBO.getOrderId() == null || CollectionUtils.isEmpty(reqBO.getVoucherStateList())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355ID\u3001\u66f4\u65b0\u5355\u636e\u548c\u5904\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (VoucherStateBO voucherState : reqBO.getVoucherStateList()) {
            if (voucherState.getObjType() != null && voucherState.getAfterState() != null) continue;
            throw new UocProBusinessException("100002", "\u5355\u636e\u7c7b\u578b\u548c\u5355\u636e\u66f4\u65b0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private int doChangeObjState(Long orderId, VoucherStateBO voucherState, OrdStateChgLogPO ordStateChgLogPo, UocCoreChgVoucherStateReqBO reqBO) throws Exception {
        int updateRow;
        Integer objType = voucherState.getObjType();
        Long objId = voucherState.getObjId();
        Integer orderState = voucherState.getAfterState();
        Integer oldState = null;
        String stateType = null;
        if (UocConstant.OBJ_TYPE.ORDER.equals(objType)) {
            OrderPO orderQuery = new OrderPO();
            orderQuery.setOrderId(orderId);
            orderQuery = this.orderMapper.getModelBy(orderQuery);
            oldState = orderQuery.getOrderState();
            stateType = "A00";
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(orderId);
            orderPO.setOrderState(orderState);
            updateRow = this.orderMapper.updateById(orderPO);
        } else if (UocConstant.OBJ_TYPE.SALE.equals(objType)) {
            OrdSalePO ordSaleQuery = new OrdSalePO();
            ordSaleQuery.setOrderId(orderId);
            ordSaleQuery.setSaleVoucherId(objId);
            ordSaleQuery = this.ordSaleMapper.getModelBy(ordSaleQuery);
            oldState = ordSaleQuery.getSaleState();
            stateType = "A01";
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            ordSalePO.setSaleVoucherId(objId);
            ordSalePO.setSaleState(orderState);
            updateRow = this.ordSaleMapper.updateById(ordSalePO);
            if (this.salePurchaseSync != null && this.salePurchaseSync.booleanValue()) {
                OrdPurchasePO purchasePO = new OrdPurchasePO();
                purchasePO.setOrderId(orderId);
                purchasePO.setSaleVoucherId(objId);
                purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
                purchasePO.setPurchaseState(orderState);
                purchasePO.setSaleState(orderState);
                this.ordPurchaseMapper.updateById(purchasePO);
            }
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(orderId);
            orderPO.setUpdateTime(new Date());
            this.orderMapper.updateById(orderPO);
            String orderSource = ordSaleQuery.getOrderSource();
            if ("1".equals(orderSource) && "ACTPEB001".equals(reqBO.getActionCode()) && UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(ordSaleQuery.getSaleState())) {
                BgyRequestOrderStatusUpdateApproveAtomReqBo updateReqBo = new BgyRequestOrderStatusUpdateApproveAtomReqBo();
                updateReqBo.setRequestId(ordSaleQuery.getRequestId());
                BgyRequestOrderStatusUpdateApproveAtomRspBo updateRspBo = this.bgyRequestOrderStatusUpdateApproveAtomService.updateStatus(updateReqBo);
                if (!"0000".equals(updateRspBo.getRespCode())) {
                    throw new UocProBusinessException(updateRspBo.getRespCode(), "\u66f4\u65b0\u8bf7\u8d2d\u5355\u72b6\u6001\u5230\u5ba1\u6279\u4e2d\u9519\u8bef\uff1a" + updateRspBo.getRespDesc());
                }
            }
        } else if (UocConstant.OBJ_TYPE.PURCHASE.equals(objType)) {
            OrdPurchasePO purchasePO = new OrdPurchasePO();
            purchasePO.setOrderId(orderId);
            purchasePO.setPurchaseVoucherId(objId);
            purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
            oldState = purchasePO.getPurchaseState();
            stateType = "A06";
            OrdPurchasePO update = new OrdPurchasePO();
            update.setPurchaseVoucherId(objId);
            update.setPurchaseState(orderState);
            updateRow = this.ordPurchaseMapper.updateById(update);
        } else if (UocConstant.OBJ_TYPE.SHIP.equals(objType)) {
            OrdShipPO ordShipQuery = new OrdShipPO();
            ordShipQuery.setOrderId(orderId);
            ordShipQuery.setShipVoucherId(objId);
            ordShipQuery = this.ordShipMapper.getModelBy(ordShipQuery);
            oldState = Integer.valueOf(ordShipQuery.getShipStatus());
            stateType = "A02";
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(orderId);
            ordShipPO.setShipStatus(String.valueOf(orderState));
            ordShipPO.setShipVoucherId(objId);
            ordShipPO.setModifyTime(new Date());
            ordShipPO.setModifyOperId(ordStateChgLogPo.getOperId());
            updateRow = this.ordShipMapper.updateById(ordShipPO);
        } else if (UocConstant.OBJ_TYPE.INSPECTION.equals(objType)) {
            OrdInspectionPO ordInspectionQuery = new OrdInspectionPO();
            ordInspectionQuery.setOrderId(orderId);
            ordInspectionQuery.setInspectionVoucherId(objId);
            ordInspectionQuery = this.ordInspectionMapper.getModelBy(ordInspectionQuery);
            oldState = ordInspectionQuery.getInspectionState();
            stateType = "A03";
            OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
            ordInspectionPO.setOrderId(orderId);
            ordInspectionPO.setInspectionState(orderState);
            ordInspectionPO.setInspectionVoucherId(objId);
            updateRow = this.ordInspectionMapper.updateById(ordInspectionPO);
        } else if (UocConstant.OBJ_TYPE.AFTER_SERVICE.equals(objType)) {
            OrdAfterServicePO ordAfterServiceQuery = new OrdAfterServicePO();
            ordAfterServiceQuery.setOrderId(orderId);
            ordAfterServiceQuery.setAfterServId(objId);
            ordAfterServiceQuery = this.ordAfterServiceMapper.getModelBy(ordAfterServiceQuery);
            oldState = ordAfterServiceQuery.getServState();
            stateType = "A05";
            OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
            ordAfterServicePO.setOrderId(orderId);
            ordAfterServicePO.setServState(orderState);
            ordAfterServicePO.setAfterServId(objId);
            updateRow = this.ordAfterServiceMapper.updateById(ordAfterServicePO);
        } else if (UocConstant.OBJ_TYPE.PAY.equals(objType)) {
            OrdPayPO ordPayQuery = new OrdPayPO();
            ordPayQuery.setOrderId(orderId);
            ordPayQuery.setPayVoucherId(objId);
            ordPayQuery = this.ordPayMapper.getModelBy(ordPayQuery);
            oldState = ordPayQuery.getPayState();
            stateType = "A04";
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setOrderId(orderId);
            ordPayPO.setPayState(orderState);
            ordPayPO.setPayVoucherId(objId);
            updateRow = this.ordPayMapper.updateById(ordPayPO);
        } else if (UocConstant.OBJ_TYPE.REQUEST.equals(objType)) {
            UocOrdRequestPo updateRequestPo = new UocOrdRequestPo();
            updateRequestPo.setRequestId(orderId);
            updateRequestPo.setRequestStatus(orderState);
            stateType = "A12";
            updateRow = this.uocOrdRequestMapper.updateByPrimaryKeySelective(updateRequestPo);
        } else if (UocConstant.OBJ_TYPE.CANCEL.equals(objType)) {
            OrdCancelPO updateCancelPo = new OrdCancelPO();
            updateCancelPo.setStatus(orderState);
            updateCancelPo.setId(objId);
            updateRow = this.ordCancelMapper.updateById(updateCancelPo);
            stateType = "A13";
        } else {
            return -1;
        }
        ordStateChgLogPo.setOldState(oldState);
        ordStateChgLogPo.setNewState(orderState);
        ordStateChgLogPo.setStateType(stateType);
        return updateRow;
    }
}

