/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.atom.api.BgyPushArrivalNoteToISPAtomService;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.atom.api.UocCoreExtFieldInAtomService;
import com.tydic.uoc.common.atom.api.UocCoreOrderShipAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyPushArrivalNoteToISPAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyPushArrivalNoteToISPAtomRspBO;
import com.tydic.uoc.common.atom.bo.CommonCenterFieldValueBO;
import com.tydic.uoc.common.atom.bo.DeliveryInfo;
import com.tydic.uoc.common.atom.bo.DeliveryOrderDetail;
import com.tydic.uoc.common.atom.bo.DriverInfo;
import com.tydic.uoc.common.atom.bo.ShipCruxFieldBO;
import com.tydic.uoc.common.atom.bo.ShipExtFieldBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreExtFieldInRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrdSkuImeiReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrderShipRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipItemReqBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdSkuImeiMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.DicDictionary;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdSkuImeiPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocCoreOrderShipAtomService")
public class UocCoreOrderShipAtomServiceImpl
implements UocCoreOrderShipAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreOrderShipAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Value(value="${ship.name:-}")
    private String shipName;
    @Value(value="${ship.phone:-}")
    private String shipPhone;
    @Autowired
    private UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdSkuImeiMapper ordSkuImeiMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private BgyPushArrivalNoteToISPAtomService bgyPushArrivalNoteToISPAtomService;
    @Autowired
    private OrdGoodsMapper goodsMapper;
    @Autowired
    OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${mockIsp:true}")
    private boolean mockIsp;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;
    @Value(value="${shipCodeSwitch:true}")
    private boolean shipCodeSwitch;

    @Override
    public UocCoreOrderShipRspBO dealCoreOrderShip(UocCoreOrderShipReqBO uocCoreOrderShipReqBO) {
        BgyPushArrivalNoteToISPAtomRspBO bgyPushArrivalNoteToISPAtomRspBO;
        this.validataParams(uocCoreOrderShipReqBO);
        UocCoreOrderShipRspBO rspBO = new UocCoreOrderShipRspBO();
        List dicDictionaries = this.sysDicDictionaryMapper.selectByPCode("UOC_LOGISTICS_CODE");
        Map<String, String> logisMap = dicDictionaries.stream().collect(Collectors.toMap(DicDictionary::getCode, DicDictionary::getDescrip));
        OrdShipPO ordShipPo = new OrdShipPO();
        BeanUtils.copyProperties((Object)((Object)uocCoreOrderShipReqBO), (Object)ordShipPo);
        ordShipPo.setShipVoucherId(Long.valueOf(this.sequence.nextId()));
        if (uocCoreOrderShipReqBO.getIsStartProcess().booleanValue()) {
            UocProcessStartRspBO run = this.startProcess(ordShipPo.getShipVoucherId(), ordShipPo.getOrderId(), uocCoreOrderShipReqBO.getProcKey());
            ordShipPo.setShipStatus(run.getStepId());
            if (!ObjectUtil.isEmpty((Object)uocCoreOrderShipReqBO.getLogisticsExecutionUnit())) {
                ordShipPo.setShipCompanyId(uocCoreOrderShipReqBO.getLogisticsExecutionUnit());
                ordShipPo.setShipCompanyName(logisMap.get(uocCoreOrderShipReqBO.getLogisticsExecutionUnit()));
                ordShipPo.setShipCompanyNo(uocCoreOrderShipReqBO.getProcessNum());
            }
            ordShipPo.setCarNo(uocCoreOrderShipReqBO.getCarNo());
            if (!ObjectUtil.isEmpty((Object)uocCoreOrderShipReqBO.getTransportMode())) {
                ordShipPo.setTransportMode(Integer.valueOf(uocCoreOrderShipReqBO.getTransportMode()));
            }
            ordShipPo.setShipName(uocCoreOrderShipReqBO.getShipName());
        }
        if (ordShipPo.getShipTime() == null) {
            ordShipPo.setShipTime(new Date());
        }
        try {
            ordShipPo.setShipVoucherCode(this.buildNo("ORDER_FHD_NO"));
            int insertResult = this.ordShipMapper.insert(ordShipPo);
            if (insertResult == 0) {
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u53d1\u8d27\u5355\u5165\u5e93\u5931\u8d25");
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("101059");
            rspBO.setRespDesc("\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u65f6\u6570\u636e\u5e93\u5f02\u5e38!");
            log.error("\u521b\u5efa\u53d1\u8d27\u5355\u5931\u8d25", (Throwable)e);
            return rspBO;
        }
        List<UocCoreShipItemReqBO> shipItemBOList = uocCoreOrderShipReqBO.getShipItemList();
        for (UocCoreShipItemReqBO shipItemBO : shipItemBOList) {
            OrdShipItemPO ordShipItemPo = new OrdShipItemPO();
            BeanUtils.copyProperties((Object)((Object)shipItemBO), (Object)ordShipItemPo);
            ordShipItemPo.setShipVoucherId(ordShipPo.getShipVoucherId());
            ordShipItemPo.setShipItemId(Long.valueOf(this.sequence.nextId()));
            this.judgeCount(ordShipItemPo);
            try {
                int inserResult = this.ordShipItemMapper.insert(ordShipItemPo);
                if (inserResult == 0) {
                    throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u660e\u7ec6\u5931\u8d25");
                }
            }
            catch (Exception e) {
                if (this.isDebugEnabled) {
                    log.debug("\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                }
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
            if (CollectionUtils.isNotEmpty(shipItemBO.getOrdSkuImeiList())) {
                ArrayList<OrdSkuImeiPO> skuImeiPoList = new ArrayList<OrdSkuImeiPO>();
                for (UocCoreOrdSkuImeiReqBO ordSkuImeiRspBO : shipItemBO.getOrdSkuImeiList()) {
                    OrdSkuImeiPO ordSkuImeiPo = new OrdSkuImeiPO();
                    BeanUtils.copyProperties((Object)((Object)ordSkuImeiRspBO), (Object)ordSkuImeiPo);
                    ordSkuImeiPo.setShipItemId(ordShipItemPo.getShipItemId());
                    ordSkuImeiPo.setOrderId(ordShipItemPo.getOrderId());
                    ordSkuImeiPo.setOrdItemId(ordShipItemPo.getOrdItemId());
                    ordSkuImeiPo.setId(Long.valueOf(this.sequence.nextId()));
                    skuImeiPoList.add(ordSkuImeiPo);
                }
                this.ordSkuImeiMapper.insertBatch(skuImeiPoList);
            }
            OrdItemPO ordItemModel = new OrdItemPO();
            ordItemModel.setOrderId(uocCoreOrderShipReqBO.getOrderId());
            ordItemModel.setOrdItemId(shipItemBO.getOrdItemId());
            try {
                ordItemModel.setSendCount(shipItemBO.getSendCount());
                int updateResult = this.ordItemMapper.updateCounts(ordItemModel);
                if (updateResult != 0) continue;
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + shipItemBO.getOrdItemId() + "]\u53d1\u8d27\u6570\u91cf\u5931\u8d25");
            }
            catch (Exception e) {
                if (this.isDebugEnabled) {
                    log.debug("\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u6216\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u53d1\u8d27\u6570\u91cf\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                }
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u6216\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u53d1\u8d27\u6570\u91cf\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        if (!ObjectUtil.isEmpty(uocCoreOrderShipReqBO.getCruxFieldList()) || !ObjectUtil.isEmpty(uocCoreOrderShipReqBO.getExtFieldList())) {
            UocCoreExtFieldInRspBO uocCoreExtFieldInRspBO;
            UocCoreExtFieldInReqBO uocCoreExtFieldInReqBO = new UocCoreExtFieldInReqBO();
            uocCoreExtFieldInReqBO.setObjId(ordShipPo.getShipVoucherId());
            uocCoreExtFieldInReqBO.setObjType(Integer.valueOf("3"));
            uocCoreExtFieldInReqBO.setOrderId(uocCoreOrderShipReqBO.getOrderId());
            if (!ObjectUtil.isEmpty(uocCoreOrderShipReqBO.getCruxFieldList())) {
                ArrayList<CommonCenterFieldValueBO> cruxFieldValueBOList = new ArrayList<CommonCenterFieldValueBO>();
                for (ShipCruxFieldBO shipCruxFieldBO : uocCoreOrderShipReqBO.getCruxFieldList()) {
                    CommonCenterFieldValueBO cruxFieldValueBO = new CommonCenterFieldValueBO();
                    BeanUtils.copyProperties((Object)shipCruxFieldBO, (Object)cruxFieldValueBO);
                    cruxFieldValueBOList.add(cruxFieldValueBO);
                }
                uocCoreExtFieldInReqBO.setCruFieldList(cruxFieldValueBOList);
            }
            if (!ObjectUtil.isEmpty(uocCoreOrderShipReqBO.getExtFieldList())) {
                ArrayList<CommonCenterFieldValueBO> extFieldValueBOList = new ArrayList<CommonCenterFieldValueBO>();
                for (ShipExtFieldBO shipExtFieldBO : uocCoreOrderShipReqBO.getExtFieldList()) {
                    CommonCenterFieldValueBO extFieldValueBO = new CommonCenterFieldValueBO();
                    BeanUtils.copyProperties((Object)shipExtFieldBO, (Object)extFieldValueBO);
                    extFieldValueBOList.add(extFieldValueBO);
                }
                uocCoreExtFieldInReqBO.setExtFieldList(extFieldValueBOList);
            }
            if (!"0000".equals((uocCoreExtFieldInRspBO = this.uocCoreExtFieldInAtomService.dealCoreExtFieldIn(uocCoreExtFieldInReqBO)).getRespCode())) {
                throw new UocProBusinessException("101059", "\u6267\u884c\u53d1\u8d27\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + uocCoreExtFieldInRspBO.getRespDesc());
            }
        }
        OrdShipPO ordShipPO1 = new OrdShipPO();
        ordShipPO1.setShipVoucherId(ordShipPo.getShipVoucherId());
        OrdShipPO modelByShipCompanyNo = this.ordShipMapper.getModelBy(ordShipPO1);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(ordShipPo.getOrderId());
        List list = this.ordItemMapper.getList(ordItemPO);
        String offerDate = null;
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            Date offerDateReal = ((OrdItemPO)list.stream().sorted(new Comparator<OrdItemPO>(){

                @Override
                public int compare(OrdItemPO o1, OrdItemPO o2) {
                    return o1.getOfferDate().compareTo(o2.getOfferDate());
                }
            }).collect(Collectors.toList()).get(0)).getOfferDate();
            offerDate = new DateTime((Object)offerDateReal).toString("yyyy-MM-dd HH:mm:ss");
        }
        if (modelByShipCompanyNo == null) {
            throw new UocProBusinessException("100100", "\u63a8\u9001ISP\u8d27\u5355\u4fe1\u606f,\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25");
        }
        OrdLogisticsRelaPO logisticsRelaCondition = new OrdLogisticsRelaPO();
        logisticsRelaCondition.setOrderId(ordShipPo.getOrderId());
        OrdLogisticsRelaPO ordLogisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(logisticsRelaCondition);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(ordShipPo.getOrderId());
        OrderPO orderPo = this.orderMapper.getModelBy(orderPO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(ordShipPo.getOrderId());
        OrdSalePO ordSalePo = this.ordSaleMapper.getModelBy(ordSalePO);
        BgyPushArrivalNoteToISPAtomReqBO bgyPushArrivalNoteToISPAtomReqBO = new BgyPushArrivalNoteToISPAtomReqBO();
        bgyPushArrivalNoteToISPAtomReqBO.setDeliveryDate(DateUtil.dateToStrLong((Date)modelByShipCompanyNo.getShipTime()));
        bgyPushArrivalNoteToISPAtomReqBO.setProductScheduleDate(DateUtil.dateToStrLong((Date)modelByShipCompanyNo.getShipTime()));
        bgyPushArrivalNoteToISPAtomReqBO.setMallOrderCode(ordSalePo.getSaleVoucherNo());
        bgyPushArrivalNoteToISPAtomReqBO.setCdbillcode(orderPo.getNcOrderCode());
        bgyPushArrivalNoteToISPAtomReqBO.setReceivingAddress(this.buildReceivIngAddress(ordLogisticsRelaPO));
        bgyPushArrivalNoteToISPAtomReqBO.setOrderId(orderPo.getOrderId());
        if (ObjectUtil.isNotNull((Object)offerDate)) {
            bgyPushArrivalNoteToISPAtomReqBO.setReceivingDate(offerDate);
            Date date = DateUtil.strToDateLong((String)offerDate);
            int hourOfDay = date.getHours();
            if (hourOfDay < 13) {
                bgyPushArrivalNoteToISPAtomReqBO.setSelectAmOrPm("am");
            } else {
                bgyPushArrivalNoteToISPAtomReqBO.setSelectAmOrPm("pm");
            }
        }
        DeliveryInfo deliveryInfo = new DeliveryInfo();
        deliveryInfo.setDeliveryDate(DateUtil.dateToStrLong((Date)modelByShipCompanyNo.getShipTime()));
        if (ObjectUtil.isNotNull((Object)offerDate)) {
            deliveryInfo.setEstimatedArrival(offerDate);
        }
        ArrayList<DriverInfo> driverInfos = new ArrayList<DriverInfo>();
        if (ObjectUtil.isNull((Object)ordSalePo)) {
            throw new UocProBusinessException("100100", "\u63a8\u9001isp\u8ba2\u5355\uff0c\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u9500\u552e\u5355");
        }
        String orderSource = ordSalePo.getOrderSource();
        if ("2".equals(orderSource)) {
            deliveryInfo.setDeliveryMethodEnum("LOGISTICS");
            deliveryInfo.setLogisticsNum(modelByShipCompanyNo.getShipId());
            deliveryInfo.setLogisticsCompany(modelByShipCompanyNo.getShipCompanyName());
        } else if (Integer.valueOf("1").equals(ordShipPo.getTransportMode())) {
            deliveryInfo.setDeliveryMethodEnum("CAR_DISTRIBUTION");
            DriverInfo driverInfo = new DriverInfo();
            driverInfo.setCarNum(ordShipPo.getCarNo());
            driverInfo.setDriverName(ObjectUtil.isEmpty((Object)modelByShipCompanyNo.getShipName()) ? this.shipName : modelByShipCompanyNo.getShipName());
            driverInfo.setDriverPhone(ObjectUtil.isEmpty((Object)modelByShipCompanyNo.getShipPhone()) ? this.shipPhone : modelByShipCompanyNo.getShipPhone());
            driverInfos.add(driverInfo);
            deliveryInfo.setDriverDtoList(driverInfos);
        } else {
            deliveryInfo.setDeliveryMethodEnum("LOGISTICS");
            deliveryInfo.setLogisticsNum(modelByShipCompanyNo.getShipCompanyNo());
            String shipCompanyId = modelByShipCompanyNo.getShipCompanyId();
            DicDictionaryBO listByPCodeAndOrderId = this.dicDictionaryService.selectdictionaryByCodeAndCode("UOC_LOGISTICS_CODE", shipCompanyId);
            if (ObjectUtil.isNotNull((Object)listByPCodeAndOrderId)) {
                deliveryInfo.setLogisticsCompany(listByPCodeAndOrderId.getDescrip());
            }
        }
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(ordSalePo.getRequestId());
        Integer costType = uocOrdRequestPo.getCostType();
        bgyPushArrivalNoteToISPAtomReqBO.setDeliveryDto(deliveryInfo);
        ArrayList<DeliveryOrderDetail> deliveryOrderDetails = new ArrayList<DeliveryOrderDetail>();
        List<UocCoreShipItemReqBO> shipItemList = uocCoreOrderShipReqBO.getShipItemList();
        for (UocCoreShipItemReqBO uocCoreShipItemReqBO : shipItemList) {
            DeliveryOrderDetail deliveryOrderDetail = new DeliveryOrderDetail();
            Long ordItemId = uocCoreShipItemReqBO.getOrdItemId();
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrdItemId(ordItemId);
            OrdGoodsPO modelBy = this.goodsMapper.getModelBy(ordGoodsPO);
            if (modelBy == null) {
                throw new UocProBusinessException("100100", "\u63a8\u9001ISP\u8d27\u5355\u4fe1\u606f,\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
            }
            if (UocConstant.CostType.ASSET.equals(costType)) {
                deliveryOrderDetail.setMaterialCode(modelBy.getNcMaterialCode());
            } else {
                deliveryOrderDetail.setMaterialCode(modelBy.getSkuMaterialId());
            }
            deliveryOrderDetail.setCarryNum(uocCoreShipItemReqBO.getSendCount().toPlainString());
            deliveryOrderDetail.setPlanCarryNum(uocCoreShipItemReqBO.getSendCount().toPlainString());
            deliveryOrderDetails.add(deliveryOrderDetail);
        }
        bgyPushArrivalNoteToISPAtomReqBO.setDeliveryOrderDetailDtoList(deliveryOrderDetails);
        bgyPushArrivalNoteToISPAtomReqBO.setDeliveryOrderCode(modelByShipCompanyNo.getShipVoucherCode());
        if (this.mockIsp && !"200".equals((bgyPushArrivalNoteToISPAtomRspBO = this.bgyPushArrivalNoteToISPAtomService.pushArrivalNote(bgyPushArrivalNoteToISPAtomReqBO)).getReturnCode())) {
            throw new UocProBusinessException("100100", "\u63a8\u9001ISP\u8d27\u5355\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + bgyPushArrivalNoteToISPAtomRspBO.getReturnMsg());
        }
        rspBO.setShipVoucherId(ordShipPo.getShipVoucherId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efa\u53d1\u8d27\u5355\u3001\u53d1\u8d27\u5355\u660e\u7ec6\u6210\u529f");
        return rspBO;
    }

    private String buildNo(String voucherNoKey) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102033", voucherNoRsp.getRespDesc());
        }
        String voucherNo = voucherNoRsp.getVoucherNo();
        if (this.shipCodeSwitch) {
            String substring = voucherNo.substring(0, 2);
            String substring1 = voucherNo.substring(4);
            return substring + substring1;
        }
        return voucherNo;
    }

    private void sendMessageShip(OrdSalePO ordSalePO, OrdShipPO modelByShipCompanyNo, String offerDate) {
        Long requestId = ordSalePO.getRequestId();
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
        sendMessageBo.setSendId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setRecId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setNoticeNodeCode("20014");
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", ordSalePO.getSaleVoucherNo()));
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u53d1\u8d27\u5355\u7f16\u53f7#}", modelByShipCompanyNo.getShipVoucherCode()));
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9884\u8ba1\u5230\u8d27\u65e5\u671f#}", offerDate));
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u8bf7\u8d2d\u5355\u7f16\u53f7#}", ordSalePO.getRequestCode()));
        this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
    }

    private void validataParams(UocCoreOrderShipReqBO uocCoreOrderShipReqBO) {
        if (uocCoreOrderShipReqBO.getOrderId() == null || uocCoreOrderShipReqBO.getOrderId() == 0L) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)uocCoreOrderShipReqBO.getShipStatus())) {
            throw new UocProBusinessException("100002", "\u53d1\u8d27\u72b6\u6001[shipStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uocCoreOrderShipReqBO.getShipItemList() == null || uocCoreOrderShipReqBO.getShipItemList().isEmpty()) {
            throw new UocProBusinessException("100002", "\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868[shipItemList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocCoreShipItemReqBO uocCoreShipItemReqBO : uocCoreOrderShipReqBO.getShipItemList()) {
            if (uocCoreShipItemReqBO.getOrdItemId() == null || uocCoreShipItemReqBO.getOrdItemId() == 0L) {
                throw new UocProBusinessException("100002", "\u53d1\u8d27\u5355\u660e\u7ec6\u4e2d\u9500\u552e\u8ba2\u5355\u660e\u7ec6ID[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (uocCoreShipItemReqBO.getOrderId() != null && uocCoreShipItemReqBO.getOrderId() != 0L) continue;
            throw new UocProBusinessException("100002", "\u53d1\u8d27\u5355\u660e\u7ec6\u4e2d\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildReceivIngAddress(OrdLogisticsRelaPO ordLogisticsRelaRspBO) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (ordLogisticsRelaRspBO == null) {
            return stringBuilder.toString();
        }
        if (ObjectUtil.isNotEmpty((Object)ordLogisticsRelaRspBO.getContactCountryName())) {
            stringBuilder.append(ordLogisticsRelaRspBO.getContactCountryName());
        }
        if (ObjectUtil.isNotEmpty((Object)ordLogisticsRelaRspBO.getContactProvinceName())) {
            stringBuilder.append(ordLogisticsRelaRspBO.getContactProvinceName());
        }
        if (ObjectUtil.isNotEmpty((Object)ordLogisticsRelaRspBO.getContactCityName())) {
            stringBuilder.append(ordLogisticsRelaRspBO.getContactCityName());
        }
        if (ObjectUtil.isNotEmpty((Object)ordLogisticsRelaRspBO.getContactCountyName())) {
            stringBuilder.append(ordLogisticsRelaRspBO.getContactCountyName());
        }
        if (ObjectUtil.isNotEmpty((Object)ordLogisticsRelaRspBO.getContactTown())) {
            stringBuilder.append(ordLogisticsRelaRspBO.getContactTown());
        }
        if (ObjectUtil.isNotEmpty((Object)ordLogisticsRelaRspBO.getContactAddress())) {
            stringBuilder.append(ordLogisticsRelaRspBO.getContactAddress());
        }
        return stringBuilder.toString();
    }

    private UocProcessStartRspBO startProcess(Long objId, Long orderId, String procKey) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        if (StringUtils.isNotBlank((CharSequence)procKey)) {
            processStartReqBO.setProcDefKey(procKey);
        } else {
            processStartReqBO.setProcDefKey("status_of_invoice");
        }
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setObjId(objId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        processStartReqBO.setOrderId(orderId);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        processStartReqBO.setVariables(map);
        UocProcessStartRspBO processStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(processStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101059", "\u901a\u8fc7\u5165\u53c2\uff1a" + processStartReqBO.toString() + "\u542f\u52a8\u72b6\u6001\u673a\u5931\u8d25\u539f\u56e0\uff1a" + processStartRspBO.getRespDesc());
        }
        return processStartRspBO;
    }

    private void judgeCount(OrdShipItemPO ordShipItemPO) {
        if (null == ordShipItemPO.getSendCount()) {
            ordShipItemPO.setSendCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getArriveCount()) {
            ordShipItemPO.setArriveCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getRefuseCount()) {
            ordShipItemPO.setRefuseCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getReturnCount()) {
            ordShipItemPO.setReturnCount(new BigDecimal(0));
        }
        if (null == ordShipItemPO.getAcceptanceCount()) {
            ordShipItemPO.setAcceptanceCount(new BigDecimal(0));
        }
    }
}

