/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.OrdPayItemRspBO;
import com.tydic.uoc.common.ability.bo.PayOrdPayRspBO;
import com.tydic.uoc.common.atom.api.UocCorePayOrderDetailQueryAtomService;
import com.tydic.uoc.common.atom.bo.UocCorePayOrderDetailQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCorePayOrderDetailQueryRspBO;
import com.tydic.uoc.common.atom.bo.UocCorePayOrderDetailRspBO;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCorePayOrderDetailQueryAtomService")
public class UocCorePayOrderDetailQueryAtomServiceImpl
implements UocCorePayOrderDetailQueryAtomService {
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;

    @Override
    public UocCorePayOrderDetailQueryRspBO getPayOrderDetailQuery(UocCorePayOrderDetailQueryReqBO reqBO) {
        UocCorePayOrderDetailQueryRspBO rspBO = new UocCorePayOrderDetailQueryRspBO();
        this.validateParams(reqBO);
        List<UocCorePayOrderDetailRspBO> payOrderDetailRspBOS = this.buildPayOrderDetailRspBOList(reqBO);
        if (CollectionUtils.isEmpty(payOrderDetailRspBOS)) {
            rspBO.setRespCode("100001");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u652f\u4ed8\u5355\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            return rspBO;
        }
        rspBO.setPayOrderDetailRspBOList(payOrderDetailRspBOS);
        return rspBO;
    }

    private void validateParams(UocCorePayOrderDetailQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null != reqBO.getObjId()) {
            if (null == reqBO.getObjType()) {
                throw new UocProBusinessException("100001", "\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u4e3a\u7a7a\u7684\u8bdd\uff0c\u5bf9\u8c61\u7c7b\u578b\u3010objType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (0L == reqBO.getObjId()) {
                throw new UocProBusinessException("100001", "\u652f\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u96f6");
            }
        }
    }

    private List<UocCorePayOrderDetailRspBO> buildPayOrderDetailRspBOList(UocCorePayOrderDetailQueryReqBO reqBO) {
        ArrayList<UocCorePayOrderDetailRspBO> payOrderDetailRspBOList = new ArrayList<UocCorePayOrderDetailRspBO>();
        OrdPayPO payPO = new OrdPayPO();
        payPO.setOrderId(reqBO.getOrderId());
        payPO.setObjId(reqBO.getObjId());
        payPO.setObjType(reqBO.getObjType());
        payPO.setOrderBy("create_time desc");
        List ordPayPOList = this.ordPayMapper.getList(payPO);
        if (CollectionUtils.isEmpty((Collection)ordPayPOList)) {
            return payOrderDetailRspBOList;
        }
        for (OrdPayPO ordPayPO : ordPayPOList) {
            UocCorePayOrderDetailRspBO payOrderDetailRspBO = new UocCorePayOrderDetailRspBO();
            PayOrdPayRspBO ordPayRspBO = new PayOrdPayRspBO();
            BeanUtils.copyProperties((Object)ordPayPO, (Object)ordPayRspBO);
            try {
                ordPayRspBO.setPayMoney(UocMoneyUtil.long2BigDecimal((Long)ordPayPO.getPayFee()));
                ordPayRspBO.setTotalMoney(UocMoneyUtil.long2BigDecimal((Long)ordPayPO.getTotalFee()));
                if (!ObjectUtil.isEmpty((Object)ordPayPO.getReduceFee())) {
                    ordPayRspBO.setReduceMoney(UocMoneyUtil.long2BigDecimal((Long)ordPayPO.getReduceFee()));
                }
                if (!ObjectUtil.isEmpty((Object)ordPayPO.getRedEnvelopeFee())) {
                    ordPayRspBO.setRedEnvelopeMoney(UocMoneyUtil.long2BigDecimal((Long)ordPayPO.getRedEnvelopeFee()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("100001", "\u652f\u4ed8\u5355\u3010uoc_ord_pay\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            payOrderDetailRspBO.setOrdPayRspBO(ordPayRspBO);
            if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                payOrderDetailRspBO.setOrdPayItemRspBOList(this.buildOrdPayItemRspBOList(ordPayPO));
            }
            payOrderDetailRspBOList.add(payOrderDetailRspBO);
        }
        return payOrderDetailRspBOList;
    }

    private List<OrdPayItemRspBO> buildOrdPayItemRspBOList(OrdPayPO ordPayPO) {
        ArrayList<OrdPayItemRspBO> ordPayItemRspBOList = new ArrayList<OrdPayItemRspBO>();
        OrdPayItemPO payItemPO = new OrdPayItemPO();
        payItemPO.setOrderId(ordPayPO.getOrderId());
        payItemPO.setPayVoucherId(ordPayPO.getPayVoucherId());
        List ordPayItemPOList = this.ordPayItemMapper.getList(payItemPO);
        if (CollectionUtils.isNotEmpty((Collection)ordPayItemPOList)) {
            for (OrdPayItemPO ordPayItemPO : ordPayItemPOList) {
                OrdPayItemRspBO ordPayItemRspBO = new OrdPayItemRspBO();
                BeanUtils.copyProperties((Object)ordPayItemPO, (Object)ordPayItemRspBO);
                ordPayItemRspBOList.add(ordPayItemRspBO);
            }
        }
        return ordPayItemRspBOList;
    }
}

