/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.mall.ability.api.UccMallCurrentStockQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCommdStockBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuNumBO_busi;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.BgyOrdItemDataRspBo;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdGoodsGiftRspBO;
import com.tydic.uoc.common.ability.bo.OrdGoodsSaleRspBO;
import com.tydic.uoc.common.ability.bo.OrdPromotionRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleCouponRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleItemWtLogRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleMtLogRspBO;
import com.tydic.uoc.common.ability.bo.OrdSaleOrderRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipItemBO;
import com.tydic.uoc.common.ability.bo.SaleOrdItemRspBO;
import com.tydic.uoc.common.atom.api.UocCoreSalesSingleDetailsQueryAtomService;
import com.tydic.uoc.common.atom.api.UocOrdSkuImeiAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreOrdSkuImeiListRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOrdSkuImeiReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreSalesSingleDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreSalesSingleDetailsQueryRspBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsAttrMapper;
import com.tydic.uoc.dao.OrdGoodsGiftMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapWtLogMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdItemWtLogMapper;
import com.tydic.uoc.dao.OrdPromotionMapper;
import com.tydic.uoc.dao.OrdSaleCouponMapper;
import com.tydic.uoc.dao.OrdSaleMapWtLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.uoc.dao.OrdSaleWtMainLogMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsAttrPO;
import com.tydic.uoc.po.OrdGoodsGiftPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemMapWtLogPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdItemWtLogPO;
import com.tydic.uoc.po.OrdPromotionPO;
import com.tydic.uoc.po.OrdSaleCouponPO;
import com.tydic.uoc.po.OrdSaleMapWtLogPO;
import com.tydic.uoc.po.OrdSaleMtLogPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdSaleWtMainLogPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdItemDataPo;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreSalesSingleDetailsQueryAtomService")
public class UocCoreSalesSingleDetailsQueryAtomServiceImpl
implements UocCoreSalesSingleDetailsQueryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreSalesSingleDetailsQueryAtomServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdSaleWtMainLogMapper ordSaleWtMainLogMapper;
    @Autowired
    private OrdSaleMtLogMapper ordSaleMtLogMapper;
    @Autowired
    private OrdSaleMapWtLogMapper ordSaleMapWtLogMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdGoodsAttrMapper ordGoodsAttrMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdItemWtLogMapper ordItemWtLogMapper;
    @Autowired
    private OrdItemMapWtLogMapper ordItemMapWtLogMapper;
    @Autowired
    private OrdPromotionMapper ordPromotionMapper;
    @Autowired
    private UocOrdSkuImeiAtomService uocOrdSkuImeiAtomService;
    @Autowired
    private OrdSaleCouponMapper ordSaleCouponMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdGoodsGiftMapper ordGoodsGiftMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private UocOrdRequestAddressMapper uocOrdRequestAddressMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private UccMallCurrentStockQryAbilityService uccMallCurrentStockQryAbilityService;

    @Override
    public UocCoreSalesSingleDetailsQueryRspBO getSalesSingleDetailsQuery(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        UocCoreSalesSingleDetailsQueryRspBO rspBO = new UocCoreSalesSingleDetailsQueryRspBO();
        OrdSaleMtLogRspBO ordSaleMtLogRspBO = this.buildOrdSaleMtLogRspBO(reqBO);
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT.equals(reqBO.getQueryLevel())) {
            OrdSaleOrderRspBO ordSaleRspBO = this.buildOrdSaleRspBO(reqBO);
            if (null == ordSaleRspBO) {
                rspBO.setRespCode("100001");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9500\u552e\u5355\u4fe1\u606f:" + reqBO.getOrderId());
                return rspBO;
            }
            rspBO.setOrdSaleRspBO(ordSaleRspBO);
            rspBO.setOrdSaleMtLogRspBO(ordSaleMtLogRspBO);
            rspBO.setOrdSaleCouponRspBOList(this.buildOrdSaleCouponRspBOList(reqBO));
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            rspBO.setSaleAccessoryList(this.buildAdjustAccessoryList(reqBO));
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            ArrayList<SaleOrdItemRspBO> itemRspBOS = new ArrayList<SaleOrdItemRspBO>();
            List<SaleOrdItemRspBO> ordItemRspBOList = this.buildOrdItemRspBOList(reqBO, ordSaleMtLogRspBO, itemRspBOS);
            rspBO.setItemInfo(itemRspBOS);
            if (CollectionUtils.isEmpty(ordItemRspBOList)) {
                if (UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u9500\u552e\u660e\u7ec6Item\u4fe1\u606f:" + reqBO.getOrderId());
                    return rspBO;
                }
            } else {
                rspBO.setOrdItemRspBOList(ordItemRspBOList);
            }
            if (null != rspBO.getOrdSaleRspBO() && null != rspBO.getOrdSaleRspBO().getSaleExtraMap() && "1".equals(rspBO.getOrdSaleRspBO().getSaleExtraMap().get("vendorOrderType")) && OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(this.qryStackHolder(reqBO.getOrderId()).getSupNo()) && CollectionUtils.isNotEmpty(itemRspBOS) && itemRspBOS.get(0) != null) {
                rspBO.getOrdSaleRspBO().setJdShipTime(DateUtils.dateToStr((Date)((SaleOrdItemRspBO)itemRspBOS.get(0)).getShipTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private OrdSaleOrderRspBO buildOrdSaleRspBO(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(salePO);
        if (null == ordSalePO) {
            return null;
        }
        OrdSaleOrderRspBO ordSaleRspBO = new OrdSaleOrderRspBO();
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        List extMapPOList = this.ordExtMapMapper.getList(ordExtMapPO);
        OrdCruxMapPO saleOrdCruxMapCondition = new OrdCruxMapPO();
        saleOrdCruxMapCondition.setOrderId(reqBO.getOrderId());
        saleOrdCruxMapCondition.setObjId(reqBO.getSaleVoucherId());
        saleOrdCruxMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        OrdCruxMapPO saleOrdCruxMapPO = this.ordCruxMapMapper.getModelBy(saleOrdCruxMapCondition);
        OrderPO orderPo = new OrderPO();
        orderPo.setOrderId(reqBO.getOrderId());
        if (null != saleOrdCruxMapPO) {
            ordSaleRspBO.setOutOrderNo(saleOrdCruxMapPO.getFieldValue1());
        }
        if (CollectionUtils.isNotEmpty((Collection)extMapPOList)) {
            for (OrdExtMapPO extMapPO : extMapPOList) {
                if (extMapPO.getFieldCode().equals("erpOrder") && extMapPO.getObjType() == 20) {
                    ordSaleRspBO.setPurchasingMode(extMapPO.getFieldValue());
                }
                if ("vendorOrderType".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setVendorOrderType(extMapPO.getFieldValue());
                }
                if ("orderCategory".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setOrderCategory(Integer.valueOf(extMapPO.getFieldValue()));
                }
                if ("busiMode".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setBusiMode(extMapPO.getFieldValue());
                }
                if ("delieveredTime".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setDelieveredTime(extMapPO.getFieldValue());
                }
                if ("inspectionTime".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setInspectionTime(extMapPO.getFieldValue());
                }
                if ("paymentDays".equals(extMapPO.getFieldCode())) {
                    ordSaleRspBO.setPaymentDays(extMapPO.getFieldValue());
                }
                if (Integer.valueOf(1).equals(ordSaleRspBO.getOrderCategory()) || ordSaleRspBO.getDelieveredTime() == null) continue;
                String paymentDays = ordSaleRspBO.getPaymentDays();
                try {
                    if (null == paymentDays) continue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(DateUtils.strToDateLong((String)ordSaleRspBO.getDelieveredTime()));
                    calendar.add(5, Integer.parseInt(paymentDays));
                    ordSaleRspBO.setPaymentTime(DateUtils.dateToStrLong((Date)calendar.getTime()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        BeanUtils.copyProperties((Object)ordSalePO, (Object)ordSaleRspBO);
        try {
            ordSaleRspBO.setPurchaseMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getPurchaseFee()));
            ordSaleRspBO.setSaleMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getSaleFee()));
            ordSaleRspBO.setBaseTransMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getBaseTransFee()));
            if (ordSalePO.getDisPrice() != null) {
                ordSaleRspBO.setDisPriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getDisPrice()));
            }
            ordSaleRspBO.setRemoteTransMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getRemoteTransFee()));
            if (ordSalePO.getTotalIntegralFee() != null) {
                ordSaleRspBO.setTotalIntegralMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getTotalIntegralFee()));
            }
            if (ordSalePO.getTotalUsedIntegral() != null) {
                ordSaleRspBO.setUsedIntegral(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getTotalUsedIntegral()));
            }
            if (ordSalePO.getTotalIntegralFee() != null) {
                ordSaleRspBO.setIntegralFee(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getTotalIntegralFee()));
            }
            if (ordSalePO.getTotalTransFee() != null) {
                ordSaleRspBO.setTotalTransMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getTotalTransFee()));
            }
            ordSaleRspBO.setOldTotalTransMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getOldTotalTransFee()));
            if (ordSalePO.getTotalActShareFee() != null) {
                ordSaleRspBO.setTotalActShareMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePO.getTotalActShareFee()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u3010uoc_ord_sale\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        ordSaleRspBO.setSaleExtraMap(this.buildSaleExtraInfoMap(reqBO));
        OrderPO modelById = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (!UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(ordSalePO.getSaleState()) && StringUtils.isNotBlank((CharSequence)modelById.getProcState())) {
            ordSaleRspBO.setSaleState(Integer.valueOf(modelById.getProcState()));
            ordSaleRspBO.setPurchaseState(Integer.valueOf(modelById.getProcState()));
        }
        if (null != modelById.getOrderType()) {
            ordSaleRspBO.setOrderType(modelById.getOrderType());
        }
        return ordSaleRspBO;
    }

    private Map<String, Object> buildSaleExtraInfoMap(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        HashMap<String, Object> orderExtraMap = new HashMap(16);
        OrdCruxMapPO saleOrdCruxMapCondition = new OrdCruxMapPO();
        saleOrdCruxMapCondition.setOrderId(reqBO.getOrderId());
        saleOrdCruxMapCondition.setObjId(reqBO.getSaleVoucherId());
        saleOrdCruxMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        OrdCruxMapPO saleOrdCruxMapPO = this.ordCruxMapMapper.getModelBy(saleOrdCruxMapCondition);
        if (saleOrdCruxMapPO != null) {
            orderExtraMap = this.getExtraMap(saleOrdCruxMapPO);
        }
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setObjId(reqBO.getSaleVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!CollectionUtils.isEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private Map<String, Object> getExtraMap(OrdCruxMapPO ordCruxMapPO) {
        HashMap<String, Object> extraMap = new HashMap<String, Object>(16);
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode1())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue1());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode2())) {
            extraMap.put(ordCruxMapPO.getFieldCode2(), ordCruxMapPO.getFieldValue2());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode3())) {
            extraMap.put(ordCruxMapPO.getFieldCode3(), ordCruxMapPO.getFieldValue3());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode4())) {
            extraMap.put(ordCruxMapPO.getFieldCode4(), ordCruxMapPO.getFieldValue4());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode5())) {
            extraMap.put(ordCruxMapPO.getFieldCode5(), ordCruxMapPO.getFieldValue5());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode6())) {
            extraMap.put(ordCruxMapPO.getFieldCode6(), ordCruxMapPO.getFieldValue6());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode7())) {
            extraMap.put(ordCruxMapPO.getFieldCode7(), ordCruxMapPO.getFieldValue7());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode8())) {
            extraMap.put(ordCruxMapPO.getFieldCode8(), ordCruxMapPO.getFieldValue8());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode9())) {
            extraMap.put(ordCruxMapPO.getFieldCode9(), ordCruxMapPO.getFieldValue9());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode10())) {
            extraMap.put(ordCruxMapPO.getFieldCode10(), ordCruxMapPO.getFieldValue10());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode11())) {
            extraMap.put(ordCruxMapPO.getFieldCode11(), ordCruxMapPO.getFieldValue11());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode12())) {
            extraMap.put(ordCruxMapPO.getFieldCode12(), ordCruxMapPO.getFieldValue12());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode13())) {
            extraMap.put(ordCruxMapPO.getFieldCode13(), ordCruxMapPO.getFieldValue13());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode14())) {
            extraMap.put(ordCruxMapPO.getFieldCode14(), ordCruxMapPO.getFieldValue14());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode15())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue15());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode16())) {
            extraMap.put(ordCruxMapPO.getFieldCode16(), ordCruxMapPO.getFieldValue16());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode17())) {
            extraMap.put(ordCruxMapPO.getFieldCode17(), ordCruxMapPO.getFieldValue17());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode18())) {
            extraMap.put(ordCruxMapPO.getFieldCode18(), ordCruxMapPO.getFieldValue18());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode19())) {
            extraMap.put(ordCruxMapPO.getFieldCode19(), ordCruxMapPO.getFieldValue19());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode20())) {
            extraMap.put(ordCruxMapPO.getFieldCode20(), ordCruxMapPO.getFieldValue20());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode21())) {
            extraMap.put(ordCruxMapPO.getFieldCode21(), ordCruxMapPO.getFieldValue21());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode22())) {
            extraMap.put(ordCruxMapPO.getFieldCode22(), ordCruxMapPO.getFieldValue22());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode23())) {
            extraMap.put(ordCruxMapPO.getFieldCode23(), ordCruxMapPO.getFieldValue23());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode24())) {
            extraMap.put(ordCruxMapPO.getFieldCode24(), ordCruxMapPO.getFieldValue24());
        }
        if (!StringUtils.isEmpty((CharSequence)ordCruxMapPO.getFieldCode25())) {
            extraMap.put(ordCruxMapPO.getFieldCode25(), ordCruxMapPO.getFieldValue25());
        }
        return extraMap;
    }

    private OrdSaleWtMainLogPO getOrdSaleWtMainLogPO(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdSaleWtMainLogPO saleWtMainLogCondition = new OrdSaleWtMainLogPO();
        saleWtMainLogCondition.setOrderId(reqBO.getOrderId());
        saleWtMainLogCondition.setSaleVoucherId(reqBO.getSaleVoucherId());
        saleWtMainLogCondition.setWtState(UocCoreConstant.WT_STATE.PENDING);
        OrdSaleWtMainLogPO ordSaleWtMainLogPO = this.ordSaleWtMainLogMapper.getModelBy(saleWtMainLogCondition);
        return ordSaleWtMainLogPO;
    }

    private OrdSaleMtLogRspBO buildOrdSaleMtLogRspBO(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdSaleMtLogRspBO ordSaleMtLogRspBO = new OrdSaleMtLogRspBO();
        OrdSaleMtLogPO saleMtLogCondition = new OrdSaleMtLogPO();
        saleMtLogCondition.setOrderId(reqBO.getOrderId());
        List ordSaleMtLogPOS = this.ordSaleMtLogMapper.getList(saleMtLogCondition);
        if (CollectionUtils.isNotEmpty((Collection)ordSaleMtLogPOS)) {
            OrdSaleMtLogPO ordSaleMtLogPO = (OrdSaleMtLogPO)ordSaleMtLogPOS.get(0);
            BeanUtils.copyProperties((Object)ordSaleMtLogPO, (Object)ordSaleMtLogRspBO);
            OrdSaleMapWtLogPO saleMapWtLogCondition = new OrdSaleMapWtLogPO();
            saleMapWtLogCondition.setWtId(ordSaleMtLogPO.getWtId());
            saleMapWtLogCondition.setOrderId(ordSaleMtLogPO.getOrderId());
            saleMapWtLogCondition.setSaleVoucherId(ordSaleMtLogPO.getSaleVoucherId());
            Map<String, Object> saleMapMtLog = this.qryOrdSaleMapWtLog(saleMapWtLogCondition);
            ordSaleMtLogRspBO.setSaleMtLogExtraMap(saleMapMtLog);
            BeanUtils.copyProperties((Object)ordSaleMtLogPO, (Object)ordSaleMtLogRspBO);
            return ordSaleMtLogRspBO;
        }
        return null;
    }

    private Map<String, Object> qryOrdSaleMapWtLog(OrdSaleMapWtLogPO saleMapWtLogCondition) {
        HashMap<String, Object> ordSaleMapWtLog = new HashMap<String, Object>();
        List ordSaleMapWtLogPOList = this.ordSaleMapWtLogMapper.getList(saleMapWtLogCondition);
        if (!CollectionUtils.isEmpty((Collection)ordSaleMapWtLogPOList)) {
            for (OrdSaleMapWtLogPO po : ordSaleMapWtLogPOList) {
                ordSaleMapWtLog.put(po.getFieldCode(), po.getNewFieldValue());
            }
        }
        return ordSaleMapWtLog;
    }

    private OrdStakeholderPO qryStackHolder(Long orderId) {
        return this.ordStakeholderMapper.getModelById(orderId.longValue());
    }

    private List<OrdAccessoryRspBO> buildAdjustAccessoryList(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getSaleVoucherId());
        ordAccessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.SALE);
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        ArrayList<OrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<OrdAccessoryRspBO>();
        if (CollectionUtils.isNotEmpty((Collection)ordAccessoryPOList)) {
            for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                ordAccessoryRspBOList.add(ordAccessoryRspBO);
            }
        }
        return ordAccessoryRspBOList;
    }

    private List<SaleOrdItemRspBO> buildOrdItemRspBOList(UocCoreSalesSingleDetailsQueryReqBO reqBO, OrdSaleMtLogRspBO ordSaleMtLogRspBO, List<SaleOrdItemRspBO> itemRspBOS) {
        List ordItemPOList;
        ArrayList<SaleOrdItemRspBO> ordItemRspBOList = new ArrayList<SaleOrdItemRspBO>();
        OrdItemPO condition = new OrdItemPO();
        condition.setOrderId(reqBO.getOrderId());
        condition.setSaleVoucherId(reqBO.getSaleVoucherId());
        if (CollectionUtils.isNotEmpty(reqBO.getItemIdList())) {
            condition.setOrdItemIdList(reqBO.getItemIdList());
        }
        if (CollectionUtils.isEmpty((Collection)(ordItemPOList = this.ordItemMapper.getList(condition)))) {
            return ordItemRspBOList;
        }
        UocOrdItemDataPo ordItemDataPo = new UocOrdItemDataPo();
        ordItemDataPo.setOrderId(reqBO.getOrderId());
        List ordItemDataPos = this.ordItemDataMapper.selectByPrimaryPoList(ordItemDataPo);
        List ordGoodsPOList = this.ordGoodsMapper.getListByOrderIdAndItemIds(reqBO.getOrderId(), ordItemPOList.stream().map(OrdItemPO::getOrdItemId).collect(Collectors.toList()));
        Map<Object, Object> stockMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)((OrdItemPO)ordItemPOList.get(0)).getSupplierShopId())) {
            stockMap = this.getStock(((UocOrdItemDataPo)ordItemDataPos.get(0)).getRequestId(), ((OrdItemPO)ordItemPOList.get(0)).getSupplierShopId(), ordItemPOList);
        }
        Map<Long, OrdGoodsPO> ordGoodsPOMap = ordGoodsPOList.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, o -> o));
        Map<Long, UocOrdItemDataPo> ordItemDataPoMap = ordItemDataPos.stream().collect(Collectors.toMap(UocOrdItemDataPo::getOrdItemId, uocOrdItemDataPo -> uocOrdItemDataPo));
        ArrayList<Long> ordItemIdList = new ArrayList<Long>();
        for (OrdItemPO ordItemPO : ordItemPOList) {
            ordItemIdList.add(ordItemPO.getOrdItemId());
            SaleOrdItemRspBO ordItemRspBO = new SaleOrdItemRspBO();
            BeanUtils.copyProperties((Object)ordItemPO, (Object)ordItemRspBO);
            try {
                ordItemRspBO.setPurchasePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getPurchasePrice()));
                ordItemRspBO.setSalePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getSalePrice()));
                ordItemRspBO.setTotalPurchaseMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getTotalPurchaseFee()));
                ordItemRspBO.setTotalSaleMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getTotalSaleFee()));
                if (ordItemRspBO.getNakedPrice() != null) {
                    ordItemRspBO.setNakedPriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getNakedPrice()));
                }
                if (ordItemRspBO.getTaxPrice() != null) {
                    ordItemRspBO.setTaxPriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getTaxPrice()));
                }
                if (ordItemRspBO.getDisPrice() != null) {
                    ordItemRspBO.setDisPriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getDisPrice()));
                }
                if (ordItemRspBO.getRedEnvelopeFee() != null) {
                    ordItemRspBO.setRedEnvelopeMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getRedEnvelopeFee()));
                }
            }
            catch (Exception e) {
                throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u660e\u7ec6Item\u3010uoc_ord_item\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            if (null != ordItemPO.getTax() && 0L != ordItemPO.getTax()) {
                BigDecimal tax = new BigDecimal(ordItemPO.getTax()).divide(new BigDecimal(100), 2, 4);
                ordItemRspBO.setNoTaxMoney(ordItemRspBO.getTotalSaleMoney().divide(tax.add(new BigDecimal(1)), 2, 4));
                ordItemRspBO.setTaxMoney(ordItemRspBO.getTotalSaleMoney().subtract(ordItemRspBO.getNoTaxMoney()));
            }
            BigDecimal max = ordItemPO.getArriveCount();
            if (ordItemPO.getRefuseCount() != null) {
                max = max.subtract(ordItemPO.getRefuseCount());
            }
            if (ordItemPO.getReturnCount() != null) {
                max = max.subtract(ordItemPO.getReturnCount());
            }
            if (null != ordGoodsPOMap.get(ordItemPO.getOrdItemId())) {
                ordItemRspBO.setSkuCode(ordGoodsPOMap.get(ordItemPO.getOrdItemId()).getSkuCode());
                ordItemRspBO.setModel(ordGoodsPOMap.get(ordItemPO.getOrdItemId()).getModel());
                ordItemRspBO.setSpec(ordGoodsPOMap.get(ordItemPO.getOrdItemId()).getSpec());
            }
            if (null != stockMap.get(ordItemPO.getSkuId())) {
                ordItemRspBO.setStock(((BigDecimal)stockMap.get(ordItemPO.getSkuId())).toString());
            }
            ordItemRspBO.setMaxAfsCount(max);
            ordItemRspBO.setOrdGoodsRspBO(this.buildOrdGoodsRspBO(ordItemRspBO));
            ordItemRspBO.setOrdGoodsGiftRspBOList(this.buildOrdItemGiftRspBO(ordItemRspBO));
            ordItemRspBO.setOrdPromotionRspBOList(this.buildOrdPromotionRspBOList(ordItemRspBO));
            OrdItemMapPO ordItemMapCondition = new OrdItemMapPO();
            ordItemMapCondition.setOrderId(reqBO.getOrderId());
            ordItemMapCondition.setOrderItemId(ordItemRspBO.getOrdItemId());
            ordItemRspBO.setOrdItemExtMap(this.getListToMap(ordItemMapCondition));
            if (ordSaleMtLogRspBO != null) {
                OrdItemWtLogPO itemWLogCondition = new OrdItemWtLogPO();
                itemWLogCondition.setWtId(ordSaleMtLogRspBO.getWtId());
                itemWLogCondition.setOrderId(ordSaleMtLogRspBO.getOrderId());
                itemWLogCondition.setOrdItemId(ordItemRspBO.getOrdItemId());
                List ordItemWtLogPOS = this.ordItemWtLogMapper.getList(itemWLogCondition);
                if (CollectionUtils.isNotEmpty((Collection)ordItemWtLogPOS)) {
                    OrdItemWtLogPO ordItemWtLogPO = (OrdItemWtLogPO)ordItemWtLogPOS.get(0);
                    OrdSaleItemWtLogRspBO ordItemWtLogRspBO = new OrdSaleItemWtLogRspBO();
                    BeanUtils.copyProperties((Object)ordItemWtLogPO, (Object)ordItemWtLogRspBO);
                    try {
                        ordItemWtLogRspBO.setSalePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemWtLogRspBO.getSalePrice()));
                        ordItemWtLogRspBO.setPurchasePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemWtLogRspBO.getPurchasePrice()));
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u660e\u7ec6Item\u65e5\u5fd7\u3010ord_item_wt_log\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
                    }
                    ordItemRspBO.setOrdItemWtLogRspBO(ordItemWtLogRspBO);
                    OrdItemMapWtLogPO ordItemMapWtLogCondition = new OrdItemMapWtLogPO();
                    ordItemMapWtLogCondition.setWtId(ordSaleMtLogRspBO.getWtId());
                    ordItemMapWtLogCondition.setOrderId(ordSaleMtLogRspBO.getOrderId());
                    ordItemMapWtLogCondition.setOrderItemId(ordItemRspBO.getOrdItemId());
                    Map<String, Object> itemMapMtLog = this.qryOrdItemMapWtLog(ordItemMapWtLogCondition);
                    ordItemWtLogRspBO.setOrdItemWtLogExtMap((Map)itemMapMtLog);
                    ordItemRspBO.setOrdItemWtLogRspBO(ordItemWtLogRspBO);
                    try {
                        ordItemRspBO.setPurchasePriceMoneyBefore(UocMoneyUtil.long2BigDecimal((Long)ordItemWtLogRspBO.getPurchasePrice()));
                        ordItemRspBO.setPurchasePriceMoneyRear(UocMoneyUtil.long2BigDecimal((Long)ordItemWtLogRspBO.getAdjustPurchasePrice()));
                        ordItemRspBO.setSalePriceMoneyBefore(UocMoneyUtil.long2BigDecimal((Long)ordItemWtLogRspBO.getSalePrice()));
                        ordItemRspBO.setSalePriceMoneyRear(UocMoneyUtil.long2BigDecimal((Long)ordItemWtLogRspBO.getAdjustSalePrice()));
                        ordItemRspBO.setMarkUpRate(ordItemWtLogRspBO.getOldAdjustRate());
                        ordItemRspBO.setMarkupRateRear(ordItemWtLogRspBO.getNewAdjustRate());
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("100001", "\u9500\u552e\u5355\u660e\u7ec6Item\u3010uoc_ord_item\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
                    }
                }
            }
            UocCoreOrdSkuImeiReqBO imeiReqBO = new UocCoreOrdSkuImeiReqBO();
            imeiReqBO.setOrdItemId(ordItemRspBO.getOrdItemId());
            imeiReqBO.setOrderId(ordItemRspBO.getOrderId());
            UocCoreOrdSkuImeiListRspBO unrImeiListRspBO = this.uocOrdSkuImeiAtomService.qryOrdSkuImeiList(imeiReqBO);
            if (unrImeiListRspBO.getRespCode().equals("0000")) {
                ordItemRspBO.setOrdSkuImeiRspBOList(unrImeiListRspBO.getList());
            }
            BgyOrdItemDataRspBo bgyOrdItemDataRspBo = new BgyOrdItemDataRspBo();
            BeanUtils.copyProperties((Object)ordItemDataPoMap.get(ordItemRspBO.getOrdItemId()), (Object)bgyOrdItemDataRspBo);
            ordItemRspBO.setOrdItemDataRspBo(bgyOrdItemDataRspBo);
            ordItemRspBOList.add(ordItemRspBO);
        }
        List shipByItemList = this.ordShipMapper.getShipByItemList(ordItemIdList);
        if (CollectionUtils.isNotEmpty((Collection)shipByItemList)) {
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(reqBO.getOrderId());
            ordShipPO.setSaleVoucherId(reqBO.getSaleVoucherId());
            List ordShipPOList = this.ordShipMapper.getList(ordShipPO);
            Map ordShipPOMap = null;
            if (CollectionUtils.isNotEmpty((Collection)ordShipPOList)) {
                ordShipPOMap = ordShipPOList.stream().collect(Collectors.toMap(OrdShipPO::getShipVoucherId, Function.identity(), (preOrdShipPO, sufOrdShipPO) -> preOrdShipPO));
            }
            Map<Long, List<OrdShipItemBO>> shipByItemMap = shipByItemList.stream().collect(Collectors.groupingBy(OrdShipItemBO::getOrdItemId));
            for (SaleOrdItemRspBO ordItemRspBO : ordItemRspBOList) {
                List<OrdShipItemBO> ordShipItemBOS = shipByItemMap.get(ordItemRspBO.getOrdItemId());
                int shipStatus = 8888;
                if (CollectionUtils.isNotEmpty(ordShipItemBOS)) {
                    BigDecimal count = BigDecimal.ZERO;
                    for (OrdShipItemBO ordShipItemBO : ordShipItemBOS) {
                        int shipStatusInt;
                        if (StringUtils.isNotBlank((CharSequence)ordShipItemBO.getShipStatus()) && shipStatus > (shipStatusInt = Integer.parseInt(ordShipItemBO.getShipStatus()))) {
                            shipStatus = shipStatusInt;
                        }
                        ordItemRspBO.setShipVoucherId(ordShipItemBO.getShipVoucherId());
                        count = count.add(ordShipItemBO.getSendCount());
                        SaleOrdItemRspBO newOrdItemRspBO = (SaleOrdItemRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)ordItemRspBO), SaleOrdItemRspBO.class);
                        newOrdItemRspBO.setSendCount(ordShipItemBO.getSendCount());
                        newOrdItemRspBO.setPurchaseCount(ordShipItemBO.getSendCount());
                        newOrdItemRspBO.setShipStatus(ordShipItemBO.getShipStatus());
                        newOrdItemRspBO.setTotalSaleFee(Long.valueOf(newOrdItemRspBO.getSalePrice() * newOrdItemRspBO.getPurchaseCount().longValue()));
                        newOrdItemRspBO.setTotalSaleMoney(newOrdItemRspBO.getSalePriceMoney().multiply(newOrdItemRspBO.getPurchaseCount()));
                        newOrdItemRspBO.setShipItemId(ordShipItemBO.getShipItemId());
                        newOrdItemRspBO.setArriveCount(ordShipItemBO.getArriveCount());
                        newOrdItemRspBO.setReturnCount(ordShipItemBO.getReturnCount());
                        newOrdItemRspBO.setRefuseCount(ordShipItemBO.getRefuseCount());
                        if (ordShipItemBO.getArriveCount() != null) {
                            BigDecimal max = ordShipItemBO.getArriveCount();
                            if (ordShipItemBO.getRefuseCount() != null) {
                                max = max.subtract(ordShipItemBO.getRefuseCount());
                            }
                            if (ordShipItemBO.getReturnCount() != null) {
                                max = max.subtract(ordShipItemBO.getReturnCount());
                            }
                            newOrdItemRspBO.setMaxAfsCount(max);
                        }
                        if (null != ordShipPOMap) {
                            OrdShipPO shipPO = (OrdShipPO)ordShipPOMap.get(ordShipItemBO.getShipVoucherId());
                            if (null != shipPO.getArriveTime()) {
                                newOrdItemRspBO.setArrivalTime(DateUtils.dateToStr((Date)shipPO.getArriveTime()));
                            } else {
                                newOrdItemRspBO.setArrivalTime(null);
                            }
                            if (null != shipPO.getShipTime()) {
                                newOrdItemRspBO.setShipTime(shipPO.getShipTime());
                            }
                        }
                        itemRspBOS.add(newOrdItemRspBO);
                    }
                    if (count.compareTo(ordItemRspBO.getPurchaseCount()) < 0) {
                        SaleOrdItemRspBO newOrdItemRspBO = (SaleOrdItemRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)ordItemRspBO), SaleOrdItemRspBO.class);
                        newOrdItemRspBO.setSendCount(ordItemRspBO.getPurchaseCount().subtract(count));
                        newOrdItemRspBO.setPurchaseCount(ordItemRspBO.getPurchaseCount().subtract(count));
                        newOrdItemRspBO.setTotalSaleMoney(newOrdItemRspBO.getSalePriceMoney().multiply(newOrdItemRspBO.getPurchaseCount()));
                        newOrdItemRspBO.setTotalSaleFee(Long.valueOf(newOrdItemRspBO.getSalePrice() * newOrdItemRspBO.getPurchaseCount().longValue()));
                        if (StringUtils.isNotBlank((CharSequence)newOrdItemRspBO.getArrivalTime())) {
                            newOrdItemRspBO.setArrivalTime(null);
                        }
                        itemRspBOS.add(newOrdItemRspBO);
                    }
                } else {
                    itemRspBOS.add(ordItemRspBO);
                }
                if (shipStatus == 8888) continue;
                ordItemRspBO.setShipStatus(shipStatus + "");
            }
        } else {
            itemRspBOS.addAll(ordItemRspBOList);
        }
        return ordItemRspBOList;
    }

    private Map<String, BigDecimal> getStock(Long requestId, Long supplierShopId, List<OrdItemPO> ordItemPOList) {
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        if (UocConstant.RequestType.CATALOG_OUT.equals(uocOrdRequestPo.getRequestType())) {
            return Maps.newHashMap();
        }
        UocOrdRequestAddressPo uocOrdRequestAddressPo = new UocOrdRequestAddressPo();
        uocOrdRequestAddressPo.setRequestId(requestId);
        uocOrdRequestAddressPo = this.uocOrdRequestAddressMapper.selectByPrimaryPo(uocOrdRequestAddressPo);
        UccMallCurrentStockQryReqBO uccMallCurrentStockQryReqBO = new UccMallCurrentStockQryReqBO();
        uccMallCurrentStockQryReqBO.setCity(Convert.toLong((Object)uocOrdRequestAddressPo.getContactCityId()));
        uccMallCurrentStockQryReqBO.setProvince(Convert.toLong((Object)uocOrdRequestAddressPo.getContactProvinceId()));
        uccMallCurrentStockQryReqBO.setTown(Convert.toLong((Object)uocOrdRequestAddressPo.getContactTownId()));
        uccMallCurrentStockQryReqBO.setCounty(Convert.toLong((Object)uocOrdRequestAddressPo.getContactCountyId()));
        List mallSkuNumBO_busiList = ordItemPOList.stream().map(ordItem -> {
            UccMallSkuNumBO_busi uccMallSkuNumBO_busi = new UccMallSkuNumBO_busi();
            uccMallSkuNumBO_busi.setSkuId(Convert.toLong((Object)ordItem.getSkuId()));
            uccMallSkuNumBO_busi.setNum(Convert.toLong((Object)ordItem.getPurchaseCount()));
            return uccMallSkuNumBO_busi;
        }).collect(Collectors.toList());
        uccMallCurrentStockQryReqBO.setSkuNum(mallSkuNumBO_busiList);
        uccMallCurrentStockQryReqBO.setSupplierShopId(supplierShopId);
        log.info("\u67e5\u8be2\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)uccMallCurrentStockQryReqBO));
        UccMallCurrentStockQryRspBO uccMallCurrentStockQryRspBO = this.uccMallCurrentStockQryAbilityService.qryStock(uccMallCurrentStockQryReqBO);
        if (!"0000".equals(uccMallCurrentStockQryRspBO.getRespCode())) {
            throw new UocProBusinessException("101082", StrUtil.format((CharSequence)"\u67e5\u8be2\u5546\u54c1\u4e2d\u5fc3\u5e93\u5b58\u5f02\u5e38\uff1a{}", (Object[])new Object[]{uccMallCurrentStockQryRspBO.getRespDesc()}));
        }
        if (CollectionUtils.isEmpty((Collection)uccMallCurrentStockQryRspBO.getCommdStockInfo())) {
            return new HashMap<String, BigDecimal>(0);
        }
        return uccMallCurrentStockQryRspBO.getCommdStockInfo().stream().collect(Collectors.toMap(UccMallCommdStockBO_busi::getSkuId, UccMallCommdStockBO_busi::getRemainNum));
    }

    private List<OrdGoodsGiftRspBO> buildOrdItemGiftRspBO(SaleOrdItemRspBO ordItemRspBO) {
        List<Object> ordGoodsGiftRspBOList = new ArrayList<OrdGoodsGiftRspBO>();
        OrdGoodsGiftPO ordGoodsGiftPO = new OrdGoodsGiftPO();
        ordGoodsGiftPO.setOrdItemId(ordItemRspBO.getOrdItemId());
        List giftPOList = this.ordGoodsGiftMapper.getList(ordGoodsGiftPO);
        if (CollectionUtils.isNotEmpty((Collection)giftPOList)) {
            ordGoodsGiftRspBOList = giftPOList.stream().map(PO -> {
                OrdGoodsGiftRspBO ordGoodsGiftRspBO = new OrdGoodsGiftRspBO();
                BeanUtils.copyProperties((Object)PO, (Object)ordGoodsGiftRspBO);
                return ordGoodsGiftRspBO;
            }).collect(Collectors.toList());
        }
        return ordGoodsGiftRspBOList;
    }

    private Map<String, Object> qryOrdItemMapWtLog(OrdItemMapWtLogPO ordItemMapWtLogCondition) {
        HashMap<String, Object> itemMapMtLog = new HashMap<String, Object>();
        List ordItemMapWtLogMapperList = this.ordItemMapWtLogMapper.getList(ordItemMapWtLogCondition);
        if (!CollectionUtils.isNotEmpty((Collection)ordItemMapWtLogMapperList)) {
            for (OrdItemMapWtLogPO po : ordItemMapWtLogMapperList) {
                itemMapMtLog.put(po.getFieldCode(), po.getNewFieldValue());
            }
        }
        return itemMapMtLog;
    }

    private Map<String, Object> getListToMap(OrdItemMapPO ordItemMapCondition) {
        List ordItemMapList = this.ordItemMapMapper.getList(ordItemMapCondition);
        HashMap<String, Object> itemExtMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)ordItemMapList)) {
            for (OrdItemMapPO ordItemMapPO : ordItemMapList) {
                itemExtMap.put(ordItemMapPO.getFieldCode(), ordItemMapPO.getFieldValue());
            }
        }
        return itemExtMap;
    }

    private Map<String, String> getGoodsAttrListToMap(OrdGoodsAttrPO ordGoodsAttrCondition) {
        List goodsAttrList = this.ordGoodsAttrMapper.getList(ordGoodsAttrCondition);
        HashMap<String, String> goodsAttrMaps = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)goodsAttrList)) {
            for (OrdGoodsAttrPO ordGoodsAttrPO : goodsAttrList) {
                goodsAttrMaps.put(ordGoodsAttrPO.getSkuPropShowName(), ordGoodsAttrPO.getSkuPropValue());
            }
        }
        return goodsAttrMaps;
    }

    private List<OrdSaleCouponRspBO> buildOrdSaleCouponRspBOList(UocCoreSalesSingleDetailsQueryReqBO reqBO) {
        ArrayList<OrdSaleCouponRspBO> ordSaleCouponRspBOList = new ArrayList<OrdSaleCouponRspBO>();
        OrdSaleCouponPO saleCouponPO = new OrdSaleCouponPO();
        saleCouponPO.setOrderId(reqBO.getOrderId());
        saleCouponPO.setSaleVoucherId(reqBO.getSaleVoucherId());
        List ordSaleCouponPOList = this.ordSaleCouponMapper.getList(saleCouponPO);
        if (CollectionUtils.isNotEmpty((Collection)ordSaleCouponPOList)) {
            for (OrdSaleCouponPO ordSaleCouponPO : ordSaleCouponPOList) {
                OrdSaleCouponRspBO ordSaleCouponRspBO = new OrdSaleCouponRspBO();
                BeanUtils.copyProperties((Object)ordSaleCouponPO, (Object)ordSaleCouponRspBO);
                ordSaleCouponRspBOList.add(ordSaleCouponRspBO);
            }
        }
        return ordSaleCouponRspBOList;
    }

    private OrdGoodsSaleRspBO buildOrdGoodsRspBO(SaleOrdItemRspBO ordItemRspBO) {
        OrdGoodsPO ordGoodsCondition = new OrdGoodsPO();
        ordGoodsCondition.setOrdItemId(ordItemRspBO.getOrdItemId());
        ordGoodsCondition.setOrderId(ordItemRspBO.getOrderId());
        OrdGoodsPO ordGoodsPO = this.ordGoodsMapper.getModelBy(ordGoodsCondition);
        OrdGoodsSaleRspBO goodsRspBO = new OrdGoodsSaleRspBO();
        if (ordGoodsPO != null) {
            BeanUtils.copyProperties((Object)ordGoodsPO, (Object)goodsRspBO);
            OrdGoodsAttrPO ordGoodsAttrCondition = new OrdGoodsAttrPO();
            ordGoodsAttrCondition.setGoodsItemId(ordGoodsPO.getGoodsItemId());
            ordGoodsAttrCondition.setOrderId(ordGoodsPO.getOrderId());
            Map<String, String> goodsAttrMap = this.getGoodsAttrListToMap(ordGoodsAttrCondition);
            goodsRspBO.setGoodsAttrMap(goodsAttrMap);
        }
        return goodsRspBO;
    }

    private List<OrdPromotionRspBO> buildOrdPromotionRspBOList(SaleOrdItemRspBO ordItemRspBO) {
        ArrayList<OrdPromotionRspBO> ordPromotionRspBOList = new ArrayList<OrdPromotionRspBO>();
        OrdPromotionPO ordPromotionCondition = new OrdPromotionPO();
        ordPromotionCondition.setOrderId(ordItemRspBO.getOrderId());
        ordPromotionCondition.setOrdItemId(ordItemRspBO.getOrdItemId());
        List promotionList = this.ordPromotionMapper.getList(ordPromotionCondition);
        ordItemRspBO.setOrdPromotionRspBOList(ordPromotionRspBOList);
        if (CollectionUtils.isNotEmpty((Collection)promotionList)) {
            for (OrdPromotionPO ordPromotionPO : promotionList) {
                OrdPromotionRspBO ordPromotionRspBO = new OrdPromotionRspBO();
                BeanUtils.copyProperties((Object)ordPromotionPO, (Object)ordPromotionRspBO);
                ordPromotionRspBOList.add(ordPromotionRspBO);
            }
        }
        return ordPromotionRspBOList;
    }
}

