/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.AfterServBO;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipRspBO;
import com.tydic.uoc.common.atom.api.UocCoreShipDetailsQueryAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreShipDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreShipDetailsQueryRspBO;
import com.tydic.uoc.common.atom.bo.UocProQryCommodityTypeReqBo;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdAsItemMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdAsItemPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.UocOrdItemDataPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreShipDetailsQueryAtomService")
public class UocCoreShipDetailsQueryAtomServiceImpl
implements UocCoreShipDetailsQueryAtomService {
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;

    @Override
    public UocCoreShipDetailsQueryRspBO getShipDetailsQuery(UocCoreShipDetailsQueryReqBO reqBO) {
        UocCoreShipDetailsQueryRspBO rspBO = new UocCoreShipDetailsQueryRspBO();
        this.validateParams(reqBO);
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY_NOT.equals(reqBO.getQueryLevel())) {
            OrdShipRspBO ordShipRspBO = this.buildOrdShipRspBO(reqBO);
            rspBO.setOrdShipRspBO(ordShipRspBO);
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_PRIMARY.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            rspBO.setShipAccessoryRspList(this.buildAdjustAccessoryList(reqBO));
        }
        if (UocCoreConstant.QUERY_LEVEL.QUERY_All.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
            List<OrdShipItemRspBO> ordShipItemRspBOList = this.buildOrdShipItemRspBOList(reqBO);
            if (CollectionUtils.isEmpty(ordShipItemRspBOList)) {
                if (UocCoreConstant.QUERY_LEVEL.QUERY_ITEM_NOT.equals(reqBO.getQueryLevel()) || UocCoreConstant.QUERY_LEVEL.QUERY_ITEM.equals(reqBO.getQueryLevel())) {
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u53d1\u8d27\u660e\u7ec6Item\u4fe1\u606f:" + reqBO.getOrderId());
                    return rspBO;
                }
            } else {
                rspBO.setOrdShipItemRspBOList(ordShipItemRspBOList);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocCoreShipDetailsQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getShipVoucherId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u53d1\u8d27\u5355ID\u3010shipVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getShipVoucherId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u53d1\u8d27\u5355ID\u3010shipVoucherId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private OrdShipRspBO buildOrdShipRspBO(UocCoreShipDetailsQueryReqBO reqBO) {
        OrdShipRspBO ordShipRspBO = new OrdShipRspBO();
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setOrderId(reqBO.getOrderId());
        shipPO.setShipVoucherId(reqBO.getShipVoucherId());
        OrdShipPO ordShipPO = this.ordShipMapper.getModelBy(shipPO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO ordSale = this.ordSaleMapper.getModelBy(ordSalePO);
        if (ordSale != null) {
            if (StringUtils.isNotBlank((CharSequence)ordSale.getChnlType())) {
                ordShipRspBO.setDeliveryWay(ordSale.getChnlType());
            } else {
                ordShipRspBO.setDeliveryWay("1");
            }
        }
        if (null == ordShipPO) {
            return ordShipRspBO;
        }
        BeanUtils.copyProperties((Object)ordShipPO, (Object)ordShipRspBO);
        ordShipRspBO.setShipExtraMap(this.buildShipExtraInfoMap(reqBO));
        AfterServBO afterServBO = new AfterServBO();
        afterServBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        afterServBO.setOrderId(ordShipPO.getOrderId());
        ArrayList<Integer> notStatus = new ArrayList<Integer>(7);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.SUCCESS);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.CONFIRM);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.APPROVAL_FAILURE);
        notStatus.add(UocConstant.AFS_ORDER_STATUS.CANCEL);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.PUR_COMPLETE);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.REFUSE);
        notStatus.add(UocConstant.ZONE_AFS_STATUS.CANCEL);
        afterServBO.setNotStatus(notStatus);
        int notEndCount = this.ordAfterServiceMapper.getNotEndCount(afterServBO);
        if (0 < notEndCount) {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(0));
        } else {
            ordShipRspBO.setIsUndoneAfter(Integer.valueOf(1));
        }
        return ordShipRspBO;
    }

    private Map<String, String> buildShipExtraInfoMap(UocCoreShipDetailsQueryReqBO reqBO) {
        HashMap<String, String> orderExtraMap = new HashMap<String, String>(16);
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setObjId(reqBO.getShipVoucherId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setFieldCode("vendorOrderType");
        ordExtMapCondition.setObjType(UocConstant.OBJ_TYPE.SALE);
        OrdExtMapPO modelBy = this.ordExtMapMapper.getModelBy(ordExtMapCondition);
        if (modelBy != null) {
            ordExtMapList.add(modelBy);
        }
        if (!CollectionUtils.isNotEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private List<OrdAccessoryRspBO> buildAdjustAccessoryList(UocCoreShipDetailsQueryReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getShipVoucherId());
        ordAccessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.SHIP);
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        ArrayList<OrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<OrdAccessoryRspBO>();
        if (CollectionUtils.isNotEmpty((Collection)ordAccessoryPOList)) {
            for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                ordAccessoryRspBOList.add(ordAccessoryRspBO);
            }
        }
        return ordAccessoryRspBOList;
    }

    private List<OrdShipItemRspBO> buildOrdShipItemRspBOList(UocCoreShipDetailsQueryReqBO reqBO) {
        List ordShipItemPOList;
        ArrayList<OrdShipItemRspBO> ordShipItemRspBOList = new ArrayList<OrdShipItemRspBO>();
        OrdShipItemPO shipItemPO = new OrdShipItemPO();
        shipItemPO.setOrderId(reqBO.getOrderId());
        shipItemPO.setShipVoucherId(reqBO.getShipVoucherId());
        if (CollectionUtils.isNotEmpty(reqBO.getShipItemIdList())) {
            shipItemPO.setShipItemIdList(reqBO.getShipItemIdList());
        }
        if (CollectionUtils.isEmpty((Collection)(ordShipItemPOList = this.ordShipItemMapper.getList(shipItemPO)))) {
            return ordShipItemRspBOList;
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO ordSale = this.ordSaleMapper.getModelBy(ordSalePO);
        List<Long> ordItemList = ordShipItemPOList.stream().map(OrdShipItemPO::getOrdItemId).collect(Collectors.toList());
        UocProQryCommodityTypeReqBo qryCommdity = new UocProQryCommodityTypeReqBo();
        qryCommdity.setOrderId(reqBO.getOrderId());
        qryCommdity.setOrdItems(ordItemList);
        qryCommdity.setBusiType(Integer.parseInt(ordSale.getOrderSource()));
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List ordItemPOS = this.ordItemMapper.getList(itemPO);
        Map ordItemPOMap = ordItemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, Function.identity(), (ordItemPO, ordItemPO1) -> ordItemPO));
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        goodsPO.setOrderId(reqBO.getOrderId());
        List ordGoodsPOS = this.ordGoodsMapper.getList(goodsPO);
        Map ordGoodsPOMap = ordGoodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, Function.identity(), (ordGoodsPO, ordGoodsPO1) -> ordGoodsPO));
        UocOrdItemDataPo ordItemDataPo = new UocOrdItemDataPo();
        ordItemDataPo.setOrderId(reqBO.getOrderId());
        List ordItemDataPos = this.ordItemDataMapper.selectByPrimaryPoList(ordItemDataPo);
        Map<Long, UocOrdItemDataPo> ordItemDataPoMap = ordItemDataPos.stream().collect(Collectors.toMap(UocOrdItemDataPo::getOrdItemId, uocOrdItemDataPo -> uocOrdItemDataPo));
        for (OrdShipItemPO ordShipItemPO : ordShipItemPOList) {
            OrdShipItemRspBO ordShipItemRspBO = new OrdShipItemRspBO();
            BeanUtils.copyProperties((Object)ordShipItemPO, (Object)ordShipItemRspBO);
            OrdItemPO ordItemPO2 = (OrdItemPO)ordItemPOMap.get(ordShipItemPO.getOrdItemId());
            ordShipItemRspBO.setSkuId(Long.valueOf(ordItemPO2.getSkuId()));
            ordShipItemRspBO.setSkuName(ordItemPO2.getSkuName());
            ordShipItemRspBO.setPurchaseCount(ordItemPO2.getPurchaseCount());
            ordShipItemRspBO.setSalePrice(ordItemPO2.getSalePrice());
            ordShipItemRspBO.setPurchasePrice(ordItemPO2.getPurchasePrice());
            ordShipItemRspBO.setArrivalTime(DateUtils.strToDate((String)ordItemPO2.getArrivalTime()));
            ordShipItemRspBO.setTax(ordItemPO2.getTax());
            ordShipItemRspBO.setInspectionExcessPercent(ordItemPO2.getInspectionExcessPercent());
            ordShipItemRspBO.setTotalAcceptanceCount(ordItemPO2.getAcceptanceCount());
            ordShipItemRspBO.setTotalArriveCount(ordItemPO2.getArriveCount());
            ordShipItemRspBO.setTotalSendCount(ordItemPO2.getSendCount());
            if (ordItemPO2.getInspectionExcessPercent() != null) {
                BigDecimal divide = new BigDecimal(ordItemPO2.getInspectionExcessPercent()).divide(new BigDecimal(100));
                ordShipItemRspBO.setInspectionExcessCount(ordItemPO2.getPurchaseCount().multiply(divide));
            } else {
                ordShipItemRspBO.setInspectionExcessCount(BigDecimal.ZERO);
            }
            try {
                ordShipItemRspBO.setSalePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemPO2.getSalePrice()));
                ordShipItemRspBO.setPurchasePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemPO2.getPurchasePrice()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
            OrdGoodsPO ordGoodsPO2 = (OrdGoodsPO)ordGoodsPOMap.get(ordShipItemPO.getOrdItemId());
            BeanUtils.copyProperties((Object)ordGoodsPO2, (Object)ordShipItemRspBO);
            ordShipItemRspBO.setPicUlr(ordGoodsPO2.getSkuMainPicUrl());
            ordShipItemRspBO.setSkuMaterialId(ordGoodsPO2.getSkuMaterialId());
            ordShipItemRspBO.setSkuMaterialName(ordGoodsPO2.getSkuMaterialName());
            ordShipItemRspBO.setSkuMaterialTypeId(ordGoodsPO2.getSkuMaterialTypeId());
            ordShipItemRspBO.setSkuMaterialTypeName(ordGoodsPO2.getSkuMaterialTypeName());
            ordShipItemRspBO.setSpuId(ordGoodsPO2.getSpuId());
            ordShipItemRspBO.setSkuUpcCode(ordGoodsPO2.getSkuUpcCode());
            ordShipItemRspBO.setSupplierShopId(ordGoodsPO2.getSupplierShopId());
            ordShipItemRspBO.setSkuExtSkuId(ordGoodsPO2.getSkuExtSkuId());
            ordShipItemRspBO.setManufacturer(ordGoodsPO2.getManufacturer());
            ordShipItemRspBO.setTechnicalParameters(ordGoodsPO2.getTechnicalParameters());
            ordShipItemRspBO.setDomestic(ordGoodsPO2.getDomestic());
            ordShipItemRspBO.setStorageAge(ordGoodsPO2.getStorageAge());
            ordShipItemRspBO.setSelfMentionAddress(ordGoodsPO2.getSelfMentionAddress());
            ordShipItemRspBO.setSelfMentionTime(ordShipItemRspBO.getSelfMentionTime());
            ordShipItemRspBO.setSkuBrandName(ordGoodsPO2.getSkuBrandName());
            ordShipItemRspBO.setSpec(ordGoodsPO2.getSpec());
            ordShipItemRspBO.setModel(ordGoodsPO2.getModel());
            ordShipItemRspBO.setTexture(ordGoodsPO2.getTexture());
            ordShipItemRspBO.setSkuSupplierId(ordGoodsPO2.getSkuSupplierId());
            ordShipItemRspBO.setSaleUnit(ordItemDataPoMap.get(ordGoodsPO2.getOrdItemId()).getSaleUnit());
            BigDecimal inAfterCount = this.qryInAfterCount(reqBO.getOrderId(), ordSale.getOrderSource(), ordShipItemRspBO.getShipItemId());
            ordShipItemRspBO.setInAfterCount(inAfterCount);
            ordShipItemRspBOList.add(ordShipItemRspBO);
        }
        return ordShipItemRspBOList;
    }

    private BigDecimal qryInAfterCount(Long orderId, String orderSource, Long shipItemId) {
        BigDecimal inAfterCount;
        block4: {
            inAfterCount = BigDecimal.ZERO;
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            if (null == ordSalePO) break block4;
            if ("2".equals(orderSource)) {
                List ordAsItemPOS = this.ordAsItemMapper.qryInAfterItems(orderId, shipItemId, Arrays.asList(UocConstant.AFS_ORDER_STATUS.PENDING_APPROVAL, UocConstant.AFS_ORDER_STATUS.IN_PROCESS, UocConstant.AFS_ORDER_STATUS.SUCCESS, UocConstant.AFS_ORDER_STATUS.HANDING_OVER));
                for (OrdAsItemPO ordAsItemPO : ordAsItemPOS) {
                    inAfterCount = inAfterCount.add(ordAsItemPO.getReturnCount());
                }
            } else {
                List ordAsItemPOS = this.ordAsItemMapper.qryInAfterItems(orderId, shipItemId, Arrays.asList(UocConstant.ZONE_AFS_STATUS.WAITE_CONFIRM, UocConstant.ZONE_AFS_STATUS.ALREADY_CONFIRM, UocConstant.ZONE_AFS_STATUS.COMPLETE));
                for (OrdAsItemPO ordAsItemPO : ordAsItemPOS) {
                    inAfterCount = inAfterCount.add(ordAsItemPO.getReturnCount());
                }
            }
        }
        return inAfterCount;
    }
}

