/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.ability.api.UccMallSpuOrderListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuOrderQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.atom.api.UocCreateOrderQryCommodityAtomService;
import com.tydic.uoc.common.atom.bo.UocCreateOrderQryCommodityAtomServiceReqBo;
import com.tydic.uoc.common.atom.bo.UocCreateOrderQryCommodityAtomServiceRspBo;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocCreateOrderQryCommodityAtomServiceImpl
implements UocCreateOrderQryCommodityAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateOrderQryCommodityAtomServiceImpl.class);
    @Autowired
    private UccMallSpuOrderListQueryAbilityService uccMallSpuOrderListQueryAbilityService;

    @Override
    public UocCreateOrderQryCommodityAtomServiceRspBo qryCommodity(UocCreateOrderQryCommodityAtomServiceReqBo reqBo) {
        UocCreateOrderQryCommodityAtomServiceRspBo rspBo = (UocCreateOrderQryCommodityAtomServiceRspBo)UocProRspBoUtil.success(UocCreateOrderQryCommodityAtomServiceRspBo.class);
        this.validateArg(reqBo);
        UccMallSpuOrderListQueryAbilityReqBO uocQryReqBo = (UccMallSpuOrderListQueryAbilityReqBO)UocProRspBoUtil.convertReq((Object)((Object)reqBo), UccMallSpuOrderListQueryAbilityReqBO.class);
        if (UocConstant.CostType.ASSET.equals(reqBo.getCostType())) {
            uocQryReqBo.setAssets(true);
        } else {
            uocQryReqBo.setAssets(false);
        }
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocQryReqBo));
        UccMallSpuOrderListQueryAbilityRspBO uocQryRspBo = this.uccMallSpuOrderListQueryAbilityService.querySpuOrderListInfo(uocQryReqBo);
        log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocQryRspBo));
        if (!"0000".equals(uocQryRspBo.getRespCode())) {
            throw new UocProBusinessException("101079", "\u4e0b\u5355\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u9519\u8bef\uff1a" + uocQryRspBo.getRespDesc());
        }
        rspBo.setOrderSpuList(uocQryRspBo.getOrderSpuList());
        for (UccMallSpuOrderListQueryBO item : uocQryRspBo.getOrderSpuList()) {
            if (UocConstant.CostType.ASSET.equals(reqBo.getCostType())) {
                if (!ObjectUtil.isEmpty((Object)item.getNcCode())) continue;
                throw new UocProBusinessException("101079", "\u56fa\u8d44nc\u7269\u6599\u7f16\u7801(ncCode)[" + item.getNcCode() + "]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List orderSkuList = item.getOrderSkuList();
            for (UccMallSkuDetailInfoBO skuBo : orderSkuList) {
                if (!ObjectUtil.isEmpty((Object)skuBo.getMaterialCode())) continue;
                throw new UocProBusinessException("101079", "\u975e\u56fa\u8d44nc\u7269\u6599\u7f16\u7801(materialCode)[" + skuBo.getMaterialCode() + "]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return rspBo;
    }

    private void validateArg(UocCreateOrderQryCommodityAtomServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgIdIn())) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027orgIdIn\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProvince())) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027Province\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCity())) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027City\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCounty())) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027County\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTown())) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027Town\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCompanyId())) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027CompanyId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getIsprofess())) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027Isprofess\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UccMallSkuOrderQryReqBO> skuOrderList = reqBo.getSkuOrderList();
        if (ObjectUtil.isEmpty(skuOrderList)) {
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027skuOrderList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccMallSkuOrderQryReqBO sku : skuOrderList) {
            if (ObjectUtil.isEmpty((Object)sku)) {
                throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027skubo\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)sku.getSupplierShopId())) {
                throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027SupplierShopId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)sku.getSkuId())) {
                throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027SkuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)sku.getCommodityId())) {
                throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027CommodityId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)sku.getNum())) {
                throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027Num\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (sku.getNum().compareTo(new BigDecimal(0)) > 0) continue;
            throw new UocProBusinessException("101079", "\u5165\u53c2\u5c5e\u6027Num\u5fc5\u987b\u5927\u4e8e0");
        }
    }
}

