/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProJsonUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfGoodsListDelAbilityService;
import com.tydic.uoc.common.ability.bo.GoodsInfoIdBO;
import com.tydic.uoc.common.ability.bo.GoodsListDelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.UocOtherOrderSourceExecuteAtomService;
import com.tydic.uoc.common.atom.api.UocProCreateOrderSaveDataAtomService;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomConsumeReqBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomConsumeRspBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomDoBusiRspBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomGetCodeReqBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomGetCodeRspBo;
import com.tydic.uoc.common.atom.bo.UocProCreateOrderSaveDataAtomRspBo;
import com.tydic.uoc.common.busi.bo.UocOtherOrderSourceExecuteAtomDoBusiDataRspBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocOtherOrderSourceExecuteAtomDsServiceImpl
implements UocOtherOrderSourceExecuteAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocOtherOrderSourceExecuteAtomDsServiceImpl.class);
    @Autowired
    private UocProCreateOrderSaveDataAtomService uocProCreateOrderSaveDataAtomService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocCreateOrderMsgProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CREATE_TAG}")
    private String tag;
    @Autowired
    private PebIntfGoodsListDelAbilityService pebIntfGoodsListDelAbilityService;

    @Override
    public UocOtherOrderSourceExecuteAtomConsumeRspBo sendMessage(UocOtherOrderSourceExecuteAtomConsumeReqBo reqBo) {
        this.validateArg(reqBo);
        UocOtherOrderSourceExecuteAtomConsumeRspBo rspBo = (UocOtherOrderSourceExecuteAtomConsumeRspBo)UocProRspBoUtil.success(UocOtherOrderSourceExecuteAtomConsumeRspBo.class);
        this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)reqBo.getConsumerObject())));
        UocPebOrdIdxSyncReqBO sendMsgBo = new UocPebOrdIdxSyncReqBO();
        sendMsgBo.setObjId(Long.valueOf(reqBo.getSaleVoucherId().toString()));
        sendMsgBo.setObjType(UocConstant.OBJ_TYPE.SALE);
        sendMsgBo.setOrderId(reqBo.getOrderId());
        sendMsgBo.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)sendMsgBo)));
        return rspBo;
    }

    @Override
    public UocOtherOrderSourceExecuteAtomGetCodeRspBo getSourceCode(UocOtherOrderSourceExecuteAtomGetCodeReqBo reqBo) {
        return new UocOtherOrderSourceExecuteAtomGetCodeRspBo("2");
    }

    @Override
    public UocOtherOrderSourceExecuteAtomDoBusiRspBo doBusi(UocProCreateOrderCombReqBo reqBo) {
        UocOtherOrderSourceExecuteAtomDoBusiRspBo rspBo = (UocOtherOrderSourceExecuteAtomDoBusiRspBo)UocProRspBoUtil.success(UocOtherOrderSourceExecuteAtomDoBusiRspBo.class);
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        Map<Long, List<UocProCreateOrderCombOrderItemReqBo>> supplierMap = orderItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getSupplierId));
        for (Long supplier : supplierMap.keySet()) {
            List<UocProCreateOrderCombOrderItemReqBo> supItemList = supplierMap.get(supplier);
            String supplierName = supItemList.get(0).getSupplierName();
            Map<String, List<UocProCreateOrderCombOrderItemReqBo>> purcharseTypeMap = supItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getPurchaseTypeId));
            for (String purchaseTypeId : purcharseTypeMap.keySet()) {
                List<UocProCreateOrderCombOrderItemReqBo> purcharseTypeList = purcharseTypeMap.get(purchaseTypeId);
                Map<String, List<UocProCreateOrderCombOrderItemReqBo>> purcharseOrgMap = purcharseTypeList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getPurchasId));
                for (String purcharseOrgId : purcharseOrgMap.keySet()) {
                    List<UocProCreateOrderCombOrderItemReqBo> purcharseOrgList = purcharseOrgMap.get(purcharseOrgId);
                    reqBo.setOrderItemList(purcharseOrgList);
                    reqBo.setOrderType(Integer.valueOf("2"));
                    UocProCreateOrderSaveDataAtomRspBo saveDataAtomRspBo = this.uocProCreateOrderSaveDataAtomService.saveOrderData(reqBo);
                    if (!"0000".equals(saveDataAtomRspBo.getRespCode())) {
                        throw new UocProBusinessException(saveDataAtomRspBo.getRespCode(), saveDataAtomRspBo.getRespDesc());
                    }
                    reqBo.setSortOrderNo(reqBo.getSortOrderNo() + 1);
                    UocOtherOrderSourceExecuteAtomDoBusiDataRspBo orderData = new UocOtherOrderSourceExecuteAtomDoBusiDataRspBo();
                    orderData.setOrderId(saveDataAtomRspBo.getOrderId());
                    orderData.setSaleVoucherId(saveDataAtomRspBo.getSaleVoucherId());
                    orderData.setSupplierName(supplierName);
                    rspBo.getOrderDataList().add(orderData);
                    orderData.setConsumerObject(this.genConsumerObj(reqBo, supItemList, orderData));
                }
            }
        }
        return rspBo;
    }

    private PebExtThirdSupplierSubmitOrderSaleItemRspBO genConsumerObj(UocProCreateOrderCombReqBo reqBo, List<UocProCreateOrderCombOrderItemReqBo> supItemList, UocOtherOrderSourceExecuteAtomDoBusiDataRspBo orderData) {
        PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO = new PebExtThirdSupplierSubmitOrderSaleItemRspBO();
        itemRspBO.setIsPreOrder(Integer.valueOf(0));
        itemRspBO.setUserId(reqBo.getUserId());
        itemRspBO.setOrgId(reqBo.getOrgId());
        itemRspBO.setToken(reqBo.getToken());
        itemRspBO.setOrderId(orderData.getOrderId());
        itemRspBO.setSaleOrderId(orderData.getSaleVoucherId().toString());
        itemRspBO.setEcpPurType(reqBo.getEcpPurType());
        itemRspBO.setCreateName(reqBo.getUsername());
        ArrayList<Object> saleOrderItemList = new ArrayList<Object>();
        for (UocProCreateOrderCombOrderItemReqBo itemBo : supItemList) {
            saleOrderItemList.add(UocProJsonUtil.convertReq((Object)itemBo, PebExtThirdSupplierSkuInfo.class));
        }
        itemRspBO.setSaleOrderItemList(saleOrderItemList);
        itemRspBO.setOrgPath(reqBo.getOrgPath());
        itemRspBO.setCompanyId(reqBo.getCompanyId());
        itemRspBO.setMemId(reqBo.getUserId());
        itemRspBO.setAccountId(reqBo.getPurchaserAccount());
        GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
        ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
        goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
        goodsListDelReqBO.setMemberId(String.valueOf(reqBo.getUserId()));
        for (UocProCreateOrderCombOrderItemReqBo skuInfo : reqBo.getOrderItemList()) {
            GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
            goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
            goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
        }
        itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
        return itemRspBO;
    }

    private void validateArg(UocOtherOrderSourceExecuteAtomConsumeReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("101080", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getConsumerObject())) {
            throw new UocProBusinessException("101080", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[consumerObject]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

