/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProJsonUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.GoodsInfoIdBO;
import com.tydic.uoc.common.ability.bo.GoodsListDelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.UocOtherOrderSourceExecuteAtomService;
import com.tydic.uoc.common.atom.api.UocProCreateOrderSaveDataAtomService;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomConsumeReqBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomConsumeRspBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomDoBusiRspBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomGetCodeReqBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomGetCodeRspBo;
import com.tydic.uoc.common.atom.bo.UocProCreateOrderSaveDataAtomRspBo;
import com.tydic.uoc.common.busi.bo.UocOtherOrderSourceExecuteAtomDoBusiDataRspBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocOtherOrderSourceExecuteAtomServiceAgreementImpl
implements UocOtherOrderSourceExecuteAtomService {
    @Autowired
    private UocProCreateOrderSaveDataAtomService uocProCreateOrderSaveDataAtomService;
    @Resource(name="uocZoneCreateOrderMsgProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_ZONE_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_ZONE_ORDER_CREATE_TAG}")
    private String tag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @Override
    public UocOtherOrderSourceExecuteAtomConsumeRspBo sendMessage(UocOtherOrderSourceExecuteAtomConsumeReqBo reqBo) {
        this.validateArg(reqBo);
        UocOtherOrderSourceExecuteAtomConsumeRspBo rspBo = (UocOtherOrderSourceExecuteAtomConsumeRspBo)UocProRspBoUtil.success(UocOtherOrderSourceExecuteAtomConsumeRspBo.class);
        this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)reqBo.getConsumerObject())));
        UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
        combReqBO.setOrderId(reqBo.getOrderId());
        combReqBO.setObjId(reqBo.getSaleVoucherId());
        combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        combReqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        return rspBo;
    }

    @Override
    public UocOtherOrderSourceExecuteAtomGetCodeRspBo getSourceCode(UocOtherOrderSourceExecuteAtomGetCodeReqBo reqBo) {
        return new UocOtherOrderSourceExecuteAtomGetCodeRspBo("1");
    }

    @Override
    public UocOtherOrderSourceExecuteAtomDoBusiRspBo doBusi(UocProCreateOrderCombReqBo reqBo) {
        for (UocProCreateOrderCombOrderItemReqBo itemReqBo : reqBo.getOrderItemList()) {
            if (!ObjectUtil.isEmpty((Object)itemReqBo.getAgrId())) continue;
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5c5e\u6027agrId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocOtherOrderSourceExecuteAtomDoBusiRspBo rspBo = (UocOtherOrderSourceExecuteAtomDoBusiRspBo)UocProRspBoUtil.success(UocOtherOrderSourceExecuteAtomDoBusiRspBo.class);
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        this.splitOrderAndSave(reqBo, rspBo, orderItemList);
        return rspBo;
    }

    private void splitOrderAndSave(UocProCreateOrderCombReqBo reqBo, UocOtherOrderSourceExecuteAtomDoBusiRspBo rspBo, List<UocProCreateOrderCombOrderItemReqBo> orderItemList) {
        Map<Long, List<UocProCreateOrderCombOrderItemReqBo>> supplierMap = orderItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getSupplierId));
        for (Long supplier : supplierMap.keySet()) {
            List<UocProCreateOrderCombOrderItemReqBo> supItemList = supplierMap.get(supplier);
            String supplierName = supItemList.get(0).getSupplierName();
            Map<String, List<UocProCreateOrderCombOrderItemReqBo>> purcharseTypeMap = supItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getPurchaseTypeId));
            for (String purchaseTypeId : purcharseTypeMap.keySet()) {
                List<UocProCreateOrderCombOrderItemReqBo> purcharseTypeList = purcharseTypeMap.get(purchaseTypeId);
                Map<String, List<UocProCreateOrderCombOrderItemReqBo>> purcharseOrgMap = purcharseTypeList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getPurchasId));
                for (String purcharseOrgId : purcharseOrgMap.keySet()) {
                    List<UocProCreateOrderCombOrderItemReqBo> purcharseOrgList = purcharseOrgMap.get(purcharseOrgId);
                    reqBo.setOrderItemList(purcharseOrgList);
                    reqBo.setOrderType(Integer.valueOf("1"));
                    UocProCreateOrderSaveDataAtomRspBo saveDataAtomRspBo = this.uocProCreateOrderSaveDataAtomService.saveOrderData(reqBo);
                    if (!"0000".equals(saveDataAtomRspBo.getRespCode())) {
                        throw new UocProBusinessException(saveDataAtomRspBo.getRespCode(), saveDataAtomRspBo.getRespDesc());
                    }
                    reqBo.setSortOrderNo(reqBo.getSortOrderNo() + 1);
                    UocOtherOrderSourceExecuteAtomDoBusiDataRspBo orderData = new UocOtherOrderSourceExecuteAtomDoBusiDataRspBo();
                    orderData.setOrderId(saveDataAtomRspBo.getOrderId());
                    orderData.setSupplierName(supplierName);
                    rspBo.getOrderDataList().add(orderData);
                    orderData.setSaleVoucherId(saveDataAtomRspBo.getSaleVoucherId());
                    orderData.setConsumerObject(this.genConsumerObj(reqBo, supplier, supplierName, purcharseOrgList.get(0).getAgrId(), purcharseTypeList, saveDataAtomRspBo));
                }
            }
        }
    }

    private PebExtAgreementSubmitOrderSaleItemRspBO genConsumerObj(UocProCreateOrderCombReqBo reqBo, Long supplier, String supplierName, Long argId, List<UocProCreateOrderCombOrderItemReqBo> argItemList, UocProCreateOrderSaveDataAtomRspBo saveDataAtomRspBo) {
        PebExtAgreementSubmitOrderSaleItemRspBO itemRspBO = new PebExtAgreementSubmitOrderSaleItemRspBO();
        itemRspBO.setGoodsSupplierId(supplier);
        itemRspBO.setGoodSupplierName(supplierName);
        itemRspBO.setIsPreOrder(Integer.valueOf(0));
        itemRspBO.setUserId(reqBo.getUserId());
        itemRspBO.setOrgId(reqBo.getOrgId());
        itemRspBO.setWarantty(argItemList.get(0).getAgreementBO().getWarantty());
        itemRspBO.setToken(reqBo.getToken());
        itemRspBO.setOrderId(saveDataAtomRspBo.getOrderId());
        itemRspBO.setSaleOrderId(saveDataAtomRspBo.getSaleVoucherId().toString());
        itemRspBO.setTotalfee(saveDataAtomRspBo.getTotalFee().divide(new BigDecimal(10000)));
        itemRspBO.setFee(itemRspBO.getTotalfee());
        ArrayList<Object> saleOrderItemList = new ArrayList<Object>();
        for (UocProCreateOrderCombOrderItemReqBo itemReqBo : argItemList) {
            saleOrderItemList.add(UocProJsonUtil.convertReq((Object)itemReqBo, PebExtAgreementSkuInfo.class));
        }
        itemRspBO.setSaleOrderItemList(saleOrderItemList);
        itemRspBO.setCreateName(reqBo.getUsername());
        itemRspBO.setEcpPurType(reqBo.getEcpPurType());
        itemRspBO.setCompanyId(reqBo.getCompanyId());
        itemRspBO.setAgrId(argId);
        itemRspBO.setMemId(reqBo.getUserId());
        itemRspBO.setMemUserType(reqBo.getMemUserType());
        GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
        ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
        goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
        goodsListDelReqBO.setMemberId(String.valueOf(reqBo.getUserId()));
        for (UocProCreateOrderCombOrderItemReqBo skuInfo : argItemList) {
            GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
            goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
            goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
        }
        itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
        return itemRspBO;
    }

    private void validateArg(UocOtherOrderSourceExecuteAtomConsumeReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("101080", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getConsumerObject())) {
            throw new UocProBusinessException("101080", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[consumerObject]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("101080", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[OrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleVoucherId())) {
            throw new UocProBusinessException("101080", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SaleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

