/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.GenerateOrderPaySeqAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCommCreateIntfLogAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCompletePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreatePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocPebAddSaleNumAtomService;
import com.tydic.uoc.common.atom.api.UocPebRefundAtomService;
import com.tydic.uoc.common.atom.bo.GenerateOrderPaySeqRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCommCreateIntfLogReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCompletePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCompletePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemAtomBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.common.atom.bo.UocPebAddSaleNumReqBO;
import com.tydic.uoc.common.atom.bo.UocPebAddSaleNumRespBO;
import com.tydic.uoc.common.atom.bo.UocPebRefundReqBO;
import com.tydic.uoc.common.atom.bo.UocPebRefundRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.PecOrdAsItemMapMapper;
import com.tydic.uoc.dao.PecOrdInspectionItemMapper;
import com.tydic.uoc.dao.PecOrdItemMapper;
import com.tydic.uoc.dao.PecOrdShipItemMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebRefundAtomService")
public class UocPebRefundAtomServiceImpl
implements UocPebRefundAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocPebRefundAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PecOrdShipItemMapper pecOrdShipItemMapper;
    @Autowired
    private PecOrdInspectionItemMapper pecOrdInspectionItemMapper;
    @Autowired
    private PecOrdAsItemMapMapper pecOrdAfterServiceMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private PecOrdItemMapper pecOrdItemMapper;
    @Autowired
    private UocCoreCompletePayOrderAtomService uocCoreCompletePayOrderAtomService;
    @Autowired
    private GenerateOrderPaySeqAtomService generateOrderPaySeqAtomService;
    @Autowired
    private UocCoreCommCreateIntfLogAtomService uocPebCommCreateIntfLogAtomService;
    @Autowired
    private UocPebAddSaleNumAtomService uocPebAddSaleNumAtomService;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;

    @Override
    public UocPebRefundRspBO dealUocPebRefund(UocPebRefundReqBO uocPebRefundReqBO) {
        UocCoreCompletePayOrderReqBO uocCoreCompletePayOrderReqBO;
        UocCoreCompletePayOrderRspBO uocCoreCompletePayOrderRspBO;
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        this.validateParams(uocPebRefundReqBO);
        Byte paymentStatus = PecConstant.PAYMENT_STATUS_S;
        String txnNo = "";
        Long failCode = 0L;
        String failDesc = "";
        UocPebRefundRspBO uocPebRefundRspBO = new UocPebRefundRspBO();
        Integer objType = uocPebRefundReqBO.getObjType();
        Long orderId = uocPebRefundReqBO.getOrderId();
        Long objId = uocPebRefundReqBO.getObjId();
        List<Long> ordItemIdList = uocPebRefundReqBO.getObjItemList();
        OrderPO orderInfo = null;
        OrdStakeholderPO ordStakeholderInfo = null;
        OrdSalePO ordSaleInfo = null;
        OrdPayPO ordPayInfo = null;
        Long payId = null;
        UocCoreCommCreateIntfLogReqBO uocPebCommCreateIntfLogReqBO = new UocCoreCommCreateIntfLogReqBO();
        try {
            orderInfo = this.orderMapper.getModelById(orderId.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        try {
            ordStakeholderInfo = this.ordStakeholderMapper.getModelById(orderId.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u8ba2\u5355\u4e09\u65b9\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        if (orderInfo == null || orderInfo.getTotalSaleFee() == null) {
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u8ba2\u5355\u91d1\u989d\u5931\u8d25");
        }
        if (ordStakeholderInfo == null) {
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u8ba2\u5355\u4e09\u65b9\u4fe1\u606f\u5931\u8d25");
        }
        try {
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            ordSaleInfo = this.ordSaleMapper.getModelBy(ordSalePO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        if (ordSaleInfo == null || ordSaleInfo.getSaleFee() == null) {
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u9500\u552e\u5355\u91d1\u989d\u5931\u8d25");
        }
        OrdSalePO ps = new OrdSalePO();
        OrdPayPO ordPayPO = new OrdPayPO();
        if (orderInfo.getUpperOrderId() != null) {
            ordPayPO.setOrderId(orderInfo.getUpperOrderId());
            ps.setOrderId(orderInfo.getUpperOrderId());
            try {
                ps = this.ordSaleMapper.getModelBy(ps);
                ordPayPO.setObjId(ps.getSaleVoucherId());
            }
            catch (Exception e) {
                throw new UocProBusinessException("101022", "\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
            }
        } else {
            ordPayPO.setOrderId(orderId);
            ordPayPO.setObjId(ordSaleInfo.getSaleVoucherId());
        }
        ordPayPO.setInterType(PecConstant.INTER_TYPE_PAY);
        try {
            ordPayInfo = this.ordPayMapper.getModelBy(ordPayPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u652f\u4ed8\u5355\u5f02\u5e38!");
        }
        if (ordPayInfo == null) {
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u652f\u4ed8\u5355\u5931\u8d25!");
        }
        if (StringUtils.isBlank((CharSequence)ordPayInfo.getOutPayOrderNo())) {
            uocPebRefundReqBO.setIsNeedOutBackPay(PecConstant.IS_NEED_OUT_BACKPAY_NO);
        }
        this.buildCreatePayOrderParmBaseParm(orderId, uocPebRefundReqBO, ordPayInfo, uocCoreCreatePayOrderReqBO);
        uocPebCommCreateIntfLogReqBO.setOrderId(orderId);
        uocPebCommCreateIntfLogReqBO.setInterCode("UniPcRefundRequest");
        uocPebCommCreateIntfLogReqBO.setCallTime(new Date());
        uocPebCommCreateIntfLogReqBO.setCreateLoginId(String.valueOf(uocPebRefundReqBO.getUserId()));
        if (objType.intValue() == PecConstant.OBJECT_TYPE_ORDER.intValue() || PecConstant.OBJECT_TYPE_ORDER_SALE.equals(objType)) {
            Long totalMoney = 0L;
            try {
                totalMoney = this.pecOrdItemMapper.getTotalMoneyByItemList(ordItemIdList, orderId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("101022", "");
            }
            ArrayList<OrdItemPO> listOrdItems = new ArrayList();
            try {
                listOrdItems = this.pecOrdItemMapper.getListByItemList(ordItemIdList, orderId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("101022", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5f02\u5e38");
            }
            this.buildCreatePayOrderParmByOrder(totalMoney, listOrdItems, uocPebRefundReqBO, uocCoreCreatePayOrderReqBO);
        } else if (objType.intValue() == PecConstant.OBJECT_TYPE_ORDER_SHIP.intValue()) {
            Long ordShipTotalMoneyBy = 0L;
            try {
                ordShipTotalMoneyBy = this.pecOrdShipItemMapper.getTotalMoneyBy(objId, orderId, ordItemIdList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("101022", "\u67e5\u8be2\u53d1\u8d27\u5355\u8be6\u60c5\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
            }
            ArrayList<Long> listByItemList = new ArrayList();
            try {
                listByItemList = this.pecOrdShipItemMapper.getListByItemList(objId, orderId, ordItemIdList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("101022", "");
            }
            this.buildCreatePayOrderParmBy(ordShipTotalMoneyBy, listByItemList, uocPebRefundReqBO, uocCoreCreatePayOrderReqBO, null);
        } else if (objType.intValue() == PecConstant.OBJECT_TYPE_ORDER_INSPECTION.intValue()) {
            Long ordInspectionIMoneyBy = 0L;
            try {
                ordInspectionIMoneyBy = this.pecOrdInspectionItemMapper.getTotalMoneyBy(objId, orderId, uocPebRefundReqBO.getObjItemList());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("101022", "\u67e5\u8be2\u53d1\u8d27\u5355\u8be6\u60c5\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
            }
            ArrayList<Long> listBy = new ArrayList();
            try {
                listBy = this.pecOrdInspectionItemMapper.getListBy(objId, orderId, uocPebRefundReqBO.getObjItemList());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("101022", "");
            }
            this.buildCreatePayOrderParmBy(ordInspectionIMoneyBy, listBy, uocPebRefundReqBO, uocCoreCreatePayOrderReqBO, null);
        } else if (PecConstant.OBJECT_TYPE_ORDER_AFTER_SERVICE.equals(objType)) {
            OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
            ordAfterServicePO.setOrderId(uocPebRefundReqBO.getOrderId());
            ordAfterServicePO.setAfterServId(uocPebRefundReqBO.getObjId());
            ordAfterServicePO = this.ordAfterServiceMapper.getModelBy(ordAfterServicePO);
            Long totalMoneyBy = 0L;
            if (PecConstant.ORDER_SOURCE.ELEC_AREA.equals(uocPebRefundReqBO.getSource())) {
                OrdPayPO payPO = new OrdPayPO();
                payPO.setOrderId(uocPebRefundReqBO.getOrderId());
                payPO.setObjId(uocPebRefundReqBO.getObjId());
                payPO.setObjType(uocPebRefundReqBO.getObjType());
                payPO = this.ordPayMapper.getModelBy(payPO);
                if (payPO != null) {
                    if (PecConstant.EXT_AFTER_SERVICE_TYPE_CODE.RETURN.equals(ordAfterServicePO.getServType())) {
                        totalMoneyBy = payPO.getPayFee();
                    }
                    payId = payPO.getPayVoucherId();
                }
            } else {
                try {
                    if (PecConstant.EXT_AFTER_SERVICE_TYPE_CODE.RETURN.equals(ordAfterServicePO.getServType())) {
                        totalMoneyBy = this.pecOrdAfterServiceMapper.getTotalMoneyBy(objId, orderId, uocPebRefundReqBO.getObjItemList());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new UocProBusinessException("101022", "\u67e5\u8be2\u552e\u540e\u670d\u52a1\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
                }
            }
            ArrayList<Long> itemList = new ArrayList();
            try {
                itemList = this.pecOrdAfterServiceMapper.getListBy(objId, orderId, uocPebRefundReqBO.getObjItemList());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("101022", "");
            }
            this.buildCreatePayOrderParmBy(totalMoneyBy, itemList, uocPebRefundReqBO, uocCoreCreatePayOrderReqBO, ordAfterServicePO.getServType());
        } else if (PecConstant.OBJECT_TYPE_ORDER_ABNORMAL_SERVICE.equals(objType)) {
            this.buildCreatePayOrderParmByAb(uocPebRefundReqBO, uocCoreCreatePayOrderReqBO);
        } else {
            throw new UocProBusinessException("101022", "\u4e0d\u652f\u6301\u7684\u5355\u636e\u7c7b\u578b");
        }
        GenerateOrderPaySeqRspBO generateOrderPaySeqRspBO = this.generateOrderPaySeqAtomService.generateOrderPaySeq();
        if (payId == null) {
            uocCoreCreatePayOrderReqBO.setPayVoucherNo(generateOrderPaySeqRspBO.getPayOrderId());
            uocCoreCreatePayOrderReqBO.setPayFee(uocCoreCreatePayOrderReqBO.getTotalFee());
            UocCoreCreatePayOrderRspBO uocCoreCreatePayOrderRspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
            if (!"0000".equals(uocCoreCreatePayOrderRspBO.getRespCode())) {
                throw new UocProBusinessException("101022", this.buildExceptionMsg("\u652f\u4ed8\u5355\u521b\u5efa\u5931\u8d25!", uocCoreCreatePayOrderRspBO.getRespDesc()));
            }
            payId = uocCoreCreatePayOrderRspBO.getPayVoucherID();
        }
        if (uocPebRefundReqBO.getIsNeedOutBackPay().intValue() == PecConstant.IS_NEED_OUT_BACKPAY_YES.intValue()) {
            UocPebAddSaleNumReqBO uocPebAddSaleNumReqBO = new UocPebAddSaleNumReqBO();
            uocPebAddSaleNumReqBO.setOrderId(orderId);
            uocPebAddSaleNumReqBO.setPayVoucherId(payId);
            uocPebAddSaleNumReqBO.setInterType(1);
            UocPebAddSaleNumRespBO uocPebAddSaleNumRespBO = this.uocPebAddSaleNumAtomService.dealAddSaleNum(uocPebAddSaleNumReqBO);
            if (!"0000".equals(uocPebAddSaleNumRespBO.getRespCode())) {
                log.error("\u7535\u5b50\u8d85\u5e02\u7ed3\u7b97\u4e2d\u5fc3\u9000\u6b3e\u5931\u8d25,\u8c03\u7528\u5546\u54c1\u9500\u552e\u7edf\u8ba1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            }
        }
        if (!"0000".equals((uocCoreCompletePayOrderRspBO = this.uocCoreCompletePayOrderAtomService.dealCoreCompletePayOrder(uocCoreCompletePayOrderReqBO = this.buildCoreCompletePayOrderParm(payId, txnNo, uocCoreCreatePayOrderReqBO))).getRespCode())) {
            throw new UocProBusinessException("101022", this.buildExceptionMsg("\u652f\u4ed8\u4e2d\u5fc3\u8c03\u7528\u5931\u8d25!", uocCoreCompletePayOrderRspBO.getRespDesc()));
        }
        uocPebRefundRspBO.setRespCode("0000");
        uocPebRefundRspBO.setFailCode(failCode);
        uocPebRefundRspBO.setFailDesc(failDesc);
        uocPebRefundRspBO.setPaymentStatus(paymentStatus);
        uocPebRefundRspBO.setTxnNo(txnNo);
        uocPebRefundRspBO.setRespDesc("\u9000\u6b3e\u6210\u529f");
        return uocPebRefundRspBO;
    }

    private void validateParams(UocPebRefundReqBO uocPebRefundReqBO) {
        if (uocPebRefundReqBO == null) {
            throw new UocProBusinessException("100002", "\u9000\u6b3e\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (uocPebRefundReqBO.getObjType() == null) {
            throw new UocProBusinessException("100002", "\u9000\u6b3e\u670d\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (uocPebRefundReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u9000\u6b3e\u670d\u52a1\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (uocPebRefundReqBO.getIsNeedOutBackPay() == null) {
            throw new UocProBusinessException("100002", "\u9000\u6b3e\u670d\u52a1\u662f\u5426\u9700\u8981\u8c03\u7528\u7ed3\u7b97\u4e2d\u5fc3\u9000\u6b3e\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!PecConstant.OBJECT_TYPE_ORDER.equals(uocPebRefundReqBO.getObjType()) && uocPebRefundReqBO.getObjId() == null) {
            throw new UocProBusinessException("100002", "\u9000\u6b3e\u670d\u52a1\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private String buildExceptionMsg(String msg, String desc) {
        StringBuilder builder = new StringBuilder(msg);
        return builder.append(desc).toString();
    }

    private void buildCreatePayOrderParmBaseParm(Long orderId, UocPebRefundReqBO uocPebRefundReqBO, OrdPayPO ordPayInfo, UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO) {
        if (uocCoreCreatePayOrderReqBO == null) {
            uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        }
        uocCoreCreatePayOrderReqBO.setOrderId(orderId);
        uocCoreCreatePayOrderReqBO.setObjId(uocPebRefundReqBO.getObjId());
        uocCoreCreatePayOrderReqBO.setObjType(uocPebRefundReqBO.getObjType());
        uocCoreCreatePayOrderReqBO.setInterType(PecConstant.INTER_TYPE_REPAY);
        uocCoreCreatePayOrderReqBO.setCreateOperId(uocPebRefundReqBO.getUserId() == null ? null : String.valueOf(uocPebRefundReqBO.getUserId()));
        uocCoreCreatePayOrderReqBO.setPayType(ordPayInfo.getPayType());
        uocCoreCreatePayOrderReqBO.setFeeType(ordPayInfo.getFeeType());
    }

    private void buildCreatePayOrderItemParmBySaleOrder(List<OrdItemPO> listOrdItems, UocPebRefundReqBO uocPebRefundReqBO, UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO, Integer servType) {
        ArrayList<UocOrderPayItemBO> uocOrderPayItemList = new ArrayList<UocOrderPayItemBO>();
        UocOrderPayItemBO uocOrderPayItemBO = null;
        for (int i = 0; i < listOrdItems.size(); ++i) {
            uocOrderPayItemBO = new UocOrderPayItemBO();
            OrdItemPO ordItemPO = listOrdItems.get(i);
            uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
            uocOrderPayItemBO.setPayObjId(uocPebRefundReqBO.getObjId());
            uocOrderPayItemBO.setPayObjType(uocPebRefundReqBO.getObjType());
            uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
            uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
            uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
            uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
            uocOrderPayItemBO.setPayCount(ordItemPO.getPurchaseCount());
            if (servType != null) {
                if (PecConstant.EXT_AFTER_SERVICE_TYPE_CODE.RETURN.equals(servType)) {
                    uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
                    uocOrderPayItemBO.setPayFee(ordItemPO.getTotalSaleFee());
                } else {
                    uocOrderPayItemBO.setTotalFee(0L);
                    uocOrderPayItemBO.setPayFee(0L);
                }
            } else {
                uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
                uocOrderPayItemBO.setPayFee(ordItemPO.getTotalSaleFee());
            }
            uocOrderPayItemList.add(uocOrderPayItemBO);
        }
        uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(uocOrderPayItemList);
    }

    private void buildCreatePayOrderParmByOrder(Long totalFee, List<OrdItemPO> listOrdItems, UocPebRefundReqBO uocPebRefundReqBO, UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO) {
        uocCoreCreatePayOrderReqBO.setTotalFee(totalFee);
        uocCoreCreatePayOrderReqBO.setPayFee(totalFee);
        this.buildCreatePayOrderItemParmBySaleOrder(listOrdItems, uocPebRefundReqBO, uocCoreCreatePayOrderReqBO, null);
    }

    private void buildCreatePayOrderParmBy(Long totalFee, List<Long> listByItemList, UocPebRefundReqBO uocPebRefundReqBO, UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO, Integer servType) {
        uocCoreCreatePayOrderReqBO.setTotalFee(totalFee);
        ArrayList<OrdItemPO> listOrdItems = new ArrayList();
        try {
            listOrdItems = this.pecOrdItemMapper.getListByItemList(listByItemList, uocPebRefundReqBO.getOrderId());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("101022", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5f02\u5e38");
        }
        this.buildCreatePayOrderItemParmBySaleOrder(listOrdItems, uocPebRefundReqBO, uocCoreCreatePayOrderReqBO, servType);
    }

    private void buildCreatePayOrderParmByAb(UocPebRefundReqBO uocPebRefundReqBO, UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO) {
        uocCoreCreatePayOrderReqBO.setTotalFee(uocPebRefundReqBO.getFee());
        ArrayList<UocOrderPayItemBO> list = new ArrayList<UocOrderPayItemBO>();
        for (UocOrderPayItemAtomBO payItemBO : uocPebRefundReqBO.getPayItemBOList()) {
            UocOrderPayItemBO uocOrderPayItemBO = new UocOrderPayItemBO();
            BeanUtils.copyProperties((Object)payItemBO, (Object)uocOrderPayItemBO);
            list.add(uocOrderPayItemBO);
        }
        uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(list);
    }

    private UocCoreCompletePayOrderReqBO buildCoreCompletePayOrderParm(Long payVoucherId, String txnNo, UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO) {
        UocCoreCompletePayOrderReqBO uocCoreCompletePayOrderReqBO = new UocCoreCompletePayOrderReqBO();
        uocCoreCompletePayOrderReqBO.setOrderId(uocCoreCreatePayOrderReqBO.getOrderId());
        uocCoreCompletePayOrderReqBO.setObjId(uocCoreCreatePayOrderReqBO.getObjId());
        uocCoreCompletePayOrderReqBO.setObjType(uocCoreCreatePayOrderReqBO.getObjType());
        uocCoreCompletePayOrderReqBO.setCreateOperId(uocCoreCreatePayOrderReqBO.getCreateOperId());
        uocCoreCompletePayOrderReqBO.setTotalFee(uocCoreCreatePayOrderReqBO.getTotalFee());
        uocCoreCompletePayOrderReqBO.setPayFee(uocCoreCreatePayOrderReqBO.getPayFee());
        uocCoreCompletePayOrderReqBO.setPayVoucherId(payVoucherId);
        uocCoreCompletePayOrderReqBO.setOutPayOrderNo(txnNo);
        return uocCoreCompletePayOrderReqBO;
    }

    private Long string2Long(String val) {
        if (val == null) {
            return null;
        }
        return Long.valueOf(val);
    }
}

