/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.AgreementSettlementBO;
import com.tydic.uoc.common.ability.bo.CommodityAttrRspBO;
import com.tydic.uoc.common.ability.bo.UocEnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.UocOrdAgreementBO;
import com.tydic.uoc.common.atom.api.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreatePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateSaleOrderAtomService;
import com.tydic.uoc.common.atom.api.UocProCreateOrderSaveDataAtomService;
import com.tydic.uoc.common.atom.bo.AtomUocCoreCreateOrderReqBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsAttrBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderItemBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.common.atom.bo.UocProCreateOrderSaveDataAtomRspBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderAddressReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.UocOrdItemDataPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocProCreateOrderSaveDataAtomServiceImpl
implements UocProCreateOrderSaveDataAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocProCreateOrderSaveDataAtomServiceImpl.class);
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocOrdRequestAddressMapper dealCoreCreateLogisticsRela;
    @Value(value="${SUPPLIER_JD_ID}")
    private String supplierJdId;
    @Autowired
    private UocCoreCreateSaleOrderAtomService uocCoreCreateSaleOrderAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private UocCoreCreateOrderAtomService uocCoreCreateOrderAtomService;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Value(value="${uoc.saveJdOrgId:false}")
    private Boolean saveJdOrgId;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;

    @Override
    public UocProCreateOrderSaveDataAtomRspBo saveOrderData(UocProCreateOrderCombReqBo reqBO) {
        List ordItemList;
        UocProCreateOrderSaveDataAtomRspBo rspBO = (UocProCreateOrderSaveDataAtomRspBo)UocProRspBoUtil.success(UocProCreateOrderSaveDataAtomRspBo.class);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIsUpdate()) && reqBO.getIsUpdate().booleanValue()) {
            Long requestId = reqBO.getRequestId();
            Integer sortNo = this.ordSaleMapper.getMaxSortNo(requestId);
            reqBO.setSortOrderNo(sortNo + 1);
        }
        Long supId = reqBO.getOrderItemList().get(0).getSupplierId();
        String supName = reqBO.getOrderItemList().get(0).getSupplierName();
        Long orderId = this.idUtil.nextId();
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getAddressBo());
        UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = this.buildCreateSaleOrderParam(reqBO.getRequestId(), reqBO.getRequestCode(), orderId, reqBO);
        uocCoreCreateSaleOrderReqBO.setProcKey(reqBO.getProcKey());
        log.debug("3.\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u9500\u552e\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2:" + JSON.toJSONString((Object)uocCoreCreateSaleOrderReqBO));
        UocCoreCreateSaleOrderRspBO uocCoreCreateSaleOrderRspBO = this.uocCoreCreateSaleOrderAtomService.dealCoreCreateSaleOrder(uocCoreCreateSaleOrderReqBO);
        if (!"0000".equals(uocCoreCreateSaleOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102109", uocCoreCreateSaleOrderRspBO.getRespDesc());
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(orderId);
        try {
            ordItemList = this.ordItemMapper.getList(ordItemPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102109", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5931\u8d25!", (Throwable)e);
        }
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = this.buildCreatePayOrderParm(ordItemList, reqBO, orderId, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        UocCoreCreatePayOrderRspBO uocCoreCreatePayOrderRspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
        if (!"0000".equals(uocCoreCreatePayOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102109", "\u652f\u4ed8\u5355\u521b\u5efa\u5931\u8d25!" + uocCoreCreatePayOrderRspBO.getRespDesc());
        }
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = this.buildCreateOrderParam(orderId, reqBO, uocCoreCreatePayOrderReqBO);
        uocCoreCreateOrderReqBO.setSupName(supName);
        uocCoreCreateOrderReqBO.setSupId(supId);
        uocCoreCreateOrderReqBO.setPurOrgPath(reqBO.getOrgPath());
        uocCoreCreateOrderReqBO.setSupRelaName(reqBO.getOrderItemList().get(0).getContact());
        uocCoreCreateOrderReqBO.setSupRelaMobile(reqBO.getOrderItemList().get(0).getRelPhone());
        UocCoreCreateOrderRspBO uocCoreCreateOrderRspBO = this.uocCoreCreateOrderAtomService.dealCoreCreateOrder(uocCoreCreateOrderReqBO);
        if (!"0000".equals(uocCoreCreateOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102109", "\u6838\u5fc3\u8ba2\u5355\u521b\u5efa\u5931\u8d25!" + uocCoreCreateOrderRspBO.getRespDesc());
        }
        this.saveAccessory(reqBO, orderId);
        this.saveExt(reqBO, orderId, ordItemList);
        this.savePayConfInfo(reqBO, orderId);
        rspBO.setOrderId(orderId);
        rspBO.setTotalFee(UocMoneyUtil.long2BigDecimal((Long)this.sumOrderFee(ordItemList)));
        rspBO.setSaleVoucherId(uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        return rspBO;
    }

    private void saveInvoice(UocProCreateOrderCombReqBo reqBO, Long orderId, Long saleId) {
        Long id = this.idUtil.nextId();
        OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
        ordInvoicePO.setInvoiceType(Integer.valueOf(1));
        ordInvoicePO.setBuyerName(reqBO.getAccountBO().getAccountName());
        ordInvoicePO.setOrderId(orderId);
        ordInvoicePO.setId(id);
        ordInvoicePO.setSaleVoucherId(saleId);
        ordInvoicePO.setInvoiceNo(reqBO.getAccountBO().getOrgCertificateCode());
        this.ordInvoiceMapper.insert(ordInvoicePO);
    }

    private void savePayConfInfo(UocProCreateOrderCombReqBo reqBO, Long orderId) {
        UocOrdAgreementBO agreementBO = reqBO.getOrderItemList().get(0).getAgreementBO();
        if (agreementBO != null) {
            ArrayList<OrdPayConfPO> payConfPOS = new ArrayList<OrdPayConfPO>();
            if (UocCoreConstant.TradeMode.TRADE_MODEL.equals(agreementBO.getTradeMode())) {
                for (AgreementSettlementBO agreementSettlementBO : agreementBO.getPaymentMethod()) {
                    OrdPayConfPO payConfPO = new OrdPayConfPO();
                    payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                    payConfPO.setOrderId(orderId);
                    if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                        payConfPO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                        payConfPO.setUserType(UocCoreConstant.UserType.PRO);
                    } else {
                        payConfPO.setPayType(reqBO.getPayType());
                        payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                    }
                    if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                        payConfPO.setPilPaySup(new BigDecimal(100));
                        if ("2".equals(agreementSettlementBO.getAssign())) {
                            payConfPO.setPayRule(Integer.valueOf(2));
                            payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                        } else {
                            payConfPO.setPayRule(Integer.valueOf(1));
                            payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                        }
                    } else {
                        payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                        payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                        payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                        payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                    }
                    if (null == payConfPO.getPrePayFee()) {
                        payConfPO.setPrePayFee(Long.valueOf(0L));
                    }
                    payConfPO.setVerPayFee(Long.valueOf(0L));
                    payConfPO.setPilPayFee(Long.valueOf(0L));
                    payConfPO.setQuaPayFee(Long.valueOf(0L));
                    payConfPO.setPilPayFee(Long.valueOf(0L));
                    if (null != agreementBO.getWarantty()) {
                        payConfPO.setWarantty(agreementBO.getWarantty());
                    }
                    payConfPO.setIsPushQua(Integer.valueOf(0));
                    payConfPO.setTime(new Date());
                    payConfPO.setPayBreakScale(BigDecimal.ZERO);
                    payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                    payConfPO.setPayNodeRule(Integer.valueOf(2));
                    payConfPOS.add(payConfPO);
                }
            } else {
                OrdPayConfPO payConfPO = new OrdPayConfPO();
                for (AgreementSettlementBO agreementSettlementBO : agreementBO.getPaymentMethod()) {
                    if (!"1".equals(agreementSettlementBO.getSettlementObject())) continue;
                    payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                    payConfPO.setOrderId(orderId);
                    if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                        payConfPO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                        payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                    }
                    if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                        payConfPO.setPilPaySup(new BigDecimal(100));
                        if ("2".equals(agreementSettlementBO.getAssign())) {
                            payConfPO.setPayRule(Integer.valueOf(2));
                            payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                        } else {
                            payConfPO.setPayRule(Integer.valueOf(1));
                            payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                        }
                    } else {
                        payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                        payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                        payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                        payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                    }
                    if (null != agreementBO.getWarantty()) {
                        payConfPO.setWarantty(agreementBO.getWarantty());
                    }
                    payConfPO.setIsPushQua(Integer.valueOf(0));
                    payConfPO.setTime(new Date());
                    payConfPO.setPayBreakScale(BigDecimal.ZERO);
                    payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                    payConfPO.setPayNodeRule(Integer.valueOf(2));
                    payConfPOS.add(payConfPO);
                    break;
                }
            }
            if (!ObjectUtil.isEmpty(payConfPOS)) {
                this.ordPayConfMapper.insertBatch(payConfPOS);
            }
        }
    }

    private void saveExt(UocProCreateOrderCombReqBo reqBO, Long orderId, List<OrdItemPO> ordItemList) {
        OrdExtMapPO ordExtMapPO;
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        ArrayList<OrdItemMapPO> itemMapPOS = new ArrayList<OrdItemMapPO>();
        for (UocProCreateOrderCombOrderItemReqBo skuInfo : reqBO.getOrderItemList()) {
            if (skuInfo.getChannel() == null) continue;
            for (OrdItemPO itemPO : ordItemList) {
                OrdExtMapPO extMapPO = new OrdExtMapPO();
                extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                extMapPO.setFieldValue(skuInfo.getChannel().toString());
                extMapPO.setFieldName("\u5546\u54c1\u9891\u9053");
                extMapPO.setFieldCode("channel");
                extMapPO.setOrderId(orderId);
                extMapPO.setObjId(itemPO.getOrdItemId());
                extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
                list.add(extMapPO);
                OrdItemMapPO mapPO = new OrdItemMapPO();
                mapPO.setOrderId(orderId);
                mapPO.setId(Long.valueOf(this.idUtil.nextId()));
                mapPO.setOrderItemId(itemPO.getOrdItemId());
                mapPO.setFieldValue(String.valueOf(skuInfo.getSoldNumber()));
                mapPO.setFieldName("\u5e93\u5b58");
                mapPO.setFieldCode("stock");
                itemMapPOS.add(mapPO);
            }
        }
        if (CollectionUtils.isNotEmpty(itemMapPOS)) {
            this.ordItemMapMapper.insertBatch(itemMapPOS);
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrderItemList().get(0).getPurchType())) {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            extMapPO.setFieldValue(reqBO.getOrderItemList().get(0).getPurchType().toString());
            extMapPO.setFieldName("\u91c7\u8d2d\u6a21\u5f0f");
            extMapPO.setFieldCode("purType");
            extMapPO.setOrderId(orderId);
            extMapPO.setObjId(orderId);
            extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(extMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderItemList().get(0).getExtField2())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(reqBO.getOrderItemList().get(0).getExtField2());
            ordExtMapPO.setFieldName("\u534f\u8baeecp\u5408\u540c\u7f16\u53f7");
            ordExtMapPO.setFieldCode("agrEcpHt");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderItemList().get(0).getExtField1())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(reqBO.getOrderItemList().get(0).getExtField1());
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f");
            ordExtMapPO.setFieldCode("purMod");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderItemList().get(0).getExtField1Str())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(reqBO.getOrderItemList().get(0).getExtField1Str());
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f\u7ffb\u8bd1");
            ordExtMapPO.setFieldCode("purModStr");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        if (this.saveJdOrgId != null && this.saveJdOrgId.booleanValue()) {
            OrdExtMapPO jdOrgId = new OrdExtMapPO();
            jdOrgId.setId(Long.valueOf(this.idUtil.nextId()));
            jdOrgId.setFieldValue(reqBO.getCompanyId().toString());
            jdOrgId.setFieldName("\u91c7\u8d2d\u5355\u4f4did");
            jdOrgId.setFieldCode("jdOrgId");
            jdOrgId.setOrderId(orderId);
            jdOrgId.setObjId(orderId);
            jdOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(jdOrgId);
        }
        OrdExtMapPO ComOrgId = new OrdExtMapPO();
        ComOrgId.setId(Long.valueOf(this.idUtil.nextId()));
        ComOrgId.setFieldValue(reqBO.getCompanyId().toString());
        ComOrgId.setFieldName("\u516c\u53f8id");
        ComOrgId.setFieldCode("companyId");
        ComOrgId.setOrderId(orderId);
        ComOrgId.setObjId(orderId);
        ComOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(ComOrgId);
    }

    private void saveAccessory(UocProCreateOrderCombReqBo reqBO, Long orderId) {
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>();
        for (UocProCreateOrderCombOrderItemReqBo item : reqBO.getOrderItemList()) {
            if (!ObjectUtil.isNotEmpty((Object)item.getAccessoryInfo())) continue;
            OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
            BeanUtils.copyProperties((Object)item.getAccessoryInfo(), (Object)accessoryPO);
            accessoryPO.setOrderId(orderId);
            accessoryPO.setObjectId(item.getOrdItemId());
            accessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            accessoryPO.setCreateTime(new Date());
            accessoryPO.setCreateOperId(reqBO.getUsername());
            accessoryPO.setAttachmentType(Integer.valueOf(2));
            list.add(accessoryPO);
        }
        try {
            this.ordAccessoryMapper.insertBatch(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AtomUocCoreCreateOrderReqBO buildCreateOrderParam(Long orderId, UocProCreateOrderCombReqBo reqBO, UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO) {
        UocOrdAgreementBO agreementBO;
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = new AtomUocCoreCreateOrderReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)uocCoreCreateOrderReqBO));
        uocCoreCreateOrderReqBO.setName(reqBO.getName());
        uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getName());
        uocCoreCreateOrderReqBO.setUserId(reqBO.getUserId());
        uocCoreCreateOrderReqBO.setOrgId(reqBO.getOrgId());
        uocCoreCreateOrderReqBO.setCompanyId(reqBO.getCompanyId());
        uocCoreCreateOrderReqBO.setCompanyName(reqBO.getCompanyName());
        uocCoreCreateOrderReqBO.setOrderId(orderId);
        uocCoreCreateOrderReqBO.setOrderNo(CommUtils.long2String((Long)orderId));
        uocCoreCreateOrderReqBO.setOrderType(reqBO.getOrderType());
        uocCoreCreateOrderReqBO.setUserType(reqBO.getMemUserType());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLoginSource())) {
            uocCoreCreateOrderReqBO.setExtField2(reqBO.getLoginSource());
        }
        uocCoreCreateOrderReqBO.setPayType("0");
        uocCoreCreateOrderReqBO.setPayOrderId(0L);
        uocCoreCreateOrderReqBO.setSaleFee(uocCoreCreatePayOrderReqBO.getTotalFee());
        uocCoreCreateOrderReqBO.setCreateOperId(CommUtils.long2String((Long)reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setOrderDesc(reqBO.getRequestReason());
        uocCoreCreateOrderReqBO.setPurId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurName(reqBO.getOrgName());
        uocCoreCreateOrderReqBO.setPurAccount(reqBO.getPurchaserAccount().toString());
        uocCoreCreateOrderReqBO.setPurPlaceOrderId(CommUtils.long2String((Long)reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setPurPlaceOrderName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setUserType(reqBO.getMemUserType());
        if (reqBO.getOrgLevel() != null) {
            uocCoreCreateOrderReqBO.setOrgLevel(reqBO.getOrgLevel());
        }
        uocCoreCreateOrderReqBO.setPurOrgId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurOrgPath(reqBO.getOrgPath());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderItemList().get(0).getGoodsSupplierId()) && ObjectUtil.isNotEmpty((Object)reqBO.getOrderItemList().get(0).getGoodsSupplierId())) {
            uocCoreCreateOrderReqBO.setSupId(Long.valueOf(reqBO.getOrderItemList().get(0).getGoodsSupplierId()));
        }
        uocCoreCreateOrderReqBO.setSupName(reqBO.getOrderItemList().get(0).getSkuSupplierName());
        uocCoreCreateOrderReqBO.setProId(reqBO.getProfessionalOrganizationId().toString());
        uocCoreCreateOrderReqBO.setProAccount(reqBO.getProAccount().toString());
        uocCoreCreateOrderReqBO.setPurAccountOwnId(reqBO.getPurchaserAccountOrgId().toString());
        uocCoreCreateOrderReqBO.setProAccountOwnName(reqBO.getProPath());
        uocCoreCreateOrderReqBO.setPurNo(reqBO.getOrgIdIn().toString());
        uocCoreCreateOrderReqBO.setSupName(reqBO.getSupName());
        UocEnterpriseAccountBO accountBO = reqBO.getAccountBO();
        if (accountBO != null) {
            uocCoreCreateOrderReqBO.setPurMobile(accountBO.getTelephone());
            uocCoreCreateOrderReqBO.setProName(accountBO.getDeliveryCenterName());
            uocCoreCreateOrderReqBO.setPurName(accountBO.getOrgName());
            uocCoreCreateOrderReqBO.setPurAccountName(accountBO.getAccountName());
            uocCoreCreateOrderReqBO.setPurAccountOwnName(accountBO.getAccountName());
            uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getUsername());
            uocCoreCreateOrderReqBO.setPurRelaMobile(accountBO.getTelephone());
        }
        if ((agreementBO = reqBO.getOrderItemList().get(0).getAgreementBO()) != null) {
            uocCoreCreateOrderReqBO.setProDeliveryId(String.valueOf(agreementBO.getProducerId()));
            uocCoreCreateOrderReqBO.setProDeliveryName(agreementBO.getProducerName());
        }
        uocCoreCreateOrderReqBO.setPurLogName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getName());
        return uocCoreCreateOrderReqBO;
    }

    private UocCoreCreatePayOrderReqBO buildCreatePayOrderParm(List<OrdItemPO> ordItemList, UocProCreateOrderCombReqBo reqBO, Long orderId, Long saleOrderId) {
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        Long totalSaleFee = this.sumOrderFee(ordItemList);
        uocCoreCreatePayOrderReqBO.setPayVoucherNo(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd") + orderId);
        uocCoreCreatePayOrderReqBO.setOrderId(orderId);
        uocCoreCreatePayOrderReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        uocCoreCreatePayOrderReqBO.setObjId(saleOrderId);
        uocCoreCreatePayOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        uocCoreCreatePayOrderReqBO.setPayType(3);
        uocCoreCreatePayOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        uocCoreCreatePayOrderReqBO.setTotalFee(totalSaleFee);
        uocCoreCreatePayOrderReqBO.setPreFee(0L);
        try {
            uocCoreCreatePayOrderReqBO.setPayFee(totalSaleFee);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102109", "\u652f\u4ed8\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        uocCoreCreatePayOrderReqBO.setCreateOperId(reqBO.getUserId().toString());
        uocCoreCreatePayOrderReqBO.setPayState(PecConstant.PAY_STAT_WAIT);
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>();
        if (!CollectionUtils.isEmpty(ordItemList)) {
            OrdItemPO ordItemPO = null;
            UocOrderPayItemBO uocOrderPayItemBO = null;
            for (int i = 0; i < ordItemList.size(); ++i) {
                ordItemPO = ordItemList.get(i);
                uocOrderPayItemBO = new UocOrderPayItemBO();
                uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjId(ordItemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
                uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
                uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
                uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
                uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
                uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
                uocOrderPayItemBO.setPayCount(ordItemPO.getPurchaseCount());
                uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
                uocOrderPayItemBO.setPayFee(ordItemPO.getTotalSaleFee());
                uocOrderPayItemBOList.add(uocOrderPayItemBO);
            }
        }
        uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        return uocCoreCreatePayOrderReqBO;
    }

    private Long sumOrderFee(List<OrdItemPO> ordItemList) {
        Long orderFee = 0L;
        for (OrdItemPO ordItemPO : ordItemList) {
            Long totalSaleFee = ordItemPO.getTotalSaleFee();
            orderFee = orderFee + totalSaleFee;
        }
        return orderFee;
    }

    private UocCoreCreateSaleOrderReqBO buildCreateSaleOrderParam(Long requestId, String requestCode, Long orderId, UocProCreateOrderCombReqBo reqBO) {
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = new UocCoreCreateSaleOrderReqBO();
        uocCoreCreateSaleOrderReqBO.setSortOrderNo(reqBO.getSortOrderNo());
        uocCoreCreateSaleOrderReqBO.setRequestType(reqBO.getRequestType());
        if (null != reqBO.getOldOrderId()) {
            uocCoreCreateSaleOrderReqBO.setOldOrderId(reqBO.getOldOrderId());
        }
        ArrayList<UocOrderItemBO> uocOrderItemList = new ArrayList<UocOrderItemBO>();
        Long purchaseFee = 0L;
        BigDecimal totalAm = BigDecimal.ZERO;
        List<UocProCreateOrderCombOrderItemReqBo> orderSaleItemList = reqBO.getOrderItemList();
        Long comTypeDataId = orderSaleItemList.get(0).getComTypeDataId();
        if (comTypeDataId != null) {
            uocCoreCreateSaleOrderReqBO.setComTypeDataId(comTypeDataId);
        }
        UocOrdAgreementBO agreementBO = null;
        for (UocProCreateOrderCombOrderItemReqBo skuInfo : orderSaleItemList) {
            if (skuInfo.getAgreementBO() != null && agreementBO == null) {
                agreementBO = skuInfo.getAgreementBO();
            }
            UocOrderItemBO uocOrderItemBO = new UocOrderItemBO();
            Long itemId = this.idUtil.nextId();
            uocOrderItemBO.setOrdItemId(itemId);
            skuInfo.setOrdItemId(itemId);
            UocOrdItemDataPo dataPo = new UocOrdItemDataPo();
            BeanUtils.copyProperties((Object)skuInfo, (Object)dataPo);
            if (ObjectUtil.isNotEmpty((Object)skuInfo.getIsFix())) {
                dataPo.setIsFix(Integer.valueOf(skuInfo.getIsFix()));
            }
            if (ObjectUtil.isNotEmpty((Object)skuInfo.getFitmentStandard())) {
                dataPo.setFitmentStandard(Integer.valueOf(skuInfo.getFitmentStandard()));
            }
            if (skuInfo.getCommodityTypeReqBo() != null) {
                dataPo.setComTypeId(skuInfo.getCommodityTypeReqBo().getComTypeId());
                dataPo.setComTypeName(skuInfo.getCommodityTypeReqBo().getComTypeName());
            }
            uocOrderItemBO.setNakedPrice(skuInfo.getNakedPrice());
            dataPo.setRequestOrgId(skuInfo.getPurchasId());
            dataPo.setRequestOrgName(skuInfo.getPurchasName());
            dataPo.setOfferDate(skuInfo.getOfferDate());
            dataPo.setOfferCycle(skuInfo.getOfferCycle());
            uocOrderItemBO.setDataPo(dataPo);
            uocOrderItemBO.setTaxId(skuInfo.getTaxCode());
            if (!ObjectUtil.isEmpty((Object)skuInfo.getPlanItemNo())) {
                uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
            }
            if (this.supplierJdId.equals(String.valueOf(skuInfo.getGoodsSupplierId()))) {
                uocOrderItemBO.setUsedCompany(skuInfo.getVendorOrderType());
            }
            uocOrderItemBO.setItemType(PecConstant.ORD_SALE_ITEM_TYPE_SKU);
            if (ObjectUtil.isNotEmpty((Object)skuInfo.getSkuId())) {
                uocOrderItemBO.setSkuId(skuInfo.getSkuId() + "");
            }
            uocOrderItemBO.setTaxId(skuInfo.getTaxCode());
            uocOrderItemBO.setSkuName(skuInfo.getSkuName());
            uocOrderItemBO.setSkuSimpleName(skuInfo.getSkuName());
            uocOrderItemBO.setSupNo(String.valueOf(skuInfo.getGoodsSupplierId()));
            uocOrderItemBO.setSupplierShopId(skuInfo.getSupplierShopId());
            uocOrderItemBO.setOldOrdItemId(skuInfo.getOldOrdItemId());
            Long skuSalePrice = 0L;
            Long skupurchasePrice = 0L;
            Long totalSkuSaleFee = 0L;
            Long totalSkuPurchaseFee = 0L;
            try {
                skuSalePrice = UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice());
                skupurchasePrice = UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice());
                BigDecimal divide = skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount());
                totalSkuSaleFee = UocMoneyUtil.bigDecimalToLong((BigDecimal)divide);
                if (ObjectUtil.isNotEmpty((Object)skuInfo.getSkuAgreementPrice())) {
                    BigDecimal multiply = skuInfo.getSkuAgreementPrice().multiply(skuInfo.getPurchaseCount());
                    totalSkuPurchaseFee = UocMoneyUtil.bigDecimalToLong((BigDecimal)multiply);
                }
                purchaseFee = purchaseFee + totalSkuPurchaseFee;
                totalAm = totalAm.add(UocMoneyUtil.long2BigDecimal((Long)totalSkuSaleFee));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("102109", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            uocOrderItemBO.setSalePrice(skuSalePrice);
            uocOrderItemBO.setPurchasePrice(skupurchasePrice);
            uocOrderItemBO.setTotalSaleFee(totalSkuSaleFee);
            uocOrderItemBO.setTotalPurchaseFee(totalSkuPurchaseFee);
            uocOrderItemBO.setCurrencyType(skuInfo.getSkuCurrencyType());
            uocOrderItemBO.setRecvAddr(skuInfo.getComparisonGoodsNo());
            uocOrderItemBO.setUnitName(skuInfo.getMeasureName());
            uocOrderItemBO.setSettleUnit(skuInfo.getSettlementUnit());
            uocOrderItemBO.setPurchaseCount(skuInfo.getPurchaseCount());
            if (skuInfo.getPlanItemId() != null) {
                uocOrderItemBO.setPlanItemId(skuInfo.getPlanItemId());
            }
            if (skuInfo.getPlanId() != null) {
                uocOrderItemBO.setPlanId(skuInfo.getPlanId());
            }
            uocOrderItemBO.setRateCode(skuInfo.getRateCode());
            uocOrderItemBO.setSapSkuLineNum(skuInfo.getSapSkuLineNum());
            uocOrderItemBO.setEnterpriseCode(skuInfo.getEnterpriseCode());
            uocOrderItemBO.setQuotedUrl(skuInfo.getQuotedUrl());
            OrdGoodsBO ordGoodsBO = new OrdGoodsBO();
            BeanUtils.copyProperties((Object)skuInfo, (Object)ordGoodsBO);
            if (ObjectUtil.isNotEmpty((Object)skuInfo.getSkuId())) {
                ordGoodsBO.setSkuId(skuInfo.getSkuId() + "");
            }
            ordGoodsBO.setSkuName(skuInfo.getSkuName());
            ordGoodsBO.setSkuSupplierId(skuInfo.getSkuSupplierId());
            ordGoodsBO.setSkuSupplierName(skuInfo.getSkuSupplierName());
            ordGoodsBO.setSkuMaterialId(skuInfo.getSkuMaterialId());
            ordGoodsBO.setSkuMaterialName(skuInfo.getSkuMaterialName());
            ordGoodsBO.setSkuExtSkuId(skuInfo.getSkuExtSkuId());
            ordGoodsBO.setSkuUpcCode(skuInfo.getSkuUpcCode());
            ordGoodsBO.setSkuCommodityTypeId(skuInfo.getSkuCommodityTypeId());
            ordGoodsBO.setSkuLocation(skuInfo.getSkuLocation());
            ordGoodsBO.setSkuMainPicUrl(skuInfo.getSkuMainPicUrl());
            ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
            ordGoodsBO.setSkuSaleArea(skuInfo.getSkuSaleArea());
            ordGoodsBO.setSkuStatus(skuInfo.getSkuStatus());
            if (!ObjectUtil.isEmpty((Object)skuInfo.getBrandId())) {
                ordGoodsBO.setSkuBrandId(ElUtils.string2Long(skuInfo.getBrandId()));
            }
            ordGoodsBO.setSkuBrandName(skuInfo.getSkuBrandName());
            ordGoodsBO.setSkuIsSupplierAgreement(skuInfo.getSkuIsSupplierAgreement());
            try {
                ordGoodsBO.setSkuMarketPrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuMarketPrice()));
                ordGoodsBO.setSkuAgreementPrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice()));
                ordGoodsBO.setSkuMemberPrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuMemberPrice()));
                ordGoodsBO.setSkuSalePrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ordGoodsBO.setSkuCurrencyType(skuInfo.getSkuCurrencyType());
            ordGoodsBO.setSupplierShopId(skuInfo.getSupplierShopId());
            ordGoodsBO.setNcMaterialCode(skuInfo.getNcMaterialCode());
            ArrayList<OrdGoodsAttrBO> ordGoodsAttrBOList = new ArrayList<OrdGoodsAttrBO>();
            if (CollectionUtils.isNotEmpty(skuInfo.getCommodityAttrList())) {
                for (CommodityAttrRspBO commodityAttrRspBO : skuInfo.getCommodityAttrList()) {
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(commodityAttrRspBO.getSkuCommodityPropGrpId());
                    ordGoodsAttrBO.setSkuCommoditySpecId(commodityAttrRspBO.getSkuCommoditySpecId());
                    ordGoodsAttrBO.setSkuPropName(commodityAttrRspBO.getSkuPropName());
                    ordGoodsAttrBO.setSkuPropShowName(commodityAttrRspBO.getSkuPropShowName());
                    ordGoodsAttrBO.setSkuPropValue(commodityAttrRspBO.getSkuPropValue());
                    ordGoodsAttrBO.setSkuPropValueListId(commodityAttrRspBO.getSkuPropValueListId());
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
            }
            ordGoodsBO.setOrdGoodsAttrBOList(ordGoodsAttrBOList);
            uocOrderItemBO.setOrdGoodsBO(ordGoodsBO);
            if (ObjectUtil.isNotEmpty((Object)skuInfo.getSpuId())) {
                uocOrderItemBO.setSpuId(skuInfo.getSpuId() + "");
            }
            uocOrderItemBO.setTax(skuInfo.getTax());
            uocOrderItemBO.setQuotationNum(skuInfo.getQuotationNum());
            uocOrderItemBO.setQuotationLineNum(skuInfo.getQuotationLineNum());
            uocOrderItemList.add(uocOrderItemBO);
        }
        if (agreementBO != null) {
            uocCoreCreateSaleOrderReqBO.setAgreementBO(agreementBO);
        }
        uocCoreCreateSaleOrderReqBO.setSaleVoucherNo(reqBO.getRequestCode() + "-" + reqBO.getSortOrderNo());
        uocCoreCreateSaleOrderReqBO.setPurchaseNo(reqBO.getRequestCode() + "-CG-" + reqBO.getSortOrderNo());
        uocCoreCreateSaleOrderReqBO.setOrderId(orderId);
        uocCoreCreateSaleOrderReqBO.setOrderLevel(0);
        uocCoreCreateSaleOrderReqBO.setOrderSource(orderSaleItemList.get(0).getOrderSource());
        uocCoreCreateSaleOrderReqBO.setPurchaseType(ElUtils.string2Integer(orderSaleItemList.get(0).getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setIsDispatch(PecConstant.IS_DISPATCH_YES);
        Long base = 0L;
        Long remote = 0L;
        Long totalTransFee = 0L;
        Long original = 0L;
        Long totalSaleFee = 0L;
        try {
            totalTransFee = UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBO.getFreightTotalFee());
            totalSaleFee = UocMoneyUtil.bigDecimal2Long((BigDecimal)totalAm);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102109", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
        }
        uocCoreCreateSaleOrderReqBO.setBaseTransFee(base);
        uocCoreCreateSaleOrderReqBO.setRemoteTransFee(remote);
        uocCoreCreateSaleOrderReqBO.setTotalTransFee(totalTransFee);
        uocCoreCreateSaleOrderReqBO.setOldTotalTransFee(original);
        uocCoreCreateSaleOrderReqBO.setSaleFee(totalSaleFee);
        uocCoreCreateSaleOrderReqBO.setGiveTime(new DateTime((Object)reqBO.getGiveTime()).toString("yyyy-MM-dd HH:mm:ss"));
        uocCoreCreateSaleOrderReqBO.setContactId(reqBO.getRequestAddressId());
        UocProCreateOrderAddressReqBo addressInfo = reqBO.getAddressBo();
        uocCoreCreateSaleOrderReqBO.setAccNbr(addressInfo.getReceiverMobileNumber());
        uocCoreCreateSaleOrderReqBO.setProvinceId(addressInfo.getReceiverProvinceId());
        uocCoreCreateSaleOrderReqBO.setCityId(addressInfo.getReceiverCityId());
        uocCoreCreateSaleOrderReqBO.setAreaId(addressInfo.getReceiverCountyId());
        uocCoreCreateSaleOrderReqBO.setAddress(addressInfo.getReceiverAddress());
        uocCoreCreateSaleOrderReqBO.setPurchaseFee(purchaseFee);
        uocCoreCreateSaleOrderReqBO.setUocOrderItemList(uocOrderItemList);
        uocCoreCreateSaleOrderReqBO.setRequestId(requestId);
        uocCoreCreateSaleOrderReqBO.setRequestCode(requestCode);
        return uocCoreCreateSaleOrderReqBO;
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, UocProCreateOrderAddressReqBo addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        return uocCoreCreateLogisticsRelaReqBO;
    }
}

