/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.ability.api.UccMallSalesVolumeAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSaleNumBo;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSalesVolumeBO;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSalesVolumeReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSalesVolumeRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.atom.api.UocProUpdateCommodityStockAtomService;
import com.tydic.uoc.common.atom.bo.UocProUpdateCommodityStockAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProUpdateCommodityStockAtomRspBo;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.po.OrdItemPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocProUpdateCommodityStockAtomServiceImpl
implements UocProUpdateCommodityStockAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocProUpdateCommodityStockAtomServiceImpl.class);
    @Autowired
    private UccMallSalesVolumeAbilityService uccMallSalesVolumeAbilityService;
    @Autowired
    private OrdItemMapper ordItemMapper;

    @Override
    public UocProUpdateCommodityStockAtomRspBo updateStock(UocProUpdateCommodityStockAtomReqBo reqBo) {
        UocProUpdateCommodityStockAtomRspBo rspBo = (UocProUpdateCommodityStockAtomRspBo)UocProRspBoUtil.success(UocProUpdateCommodityStockAtomRspBo.class);
        this.validateArg(reqBo);
        Long orderId = reqBo.getOrderId();
        Integer incOrDec = reqBo.getIncOrDec();
        OrdItemPO qryOrdItem = new OrdItemPO();
        qryOrdItem.setOrderId(orderId);
        List list = this.ordItemMapper.getList(qryOrdItem);
        if (ObjectUtil.isEmpty((Object)list)) {
            return rspBo;
        }
        UccMallUpdateSalesVolumeReqBO updateStokReqBo = new UccMallUpdateSalesVolumeReqBO();
        updateStokReqBo.setUccUpdateSalesVolumeBOS(new ArrayList());
        UccMallUpdateSalesVolumeBO uccUpdateBo = new UccMallUpdateSalesVolumeBO();
        uccUpdateBo.setSupplierShopId(((OrdItemPO)list.get(0)).getSupplierShopId());
        uccUpdateBo.setSaleNumBos(new ArrayList());
        for (OrdItemPO ordItemPO : list) {
            UccMallUpdateSaleNumBo uccUpdateMinBo = new UccMallUpdateSaleNumBo();
            uccUpdateMinBo.setSkuId(Long.valueOf(ordItemPO.getSkuId()));
            uccUpdateMinBo.setIncOrDec(incOrDec);
            uccUpdateMinBo.setSoldNumber(ordItemPO.getPurchaseCount());
            uccUpdateBo.getSaleNumBos().add(uccUpdateMinBo);
            updateStokReqBo.getUccUpdateSalesVolumeBOS().add(uccUpdateBo);
        }
        log.info("\u8c03\u7528\u5546\u54c1\u66f4\u65b0\u5546\u54c1\u5e93\u5b58\u5165\u53c2\uff1a" + JSON.toJSONString((Object)updateStokReqBo));
        UccMallUpdateSalesVolumeRspBO uccMallUpdateSalesVolumeRspBO = this.uccMallSalesVolumeAbilityService.updateSalesVolume(updateStokReqBo);
        log.info("\u8c03\u7528\u5546\u54c1\u66f4\u65b0\u5546\u54c1\u5e93\u5b58\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uccMallUpdateSalesVolumeRspBO));
        return rspBo;
    }

    private void validateArg(UocProUpdateCommodityStockAtomReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getIncOrDec())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[incOrDec]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

