/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcQryNoticeNodeAbilityService;
import com.tydic.cfc.ability.bo.CfcQryNoticeNodeAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryNoticeNodeAbilityRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.atom.api.UocSendMessageAtomService;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomRspBo;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocSendMessageAtomServiceImpl
implements UocSendMessageAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocSendMessageAtomServiceImpl.class);
    @Value(value="${uoc.core.noticeUrl:http://10.10.178.68:8090/message/sendInnerMessage}")
    private String noticeUrl;
    @Autowired
    private CfcQryNoticeNodeAbilityService cfcQryNoticeNodeAbilityService;
    private static final String MESSAGE_SUCCESS_CODE = "0";
    @Value(value="${uoc.notice.app.id:1000}")
    private Long uocNoticeAppId;
    @Value(value="${uoc.notice.time:6000}")
    private int noticeItemOut;

    @Override
    public UocSendMessageAtomRspBo sendMessage(UocSendMessageAtomReqBo reqBo) {
        UocSendMessageAtomRspBo rspBo = (UocSendMessageAtomRspBo)UocProRspBoUtil.success(UocSendMessageAtomRspBo.class);
        this.validadateArg(reqBo);
        CfcQryNoticeNodeAbilityReqBO cfcQryNoticeNodeAbilityReqBO = new CfcQryNoticeNodeAbilityReqBO();
        cfcQryNoticeNodeAbilityReqBO.setNoticeNodeCode(reqBo.getNoticeNodeCode());
        log.info("\u8c03\u7528\u914d\u7f6e\u4e2d\u5fc3\u67e5\u8be2\u901a\u77e5\u914d\u7f6e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cfcQryNoticeNodeAbilityReqBO));
        CfcQryNoticeNodeAbilityRspBO noticeNodeAbilityRspBO = this.cfcQryNoticeNodeAbilityService.qryNoticeNodeDetail(cfcQryNoticeNodeAbilityReqBO);
        log.info("\u8c03\u7528\u914d\u7f6e\u4e2d\u5fc3\u67e5\u8be2\u901a\u77e5\u914d\u7f6e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)noticeNodeAbilityRspBO));
        if (!"0000".equals(noticeNodeAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException(noticeNodeAbilityRspBO.getRespCode(), "\u53d1\u9001\u901a\u77e5\u5931\u8d25\uff08\u67e5\u8be2\u914d\u7f6e\uff09\uff1a" + noticeNodeAbilityRspBO.getRespDesc());
        }
        String title = noticeNodeAbilityRspBO.getCfcQryNoticeNodeBO().getNoticeName();
        String messageContent = noticeNodeAbilityRspBO.getCfcQryNoticeNodeBO().getNoticeContent();
        List<UocSendMessageAtomReqDataBo> replaceDataList = reqBo.getReplaceDataList();
        for (UocSendMessageAtomReqDataBo dataBo : replaceDataList) {
            messageContent = messageContent.replace(dataBo.getReplaceContent(), dataBo.getRealContent());
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("sendid", reqBo.getSendId());
        paramMap.put("recid", reqBo.getRecId());
        paramMap.put("appid", this.uocNoticeAppId);
        paramMap.put("titel", title);
        paramMap.put("text", messageContent);
        log.info("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u53d1\u9001\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(paramMap));
        String resultStr = HttpUtil.post((String)this.noticeUrl, paramMap);
        JSONObject resultMap = JSON.parseObject((String)resultStr);
        log.info("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u53d1\u9001\u6d88\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)resultMap));
        if (!MESSAGE_SUCCESS_CODE.equals(resultMap.get("code"))) {
            throw new UocProBusinessException("104047", "\u53d1\u9001\u901a\u77e5\u5931\u8d25\uff1a" + resultMap.get("message").toString());
        }
        return rspBo;
    }

    private void validadateArg(UocSendMessageAtomReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSendId())) {
            log.info(JSON.toJSONString((Object)reqBo));
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[sendId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getNoticeNodeCode())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[noticeNodeCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRecId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[recId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBo.getReplaceDataList())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[replaceDataList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocSendMessageAtomReqDataBo uocSendMessageAtomReqDataBo : reqBo.getReplaceDataList()) {
            this.validateData(uocSendMessageAtomReqDataBo);
        }
    }

    private void validateData(UocSendMessageAtomReqDataBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRealContent())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[realContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReplaceContent())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[replaceContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

