/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.BgyCatalogInModRequestNoCostAbilityRspBO;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveRestartAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveRestartReqBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveRestartRspBO;
import com.tydic.uoc.common.atom.bo.BgyRestartKtApproveInfo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.BgyCatalogInModRequestNoCostBusiService;
import com.tydic.uoc.common.comb.bo.BgyCatalogInModRequestNoCostCombReqBO;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderAddressReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCompanyReqBo;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestCommodityTypeMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestCommodityTypePo;
import com.tydic.uoc.po.UocOrdRequestPo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatalogInModRequestNoCostBusiServiceImpl
implements BgyCatalogInModRequestNoCostBusiService {
    @Autowired
    private UocOrdRequestAddressMapper addressMapper;
    @Autowired
    private UocOrdRequestMapper requestMapper;
    @Autowired
    private UocOrdItemDataMapper itemDataMapper;
    @Autowired
    private UocOrdRequestCommodityTypeMapper commodityTypeMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private BgyRequestOrderApproveRestartAtomService bgyRequestOrderApproveRestartAtomService;
    @Value(value="${isKtRestart:true}")
    private Boolean isKtRestart;
    @Value(value="${k2_request_order_url:https://bgy-malluat.countrygarden.com.cn/#/index/agrOrderDetailK2?requestId=}")
    private String bizFormUrl;

    @Override
    public BgyCatalogInModRequestNoCostAbilityRspBO modRequest(BgyCatalogInModRequestNoCostCombReqBO reqBO) {
        BgyCatalogInModRequestNoCostAbilityRspBO rspBO = new BgyCatalogInModRequestNoCostAbilityRspBO();
        this.buildAndUpdateAddressInfo(reqBO);
        String formUrl = this.buildAndUpdateRequestOrderInfo(reqBO);
        this.buildAndUpdateCommodityTpyeInfo(reqBO);
        rspBO.setIsSuccess(Boolean.valueOf(true));
        rspBO.setRespCode("0000");
        rspBO.setRequestId(reqBO.getRequestId());
        rspBO.setK2FormUrl(formUrl);
        return rspBO;
    }

    private String buildAndUpdateRequestOrderInfo(BgyCatalogInModRequestNoCostCombReqBO reqBo) {
        UocProcessRunRspBO uocProcessRunRspBO;
        UocProcessRunReqBO uocProcessRunReqBO = new UocProcessRunReqBO();
        uocProcessRunReqBO.setProcDefKey("BGY_REQUEST_ORDER_STATUS");
        uocProcessRunReqBO.setObjId(reqBo.getRequestId());
        uocProcessRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        uocProcessRunReqBO.setSysCode("UOC");
        uocProcessRunReqBO.setOrderId(reqBo.getRequestId());
        uocProcessRunReqBO.setOperId("1");
        UocOrdRequestPo requestPo = this.requestMapper.selectByPrimaryKey(reqBo.getRequestId());
        String formUrl = "";
        if (this.isKtRestart.booleanValue()) {
            BgyRequestOrderApproveRestartReqBO approveRestartReqBO = new BgyRequestOrderApproveRestartReqBO();
            BgyRestartKtApproveInfo requestInfo = new BgyRestartKtApproveInfo();
            requestInfo.setK2Id(requestPo.getKtId());
            requestInfo.setBizId(reqBo.getRequestId().toString());
            requestInfo.setBizFormUrl(this.bizFormUrl + reqBo.getRequestId());
            approveRestartReqBO.setRequestInfo(requestInfo);
            approveRestartReqBO.setEsbInfo(new EsbInfoBO());
            approveRestartReqBO.setRequestId(reqBo.getRequestId());
            BgyRequestOrderApproveRestartRspBO approveRestartRspBO = this.bgyRequestOrderApproveRestartAtomService.progress(approveRestartReqBO);
            if (!"S".equalsIgnoreCase(approveRestartRspBO.getReturnStatus())) {
                throw new UocProBusinessException("101030", "k2\u91cd\u65b0\u53d1\u8d77\u5ba1\u6279\u5931\u8d25\uff1a!" + approveRestartRspBO.getReturnMsg());
            }
            formUrl = approveRestartRspBO.getFormUrl();
            if (ObjectUtil.isEmpty((Object)formUrl)) {
                throw new UocProBusinessException("101030", "\u4fee\u6539\u8bf7\u8d2d\u5355\uff0c\u53d1\u8d77\u91cd\u65b0\u5ba1\u6279\u5931\u8d25\uff1a\u8fd4\u56deurl\u4e3a\u7a7a");
            }
        }
        if (!"0000".equals((uocProcessRunRspBO = this.uocRunProcessAtomService.start(uocProcessRunReqBO)).getRespCode())) {
            throw new UocProBusinessException("101030", "\u6279\u91cf\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5931\u8d25!" + uocProcessRunRspBO.getRespDesc());
        }
        UocProCreateOrderCompanyReqBo companyInfoBo = reqBo.getCompanyInfoBo();
        UocOrdRequestPo saveRequestPo = new UocOrdRequestPo();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)saveRequestPo);
        BeanUtils.copyProperties((Object)companyInfoBo, (Object)saveRequestPo);
        saveRequestPo.setRequestStatus(Integer.valueOf(uocProcessRunRspBO.getStepId()));
        saveRequestPo.setRequestManId(reqBo.getUserId().toString());
        saveRequestPo.setRequestManName(reqBo.getName());
        if (reqBo.getOrgIdIn() != null) {
            saveRequestPo.setRequestDeptId(reqBo.getOrgIdIn().toString());
        }
        saveRequestPo.setAccountId(reqBo.getPurchaserAccount());
        saveRequestPo.setAccountName(reqBo.getPurchaserAccountName());
        saveRequestPo.setYsDeptId(companyInfoBo.getYsDeptId());
        saveRequestPo.setYsDeptName(companyInfoBo.getYsDeptName());
        saveRequestPo.setRequestDeptId(companyInfoBo.getRequestDeptId());
        saveRequestPo.setRequestDeptName(companyInfoBo.getRequestDeptName());
        if (ObjectUtil.isNotEmpty((Object)formUrl)) {
            saveRequestPo.setKtFormUrl(formUrl);
        }
        saveRequestPo.setKtId(requestPo.getKtId());
        this.requestMapper.updateByPrimaryKeySelective(saveRequestPo);
        return formUrl;
    }

    private void buildAndUpdateCommodityTpyeInfo(BgyCatalogInModRequestNoCostCombReqBO reqBO) {
        UocOrdRequestCommodityTypePo commodityTypePo = new UocOrdRequestCommodityTypePo();
        for (UocProCreateOrderCombOrderItemReqBo orderItemReqBo : reqBO.getOrderItemList()) {
            if (!ObjectUtil.isNotNull((Object)orderItemReqBo.getCommodityTypeReqBo())) continue;
            BeanUtils.copyProperties((Object)orderItemReqBo.getCommodityTypeReqBo(), (Object)commodityTypePo);
            this.commodityTypeMapper.updateByPrimaryKeySelective(commodityTypePo);
        }
    }

    private void buildAndUpdateAddressInfo(BgyCatalogInModRequestNoCostCombReqBO reqBo) {
        UocProCreateOrderAddressReqBo addressBo = reqBo.getAddressBo();
        UocOrdRequestAddressPo addAddrPo = new UocOrdRequestAddressPo();
        BeanUtils.copyProperties((Object)addressBo, (Object)addAddrPo);
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactTown(addressBo.getReceiverTown());
        addAddrPo.setContactTownId(addressBo.getReceiverTownId());
        addAddrPo.setContactAddress(addressBo.getReceiverAddress());
        addAddrPo.setContactCompany(addressBo.getReceiverCompany());
        addAddrPo.setContactFixPhone(addressBo.getReceiverFixPhone());
        addAddrPo.setContactMobile(addressBo.getReceiverMobileNumber());
        addAddrPo.setContactName(addressBo.getReceiverName());
        addAddrPo.setContactEmail(addressBo.getReceiverEmail());
        addAddrPo.setContactCountryName(addressBo.getReceiverCountryName());
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactProvinceName(addressBo.getReceiverProvinceName());
        addAddrPo.setContactProvinceId(addressBo.getReceiverProvinceId());
        addAddrPo.setContactCityName(addressBo.getReceiverCityName());
        addAddrPo.setContactCityId(addressBo.getReceiverCityId());
        addAddrPo.setContactCountyName(addressBo.getReceiverCountyName());
        this.addressMapper.updateByPrimaryKeySelective(addAddrPo);
    }
}

