/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.K2ApprovedConstants;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityRspBo;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.atom.api.BgyCancelRequestOrderAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyCancelRequestOrderAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyCancelRequestOrderAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgyCancelRequestOrderInfo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.BgyCatalogOutCancelRequestOrderBusiService;
import com.tydic.uoc.common.busi.api.UocProCancelBusiService;
import com.tydic.uoc.common.busi.bo.BgyCatalogInCancelRequestOrderBusiOrderRspBo;
import com.tydic.uoc.common.busi.bo.BgyCatalogOutCancelRequestOrderBusiReqBo;
import com.tydic.uoc.common.busi.bo.BgyCatalogOutCancelRequestOrderBusiRspBo;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatalogOutCancelRequestOrderBusiServiceImpl
implements BgyCatalogOutCancelRequestOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogOutCancelRequestOrderBusiServiceImpl.class);
    @Autowired
    private UocProCancelBusiService uocProCancelBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${isKtCancel:false}")
    private boolean isKtCancel;
    @Value(value="${k2_request_order_source_id}")
    private String sourceId;
    @Value(value="${k2_cancel_order_activityName:010_\u4f9b\u5e94\u5546\u786e\u8ba4}")
    private String activityName;
    @Value(value="${k2approver}")
    private String k2approver;
    @Autowired
    private BgyCancelRequestOrderAtomService bgyCancelRequestOrderAtomService;

    @Override
    public BgyCatalogOutCancelRequestOrderBusiRspBo cancelRequestOrder(BgyCatalogOutCancelRequestOrderBusiReqBo reqBo) {
        this.validateArg(reqBo);
        BgyCatalogOutCancelRequestOrderBusiRspBo rspBo = (BgyCatalogOutCancelRequestOrderBusiRspBo)UocProRspBoUtil.success(BgyCatalogOutCancelRequestOrderBusiRspBo.class);
        Long requestId = reqBo.getRequestId();
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        if (ObjectUtil.isEmpty((Object)uocOrdRequestPo)) {
            throw new UocProBusinessException("104047", "\u8be5\u8bf7\u8d2d\u5355" + requestId + "\u4e0d\u5b58\u5728");
        }
        Integer requestStatus = uocOrdRequestPo.getRequestStatus();
        if (!UocConstant.REQUEST_ORDER_STATUS.REJECT.equals(requestStatus)) {
            throw new UocProBusinessException("104047", "\u8be5\u8bf7\u8d2d\u5355\u72b6\u6001(" + requestStatus + ")\u4e0d\u5141\u8bb8\u64a4\u9500");
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(requestId);
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        processRunReqBO.setOrderId(requestId);
        if (reqBo.getCancelOperId() != null) {
            processRunReqBO.setOperId(String.valueOf(reqBo.getCancelOperId()));
        } else {
            processRunReqBO.setOperId("0");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("auditFlag", "1107");
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        UocOrdRequestPo updateRequestPo = new UocOrdRequestPo();
        updateRequestPo.setRequestId(reqBo.getRequestId());
        updateRequestPo.setCancelDate(this.orderMapper.getDbDate());
        updateRequestPo.setCancelDesc(reqBo.getCancelDesc());
        updateRequestPo.setCancelOperName(reqBo.getCancelOperName());
        updateRequestPo.setCancelOperId(reqBo.getCancelOperId());
        int i = this.uocOrdRequestMapper.updateByPrimaryKeySelective(updateRequestPo);
        OrdSalePO qrySalePo = new OrdSalePO();
        qrySalePo.setRequestId(requestId);
        List list = this.ordSaleMapper.getList(qrySalePo);
        for (OrdSalePO salePO : list) {
            BgyCatalogInCancelOrderAbilityReqBo cancelOrderReqBo = new BgyCatalogInCancelOrderAbilityReqBo();
            cancelOrderReqBo.setOrderId(salePO.getOrderId());
            cancelOrderReqBo.setSaleVoucherId(salePO.getSaleVoucherId());
            cancelOrderReqBo.setCancelReason("10");
            BgyCatalogInCancelOrderAbilityRspBo bgyCatalogInCancelOrderAbilityRspBo = this.uocProCancelBusiService.dealOrderCancelled(cancelOrderReqBo);
            if (!"0000".equals(bgyCatalogInCancelOrderAbilityRspBo.getRespCode())) {
                throw new UocProBusinessException(bgyCatalogInCancelOrderAbilityRspBo.getRespCode(), bgyCatalogInCancelOrderAbilityRspBo.getRespDesc());
            }
            BgyCatalogInCancelRequestOrderBusiOrderRspBo orderDataTmpBo = new BgyCatalogInCancelRequestOrderBusiOrderRspBo();
            orderDataTmpBo.setOrderId(salePO.getOrderId());
            orderDataTmpBo.setSaleVoucherId(salePO.getSaleVoucherId());
            rspBo.getOrderList().add(orderDataTmpBo);
        }
        if (this.isKtCancel) {
            BgyCancelRequestOrderAtomRspBO atomRspBO;
            BgyCancelRequestOrderAtomReqBO atomReqBO = new BgyCancelRequestOrderAtomReqBO();
            BgyCancelRequestOrderInfo cancelKtProcessRequestInfo = new BgyCancelRequestOrderInfo();
            cancelKtProcessRequestInfo.setK2Id(uocOrdRequestPo.getKtId());
            cancelKtProcessRequestInfo.setOperateUserCode(this.k2approver);
            cancelKtProcessRequestInfo.setActivityName(this.activityName);
            cancelKtProcessRequestInfo.setApproveDate(new Date());
            cancelKtProcessRequestInfo.setSourceId(this.sourceId);
            cancelKtProcessRequestInfo.setComment("\u4e3b\u52a8\u53d6\u6d88");
            atomReqBO.setRequestInfo(cancelKtProcessRequestInfo);
            atomReqBO.setEsbInfo(new EsbInfoBO());
            if (K2ApprovedConstants.K2_APPROVED_FLAG_TRUE.equals(uocOrdRequestPo.getKtFlag()) && !K2ApprovedConstants.K2_SECOND_FLAG_TRUE.equals(uocOrdRequestPo.getKtSecondFlag()) && !"A0001".equalsIgnoreCase((atomRspBO = this.bgyCancelRequestOrderAtomService.cancelRequestOrder(atomReqBO)).getReturnCode())) {
                throw new UocProBusinessException(atomRspBO.getReturnCode(), "K2\u5ba1\u6279\u4f5c\u5e9f\u5f02\u5e38: " + atomRspBO.getReturnMsg());
            }
        }
        return rspBo;
    }

    private void validateArg(BgyCatalogOutCancelRequestOrderBusiReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelDesc())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[cancelDesc]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelOperId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[cancelOperId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelOperName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[cancelOperName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

