/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.UmcDeptBossQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDeptBossQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDeptBossQryAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCostAccessoryBO;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCostCreateOrderCompanyInfoCostReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCreateRequestOrderAddressReqBo;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveFirstAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyKtApproveInfo;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstReqBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.busi.api.BgyCatalogOutCostCreateOrderBusiService;
import com.tydic.uoc.common.busi.bo.BgyCatalogOutBusiRspBO;
import com.tydic.uoc.common.comb.bo.UocCatalogOutCreateRequestOrderCombReqBO;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombCommodityTypeReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestCommodityTypeMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestCommodityTypePo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatalogOutCostCreateOrderBusiServiceImpl
implements BgyCatalogOutCostCreateOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogOutCostCreateOrderBusiServiceImpl.class);
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private UocOrdRequestAddressMapper uocOrdRequestAddressMapper;
    @Autowired
    private UocOrdRequestCommodityTypeMapper uocOrdRequestCommodityTypeMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private BgyRequestOrderApproveFirstAtomService bgyRequestOrderApproveFirstAtomService;
    @Autowired
    private UocOrdRequestAddressMapper ordRequestAddressMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private UmcDeptBossQryAbilityService umcDeptBossQryAbilityService;
    @Value(value="${catalog_out_process_code:CGP120714}")
    private String catalogOutProcessCode;
    @Value(value="#{'${k2_stockOrg_list}'.split(',')}")
    private List<String> stockOrgList;

    @Override
    public BgyCatalogOutBusiRspBO creatOrder(UocCatalogOutCreateRequestOrderCombReqBO reqBO) {
        BgyCatalogOutBusiRspBO busiRspBO = (BgyCatalogOutBusiRspBO)UocProRspBoUtil.success(BgyCatalogOutBusiRspBO.class);
        Long requestId = 0L;
        if (ObjectUtil.isEmpty((Object)reqBO.getRequestId())) {
            requestId = this.sequence.nextId();
            reqBO.setRequestId(requestId);
        } else {
            requestId = reqBO.getRequestId();
        }
        reqBO.setRequestCode(this.genRequestCode());
        this.buildAndSaveRequestOrderInfo(reqBO);
        this.buildAndSaveAddressInfo(reqBO);
        this.saveCommodityType(reqBO);
        this.saveAccessoryInfo(reqBO);
        BgyRequestOrderApproveFirstReqBO approveFirstReqBO = new BgyRequestOrderApproveFirstReqBO();
        approveFirstReqBO.setEsbInfo(new EsbInfoBO());
        UocOrdRequestPo ordRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        approveFirstReqBO.setRequestId(requestId);
        BgyKtApproveInfo approveInfo = new BgyKtApproveInfo();
        approveInfo.setApplyUserCode(ordRequestPo.getRequestManWorkNo());
        approveInfo.setStartUserCode(ordRequestPo.getRequestManWorkNo());
        JSONObject jsonObject = new JSONObject();
        UocOrdRequestAddressPo ordRequestAddressPo = new UocOrdRequestAddressPo();
        ordRequestAddressPo.setRequestId(requestId);
        ordRequestAddressPo = this.ordRequestAddressMapper.selectByPrimaryPo(ordRequestAddressPo);
        if (UocConstant.CostType.ASSET.equals(ordRequestPo.getCostType()) && !this.stockOrgList.contains(ordRequestPo.getStockOrgId())) {
            jsonObject.put("purchase_type", (Object)"1");
        } else if (!UocConstant.CostType.ASSET.equals(ordRequestPo.getCostType()) && !this.stockOrgList.contains(ordRequestPo.getStockOrgId())) {
            jsonObject.put("purchase_type", (Object)"2");
        } else if (this.stockOrgList.contains(ordRequestPo.getStockOrgId())) {
            jsonObject.put("purchase_type", (Object)"3");
        }
        approveInfo.setDataFields(jsonObject.toString());
        UmcDeptBossQryAbilityReqBO umcReqBO = new UmcDeptBossQryAbilityReqBO();
        umcReqBO.setRegAccount(ordRequestAddressPo.getContactBip());
        UmcDeptBossQryAbilityRspBO umcRspBo = this.umcDeptBossQryAbilityService.qryDeptBoss(umcReqBO);
        if (!"0000".equals(umcRspBo.getRespCode())) {
            throw new UocProBusinessException("102114", "\u4f1a\u5458\u8fd4\u56de\u9884\u7b97\u90e8\u95e8\u8d1f\u8d23\u4eba\u9519\u8bef\uff1a" + umcRspBo.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)umcRspBo.getDeptBossAccount())) {
            throw new UocProBusinessException("102114", "\u4f1a\u5458\u8fd4\u56de\u9884\u7b97\u90e8\u95e8\u8d1f\u8d23\u4eba\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcRspBo.getWorkNo())) {
            throw new UocProBusinessException("102114", "\u4f1a\u5458\u8fd4\u56de\u9884\u7b97\u90e8\u95e8\u8d1f\u8d23\u4eba\u5de5\u53f7\u4e3a\u7a7a");
        }
        JSONObject budgetDeptObject = new JSONObject();
        JSONObject approversObject = new JSONObject();
        approversObject.put("actApprover1", (Object)umcRspBo.getWorkNo());
        budgetDeptObject.put("Approvers", (Object)approversObject.toString());
        approveInfo.setFlowRoleInfo(budgetDeptObject.toString());
        approveFirstReqBO.setRequestInfo(approveInfo);
        if (ObjectUtil.isEmpty((Object)reqBO.getIsProcess())) {
            BgyRequestOrderApproveFirstRspBO approveFirstRspBO = this.bgyRequestOrderApproveFirstAtomService.progress(approveFirstReqBO);
            if (!"A0001".equalsIgnoreCase(approveFirstRspBO.getReturnCode())) {
                throw new UocProBusinessException("102114", "\u53d1\u8d77k2\u7b2c\u4e00\u6b65\u5ba1\u6279\u9519\u8bef" + approveFirstRspBO.getReturnMsg());
            }
            busiRspBO.setKtUrl(approveFirstRspBO.getFormUrl());
            this.run(reqBO, true);
        } else {
            this.run(reqBO, false);
        }
        busiRspBO.setRequestId(requestId);
        busiRspBO.setRequestCode(reqBO.getRequestCode());
        return busiRspBO;
    }

    private void saveAccessoryInfo(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryInfo())) {
            ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>();
            for (BgyCatalogOutCostAccessoryBO item : reqBo.getAccessoryInfo()) {
                OrdAccessoryPO accessoryPO = new OrdAccessoryPO();
                BeanUtils.copyProperties((Object)item, (Object)accessoryPO);
                accessoryPO.setOrderId(reqBo.getRequestId());
                accessoryPO.setObjectId(reqBo.getRequestId());
                accessoryPO.setId(Long.valueOf(this.sequence.nextId()));
                accessoryPO.setCreateTime(new Date());
                accessoryPO.setCreateOperId(reqBo.getUsername());
                accessoryPO.setAttachmentType(Integer.valueOf(2));
                list.add(accessoryPO);
            }
            try {
                this.ordAccessoryMapper.insertBatch(list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void saveCommodityType(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        HashMap<String, UocProCreateOrderCombCommodityTypeReqBo> cacheComTypeMap = new HashMap<String, UocProCreateOrderCombCommodityTypeReqBo>();
        for (UocProCreateOrderCombOrderItemReqBo combOrderItemReqBo : orderItemList) {
            UocProCreateOrderCombCommodityTypeReqBo commodityTypeReqBo = combOrderItemReqBo.getCommodityTypeReqBo();
            if (commodityTypeReqBo == null) continue;
            cacheComTypeMap.put(commodityTypeReqBo.getComTypeId(), commodityTypeReqBo);
        }
        if (!ObjectUtil.isEmpty(cacheComTypeMap)) {
            HashMap<String, Long> savedComTypeMap = new HashMap<String, Long>();
            for (String commTypeId : cacheComTypeMap.keySet()) {
                UocProCreateOrderCombCommodityTypeReqBo combCommodityTypeReqBo = (UocProCreateOrderCombCommodityTypeReqBo)cacheComTypeMap.get(commTypeId);
                UocOrdRequestCommodityTypePo saveCommodityTypePo = new UocOrdRequestCommodityTypePo();
                BeanUtils.copyProperties((Object)combCommodityTypeReqBo, (Object)saveCommodityTypePo);
                Long commodityDataId = this.sequence.nextId();
                saveCommodityTypePo.setComTypeDataId(commodityDataId);
                saveCommodityTypePo.setRequestId(reqBo.getRequestId());
                saveCommodityTypePo.setRequestCode(reqBo.getRequestCode());
                this.uocOrdRequestCommodityTypeMapper.insert(saveCommodityTypePo);
                savedComTypeMap.put(commTypeId, commodityDataId);
            }
            for (UocProCreateOrderCombOrderItemReqBo combOrderItemReqBo : orderItemList) {
                UocProCreateOrderCombCommodityTypeReqBo commodityTypeReqBo = combOrderItemReqBo.getCommodityTypeReqBo();
                if (commodityTypeReqBo == null) continue;
                combOrderItemReqBo.setComTypeDataId((Long)savedComTypeMap.get(commodityTypeReqBo.getComTypeId()));
            }
        }
    }

    private void buildAndSaveAddressInfo(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        Long addressId = this.sequence.nextId();
        reqBo.getAddressBo().setRequestAddressId(addressId);
        reqBo.setRequestAddressId(addressId);
        BgyCatalogOutCreateRequestOrderAddressReqBo addressBo = reqBo.getAddressBo();
        UocOrdRequestAddressPo addAddrPo = new UocOrdRequestAddressPo();
        BeanUtils.copyProperties((Object)addressBo, (Object)addAddrPo);
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactTown(addressBo.getReceiverTown());
        addAddrPo.setContactTownId(addressBo.getReceiverTownId());
        addAddrPo.setContactAddress(addressBo.getReceiverAddress());
        addAddrPo.setContactCompany(addressBo.getReceiverCompany());
        addAddrPo.setContactFixPhone(addressBo.getReceiverFixPhone());
        addAddrPo.setContactMobile(addressBo.getReceiverMobileNumber());
        addAddrPo.setContactName(addressBo.getReceiverName());
        addAddrPo.setContactEmail(addressBo.getReceiverEmail());
        addAddrPo.setContactCountryName(addressBo.getReceiverCountryName());
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactProvinceName(addressBo.getReceiverProvinceName());
        addAddrPo.setContactProvinceId(addressBo.getReceiverProvinceId());
        addAddrPo.setContactCityName(addressBo.getReceiverCityName());
        addAddrPo.setContactCityId(addressBo.getReceiverCityId());
        addAddrPo.setContactCountyName(addressBo.getReceiverCountyName());
        addAddrPo.setContactBip(addressBo.getCertName());
        addAddrPo.setOrgType(addressBo.getOrgType());
        addAddrPo.setRequestAddressId(addressId);
        addAddrPo.setRequestId(reqBo.getRequestId());
        addAddrPo.setRequestCode(reqBo.getRequestCode());
        this.uocOrdRequestAddressMapper.insert(addAddrPo);
    }

    private void run(UocCatalogOutCreateRequestOrderCombReqBO reqBo, boolean isCreatOrder) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBo.getRequestId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        processRunReqBO.setOrderId(reqBo.getRequestId());
        processRunReqBO.setOperId("1");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (isCreatOrder) {
            map.put("approve", "1");
        } else {
            map.put("approve", "0");
        }
        processRunReqBO.setVariables(map);
        this.uocRunProcessAtomService.start(processRunReqBO);
    }

    private void buildAndSaveRequestOrderInfo(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        BgyCatalogOutCostCreateOrderCompanyInfoCostReqBo companyInfoBo = reqBo.getCompanyInfoBo();
        UocOrdRequestPo saveRequestPo = new UocOrdRequestPo();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)saveRequestPo);
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefKey("BGY_REQUEST_ORDER_OUT_STATUS");
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setOrderId(reqBo.getRequestId());
        processStartReqBO.setObjId(reqBo.getRequestId());
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        UocProcessStartRspBO uocProcessStartRspBO = new UocProcessStartRspBO();
        uocProcessStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(uocProcessStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101030", "\u6279\u91cf\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5931\u8d25!" + uocProcessStartRspBO.getRespDesc());
        }
        BeanUtils.copyProperties((Object)companyInfoBo, (Object)saveRequestPo);
        saveRequestPo.setRequestTime(new Date());
        saveRequestPo.setRequestManWorkNo(reqBo.getWorkNo());
        saveRequestPo.setRequestStatus(Integer.valueOf(uocProcessStartRspBO.getStepId()));
        saveRequestPo.setOrgTreePath(reqBo.getOrgPath());
        if (ObjectUtil.isEmpty((Object)saveRequestPo.getAccountId()) || ObjectUtil.isEmpty((Object)saveRequestPo.getAccountName())) {
            saveRequestPo.setAccountId(reqBo.getPurchaserAccount());
            saveRequestPo.setAccountName(reqBo.getPurchaserAccountName());
        }
        saveRequestPo.setYsDeptId(companyInfoBo.getYsDeptId());
        saveRequestPo.setYsDeptName(companyInfoBo.getYsDeptName());
        saveRequestPo.setProfitId(companyInfoBo.getProfitId());
        saveRequestPo.setProfitName(companyInfoBo.getProfitName());
        saveRequestPo.setRequestManId(reqBo.getUserId().toString());
        saveRequestPo.setRequestManName(reqBo.getName());
        saveRequestPo.setRequestDeptId(companyInfoBo.getRequestDeptId());
        saveRequestPo.setRequestDeptName(companyInfoBo.getRequestDeptName());
        saveRequestPo.setRequestManDeptId(reqBo.getOrgIdIn() != null ? reqBo.getOrgIdIn().toString() : null);
        saveRequestPo.setRequestManDeptName(reqBo.getOrgName());
        saveRequestPo.setRequestManBip(reqBo.getUsername());
        if (!ObjectUtil.isEmpty((Object)companyInfoBo.getIsFix())) {
            saveRequestPo.setIsFix(Integer.valueOf(companyInfoBo.getIsFix()));
        }
        if (!ObjectUtil.isEmpty((Object)companyInfoBo.getFitmentStandard())) {
            saveRequestPo.setFitmentStandard(Integer.valueOf(companyInfoBo.getFitmentStandard()));
        }
        try {
            saveRequestPo.setPredictFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getTotalFee()));
            saveRequestPo.setCommodityTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getCommodityTotalFee()));
            saveRequestPo.setRequestTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getTotalFee()));
            saveRequestPo.setFreightTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getFreightTotalFee()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        this.uocOrdRequestMapper.insert(saveRequestPo);
    }

    private String genRequestCode() {
        String requestCode = "";
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode("ORDER_QGD_NO");
        getBo.setOrgType("-1");
        log.info("\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getBo));
        try {
            CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
            log.info("\u83b7\u53d6\u7f16\u53f7\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)encodedSerial));
            requestCode = (String)encodedSerial.getSerialNoList().get(0);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage());
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return requestCode;
    }
}

