/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCostCreateOrderCompanyInfoCostReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCreateRequestOrderAddressReqBo;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveRestartAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveRestartReqBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveRestartRspBO;
import com.tydic.uoc.common.atom.bo.BgyRestartKtApproveInfo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.BgyCatalogOutCostModOrderBusiService;
import com.tydic.uoc.common.comb.bo.BgyCatalogOutModRequestCostAbilityRspBO;
import com.tydic.uoc.common.comb.bo.BgyCatalogOutModRequestCostCombReqBO;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombCommodityTypeReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestCommodityTypeMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.UocOrdItemDataPo;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestCommodityTypePo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatalogOutCostModOrderBusiServiceImpl
implements BgyCatalogOutCostModOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogOutCostModOrderBusiServiceImpl.class);
    @Autowired
    private UocOrdRequestCommodityTypeMapper uocOrdRequestCommodityTypeMapper;
    @Autowired
    private UocOrdRequestAddressMapper addressMapper;
    @Autowired
    private UocOrdRequestMapper requestMapper;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${isKtRestart:false}")
    private Boolean isKtRestart;
    @Value(value="k2_request_order_url:https://bgy-malluat.countrygarden.com.cn/#/index/agrOrderDetailK2?requestId=")
    private String bizFormUrl;
    @Autowired
    private BgyRequestOrderApproveRestartAtomService bgyRequestOrderApproveRestartAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Override
    public BgyCatalogOutModRequestCostAbilityRspBO modRequest(BgyCatalogOutModRequestCostCombReqBO reqBO) {
        BgyCatalogOutModRequestCostAbilityRspBO rspBO = (BgyCatalogOutModRequestCostAbilityRspBO)UocProRspBoUtil.success(BgyCatalogOutModRequestCostAbilityRspBO.class);
        this.buildAndUpdateAddressInfo(reqBO);
        String formUrl = this.buildAndUpdateRequestOrderInfo(reqBO);
        this.saveCommodityType(reqBO);
        this.buildAndUpdateItemDataInfo(reqBO);
        rspBO.setIsSuccess(true);
        rspBO.setRespCode("0000");
        rspBO.setRequestId(reqBO.getRequestId());
        rspBO.setK2FormUrl(formUrl);
        return rspBO;
    }

    private void buildAndUpdateItemDataInfo(BgyCatalogOutModRequestCostCombReqBO reqBO) {
        if (ObjectUtil.isNotEmpty(reqBO.getOrderItemList())) {
            for (UocProCreateOrderCombOrderItemReqBo item : reqBO.getOrderItemList()) {
                UocOrdItemDataPo ordItemDataPo = new UocOrdItemDataPo();
                BeanUtils.copyProperties((Object)item, (Object)ordItemDataPo);
                ordItemDataPo.setComTypeId(String.valueOf(item.getCommodityTypeId()));
                ordItemDataPo.setComTypeName(item.getCommodityTypeName());
                this.ordItemDataMapper.updateByPrimaryKeySelective(ordItemDataPo);
            }
        }
    }

    private void saveCommodityType(BgyCatalogOutModRequestCostCombReqBO reqBo) {
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        HashMap<String, UocProCreateOrderCombCommodityTypeReqBo> cacheComTypeMap = new HashMap<String, UocProCreateOrderCombCommodityTypeReqBo>();
        for (UocProCreateOrderCombOrderItemReqBo combOrderItemReqBo : orderItemList) {
            UocProCreateOrderCombCommodityTypeReqBo commodityTypeReqBo = combOrderItemReqBo.getCommodityTypeReqBo();
            if (commodityTypeReqBo == null) continue;
            cacheComTypeMap.put(commodityTypeReqBo.getComTypeId(), commodityTypeReqBo);
        }
        if (!ObjectUtil.isEmpty(cacheComTypeMap)) {
            HashMap savedComTypeMap = new HashMap();
            for (String commTypeId : cacheComTypeMap.keySet()) {
                Long commodityDataId = this.sequence.nextId();
                UocProCreateOrderCombCommodityTypeReqBo combCommodityTypeReqBo = (UocProCreateOrderCombCommodityTypeReqBo)cacheComTypeMap.get(commTypeId);
                UocOrdRequestCommodityTypePo saveCommodityTypePo = new UocOrdRequestCommodityTypePo();
                BeanUtils.copyProperties((Object)combCommodityTypeReqBo, (Object)saveCommodityTypePo);
                saveCommodityTypePo.setRequestId(reqBo.getRequestId());
                saveCommodityTypePo.setRequestCode(reqBo.getRequestCode());
                List commodityTypePoList = this.uocOrdRequestCommodityTypeMapper.selectByPrimaryPoList(saveCommodityTypePo);
                if (!ObjectUtil.isEmpty((Object)commodityTypePoList)) continue;
                saveCommodityTypePo.setComTypeDataId(commodityDataId);
                this.uocOrdRequestCommodityTypeMapper.insert(saveCommodityTypePo);
            }
        }
    }

    private void buildAndUpdateAddressInfo(BgyCatalogOutModRequestCostCombReqBO reqBo) {
        BgyCatalogOutCreateRequestOrderAddressReqBo addressBo = reqBo.getAddressBo();
        UocOrdRequestAddressPo addAddrPo = new UocOrdRequestAddressPo();
        BeanUtils.copyProperties((Object)addressBo, (Object)addAddrPo);
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactTown(addressBo.getReceiverTown());
        addAddrPo.setContactTownId(addressBo.getReceiverTownId());
        addAddrPo.setContactAddress(addressBo.getReceiverAddress());
        addAddrPo.setContactCompany(addressBo.getReceiverCompany());
        addAddrPo.setContactFixPhone(addressBo.getReceiverFixPhone());
        addAddrPo.setContactMobile(addressBo.getReceiverMobileNumber());
        addAddrPo.setContactName(addressBo.getReceiverName());
        addAddrPo.setContactEmail(addressBo.getReceiverEmail());
        addAddrPo.setContactCountryName(addressBo.getReceiverCountryName());
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactProvinceName(addressBo.getReceiverProvinceName());
        addAddrPo.setContactProvinceId(addressBo.getReceiverProvinceId());
        addAddrPo.setContactCityName(addressBo.getReceiverCityName());
        addAddrPo.setContactCityId(addressBo.getReceiverCityId());
        addAddrPo.setContactCountyName(addressBo.getReceiverCountyName());
        this.addressMapper.updateByPrimaryKeySelective(addAddrPo);
    }

    private String buildAndUpdateRequestOrderInfo(BgyCatalogOutModRequestCostCombReqBO reqBo) {
        UocProcessRunRspBO uocProcessRunRspBO;
        UocProcessRunReqBO uocProcessRunReqBO = new UocProcessRunReqBO();
        uocProcessRunReqBO.setProcDefKey("BGY_REQUEST_ORDER_OUT_STATUS");
        uocProcessRunReqBO.setObjId(reqBo.getRequestId());
        uocProcessRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        uocProcessRunReqBO.setSysCode("UOC");
        uocProcessRunReqBO.setOrderId(reqBo.getRequestId());
        uocProcessRunReqBO.setOperId("1");
        UocOrdRequestPo requestPo = this.requestMapper.selectByPrimaryKey(reqBo.getRequestId());
        String formUrl = "";
        if (this.isKtRestart.booleanValue()) {
            BgyRequestOrderApproveRestartReqBO approveRestartReqBO = new BgyRequestOrderApproveRestartReqBO();
            BgyRestartKtApproveInfo requestInfo = new BgyRestartKtApproveInfo();
            requestInfo.setK2Id(requestPo.getKtId());
            requestInfo.setBizId(reqBo.getRequestId().toString());
            requestInfo.setBizFormUrl(this.bizFormUrl + reqBo.getRequestId());
            approveRestartReqBO.setRequestInfo(requestInfo);
            approveRestartReqBO.setEsbInfo(new EsbInfoBO());
            approveRestartReqBO.setRequestId(reqBo.getRequestId());
            BgyRequestOrderApproveRestartRspBO approveRestartRspBO = this.bgyRequestOrderApproveRestartAtomService.progress(approveRestartReqBO);
            if (!"S".equalsIgnoreCase(approveRestartRspBO.getReturnStatus())) {
                throw new UocProBusinessException("101030", "k2\u91cd\u65b0\u53d1\u8d77\u5ba1\u6279\u5931\u8d25\uff1a!" + approveRestartRspBO.getReturnMsg());
            }
            formUrl = approveRestartRspBO.getFormUrl();
            if (ObjectUtil.isEmpty((Object)formUrl)) {
                throw new UocProBusinessException("101030", "\u4fee\u6539\u8bf7\u8d2d\u5355\uff0c\u53d1\u8d77\u91cd\u65b0\u5ba1\u6279\u5931\u8d25\uff1a\u8fd4\u56deurl\u4e3a\u7a7a");
            }
        }
        if (!"0000".equals((uocProcessRunRspBO = this.uocRunProcessAtomService.start(uocProcessRunReqBO)).getRespCode())) {
            throw new UocProBusinessException("101030", "\u6279\u91cf\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5931\u8d25!" + uocProcessRunRspBO.getRespDesc());
        }
        BgyCatalogOutCostCreateOrderCompanyInfoCostReqBo companyInfoBo = reqBo.getCompanyInfoBo();
        UocOrdRequestPo saveRequestPo = new UocOrdRequestPo();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)saveRequestPo);
        BeanUtils.copyProperties((Object)companyInfoBo, (Object)saveRequestPo);
        saveRequestPo.setRequestStatus(Integer.valueOf(uocProcessRunRspBO.getStepId()));
        saveRequestPo.setRequestManId(reqBo.getUserId().toString());
        saveRequestPo.setRequestManName(reqBo.getName());
        if (reqBo.getOrgIdIn() != null) {
            saveRequestPo.setRequestDeptId(reqBo.getOrgIdIn().toString());
        }
        saveRequestPo.setAccountId(reqBo.getPurchaserAccount());
        saveRequestPo.setAccountName(reqBo.getPurchaserAccountName());
        saveRequestPo.setYsDeptId(companyInfoBo.getYsDeptId());
        saveRequestPo.setYsDeptName(companyInfoBo.getYsDeptName());
        saveRequestPo.setRequestDeptId(companyInfoBo.getRequestDeptId());
        saveRequestPo.setRequestDeptName(companyInfoBo.getRequestDeptName());
        if (ObjectUtil.isNotEmpty((Object)formUrl)) {
            saveRequestPo.setKtFormUrl(formUrl);
        }
        saveRequestPo.setKtId(requestPo.getKtId());
        this.requestMapper.updateByPrimaryKeySelective(saveRequestPo);
        return formUrl;
    }
}

