/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.AgreementSettlementBO;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCostCreateOrderCommodityTypeInfoReqBo;
import com.tydic.uoc.common.ability.bo.BgyTemStorageAddressReqBo;
import com.tydic.uoc.common.ability.bo.CommodityAttrRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.atom.api.BgyCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.api.BgyCreateRequestOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreatePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateSaleOrderAtomService;
import com.tydic.uoc.common.atom.bo.AtomUocCoreCreateOrderReqBO;
import com.tydic.uoc.common.atom.bo.BgyCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.BgyCreateLogisticsReqBO;
import com.tydic.uoc.common.atom.bo.BgyCreateRequestOrderReqBO;
import com.tydic.uoc.common.atom.bo.BgyCreateRequestOrderRspBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsAttrBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrdItemDataBO;
import com.tydic.uoc.common.atom.bo.UocOrderItemBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.BgyCatalogOutNoCostCreateOrderBusiService;
import com.tydic.uoc.common.busi.bo.BgyCatalogOutBusiRspBO;
import com.tydic.uoc.common.comb.bo.BgyCatalogOutNoCostReqBO;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayConfPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatalogOutNoCostCreateOrderBusiServiceImpl
implements BgyCatalogOutNoCostCreateOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogOutNoCostCreateOrderBusiServiceImpl.class);
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;
    @Autowired
    private BgyCoreCreateLogisticsRelaAtomService bgyCoreCreateLogisticsRelaAtomService;
    @Autowired
    private BgyCreateRequestOrderAtomService bgyCreateRequestOrderAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocCoreCreateSaleOrderAtomService uocCoreCreateSaleOrderAtomService;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private UocCoreCreateOrderAtomService uocCoreCreateOrderAtomService;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Value(value="${uoc.saveJdOrgId:false}")
    private Boolean saveJdOrgId;

    @Override
    public BgyCatalogOutBusiRspBO creatOrder(BgyCatalogOutNoCostReqBO reqBO) {
        List ordItemList;
        BgyCatalogOutBusiRspBO rspBO = new BgyCatalogOutBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Long requestOrdId = this.idUtil.nextId();
        Long orderId = this.idUtil.nextId();
        BgyCreateLogisticsReqBO bgyCreateLogisticsReqBO = this.buildLogisticsRelaTionParam(requestOrdId, reqBO.getAddressBo());
        BgyCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.bgyCoreCreateLogisticsRelaAtomService.dealCoreCreateLogisticsRela(bgyCreateLogisticsReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        Long contactId = uocCoreCreateLogisticsRelaRspBO.getRequestAddressId();
        log.info("\u7269\u6d41\u8bf7\u6c42\u5730\u5740id\uff1a{}", (Object)contactId);
        BgyCreateRequestOrderReqBO bgyCreateRequestOrderReqBO = this.buildRequestOrderParam(reqBO, requestOrdId, contactId, orderId);
        BgyCreateRequestOrderRspBO bgyCreateRequestOrderRspBO = this.bgyCreateRequestOrderAtomService.dealCoreCreateSaleOrder(bgyCreateRequestOrderReqBO);
        if (!"0000".equals(bgyCreateRequestOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", bgyCreateRequestOrderRspBO.getRespDesc());
        }
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = this.buildCreateSaleOrderParam(reqBO, orderId, contactId);
        UocCoreCreateSaleOrderRspBO uocCoreCreateSaleOrderRspBO = this.uocCoreCreateSaleOrderAtomService.dealCoreCreateSaleOrder(uocCoreCreateSaleOrderReqBO);
        if (!"0000".equals(uocCoreCreateSaleOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateSaleOrderRspBO.getRespDesc());
        }
        OrdItemPO ordItemPo = new OrdItemPO();
        ordItemPo.setOrderId(orderId);
        try {
            ordItemList = this.ordItemMapper.getList(ordItemPo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102107", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5931\u8d25!");
        }
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = this.buildCreatePayOrderParam(orderId, reqBO, ordItemList, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        UocCoreCreatePayOrderRspBO uocCoreCreatePayOrderRspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
        if (!"0000".equals(uocCoreCreatePayOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreatePayOrderRspBO.getRespDesc());
        }
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = this.buildCreateOrderParam(orderId, reqBO);
        UocCoreCreateOrderRspBO uocCoreCreateOrderRspBO = this.uocCoreCreateOrderAtomService.dealCoreCreateOrder(uocCoreCreateOrderReqBO);
        if (!"0000".equals(uocCoreCreateOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102107", uocCoreCreateOrderRspBO.getRespDesc());
        }
        this.saveAccessory(reqBO, orderId);
        this.saveExt(reqBO, orderId, ordItemList);
        this.savePayConfInfo(reqBO, rspBO, orderId);
        rspBO.setRequestId(requestOrdId);
        return rspBO;
    }

    private void saveExt(BgyCatalogOutNoCostReqBO reqBO, Long orderId, List<OrdItemPO> ordItemList) {
        OrdExtMapPO transactionNoticeNo;
        OrdExtMapPO ordExtMapPO;
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        ArrayList<OrdItemMapPO> itemMapPOS = new ArrayList<OrdItemMapPO>();
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            if (skuInfo.getChannel() == null) continue;
            for (OrdItemPO itemPO : ordItemList) {
                OrdExtMapPO extMapPO = new OrdExtMapPO();
                extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                extMapPO.setFieldValue(skuInfo.getChannel().toString());
                extMapPO.setFieldName("\u5546\u54c1\u9891\u9053");
                extMapPO.setFieldCode("channel");
                extMapPO.setOrderId(orderId);
                extMapPO.setObjId(itemPO.getOrdItemId());
                extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
                list.add(extMapPO);
                OrdItemMapPO mapPO = new OrdItemMapPO();
                mapPO.setOrderId(orderId);
                mapPO.setId(Long.valueOf(this.idUtil.nextId()));
                mapPO.setOrderItemId(itemPO.getOrdItemId());
                mapPO.setFieldValue(String.valueOf(skuInfo.getSoldNumber()));
                mapPO.setFieldName("\u5e93\u5b58");
                mapPO.setFieldCode("stock");
                itemMapPOS.add(mapPO);
            }
        }
        if (CollectionUtils.isNotEmpty(itemMapPOS)) {
            this.ordItemMapMapper.insertBatch(itemMapPOS);
        }
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
        extMapPO.setFieldValue(reqBO.getSaleOrderItemList().get(0).getPurchType().toString());
        extMapPO.setFieldName("\u91c7\u8d2d\u6a21\u5f0f");
        extMapPO.setFieldCode("purType");
        extMapPO.setOrderId(orderId);
        extMapPO.setObjId(orderId);
        extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
        list.add(extMapPO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderItemList().get(0).getExtField2())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(reqBO.getSaleOrderItemList().get(0).getExtField2());
            ordExtMapPO.setFieldName("\u534f\u8baeecp\u5408\u540c\u7f16\u53f7");
            ordExtMapPO.setFieldCode("agrEcpHt");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderItemList().get(0).getExtField1())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(reqBO.getSaleOrderItemList().get(0).getExtField1());
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f");
            ordExtMapPO.setFieldCode("purMod");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderItemList().get(0).getExtField1Str())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(reqBO.getSaleOrderItemList().get(0).getExtField1Str());
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f\u7ffb\u8bd1");
            ordExtMapPO.setFieldCode("purModStr");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        OrdExtMapPO ecpPurType = new OrdExtMapPO();
        ecpPurType.setId(Long.valueOf(this.idUtil.nextId()));
        ecpPurType.setFieldValue(reqBO.getEcpPurType());
        ecpPurType.setFieldName("ecp\u91c7\u8d2d\u7c7b\u578b");
        ecpPurType.setFieldCode("ecpPurType");
        ecpPurType.setOrderId(orderId);
        ecpPurType.setObjId(orderId);
        ecpPurType.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(ecpPurType);
        if (this.saveJdOrgId != null && this.saveJdOrgId.booleanValue()) {
            OrdExtMapPO jdOrgId = new OrdExtMapPO();
            jdOrgId.setId(Long.valueOf(this.idUtil.nextId()));
            jdOrgId.setFieldValue(reqBO.getCompanyId().toString());
            jdOrgId.setFieldName("\u91c7\u8d2d\u5355\u4f4did");
            jdOrgId.setFieldCode("jdOrgId");
            jdOrgId.setOrderId(orderId);
            jdOrgId.setObjId(orderId);
            jdOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(jdOrgId);
        }
        OrdExtMapPO orderCategory = new OrdExtMapPO();
        orderCategory.setId(Long.valueOf(this.idUtil.nextId()));
        if (CollectionUtils.isNotEmpty(reqBO.getActiveBOList())) {
            orderCategory.setFieldValue("1");
        } else {
            orderCategory.setFieldValue("0");
        }
        OrdExtMapPO payBusiType = new OrdExtMapPO();
        payBusiType.setId(Long.valueOf(this.idUtil.nextId()));
        if (CollectionUtils.isNotEmpty(reqBO.getActiveBOList())) {
            payBusiType.setFieldValue("3");
        } else {
            payBusiType.setFieldValue(reqBO.getSaleOrderItemList().get(0).getAgreementMode());
        }
        payBusiType.setFieldName("\u4e1a\u52a1\u7c7b\u578b");
        payBusiType.setFieldCode("payBusiType");
        payBusiType.setOrderId(orderId);
        payBusiType.setObjId(orderId);
        payBusiType.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(payBusiType);
        orderCategory.setFieldName("\u5458\u5de5\u798f\u5229");
        orderCategory.setFieldCode("orderCategory");
        orderCategory.setOrderId(orderId);
        orderCategory.setObjId(orderId);
        orderCategory.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(orderCategory);
        OrdExtMapPO ComOrgId = new OrdExtMapPO();
        ComOrgId.setId(Long.valueOf(this.idUtil.nextId()));
        ComOrgId.setFieldValue(reqBO.getCompanyId().toString());
        ComOrgId.setFieldName("\u516c\u53f8id");
        ComOrgId.setFieldCode("companyId");
        ComOrgId.setOrderId(orderId);
        ComOrgId.setObjId(orderId);
        ComOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(ComOrgId);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionNoticeNo())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u6210\u4ea4\u901a\u77e5\u4e66\u7f16\u53f7");
            transactionNoticeNo.setFieldValue(reqBO.getTransactionNoticeNo());
            transactionNoticeNo.setFieldCode("transactionNoticeNo");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionNoticeName())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u6210\u4ea4\u901a\u77e5\u4e66\u540d\u79f0");
            transactionNoticeNo.setFieldValue(reqBO.getTransactionNoticeName());
            transactionNoticeNo.setFieldCode("transactionNoticeName");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getComplianceTime())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u627f\u8bfa\u5230\u8d27\u65e5");
            transactionNoticeNo.setFieldValue(reqBO.getComplianceTime());
            transactionNoticeNo.setFieldCode("complianceTime");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryRequestMethod())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u4ea4\u8d27\u671f\u8981\u6c42\u65b9\u5f0f");
            transactionNoticeNo.setFieldValue(reqBO.getDeliveryRequestMethod());
            transactionNoticeNo.setFieldCode("deliveryRequestMethod");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (list.size() > 0) {
            this.ordExtMapMapper.insertBatch(list);
        }
    }

    private void savePayConfInfo(BgyCatalogOutNoCostReqBO reqBO, BgyCatalogOutBusiRspBO rspBO, Long orderId) {
        ArrayList<OrdPayConfPO> payConfPOS;
        if (UocCoreConstant.TradeMode.TRADE_MODEL.equals(reqBO.getAgreementBO().getTradeMode())) {
            payConfPOS = new ArrayList<OrdPayConfPO>(2);
            for (AgreementSettlementBO agreementSettlementBO : reqBO.getAgreementBO().getPaymentMethod()) {
                OrdPayConfPO payConfPO = new OrdPayConfPO();
                payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                payConfPO.setOrderId(orderId);
                if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                    payConfPO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                    payConfPO.setUserType(UocCoreConstant.UserType.PRO);
                } else {
                    payConfPO.setPayType(reqBO.getPayType());
                    payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                }
                if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                    payConfPO.setPilPaySup(new BigDecimal(100));
                    if ("2".equals(agreementSettlementBO.getAssign())) {
                        payConfPO.setPayRule(Integer.valueOf(2));
                        payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    } else {
                        payConfPO.setPayRule(Integer.valueOf(1));
                        payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    }
                } else {
                    payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                    payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                    payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                    payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                }
                if (null == payConfPO.getPrePayFee()) {
                    payConfPO.setPrePayFee(Long.valueOf(0L));
                }
                payConfPO.setVerPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                payConfPO.setQuaPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                if (null != reqBO.getAgreementBO().getWarantty()) {
                    payConfPO.setWarantty(reqBO.getAgreementBO().getWarantty());
                }
                payConfPO.setIsPushQua(Integer.valueOf(0));
                payConfPO.setTime(new Date());
                payConfPO.setPayBreakScale(BigDecimal.ZERO);
                payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                payConfPO.setPayNodeRule(Integer.valueOf(2));
                payConfPOS.add(payConfPO);
            }
        } else {
            payConfPOS = new ArrayList(1);
            OrdPayConfPO payConfPO = new OrdPayConfPO();
            for (AgreementSettlementBO agreementSettlementBO : reqBO.getAgreementBO().getPaymentMethod()) {
                if (!"1".equals(agreementSettlementBO.getSettlementObject())) continue;
                payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                payConfPO.setOrderId(orderId);
                if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                    payConfPO.setPayType(Integer.valueOf(agreementSettlementBO.getSettlementType()));
                    payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                }
                if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                    payConfPO.setPilPaySup(new BigDecimal(100));
                    if ("2".equals(agreementSettlementBO.getAssign())) {
                        payConfPO.setPayRule(Integer.valueOf(2));
                        payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    } else {
                        payConfPO.setPayRule(Integer.valueOf(1));
                        payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    }
                } else {
                    payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                    payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                    payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                    payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                }
                if (null != reqBO.getAgreementBO().getWarantty()) {
                    payConfPO.setWarantty(reqBO.getAgreementBO().getWarantty());
                }
                payConfPO.setIsPushQua(Integer.valueOf(0));
                payConfPO.setTime(new Date());
                payConfPO.setPayBreakScale(BigDecimal.ZERO);
                payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                payConfPO.setPayNodeRule(Integer.valueOf(2));
                payConfPOS.add(payConfPO);
                break;
            }
        }
        this.ordPayConfMapper.insertBatch(payConfPOS);
    }

    private void saveAccessory(BgyCatalogOutNoCostReqBO reqBO, Long orderId) {
        if (CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("CREATE_ORDER");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private AtomUocCoreCreateOrderReqBO buildCreateOrderParam(Long orderId, BgyCatalogOutNoCostReqBO reqBO) {
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = new AtomUocCoreCreateOrderReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)uocCoreCreateOrderReqBO));
        if (PebExtConstant.OrderType.DA.equals(reqBO.getOrderType())) {
            uocCoreCreateOrderReqBO.setOrderName(reqBO.getOrderName() + "\u7684\u91c7\u8d2d\u8ba2\u5355");
        } else {
            uocCoreCreateOrderReqBO.setOrderName(String.valueOf(orderId));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLoginSource())) {
            uocCoreCreateOrderReqBO.setExtField2(reqBO.getLoginSource());
        }
        if (reqBO.getSaleOrderItemList().get(0).getContractId() != null) {
            uocCoreCreateOrderReqBO.setExtField3(reqBO.getSaleOrderItemList().get(0).getContractId().toString());
        }
        uocCoreCreateOrderReqBO.setUserId(reqBO.getUserId());
        uocCoreCreateOrderReqBO.setOrgId(reqBO.getOrgId());
        uocCoreCreateOrderReqBO.setUserType(reqBO.getMemUserType());
        uocCoreCreateOrderReqBO.setCompanyId(reqBO.getCompanyId());
        uocCoreCreateOrderReqBO.setCompanyName(reqBO.getCompanyName());
        if (reqBO.getOrgLevel() != null) {
            uocCoreCreateOrderReqBO.setOrgLevel(reqBO.getOrgLevel());
        }
        uocCoreCreateOrderReqBO.setOrderId(orderId);
        uocCoreCreateOrderReqBO.setOrderNo(CommUtils.long2String((Long)orderId));
        if (reqBO.getOrderType() == null) {
            if (CollectionUtils.isNotEmpty(reqBO.getActiveBOList())) {
                uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.FL);
            } else {
                uocCoreCreateOrderReqBO.setOrderType(Integer.parseInt(reqBO.getSaleOrderItemList().get(0).getAgreementMode()));
            }
        } else {
            uocCoreCreateOrderReqBO.setOrderType(reqBO.getOrderType());
        }
        uocCoreCreateOrderReqBO.setPayType(String.valueOf(reqBO.getPayType()));
        Long saleFee = reqBO.getRequestTotalFee();
        uocCoreCreateOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateOrderReqBO.setCreateOperId(CommUtils.long2String((Long)reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setOrderDesc(reqBO.getComment());
        uocCoreCreateOrderReqBO.setPurId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurName(reqBO.getOrgName());
        uocCoreCreateOrderReqBO.setPurPlaceOrderId(String.valueOf(reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setPurPlaceOrderName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setPurOrgId(CommUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurOrgPath(reqBO.getOrgPath());
        EnterpriseAccountBO accountBO = reqBO.getEnterpriseAccountBO();
        if (accountBO != null) {
            uocCoreCreateOrderReqBO.setPurMobile(accountBO.getTelephone());
            uocCoreCreateOrderReqBO.setProAccountRelaMobile(reqBO.getProPhone());
            uocCoreCreateOrderReqBO.setProName(accountBO.getDeliveryCenterName());
            uocCoreCreateOrderReqBO.setPurAccountName(accountBO.getAccountName());
            uocCoreCreateOrderReqBO.setPurAccountOwnName(accountBO.getAccountName());
            uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getUsername());
            uocCoreCreateOrderReqBO.setPurRelaMobile(accountBO.getTelephone());
        }
        uocCoreCreateOrderReqBO.setProAccountOwnName(reqBO.getProPath());
        if (reqBO.getProAccount() != null) {
            uocCoreCreateOrderReqBO.setProAccount(String.valueOf(reqBO.getProAccount()));
        }
        return uocCoreCreateOrderReqBO;
    }

    private UocCoreCreatePayOrderReqBO buildCreatePayOrderParam(Long orderId, BgyCatalogOutNoCostReqBO reqBO, List<OrdItemPO> ordItemPOS, Long saleOrderId) {
        UocCoreCreatePayOrderReqBO payOrderReqBO = new UocCoreCreatePayOrderReqBO();
        payOrderReqBO.setPayVoucherNo(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd") + orderId);
        payOrderReqBO.setOrderId(orderId);
        payOrderReqBO.setObjId(saleOrderId);
        payOrderReqBO.setObjType(UocConstant.ORDER_TYPE.SALE_ORDER);
        payOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        if (reqBO.getPayTypeIn() != null) {
            payOrderReqBO.setPayType(reqBO.getPayTypeIn());
        } else {
            payOrderReqBO.setPayType(reqBO.getPayType());
        }
        payOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        payOrderReqBO.setTotalFee(reqBO.getRequestTotalFee());
        Long totalPrice = payOrderReqBO.getTotalFee();
        payOrderReqBO.setTotalFee(totalPrice);
        payOrderReqBO.setPayFee(totalPrice);
        if (payOrderReqBO.getPayFee().equals(payOrderReqBO.getRedEnvelopeFee())) {
            payOrderReqBO.setPayTime(new Date());
            payOrderReqBO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
        } else {
            payOrderReqBO.setPayState(UocConstant.PAY_ORDER_STATUS.UNPAID);
        }
        payOrderReqBO.setCreateOperId(CommUtils.long2String((Long)reqBO.getUserId()));
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>();
        OrdItemPO ordItemPO = null;
        UocOrderPayItemBO uocOrderPayItemBO = null;
        Iterator<OrdItemPO> iterator = ordItemPOS.iterator();
        while (iterator.hasNext()) {
            OrdItemPO ordItemPO1;
            ordItemPO = ordItemPO1 = iterator.next();
            uocOrderPayItemBO = new UocOrderPayItemBO();
            uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
            uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
            uocOrderPayItemBO.setPayObjId(ordItemPO.getOrdItemId());
            uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
            uocOrderPayItemBO.setPayCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
            uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
            uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
            uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
            uocOrderPayItemBO.setReduceFee(ordItemPO.getDisPrice());
            if (ordItemPO.getDisPrice() == null) {
                ordItemPO.setDisPrice(Long.valueOf(0L));
            }
            if (ordItemPO.getActShareFee() == null) {
                ordItemPO.setActShareFee(Long.valueOf(0L));
            }
            uocOrderPayItemBO.setPayFee(ordItemPO.getPreFee());
            uocOrderPayItemBO.setActFee(ordItemPO.getActShareFee());
            uocOrderPayItemBO.setPreFee(ordItemPO.getPreFee());
            uocOrderPayItemBOList.add(uocOrderPayItemBO);
        }
        payOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        return payOrderReqBO;
    }

    private UocCoreCreateSaleOrderReqBO buildCreateSaleOrderParam(BgyCatalogOutNoCostReqBO reqBO, Long orderId, Long contactId) {
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = new UocCoreCreateSaleOrderReqBO();
        ArrayList<UocOrderItemBO> uocOrderItemList = new ArrayList<UocOrderItemBO>();
        Long purchaseFee = 0L;
        BigDecimal totalAm = BigDecimal.ZERO;
        BigDecimal totalPre = BigDecimal.ZERO;
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            UocOrderItemBO uocOrderItemBO = new UocOrderItemBO();
            if (!ObjectUtil.isEmpty((Object)skuInfo.getPlanItemNo())) {
                uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
            }
            totalAm = totalAm.add(skuInfo.getTotalPrice());
            totalPre = totalPre.add(skuInfo.getPreFee());
            uocOrderItemBO.setItemType(PecConstant.ORD_SALE_ITEM_TYPE_ME);
            Long skuSalePrice = 0L;
            Long skupurchasePrice = 0L;
            Long skuSaleFee = 0L;
            Long skuPurchaseFee = 0L;
            try {
                skuSalePrice = UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice());
                skupurchasePrice = UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice());
                BigDecimal divide = skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount());
                skuSaleFee = UocMoneyUtil.bigDecimalToLong((BigDecimal)divide);
                BigDecimal multiply = skuInfo.getSkuAgreementPrice().multiply(skuInfo.getPurchaseCount());
                skuPurchaseFee = UocMoneyUtil.bigDecimalToLong((BigDecimal)multiply);
                purchaseFee = purchaseFee + skuPurchaseFee;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("102107", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            uocOrderItemBO.setSalePrice(skuSalePrice);
            uocOrderItemBO.setPurchasePrice(skupurchasePrice);
            uocOrderItemBO.setTotalSaleFee(skuSaleFee);
            uocOrderItemBO.setTotalPurchaseFee(skuPurchaseFee);
            uocOrderItemBO.setRecvAddr(skuInfo.getComparisonGoodsNo());
            uocOrderItemBO.setSettleUnit(skuInfo.getSettlementUnit());
            uocOrderItemBO.setPurchaseCount(skuInfo.getPurchaseCount());
            uocOrderItemBO.setMateriaCode(skuInfo.getSkuMaterialId());
            OrdGoodsBO ordGoodsBO = new OrdGoodsBO();
            BeanUtils.copyProperties((Object)skuInfo, (Object)ordGoodsBO);
            ordGoodsBO.setSupplierShopName(skuInfo.getSupplierShopName());
            ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
            ordGoodsBO.setSkuMaterialId(skuInfo.getSkuMaterialId());
            ordGoodsBO.setSkuMaterialName(skuInfo.getSkuMaterialName());
            ordGoodsBO.setSkuMainPicUrl(skuInfo.getSkuMainPicUrl());
            ordGoodsBO.setSkuSaleArea(skuInfo.getSkuSaleArea());
            ordGoodsBO.setSkuStatus(skuInfo.getSkuStatus());
            try {
                ordGoodsBO.setSkuSalePrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("102107", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            ArrayList<OrdGoodsAttrBO> ordGoodsAttrBOList = new ArrayList<OrdGoodsAttrBO>();
            if (CollectionUtils.isNotEmpty((Collection)skuInfo.getCommodityAttrList())) {
                for (CommodityAttrRspBO commodityAttrRspBO : skuInfo.getCommodityAttrList()) {
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityId(commodityAttrRspBO.getSkuCommodityId());
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(commodityAttrRspBO.getSkuCommodityPropGrpId());
                    ordGoodsAttrBO.setSkuCommoditySpecId(commodityAttrRspBO.getSkuCommoditySpecId());
                    ordGoodsAttrBO.setSkuPropName(commodityAttrRspBO.getSkuPropName());
                    ordGoodsAttrBO.setSkuPropShowName(commodityAttrRspBO.getSkuPropShowName());
                    ordGoodsAttrBO.setSkuPropValue(commodityAttrRspBO.getSkuPropValue());
                    ordGoodsAttrBO.setSkuPropValueListId(commodityAttrRspBO.getSkuPropValueListId());
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
                if (skuInfo.getServenRejectAllow() != null && skuInfo.getServenRejectAllow().equals(PecConstant.SERVEN_REJECT_ALLOW)) {
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityId(skuInfo.getSpuId());
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(null);
                    ordGoodsAttrBO.setSkuCommoditySpecId(null);
                    ordGoodsAttrBO.setSkuPropName("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropShowName("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropValue("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropValueListId(null);
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
            }
            uocOrderItemBO.setOrdGoodsBO(ordGoodsBO);
            if (skuInfo.getPlanItemId() != null) {
                uocOrderItemBO.setPlanItemId(skuInfo.getPlanItemId());
            }
            if (skuInfo.getPlanId() != null) {
                uocOrderItemBO.setPlanId(skuInfo.getPlanId());
            }
            uocOrderItemList.add(uocOrderItemBO);
        }
        reqBO.setRequestTotalFee(totalAm.longValue());
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uocCoreCreateSaleOrderReqBO);
        uocCoreCreateSaleOrderReqBO.setSaleVoucherNo(this.buildNo("ZH", "SALE_ORDER_NO"));
        uocCoreCreateSaleOrderReqBO.setPurchaseNo(this.buildNo("ZHCG", "PUR_ORDER_NO"));
        uocCoreCreateSaleOrderReqBO.setOrderId(orderId);
        uocCoreCreateSaleOrderReqBO.setOrderLevel(2);
        uocCoreCreateSaleOrderReqBO.setIsDispatch(PecConstant.IS_DISPATCH_YES);
        Long base = 0L;
        Long remote = 0L;
        Long total = 0L;
        Long saleFee = 0L;
        try {
            if (reqBO.getTatleTransportationFee() != null) {
                total = UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBO.getTatleTransportationFee());
            }
            saleFee = reqBO.getRequestTotalFee();
        }
        catch (Exception e) {
            throw new UocProBusinessException("102107", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!", (Throwable)e);
        }
        if (total == null) {
            total = 0L;
        }
        uocCoreCreateSaleOrderReqBO.setBaseTransFee(base);
        uocCoreCreateSaleOrderReqBO.setRemoteTransFee(remote);
        uocCoreCreateSaleOrderReqBO.setTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setOldTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateSaleOrderReqBO.setContactId(contactId);
        uocCoreCreateSaleOrderReqBO.setAccNbr(reqBO.getAddressBo().getReceiverMobileNumber());
        uocCoreCreateSaleOrderReqBO.setProvinceId(reqBO.getAddressBo().getReceiverProvinceId());
        uocCoreCreateSaleOrderReqBO.setCityId(reqBO.getAddressBo().getReceiverCityId());
        uocCoreCreateSaleOrderReqBO.setAreaId(reqBO.getAddressBo().getReceiverCountyId());
        uocCoreCreateSaleOrderReqBO.setAddress(reqBO.getAddressBo().getReceiverAddress());
        uocCoreCreateSaleOrderReqBO.setPurchaseFee(purchaseFee);
        uocCoreCreateSaleOrderReqBO.setUocOrderItemList(uocOrderItemList);
        return uocCoreCreateSaleOrderReqBO;
    }

    private BgyCreateLogisticsReqBO buildLogisticsRelaTionParam(Long requestOrdId, BgyTemStorageAddressReqBo addressInfoIntfceBO) {
        BgyCreateLogisticsReqBO bgyCreateLogisticsReqBO = new BgyCreateLogisticsReqBO();
        bgyCreateLogisticsReqBO.setRequestId(requestOrdId);
        bgyCreateLogisticsReqBO.setRequestCode("");
        bgyCreateLogisticsReqBO.setHsCompanyId(addressInfoIntfceBO.getHsCompanyId());
        bgyCreateLogisticsReqBO.setHsCompanyName(addressInfoIntfceBO.getHsCompanyName());
        bgyCreateLogisticsReqBO.setStockOrgId(addressInfoIntfceBO.getStockOrgId());
        bgyCreateLogisticsReqBO.setStockOrgName(addressInfoIntfceBO.getStockOrgName());
        bgyCreateLogisticsReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        bgyCreateLogisticsReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        bgyCreateLogisticsReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        bgyCreateLogisticsReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        bgyCreateLogisticsReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        bgyCreateLogisticsReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        bgyCreateLogisticsReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        bgyCreateLogisticsReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        bgyCreateLogisticsReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        bgyCreateLogisticsReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        bgyCreateLogisticsReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        bgyCreateLogisticsReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        bgyCreateLogisticsReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        bgyCreateLogisticsReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        bgyCreateLogisticsReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        bgyCreateLogisticsReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        return bgyCreateLogisticsReqBO;
    }

    private BgyCreateRequestOrderReqBO buildRequestOrderParam(BgyCatalogOutNoCostReqBO reqBO, Long requestordId, Long requestAddressId, Long orderId) {
        BgyCreateRequestOrderReqBO bgyCreateRequestOrderReqBO = new BgyCreateRequestOrderReqBO();
        ArrayList<UocOrdItemDataBO> uocOrderItemDataList = new ArrayList<UocOrdItemDataBO>();
        BigDecimal totalAm = BigDecimal.ZERO;
        for (BgyCatalogOutCostCreateOrderCommodityTypeInfoReqBo materialInfo : reqBO.getCommodityTypeList()) {
            UocOrdItemDataBO uocOrdItemDataBO = new UocOrdItemDataBO();
            uocOrdItemDataBO.setRequestId(requestordId);
            uocOrdItemDataBO.setOrderId(orderId);
            uocOrdItemDataBO.setOrdItemDataId(this.idUtil.nextId());
            uocOrdItemDataBO.setOrdItemId(this.idUtil.nextId());
            BeanUtils.copyProperties((Object)materialInfo, (Object)uocOrdItemDataBO);
            uocOrderItemDataList.add(uocOrdItemDataBO);
            totalAm = totalAm.add(materialInfo.getTotalPrice());
        }
        bgyCreateRequestOrderReqBO.setUocOrderItemDataList(uocOrderItemDataList);
        bgyCreateRequestOrderReqBO.setRequestId(this.idUtil.nextId());
        bgyCreateRequestOrderReqBO.setRequestCode("");
        bgyCreateRequestOrderReqBO.setNcRequestCode("");
        BeanUtils.copyProperties((Object)reqBO.getCompanyInfoBo(), (Object)bgyCreateRequestOrderReqBO);
        bgyCreateRequestOrderReqBO.setRequestManId(reqBO.getUserId().toString());
        bgyCreateRequestOrderReqBO.setRequestManName(reqBO.getUsername());
        bgyCreateRequestOrderReqBO.setRequestTime(new Date());
        bgyCreateRequestOrderReqBO.setTotalFee(reqBO.getCommodityTotalFee());
        bgyCreateRequestOrderReqBO.setRequestTotalFee(reqBO.getRequestTotalFee());
        bgyCreateRequestOrderReqBO.setGiveTime(reqBO.getGiveTime());
        return bgyCreateRequestOrderReqBO;
    }

    private String buildNo(String start, String voucherNoKey) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102107", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.buildNo(start);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String buildNo(String start) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        return start + date + time.substring(time.length() - 6);
    }
}

