/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.K2ApprovedConstants;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.BgyCatalogOutReceiveK2ApprovedMsgUpdateBusiService;
import com.tydic.uoc.common.busi.bo.BgyReceiveK2ApprovedMsgUpdateBusiReqBo;
import com.tydic.uoc.common.busi.bo.BgyReceiveK2ApprovedMsgUpdateBusiRspBo;
import com.tydic.uoc.common.busi.bo.BgyReceiveK2ApprovedMsgUpdateBusiRspOrderBo;
import com.tydic.uoc.common.comb.bo.BgyPushRequestOrderToNcCombReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdItemDataPo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatalogOutReceiveK2ApprovedMsgUpdateBusiServiceImpl
implements BgyCatalogOutReceiveK2ApprovedMsgUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogOutReceiveK2ApprovedMsgUpdateBusiServiceImpl.class);
    @Autowired
    private UocOrdRequestMapper ordRequestMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Value(value="${k2callback.switch:true}")
    private boolean k2callbackWwitch;
    @Resource(name="bgyUocRequestOrderToNcMsgProvider")
    private ProxyMessageProducer bgyUocRequestOrderToNcMsgProvider;
    @Value(value="${BGY_UOC_REQUEST_ORDER_NC_TOPIC}")
    private String requestOrderNcTopic;
    @Value(value="${BGY_UOC_REQUEST_ORDER_CREATE_TAG}")
    private String requestOrderNcTag;

    @Override
    public BgyReceiveK2ApprovedMsgUpdateBusiRspBo updateData(BgyReceiveK2ApprovedMsgUpdateBusiReqBo reqBo) {
        BgyReceiveK2ApprovedMsgUpdateBusiRspBo rspBo = (BgyReceiveK2ApprovedMsgUpdateBusiRspBo)UocProRspBoUtil.success(BgyReceiveK2ApprovedMsgUpdateBusiRspBo.class);
        log.info("\u76ee\u5f55\u5916K2\u56de\u8c03\u5165\u53c2(busi\u5c42)\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        String k2Id = reqBo.getK2Id();
        Integer status = reqBo.getStatus();
        UocOrdRequestPo qryRequestPo = new UocOrdRequestPo();
        qryRequestPo.setKtId(k2Id);
        List qryRequestRspPoList = this.ordRequestMapper.selectByCondition(qryRequestPo);
        if (ObjectUtil.isEmpty((Object)qryRequestRspPoList)) {
            log.info("\u6839\u636ek2id(" + k2Id + ")\u67e5\u8be2\u8bf7\u8d2d\u5355\u4e0d\u5b58\u5728");
            return rspBo;
        }
        UocOrdRequestPo uocOrdRequestRspPo = (UocOrdRequestPo)qryRequestRspPoList.get(0);
        Long requestId = uocOrdRequestRspPo.getRequestId();
        rspBo.setRequestId(requestId);
        if (!this.k2callbackWwitch) {
            return rspBo;
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(requestId);
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        processRunReqBO.setOrderId(requestId);
        processRunReqBO.setOperId("1");
        HashMap<String, Object> map = new HashMap<String, Object>();
        processRunReqBO.setVariables(map);
        if (K2ApprovedConstants.APPROEING.equals(status) && "\u5f00\u59cb".equals(reqBo.getActivityName())) {
            UocOrdRequestPo uocOrdRequestPo = new UocOrdRequestPo();
            uocOrdRequestPo.setRequestId(requestId);
            uocOrdRequestPo.setKtFirstApproveCode(reqBo.getKtApproveOperId());
            try {
                this.ordRequestMapper.updateByPrimaryKeySelective(uocOrdRequestPo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (K2ApprovedConstants.APROVED.equals(status)) {
            map.put("approve", "1");
            UocProcessRunRspBO requestRspBo = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(requestRspBo.getRespCode())) {
                throw new UocProBusinessException(requestRspBo.getRespCode(), requestRspBo.getRespDesc());
            }
            qryRequestPo.setRequestId(requestId);
            qryRequestPo.setRequestStatus(Integer.valueOf(requestRspBo.getStepId()));
            BgyPushRequestOrderToNcCombReqBO ncCombReqBOreqBO = new BgyPushRequestOrderToNcCombReqBO();
            ncCombReqBOreqBO.setRequestId(requestId);
            ncCombReqBOreqBO.setKtApproveId(reqBo.getKtApproveOperId());
            ncCombReqBOreqBO.setKtAprroveTime(reqBo.getKtApproveTime());
            ncCombReqBOreqBO.setRequestType(UocConstant.RequestType.CATALOG_OUT);
            this.bgyUocRequestOrderToNcMsgProvider.send(new ProxyMessage(this.requestOrderNcTopic, this.requestOrderNcTag, JSON.toJSONString((Object)ncCombReqBOreqBO)));
            UocOrdItemDataPo ordItemDataPo = new UocOrdItemDataPo();
            ordItemDataPo.setRequestId(requestId);
            ordItemDataPo = this.ordItemDataMapper.selectByPrimaryPo(ordItemDataPo);
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(ordItemDataPo.getOrderId());
            ordSalePO.setSaleState(UocConstant.SALE_ORDER_STATUS.PROCESSING);
            try {
                this.ordRequestMapper.updateByPrimaryKeySelective(qryRequestPo);
                this.ordSaleMapper.updateById(ordSalePO);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u8ba2\u5355\u8868\u72b6\u6001\u5f02\u5e38\uff1a{}", (Throwable)e);
                throw new UocProBusinessException("102112", "\u66f4\u65b0\u76ee\u5f55\u5916\u8ba2\u5355\u72b6\u6001\u5f02\u5e38" + e.getMessage());
            }
            ordSalePO.setRequestId(requestId);
            List list = this.ordSaleMapper.getList(ordSalePO);
            BgyReceiveK2ApprovedMsgUpdateBusiRspOrderBo orderDataBo = new BgyReceiveK2ApprovedMsgUpdateBusiRspOrderBo();
            orderDataBo.setOrderId(((OrdSalePO)list.get(0)).getOrderId());
            orderDataBo.setSaleOrderId(((OrdSalePO)list.get(0)).getSaleVoucherId());
            rspBo.getOrderIdList().add(orderDataBo);
        } else if (K2ApprovedConstants.REJECT.equals(status)) {
            map.put("approve", "0");
            UocProcessRunRspBO requestRspBo = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(requestRspBo.getRespCode())) {
                throw new UocProBusinessException(requestRspBo.getRespCode(), requestRspBo.getRespDesc());
            }
            qryRequestPo.setRequestId(requestId);
            qryRequestPo.setKtActivityName(reqBo.getActivityName());
            try {
                this.ordRequestMapper.updateByPrimaryKeySelective(qryRequestPo);
            }
            catch (Exception e) {
                throw new UocProBusinessException("102112", "\u66f4\u65b0\u76ee\u5f55\u5916\u8bf7\u8d2d\u5355\u5f02\u5e38" + e.getMessage());
            }
        }
        return rspBo;
    }
}

