/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.ability.bo.BgyCommodityPurchaseRecordInfoBo;
import com.tydic.uoc.common.ability.bo.BgyCommodityPurchaseRecordListQueryReqBo;
import com.tydic.uoc.common.ability.bo.BgyCommodityPurchaseRecordListQueryRspBo;
import com.tydic.uoc.common.busi.api.BgyCommodityPurchaseRecordListQueryBusiService;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BgyCommodityPurchaseRecordListQueryBusiServiceImpl
implements BgyCommodityPurchaseRecordListQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyCommodityPurchaseRecordListQueryBusiServiceImpl.class);
    @Autowired
    private UocEsConfig uocEsConfig;
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Override
    public BgyCommodityPurchaseRecordListQueryRspBo queryCommodityPurchaseRecordList(BgyCommodityPurchaseRecordListQueryReqBo reqBo) {
        String result;
        BgyCommodityPurchaseRecordListQueryRspBo rspBo = new BgyCommodityPurchaseRecordListQueryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryCommodityPurchaseRecordEsSql(reqBo);
        log.info("ES\u67e5\u8be2\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u8bed\u53e5\uff1a{}", (Object)qryString);
        String endPoint = "/" + this.uocEsConfig.getCommodityPurchaseRecordIndexName() + "/_search";
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(qryString);
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getCommodityPurchaseRecordIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25");
                    rspBo.setRespCode("100001");
                    rspBo.setRespDesc("\u81ea\u52a8\u521b\u5efa\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25");
                    return rspBo;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBo.setRespCode("102052");
                    rspBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBo;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBo.setRespCode("102052");
            rspBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
            return rspBo;
        }
        this.resolveReturnData(result, rspBo, reqBo);
        return rspBo;
    }

    private void resolveReturnData(String result, BgyCommodityPurchaseRecordListQueryRspBo rspBo, BgyCommodityPurchaseRecordListQueryReqBo reqBo) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(total.intValue());
            rspBo.setRows(new ArrayList(0));
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u4fe1\u606f!");
            return;
        }
        ArrayList<BgyCommodityPurchaseRecordInfoBo> rows = new ArrayList<BgyCommodityPurchaseRecordInfoBo>(listObject.size());
        HashMap<Long, BgyCommodityPurchaseRecordInfoBo> commodityPurchaseRecordInfoBoMap = new HashMap<Long, BgyCommodityPurchaseRecordInfoBo>(listObject.size());
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            BgyCommodityPurchaseRecordInfoBo commodityPurchaseRecordInfoBo = (BgyCommodityPurchaseRecordInfoBo)JSON.toJavaObject((JSON)data, BgyCommodityPurchaseRecordInfoBo.class);
            rows.add(commodityPurchaseRecordInfoBo);
            commodityPurchaseRecordInfoBoMap.put(commodityPurchaseRecordInfoBo.getSkuId(), commodityPurchaseRecordInfoBo);
        }
        int totalPageNo = total % reqBo.getPageSize() == 0 ? total / reqBo.getPageSize() : total / reqBo.getPageSize() + 1;
        rspBo.setTotal(totalPageNo);
        rspBo.setRecordsTotal(total.intValue());
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBo.setRows(rows);
        rspBo.setCommodityPurchaseRecordInfoBoMap(commodityPurchaseRecordInfoBoMap);
    }
}

