/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.mall.ability.api.UccMaterialcodelowestpriceQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMaterialcodelowestpriceQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMaterialcodelowestpriceQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMaterialcodelowestpriceQryBO;
import com.tydic.commodity.mall.ability.bo.UccSpuInformationQryListAbilityBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.BgyCreateComparisonGoodsReqBO;
import com.tydic.uoc.common.ability.bo.BgyCreateComparisonGoodsRspBO;
import com.tydic.uoc.common.ability.bo.UocComparisonGoodsBO;
import com.tydic.uoc.common.busi.api.BgyCreateComparisonGoodsBusiService;
import com.tydic.uoc.dao.ComparisonGoodsMapper;
import com.tydic.uoc.po.ComparisonGoodsPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BgyCreateComparisonGoodsBusiServiceImpl
implements BgyCreateComparisonGoodsBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyCreateComparisonGoodsBusiServiceImpl.class);
    @Autowired
    private ComparisonGoodsMapper comparisonGoodsMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private UccMaterialcodelowestpriceQryAbilityService uccMaterialcodelowestpriceQryAbilityService;

    @Override
    public BgyCreateComparisonGoodsRspBO dealComparisonGoods(BgyCreateComparisonGoodsReqBO reqBO) {
        BgyCreateComparisonGoodsRspBO rspBO = new BgyCreateComparisonGoodsRspBO();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsInfo())) {
            List materialCodeList = reqBO.getGoodsInfo().stream().filter(e -> ObjectUtil.isNotEmpty((Object)e.getSkuMaterialCode())).map(e -> {
                UccMaterialcodelowestpriceQryBO uccMaterialcodelowestpriceQryBO = new UccMaterialcodelowestpriceQryBO();
                uccMaterialcodelowestpriceQryBO.setMaterialCode(e.getSkuMaterialCode());
                uccMaterialcodelowestpriceQryBO.setSkuId(Long.valueOf(e.getSkuId()));
                uccMaterialcodelowestpriceQryBO.setCommodityTypeId(e.getCommodityTypeId());
                uccMaterialcodelowestpriceQryBO.setBrandId(e.getBrandId());
                uccMaterialcodelowestpriceQryBO.setSkuName(e.getSkuName());
                return uccMaterialcodelowestpriceQryBO;
            }).collect(Collectors.toList());
            log.info("\u7269\u6599\u7f16\u7801\u5217\u8868\uff1a{}", (Object)materialCodeList.toString());
            if (materialCodeList.isEmpty()) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u4e0d\u4e3a\u6700\u4f4e\u4ef7\u7684\u5546\u54c1");
                return rspBO;
            }
            UccMaterialcodelowestpriceQryAbilityReqBO uccReqBO = new UccMaterialcodelowestpriceQryAbilityReqBO();
            uccReqBO.setOrgId(reqBO.getOrgId());
            uccReqBO.setProvince(reqBO.getProvince());
            uccReqBO.setCity(reqBO.getCity());
            uccReqBO.setCounty(reqBO.getCounty());
            uccReqBO.setTown(reqBO.getTown());
            uccReqBO.setMaterialCodeList(materialCodeList);
            uccReqBO.setOrgPath(reqBO.getOrgPath());
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u6700\u4f4e\u4ef7\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            UccMaterialcodelowestpriceQryAbilityRspBO uccRspBO = this.uccMaterialcodelowestpriceQryAbilityService.getlowestpriceQry(uccReqBO);
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u6700\u4f4e\u4ef7\u5546\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            if (!"0000".equals(uccRspBO.getRespCode())) {
                log.info("\u67e5\u8be2\u6700\u4f4e\u4ef7\u5546\u54c1\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)uccRspBO.getRespDesc());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(uccRspBO.getRespDesc());
                return rspBO;
            }
            if (uccRspBO.getRows().size() == 0) {
                log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u4e0d\u4e3a\u6700\u4f4e\u4ef7\u7684\u5546\u54c1\uff1a{}", (Object)uccRspBO.getRows().size());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u4e0d\u4e3a\u6700\u4f4e\u4ef7\u7684\u5546\u54c1");
                return rspBO;
            }
            List goodsList = reqBO.getGoodsInfo().stream().filter(e -> {
                for (UccSpuInformationQryListAbilityBO uccBO : uccRspBO.getRows()) {
                    if (!e.getSkuMaterialCode().equals(uccBO.getMaterialCode())) continue;
                    String no = this.biuldNo("", "BJ-");
                    e.setComparisonGoodsNo(no);
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            rspBO.setGoodsList(goodsList);
            ArrayList<ComparisonGoodsPO> list = new ArrayList<ComparisonGoodsPO>();
            try {
                for (UocComparisonGoodsBO uocComparisonGoodsBO : goodsList) {
                    ComparisonGoodsPO goodsPO = new ComparisonGoodsPO();
                    BeanUtils.copyProperties((Object)uocComparisonGoodsBO, (Object)goodsPO);
                    goodsPO.setSkuSalePrice(UocMoneyUtil.bigDecimal2Long((BigDecimal)uocComparisonGoodsBO.getSkuSalePrice()));
                    goodsPO.setMaterial(uocComparisonGoodsBO.getSkuMaterialCode());
                    goodsPO.setSkuCode(uocComparisonGoodsBO.getCommodityCode());
                    goodsPO.setMaterialName(uocComparisonGoodsBO.getSkuMaterialName());
                    goodsPO.setSkuSource(uocComparisonGoodsBO.getSkuSource());
                    goodsPO.setNakeSalePrice(UocMoneyUtil.bigDecimal2Long((BigDecimal)uocComparisonGoodsBO.getNakeSalePrice()));
                    list.add(goodsPO);
                    for (UccSpuInformationQryListAbilityBO uccBO : uccRspBO.getRows()) {
                        if (!uocComparisonGoodsBO.getSkuMaterialCode().equals(uccBO.getMaterialCode())) continue;
                        ComparisonGoodsPO goodsPO2 = (ComparisonGoodsPO)JSON.parseObject((String)JSON.toJSONString((Object)uccBO), ComparisonGoodsPO.class);
                        goodsPO2.setImgUrl(uccBO.getPriPicUrl());
                        goodsPO2.setSpecification(uccBO.getSpec());
                        goodsPO2.setModel(uccBO.getModel());
                        goodsPO2.setGoodsSupplierId(uccBO.getVendorId().toString());
                        goodsPO2.setGoodsSupplierName(uccBO.getVendorName());
                        goodsPO2.setComparisonGoodsNo(uocComparisonGoodsBO.getComparisonGoodsNo());
                        goodsPO2.setSkuSalePrice(UocMoneyUtil.bigDecimal2Long((BigDecimal)uccBO.getSalePrice()));
                        goodsPO2.setShopId(String.valueOf(uccBO.getSupplierShopId()));
                        goodsPO2.setUnitName(uccBO.getSalesUnitName());
                        goodsPO2.setCommodityTypeId(uccBO.getCommodityTypeId());
                        goodsPO2.setCommodityTypeName(uccBO.getCommodityTypeName());
                        goodsPO2.setMaterial(uccBO.getMaterialCode());
                        goodsPO2.setMaterialName(uccBO.getMaterialName());
                        goodsPO2.setNakeSalePrice(UocMoneyUtil.bigDecimal2Long((BigDecimal)uccBO.getUnTaxPrice()));
                        goodsPO2.setSkuSource(uccBO.getSkuSource());
                        goodsPO2.setSpuId(String.valueOf(uccBO.getCommodityId()));
                        goodsPO2.setAgrId(String.valueOf(uccBO.getAgreementId()));
                        list.add(goodsPO2);
                    }
                }
            }
            catch (Exception e2) {
                throw new UocProBusinessException("100001", "\u751f\u6210\u6bd4\u4ef7\u5355\u65f6\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
            }
            this.comparisonGoodsMapper.insertBatch(list);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        ComparisonGoodsPO cancelPO = new ComparisonGoodsPO();
        cancelPO.setComparisonGoodsNo(no);
        int count = this.comparisonGoodsMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }
}

