/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.bo.BgyRequisitionListBo;
import com.tydic.uoc.common.ability.bo.BgyRequisitionListCommodityInfoBo;
import com.tydic.uoc.common.busi.api.BgyEsQryRequisitionListBusiService;
import com.tydic.uoc.common.busi.bo.BgyEsQryRequisitionListBusiReqBo;
import com.tydic.uoc.common.busi.bo.BgyEsQryRequisitionListBusiRspBo;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BgyEsQryRequisitionListBusiServiceImpl
implements BgyEsQryRequisitionListBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyEsQryRequisitionListBusiServiceImpl.class);
    @Autowired
    private UocEsConfig uocEsConfig;
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Override
    public BgyEsQryRequisitionListBusiRspBo qryEsRequisitionInfo(BgyEsQryRequisitionListBusiReqBo reqBo) {
        String result;
        BgyEsQryRequisitionListBusiRspBo rspBo = new BgyEsQryRequisitionListBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryRequisitionEsSql(reqBo);
        log.info("ES\u67e5\u8be2\u8bf7\u8d2d\u5355\u8bed\u53e5\uff1a{}", (Object)qryString);
        String endPoint = "/" + this.uocEsConfig.getRequestIndexName() + "/_search";
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(qryString);
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getRequestIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u8bf7\u8d2d\u5355\u7d22\u5f15\u5931\u8d25");
                    rspBo.setRespCode("100001");
                    rspBo.setRespDesc("\u81ea\u52a8\u521b\u5efa\u8bf7\u8d2d\u5355\u7d22\u5f15\u5931\u8d25");
                    return rspBo;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBo.setRespCode("102052");
                    rspBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8bf7\u8d2d\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBo;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBo.setRespCode("102052");
            rspBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8bf7\u8d2d\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
            return rspBo;
        }
        if (null != reqBo.getIsQueryTab() && reqBo.getIsQueryTab().booleanValue()) {
            this.resolveReturnCounts(result, rspBo, reqBo);
        } else {
            this.resolveReturnData(result, rspBo, reqBo.getPageSize(), reqBo.getPageNo(), reqBo.getIsRemainingTime());
        }
        return rspBo;
    }

    private void resolveReturnData(String result, BgyEsQryRequisitionListBusiRspBo rspBo, Integer pageSize, Integer pageNo, Boolean isRemainingTime) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBo.setPageNo(1);
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(total);
            rspBo.setRows(new ArrayList());
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8bf7\u8d2d\u5355\u4fe1\u606f!");
            return;
        }
        ArrayList<BgyRequisitionListBo> rows = new ArrayList<BgyRequisitionListBo>(listObject.size());
        HashSet<String> approvingSupplierIdSet = new HashSet<String>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            BgyRequisitionListBo requisitionListBo = (BgyRequisitionListBo)JSON.toJavaObject((JSON)objJson, BgyRequisitionListBo.class);
            if (null != isRemainingTime && isRemainingTime.booleanValue() && (UocConstant.REQUEST_ORDER_STATUS.CONFIRM.equals(requisitionListBo.getRequestStatus()) || UocConstant.REQUEST_ORDER_STATUS.APPROVING.equals(requisitionListBo.getRequestStatus()))) {
                HashSet<String> singleApprovingSupplierIdSet = new HashSet<String>();
                for (BgyRequisitionListCommodityInfoBo requisitionListCommodityInfoBo : requisitionListBo.getCommodityInfoBoList()) {
                    if (!String.valueOf(UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT).equals(requisitionListCommodityInfoBo.getOrderSource())) continue;
                    String skuSupplierId = String.valueOf(requisitionListCommodityInfoBo.getSkuSupplierId());
                    approvingSupplierIdSet.add(skuSupplierId);
                    singleApprovingSupplierIdSet.add(skuSupplierId);
                }
                requisitionListBo.setApprovingSupplierIdSet(singleApprovingSupplierIdSet);
            }
            rows.add(requisitionListBo);
        }
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBo.setTotal(totalPageNo);
        rspBo.setRecordsTotal(total);
        rspBo.setPageNo(pageNo);
        rspBo.setRespDesc("\u67e5\u8be2\u8bf7\u8d2d\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBo.setRows(rows);
        rspBo.setApprovingSupplierIdSet(approvingSupplierIdSet);
    }

    public void resolveReturnCounts(String result, BgyEsQryRequisitionListBusiRspBo rspBo, BgyEsQryRequisitionListBusiReqBo reqBo) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"all_interests");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        HashMap<String, Integer> tabCountsMap = new HashMap<String, Integer>(bucketsArray.size());
        for (int i = 0; i < bucketsArray.size(); ++i) {
            JSONObject bucketsObj = bucketsArray.getJSONObject(i);
            tabCountsMap.put(bucketsObj.getString("key"), bucketsObj.getInteger("doc_count"));
        }
        rspBo.setTabCountsMap(tabCountsMap);
    }
}

