/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.busi.api.BgyExportOrderBusiService;
import com.tydic.uoc.common.busi.bo.BgyExportOrderBusiReqBO;
import com.tydic.uoc.common.busi.bo.BgyExportOrderBusiRspBO;
import com.tydic.uoc.common.busi.bo.BgyExportOrderItemBusiRspBO;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.ExportOrderItemPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BgyExportOrderBusiServiceImpl
implements BgyExportOrderBusiService {
    @Autowired
    private OrdStakeholderMapper stakeholderMapper;
    @Autowired
    private UocOrdRequestMapper requestMapper;
    @Autowired
    private OrdPurchaseMapper purchaseMapper;
    @Autowired
    private OrdSaleMapper saleMapper;
    @Autowired
    private OrdItemMapper itemMapper;
    @Autowired
    private OrderMapper orderMapper;

    @Override
    public BgyExportOrderBusiRspBO getOrderInfo(BgyExportOrderBusiReqBO reqBO) {
        BgyExportOrderBusiRspBO rspBO = new BgyExportOrderBusiRspBO();
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        OrdStakeholderPO getStakeholderPO = this.stakeholderMapper.getModelBy(stakeholderPO);
        if (getStakeholderPO == null) {
            throw new UocProBusinessException("100200", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355ID\uff1a" + reqBO.getOrderId() + " \u5bf9\u5e94\u4e09\u65b9\u8868");
        }
        UocOrdRequestPo getRequestPO = this.requestMapper.selectByPrimaryKey(reqBO.getRequestId());
        if (getRequestPO == null) {
            throw new UocProBusinessException("100200", "\u672a\u67e5\u8be2\u5230\u8bf7\u8d2d\u5355ID\uff1a" + reqBO.getRequestId() + " \u5bf9\u5e94\u8bf7\u8d2d\u8868");
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO getSalePO = this.saleMapper.getModelBy(ordSalePO);
        if (getRequestPO == null) {
            throw new UocProBusinessException("100200", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9500\u552e\u8ba2\u5355\u4fe1\u606f");
        }
        OrdPurchasePO ordPurchasePO = new OrdPurchasePO();
        ordPurchasePO.setPurchaseVoucherId(getSalePO.getPurchaseVoucherId());
        ordPurchasePO.setOrderId(getSalePO.getOrderId());
        OrdPurchasePO getPurchasePO = this.purchaseMapper.getModelBy(ordPurchasePO);
        if (getPurchasePO == null) {
            throw new UocProBusinessException("100200", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u91c7\u8d2d\u5355\u4fe1\u606f");
        }
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        OrderPO getOrderPO = this.orderMapper.getModelBy(orderPO);
        if (getOrderPO == null) {
            throw new UocProBusinessException("100200", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f");
        }
        rspBO.setPurName(getStakeholderPO.getPurName());
        rspBO.setRequestDeptName(getRequestPO.getRequestDeptName());
        rspBO.setAccountName(getRequestPO.getAccountName());
        rspBO.setPurMobile(getStakeholderPO.getPurMobile());
        rspBO.setPurPlaceOrderName(getStakeholderPO.getPurRelaName());
        rspBO.setPurchaseVoucherNo(getPurchasePO.getPurchaseVoucherNo());
        rspBO.setSaleVoucherNo(getSalePO.getSaleVoucherNo());
        rspBO.setOrderNo(getOrderPO.getOrderNo());
        rspBO.setSupName(getStakeholderPO.getSupName());
        rspBO.setSupRelaName(getStakeholderPO.getSupRelaName());
        rspBO.setSupRelaMobile(getStakeholderPO.getSupRelaMobile());
        ArrayList<BgyExportOrderItemBusiRspBO> itemList = new ArrayList<BgyExportOrderItemBusiRspBO>();
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        ordItemPO.setSaleVoucherId(getSalePO.getSaleVoucherId());
        List exportOrderItemPOList = this.itemMapper.qryExportOrderItem(ordItemPO);
        HashMap<Long, ExportOrderItemPO> orderItemPOMap = new HashMap<Long, ExportOrderItemPO>();
        for (ExportOrderItemPO exportOrderItemPO : exportOrderItemPOList) {
            orderItemPOMap.put(exportOrderItemPO.getOrdItemId(), exportOrderItemPO);
        }
        for (Map.Entry entry : orderItemPOMap.entrySet()) {
            BgyExportOrderItemBusiRspBO busiRspBO = (BgyExportOrderItemBusiRspBO)JSON.parseObject((String)JSON.toJSONString(entry.getValue()), BgyExportOrderItemBusiRspBO.class);
            busiRspBO.setTax(((ExportOrderItemPO)entry.getValue()).getTax() + "%");
            try {
                busiRspBO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)((ExportOrderItemPO)entry.getValue()).getSalePrice()).toString());
                busiRspBO.setTotalSaleFee(MoneyUtils.Long2BigDecimal((Long)((ExportOrderItemPO)entry.getValue()).getTotalSaleFee()).toString());
                busiRspBO.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal((Long)((ExportOrderItemPO)entry.getValue()).getTotalPurchaseFee()).toString());
                busiRspBO.setPurchasePrice(MoneyUtils.Long2BigDecimal((Long)((ExportOrderItemPO)entry.getValue()).getPurchasePrice()).toString());
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            itemList.add(busiRspBO);
        }
        rspBO.setItemList(itemList);
        return rspBO;
    }
}

