/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.BipConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfQryDistributionBusiService;
import com.tydic.uoc.busibase.busi.bo.QryDistributionReqBO;
import com.tydic.uoc.busibase.busi.bo.QryDistributionRspBO;
import com.tydic.uoc.common.atom.api.BgyGetStorageFromNCAtomService;
import com.tydic.uoc.common.atom.api.BgyStorageSyncEcomAtomService;
import com.tydic.uoc.common.atom.api.UocQrySupIdAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyGetStorageBodyFromNCRspBO;
import com.tydic.uoc.common.atom.bo.BgyGetStorageFromNCAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyGetStorageFromNCAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgyGetStorageHeadFromNCRspBO;
import com.tydic.uoc.common.atom.bo.BgyGetStorageInfoFromNCReqBO;
import com.tydic.uoc.common.atom.bo.BgySendTodoInfoAtomArgReqBo;
import com.tydic.uoc.common.atom.bo.BgySendTodoInfoAtomReqBo;
import com.tydic.uoc.common.atom.bo.BgySendTodoLoginBo;
import com.tydic.uoc.common.atom.bo.BgyStorageSyncEcomAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyStorageSyncEcomAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgyStorageSyncEcomSkuBO;
import com.tydic.uoc.common.atom.bo.BgyStorageSyncEcomStockBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.busi.api.BgyGetStorageFromNCBusiService;
import com.tydic.uoc.common.busi.bo.BgyGetStorageFromNCBusiReqBO;
import com.tydic.uoc.common.busi.bo.BgyGetStorageFromNCBusiRspBO;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BgyGetStorageFromNCBusiServiceImpl
implements BgyGetStorageFromNCBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyGetStorageFromNCBusiServiceImpl.class);
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private BgyGetStorageFromNCAtomService bgyGetStorageFromNCAtomService;
    @Autowired
    private BgyStorageSyncEcomAtomService bgyStorageSyncEcomAtomService;
    @Autowired
    private PebIntfQryDistributionBusiService pebIntfQryDistributionBusiService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Autowired
    private UocQrySupIdAtomService uocQrySupIdAtomService;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    private static final Integer SEND_ORDER = 2;
    @Value(value="${UOC_PRO_BIP_NOTICE_ORDER_TOPIC:UOC_PRO_BIP_NOTICE_ORDER_TOPIC}")
    private String noticeBipTopic;
    @Value(value="${UOC_PRO_BIP_NOTICE_ORDER_TAG:*}")
    private String noticeBipTag;
    @Resource(name="uocProBipNoticeMsgProvider")
    private ProxyMessageProducer uocProBipNoticeMsgProvider;
    @Value(value="${BIP_APP_NAME:BU00149}")
    private String appName;
    @Value(value="${COMMENT_BIP_LINK:/unagrMyOrder}")
    private String CommentBipLink;
    @Value(value="${cas.login.url}")
    private String casLoginUrl;
    @Value(value="${cgsc.login.url}")
    private String cgscLoginUrl;
    private static final Integer CHECK_UN_SYNC_STATUS = 3;

    @Override
    public BgyGetStorageFromNCBusiRspBO dealGetStorageFromNc(BgyGetStorageFromNCBusiReqBO reqBO) {
        BgyGetStorageFromNCBusiRspBO rspBO = new BgyGetStorageFromNCBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UocProcessRunReqBO process = this.createProcess();
        OrdSalePO ordSalePO = reqBO.getOrdSalePO();
        Map<Long, List<OrdItemPO>> orderItemListMap = reqBO.getOrderItemListMap();
        Map<Long, OrdItemPO> orderItemMap = reqBO.getOrderItemMap();
        Map<Long, List<OrdInspectionPO>> ordInspectionPOMap = reqBO.getOrdInspectionPOMap();
        Map<Long, OrdGoodsPO> ordGoodsPOMap = reqBO.getOrdGoodsPOMap();
        Map<String, OrdShipPO> shipPOMap = reqBO.getShipPOMap();
        BgyGetStorageFromNCAtomRspBO ncStorageHead = this.getNCStorage(ordSalePO, "crinfor_h_cgsc_view");
        if (CollectionUtils.isEmpty(ncStorageHead.getBgyGetStorageHeadFromNCRspBOs())) {
            return rspBO;
        }
        BgyGetStorageFromNCAtomRspBO ncStorageBody = this.getNCStorage(ordSalePO, "crinfor_b_cgsc_view");
        if (CollectionUtils.isEmpty(ncStorageBody.getBgyGetStorageBodyFromNCRspBOs())) {
            return rspBO;
        }
        List<BgyGetStorageHeadFromNCRspBO> bgyGetStorageHeadFromNCRspBOs = ncStorageHead.getBgyGetStorageHeadFromNCRspBOs();
        List<BgyGetStorageBodyFromNCRspBO> bgyGetStorageBodyFromNCRspBOs = ncStorageBody.getBgyGetStorageBodyFromNCRspBOs();
        if (ObjectUtil.isNull(ordInspectionPOMap.get(ordSalePO.getOrderId()))) {
            List<Long> inspectionVoucherIdList = this.createInspectionInfo(bgyGetStorageHeadFromNCRspBOs, bgyGetStorageBodyFromNCRspBOs, ordSalePO, orderItemMap, ordGoodsPOMap, shipPOMap);
            rspBO.setInspectionVoucherIdList(inspectionVoucherIdList);
            if (this.verifyIsAllStorage(ordSalePO.getSaleVoucherId(), ordSalePO.getOrderId())) {
                this.runProcess(process, ordSalePO.getSaleVoucherId(), ordSalePO.getOrderId());
            }
            this.updateEvaluationStatus(ordSalePO);
        } else {
            List existInspectionVoucherCodes = ordInspectionPOMap.get(ordSalePO.getOrderId()).stream().map(OrdInspectionPO::getInspectionVoucherCode).collect(Collectors.toList());
            bgyGetStorageHeadFromNCRspBOs.removeIf(bgyGetStorageHeadFromNCRspBO -> existInspectionVoucherCodes.contains(bgyGetStorageHeadFromNCRspBO.getCgeneralhid()));
            List toBeStorageHeadIds = bgyGetStorageHeadFromNCRspBOs.stream().map(BgyGetStorageHeadFromNCRspBO::getCgeneralhid).collect(Collectors.toList());
            List<BgyGetStorageBodyFromNCRspBO> toBeStorageBodyFromNCRspBOS = bgyGetStorageBodyFromNCRspBOs.stream().filter(bgyGetStorageBodyFromNCRspBO -> toBeStorageHeadIds.contains(bgyGetStorageBodyFromNCRspBO.getCfirstbillhid())).collect(Collectors.toList());
            List<Long> inspectionVoucherIdList = this.createInspectionInfo(bgyGetStorageHeadFromNCRspBOs, toBeStorageBodyFromNCRspBOS, ordSalePO, orderItemMap, ordGoodsPOMap, shipPOMap);
            rspBO.setInspectionVoucherIdList(inspectionVoucherIdList);
            if (this.verifyIsAllStorage(ordSalePO.getSaleVoucherId(), ordSalePO.getOrderId())) {
                this.runProcess(process, ordSalePO.getSaleVoucherId(), ordSalePO.getOrderId());
            }
        }
        this.sendMessageToRequest(ordSalePO);
        this.sendMessageToSup(ordSalePO);
        return rspBO;
    }

    private void sendMessageToSup(OrdSalePO ordSalePO) {
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
        UocQrySupIdAtomReqBo uocQrySupIdAtomReqBo = new UocQrySupIdAtomReqBo();
        uocQrySupIdAtomReqBo.setSupNo(stakeholderPO.getSupNo());
        UocQrySupIdAtomRspBo uocQrySupIdAtomRspBo = this.uocQrySupIdAtomService.getSupIds(uocQrySupIdAtomReqBo);
        OrdPurchasePO ordPurchasePO = new OrdPurchasePO();
        ordPurchasePO.setPurchaseVoucherId(ordSalePO.getPurchaseVoucherId());
        OrdPurchasePO modelBy = this.ordPurchaseMapper.getModelBy(ordPurchasePO);
        List<Long> supUserIds = uocQrySupIdAtomRspBo.getSupUserIds();
        for (Long supUserId : supUserIds) {
            UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
            sendMessageBo.setSendId(supUserId);
            sendMessageBo.setRecId(supUserId);
            sendMessageBo.setNoticeNodeCode("20016");
            sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7#}", modelBy.getPurchaseVoucherNo()));
            sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u8bf7\u8d2d\u5355\u7f16\u53f7#}", ordSalePO.getRequestCode()));
            this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
        }
    }

    private void sendMessageToRequest(OrdSalePO ordSalePO) {
        Long requestId = ordSalePO.getRequestId();
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
        sendMessageBo.setSendId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setRecId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setNoticeNodeCode("20015");
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", ordSalePO.getSaleVoucherNo()));
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u8bf7\u8d2d\u5355\u53f7#}", uocOrdRequestPo.getRequestCode()));
        this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
        this.sendBipTodoMessage(ordSalePO, uocOrdRequestPo);
    }

    private void sendBipTodoMessage(OrdSalePO ordSalePO, UocOrdRequestPo ordRequestPo) {
        UocQrySupIdAtomReqBo uocQrySupIdAtomReqBo = new UocQrySupIdAtomReqBo();
        uocQrySupIdAtomReqBo.setRequestManId(Long.valueOf(ordRequestPo.getRequestManId()));
        String reqBip = this.uocQrySupIdAtomService.getSupIds(uocQrySupIdAtomReqBo).getReqBip();
        Date date = new Date();
        BgySendTodoLoginBo bgySendTodoLoginBo = new BgySendTodoLoginBo();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BgySendTodoInfoAtomReqBo sendInfoBo = new BgySendTodoInfoAtomReqBo();
        BgySendTodoInfoAtomArgReqBo arg0 = new BgySendTodoInfoAtomArgReqBo();
        arg0.setDocCreator("{\"LoginName\":\"null\"}");
        arg0.setModelId(BipConstant.COMMENT_PREFIX + ordSalePO.getSaleVoucherNo());
        arg0.setCreateTime(dateFormat.format(date));
        arg0.setAppName(this.appName);
        arg0.setSubject(BipConstant.ORDER_TOBE_EVALUATED_TITLE);
        arg0.setLink(this.casLoginUrl + "/idp/oauth2/authorize?client_id=cgsc&redirect_uri=" + this.cgscLoginUrl + "/%23/loginNew?routerUrl=unagrMyOrder%26orderCode=" + ordSalePO.getSaleVoucherNo() + "%26type=1&response_type=code&state=123");
        arg0.setType(BipConstant.APPROVAL_TYPE);
        bgySendTodoLoginBo.setLoginName(reqBip);
        arg0.setTargets(JSON.toJSONString((Object)bgySendTodoLoginBo));
        sendInfoBo.setArg0(arg0);
        this.uocProBipNoticeMsgProvider.send(new ProxyMessage(this.noticeBipTopic, this.noticeBipTag, JSON.toJSONString((Object)sendInfoBo)));
    }

    private void updateEvaluationStatus(OrdSalePO ordSalePO) {
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        ordExtMapPO.setObjType(PecConstant.OBJ_TYPE.SALE);
        ordExtMapPO.setObjId(ordSalePO.getSaleVoucherId());
        ordExtMapPO.setOrderId(ordSalePO.getOrderId());
        ordExtMapPO.setFieldCode("evaluateState");
        ordExtMapPO.setFieldValue("0");
        this.ordExtMapMapper.insert(ordExtMapPO);
    }

    private boolean verifyIsAllStorage(Long ordSaleId, Long orderId) {
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setSaleVoucherId(ordSaleId);
        ordItemPO.setOrderId(orderId);
        List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
        return ordItemPOS.stream().allMatch(ordItem -> ordItem.getPurchaseCount().compareTo(ordItem.getArriveCount()) == 0);
    }

    private List<Long> createInspectionInfo(List<BgyGetStorageHeadFromNCRspBO> bgyGetStorageHeadFromNCRspBOs, List<BgyGetStorageBodyFromNCRspBO> bgyGetStorageBodyFromNCRspBOs, OrdSalePO ordSalePO, Map<Long, OrdItemPO> orderItemMap, Map<Long, OrdGoodsPO> ordGoodsPOMap, Map<String, OrdShipPO> shipPOMap) {
        Map<String, List<BgyGetStorageBodyFromNCRspBO>> bgyGetStorageBodyFromNCRspBOMap = bgyGetStorageBodyFromNCRspBOs.stream().collect(Collectors.groupingBy(BgyGetStorageBodyFromNCRspBO::getCgeneralhid));
        List<OrdInspectionPO> tobeInsertInspectionList = bgyGetStorageHeadFromNCRspBOs.stream().map(bgyGetStorageHeadFromNCRspBO -> {
            OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
            ordInspectionPO.setInspectionVoucherId(Long.valueOf(Sequence.getInstance().nextId()));
            ordInspectionPO.setInspectionVoucherCode(bgyGetStorageHeadFromNCRspBO.getCgeneralhid());
            ordInspectionPO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
            ordInspectionPO.setPurchaseVoucherId(ordSalePO.getPurchaseVoucherId());
            ordInspectionPO.setOrderId(ordSalePO.getOrderId());
            BigDecimal totalInspectionMoney = ((List)bgyGetStorageBodyFromNCRspBOMap.get(bgyGetStorageHeadFromNCRspBO.getCgeneralhid())).stream().map(bgyGetStorageBodyFromNCRspBO -> new BigDecimal(bgyGetStorageBodyFromNCRspBO.getNorigtaxmny())).reduce(BigDecimal.ZERO, BigDecimal::add);
            ordInspectionPO.setInspTotalSaleFee(this.bigDecimal2Long(totalInspectionMoney));
            ordInspectionPO.setInspectionTime((Date)DateUtil.parse((CharSequence)bgyGetStorageHeadFromNCRspBO.getDbilldate()));
            ordInspectionPO.setCreateTime(new Date());
            ordInspectionPO.setInspectionOper(bgyGetStorageHeadFromNCRspBO.getWhsmanager());
            ordInspectionPO.setNcStorageCode(bgyGetStorageHeadFromNCRspBO.getVbillcode());
            ordInspectionPO.setNcArrivalCode(bgyGetStorageHeadFromNCRspBO.getVdef18());
            ordInspectionPO.setInspectionState(Integer.valueOf(1));
            ordInspectionPO.setCheckState(CHECK_UN_SYNC_STATUS);
            return ordInspectionPO;
        }).collect(Collectors.toList());
        Map<String, OrdInspectionPO> ordInspMap = tobeInsertInspectionList.stream().collect(Collectors.toMap(OrdInspectionPO::getInspectionVoucherCode, o -> o));
        List<OrdInspectionItemPO> tobeInsertInspectionItemList = bgyGetStorageBodyFromNCRspBOs.stream().map(bgyGetStorageBodyFromNCRspBO -> {
            OrdInspectionPO ordInspectionPO = (OrdInspectionPO)ordInspMap.get(bgyGetStorageBodyFromNCRspBO.getCgeneralhid());
            OrdItemPO ordItemPO = (OrdItemPO)orderItemMap.get(Convert.toLong((Object)bgyGetStorageBodyFromNCRspBO.getDetailid()));
            OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
            ordInspectionItemPO.setInspectionItemId(Long.valueOf(Sequence.getInstance().nextId()));
            ordInspectionItemPO.setOrdItemId(ordItemPO.getOrdItemId());
            ordInspectionItemPO.setInspectionVoucherId(ordInspectionPO.getInspectionVoucherId());
            ordInspectionItemPO.setOrderId(ordInspectionPO.getOrderId());
            ordInspectionItemPO.setCheckStatus(UocCoreConstant.CHECK_SATE_INSPECTED);
            ordInspectionItemPO.setInspPurchaseFee(Long.valueOf(new BigDecimal(ordItemPO.getPurchasePrice()).multiply(new BigDecimal(bgyGetStorageBodyFromNCRspBO.getNnum())).longValue()));
            ordInspectionItemPO.setInspSaleFee(this.bigDecimal2Long(new BigDecimal(bgyGetStorageBodyFromNCRspBO.getNorigtaxmny())));
            ordInspectionItemPO.setUnitName(ordItemPO.getUnitName());
            ordInspectionItemPO.setInspectionCount(new BigDecimal(bgyGetStorageBodyFromNCRspBO.getNnum()));
            ordInspectionItemPO.setNcStorageItemCode(bgyGetStorageBodyFromNCRspBO.getCgeneralbid());
            return ordInspectionItemPO;
        }).collect(Collectors.toList());
        Map<Long, List<OrdInspectionItemPO>> ordInspectionItemPOListMap = tobeInsertInspectionItemList.stream().collect(Collectors.groupingBy(OrdInspectionItemPO::getInspectionVoucherId));
        for (OrdInspectionPO ordInspectionPO : tobeInsertInspectionList) {
            long sum = ordInspectionItemPOListMap.get(ordInspectionPO.getInspectionVoucherId()).stream().mapToLong(OrdInspectionItemPO::getInspPurchaseFee).sum();
            ordInspectionPO.setInspTotalPurchaseFee(Long.valueOf(sum));
        }
        ArrayList ordItemPOList = new ArrayList();
        Map<Long, List<OrdInspectionItemPO>> ordInsItemMap = tobeInsertInspectionItemList.stream().collect(Collectors.groupingBy(OrdInspectionItemPO::getOrdItemId));
        ordInsItemMap.forEach((ordItemId, ordInsItemList) -> {
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrdItemId(ordItemId);
            BigDecimal totalInspCount = ordInsItemList.stream().map(OrdInspectionItemPO::getInspectionCount).reduce(BigDecimal.ZERO, BigDecimal::add);
            ordItemPO.setArriveCount(totalInspCount);
            ordItemPO.setAcceptanceCount(totalInspCount);
            ordItemPOList.add(ordItemPO);
        });
        if (!CollectionUtils.isEmpty(ordItemPOList)) {
            this.ordItemMapper.updateCountsBatch(ordItemPOList);
        }
        if (!CollectionUtils.isEmpty(tobeInsertInspectionList)) {
            this.ordInspectionMapper.insertBatch(tobeInsertInspectionList);
        }
        if (!CollectionUtils.isEmpty(tobeInsertInspectionItemList)) {
            this.ordInspectionItemMapper.insertBatch(tobeInsertInspectionItemList);
        }
        if ("2".equals(ordSalePO.getOrderSource()) && !CollectionUtils.isEmpty(tobeInsertInspectionItemList) && !CollectionUtils.isEmpty(tobeInsertInspectionList)) {
            this.syncEcomStorage(tobeInsertInspectionList, tobeInsertInspectionItemList, shipPOMap, ordGoodsPOMap, ordSalePO);
        }
        return tobeInsertInspectionList.stream().map(OrdInspectionPO::getInspectionVoucherId).collect(Collectors.toList());
    }

    private void syncEcomStorage(List<OrdInspectionPO> tobeInsertInspectionList, List<OrdInspectionItemPO> tobeInsertInspectionItemList, Map<String, OrdShipPO> shipPOMap, Map<Long, OrdGoodsPO> ordGoodsPOMap, OrdSalePO ordSalePO) {
        Map<Long, List<OrdInspectionItemPO>> insItemListMap = tobeInsertInspectionItemList.stream().collect(Collectors.groupingBy(OrdInspectionItemPO::getInspectionVoucherId));
        BgyStorageSyncEcomAtomReqBO bgyStorageSyncEcomAtomReqBO = new BgyStorageSyncEcomAtomReqBO();
        ArrayList<BgyStorageSyncEcomStockBO> bgyStorageSyncEcomStockBOS = new ArrayList<BgyStorageSyncEcomStockBO>();
        Long skuSupplierId = ordGoodsPOMap.get(tobeInsertInspectionItemList.get(0).getOrdItemId()).getSkuSupplierId();
        String ncArrivalCode = tobeInsertInspectionList.get(0).getNcArrivalCode();
        OrdShipPO ordShipPO1 = shipPOMap.get(ncArrivalCode);
        for (OrdInspectionPO ordInspectionPO : tobeInsertInspectionList) {
            BgyStorageSyncEcomStockBO bgyStorageSyncEcomStockBO = new BgyStorageSyncEcomStockBO();
            OrdShipPO ordShipPO = shipPOMap.get(ordInspectionPO.getNcArrivalCode());
            String deliveryOrderId = this.getDeliveryOrderId(ordShipPO, skuSupplierId);
            bgyStorageSyncEcomStockBO.setDeliveryOrderId(deliveryOrderId);
            bgyStorageSyncEcomStockBO.setStockNo(ordInspectionPO.getInspectionVoucherCode());
            List<BgyStorageSyncEcomSkuBO> bgyStorageSyncEcomSkuBOS = insItemListMap.get(ordInspectionPO.getInspectionVoucherId()).stream().map(ordInspectionItemPO -> {
                BgyStorageSyncEcomSkuBO bgyStorageSyncEcomSkuBO = new BgyStorageSyncEcomSkuBO();
                bgyStorageSyncEcomSkuBO.setExtSkuId(((OrdGoodsPO)ordGoodsPOMap.get(ordInspectionItemPO.getOrdItemId())).getSkuExtSkuId());
                bgyStorageSyncEcomSkuBO.setNum(ordInspectionItemPO.getInspectionCount().toString());
                return bgyStorageSyncEcomSkuBO;
            }).collect(Collectors.toList());
            bgyStorageSyncEcomStockBO.setSkuInfo(bgyStorageSyncEcomSkuBOS);
            bgyStorageSyncEcomStockBOS.add(bgyStorageSyncEcomStockBO);
        }
        bgyStorageSyncEcomAtomReqBO.setStockInfo(bgyStorageSyncEcomStockBOS);
        bgyStorageSyncEcomAtomReqBO.setOrderId(ordShipPO1.getExtOrderId());
        bgyStorageSyncEcomAtomReqBO.setOurOrderId(ordSalePO.getOrderId());
        bgyStorageSyncEcomAtomReqBO.setSupplierId(Convert.toStr((Object)skuSupplierId));
        BgyStorageSyncEcomAtomRspBO bgyStorageSyncEcomAtomRspBO = this.bgyStorageSyncEcomAtomService.dealStorageSyncEcom(bgyStorageSyncEcomAtomReqBO);
        if (!"0000".equals(bgyStorageSyncEcomAtomRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u540c\u6b65\u7535\u5546\u5165\u5e93\u5355\u5931\u8d25\uff01");
        }
    }

    private String getDeliveryOrderId(OrdShipPO ordShipPO, Long skuSupplierId) {
        QryDistributionReqBO qryDistributionReqBO = new QryDistributionReqBO();
        qryDistributionReqBO.setType(SEND_ORDER);
        qryDistributionReqBO.setOrderId(ordShipPO.getPackageId());
        qryDistributionReqBO.setSupplierId(skuSupplierId);
        QryDistributionRspBO qryDistributionRspBO = this.pebIntfQryDistributionBusiService.qryDistributionService(qryDistributionReqBO);
        if (!"0000".equals(qryDistributionRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u7535\u5546\u8fd0\u5355\u53f7\u5931\u8d25\uff01");
        }
        return qryDistributionRspBO.getDeliveryOrderId();
    }

    private BgyGetStorageFromNCAtomRspBO getNCStorage(OrdSalePO ordSalePO, String viewCode) {
        BgyGetStorageFromNCAtomReqBO bgyGetStorageFromNCAtomReqBO = new BgyGetStorageFromNCAtomReqBO();
        BgyGetStorageInfoFromNCReqBO bgyGetStorageInfoFromNCReqBO = new BgyGetStorageInfoFromNCReqBO();
        bgyGetStorageInfoFromNCReqBO.setCdBillCode(ordSalePO.getNcOrderCode());
        bgyGetStorageInfoFromNCReqBO.setOrderId(ordSalePO.getOrderId());
        bgyGetStorageInfoFromNCReqBO.setViewCode(viewCode);
        bgyGetStorageFromNCAtomReqBO.setRequestInfo(bgyGetStorageInfoFromNCReqBO);
        BgyGetStorageFromNCAtomRspBO storageFromNC = this.bgyGetStorageFromNCAtomService.getStorageFromNC(bgyGetStorageFromNCAtomReqBO);
        if (!"0000".equals(storageFromNC.getRespCode())) {
            throw new UocProBusinessException("8888", "\u83b7\u53d6\u5165\u5e93\u5355\u5931\u8d25\uff01");
        }
        return storageFromNC;
    }

    private UocProcessRunReqBO createProcess() {
        UocProcessRunReqBO uocProcessRunReqBO = new UocProcessRunReqBO();
        uocProcessRunReqBO.setProcDefKey("cnnc_el_sale_order_master_order_status");
        uocProcessRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocProcessRunReqBO.setSysCode("UOC");
        uocProcessRunReqBO.setOperId("1");
        return uocProcessRunReqBO;
    }

    private void runProcess(UocProcessRunReqBO process, Long saleOrderId, Long orderId) {
        process.setObjId(saleOrderId);
        process.setOrderId(orderId);
        this.uocRunProcessAtomService.start(process);
    }

    private Long bigDecimal2Long(BigDecimal bigDecimal) {
        try {
            return UocMoneyUtil.bigDecimal2Long((BigDecimal)bigDecimal);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u9a8c\u6536\u5355\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

