/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.ability.bo.BgyArrRegisterInspectionIReqBO;
import com.tydic.uoc.common.ability.bo.BgyArrRegisterInspectionItemReqBO;
import com.tydic.uoc.common.ability.bo.BgyOrderAcceptAbilityReqBO;
import com.tydic.uoc.common.ability.bo.BgyOrderAcceptAbilityRspBO;
import com.tydic.uoc.common.atom.api.UocCoreInspectionAtomService;
import com.tydic.uoc.common.busi.api.BgyOrderAcceptBusiService;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BgyOrderAcceptBusiServiceImpl
implements BgyOrderAcceptBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyOrderAcceptBusiServiceImpl.class);
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocCoreInspectionAtomService uocCoreInspectionAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper orderSaleMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;

    @Override
    public BgyOrderAcceptAbilityRspBO dealPebOrderAccept(BgyOrderAcceptAbilityReqBO reqBO) {
        this.createInspectionCode(reqBO);
        BgyOrderAcceptAbilityRspBO rspBO = new BgyOrderAcceptAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9a8c\u6536\u6210\u529f");
        return rspBO;
    }

    private void createInspectionCode(BgyOrderAcceptAbilityReqBO reqBO) {
        OrderPO orderPO = new OrderPO();
        orderPO.setNcOrderCode(reqBO.getNcOrderCode());
        orderPO = this.orderMapper.getModelBy(orderPO);
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderPO.getOrderId());
        ordSalePO = this.orderSaleMapper.getModelBy(ordSalePO);
        for (BgyArrRegisterInspectionIReqBO insInfo : reqBO.getArrInspectionList()) {
            ordInspectionPO.setInspectionVoucherCode(insInfo.getInspectionVoucherCode());
            ordInspectionPO.setInspectionVoucherId(Long.valueOf(this.sequence.nextId()));
            ordInspectionPO.setCreateTime(new Date());
            ordInspectionPO.setOrderId(orderPO.getOrderId());
            ordInspectionPO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
            ordInspectionPO.setInspectionState(insInfo.getInspectionState());
            try {
                this.ordInspectionMapper.insert(ordInspectionPO);
            }
            catch (Exception e) {
                log.error("\u63d2\u5165\u9a8c\u6536\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new UocProBusinessException("101034", "\u63d2\u5165\u9a8c\u6536\u5355\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
            ArrayList<OrdInspectionItemPO> ordInspectionItemPOList = new ArrayList<OrdInspectionItemPO>();
            for (BgyArrRegisterInspectionItemReqBO inspectionItemReqBO : insInfo.getBgyArrRegisterInspectionItemReqBOList()) {
                OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
                OrdItemPO ordItemPO = new OrdItemPO();
                ordInspectionItemPO.setInspectionVoucherId(ordInspectionPO.getInspectionVoucherId());
                ordInspectionItemPO.setInspectionItemId(Long.valueOf(this.sequence.nextId()));
                ordInspectionItemPO.setInspectionCount(inspectionItemReqBO.getArriveCount());
                ordInspectionItemPO.setOrderId(orderPO.getOrderId());
                ordInspectionItemPO.setOrdItemId(inspectionItemReqBO.getInspectionItemId());
                ordInspectionItemPOList.add(ordInspectionItemPO);
                ordItemPO.setOrdItemId(inspectionItemReqBO.getInspectionItemId());
                ordItemPO.setArriveCount(inspectionItemReqBO.getArriveCount());
                ordItemPO.setOrderId(orderPO.getOrderId());
                try {
                    this.ordItemMapper.updateArriveCountByItem(ordItemPO);
                }
                catch (Exception e) {
                    log.error("\u63d2\u5165\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                    throw new UocProBusinessException("101034", "\u63d2\u5165\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
                }
            }
            try {
                this.ordInspectionItemMapper.insertBatch(ordInspectionItemPOList);
            }
            catch (Exception e) {
                log.error("\u63d2\u5165\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
                throw new UocProBusinessException("101034", "\u63d2\u5165\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
    }
}

