/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.general.ability.api.UmcDeptBossQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDeptBossQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDeptBossQryAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveFirstAtomService;
import com.tydic.uoc.common.atom.api.BgyRequestOrderStatusUpdateApproveAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocSendMessageAtomService;
import com.tydic.uoc.common.atom.bo.BgyKtApproveInfo;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstReqBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.busi.api.BgyRequestOrderStatusExecuteBusiService;
import com.tydic.uoc.common.busi.bo.BgyRequestOrderStatusExecuteBusiReqBo;
import com.tydic.uoc.common.busi.bo.BgyRequestOrderStatusExecuteBusiRspBo;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyRequestOrderStatusExecuteBusiServiceImpl
implements BgyRequestOrderStatusExecuteBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyRequestOrderStatusExecuteBusiServiceImpl.class);
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private BgyRequestOrderStatusUpdateApproveAtomService bgyRequestOrderStatusUpdateApproveAtomService;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private BgyRequestOrderApproveFirstAtomService bgyRequestOrderApproveFirstAtomService;
    @Autowired
    private UocOrdRequestAddressMapper ordRequestAddressMapper;
    @Value(value="${k2_fix_request_man:test000}")
    private String KtfixRequestManBip;
    @Autowired
    private UocSendMessageAtomService uocSendMessageAtomService;
    @Autowired
    private UmcDeptBossQryAbilityService umcDeptBossQryAbilityService;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC:UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG:UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Value(value="${umcOrgTypeSwitch:true}")
    private boolean umcOrgTypeSwitch;
    @Value(value="#{'${k2_stockOrg_list}'.split(',')}")
    private List<String> stockOrgList;

    @Override
    public BgyRequestOrderStatusExecuteBusiRspBo executeStatus(BgyRequestOrderStatusExecuteBusiReqBo reqBo) {
        this.validateArg(reqBo);
        BgyRequestOrderStatusExecuteBusiRspBo rspBo = (BgyRequestOrderStatusExecuteBusiRspBo)UocProRspBoUtil.success(BgyRequestOrderStatusExecuteBusiRspBo.class);
        Long requestId = reqBo.getRequestId();
        OrdSalePO qrySaleOrderPo = new OrdSalePO();
        qrySaleOrderPo.setRequestId(requestId);
        List saleOrdRspList = this.ordSaleMapper.getList(qrySaleOrderPo);
        boolean canUpdateState = false;
        boolean haveSupmarketPreFailed = true;
        for (OrdSalePO ordSalePO : saleOrdRspList) {
            String orderSource = ordSalePO.getOrderSource();
            if ("2".equals(orderSource)) {
                canUpdateState = UocConstant.SALE_ORDER_STATUS.PRE_ORDER_FAILED.equals(ordSalePO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(ordSalePO.getSaleState());
                if (!UocConstant.SALE_ORDER_STATUS.PRE_ORDER_FAILED.equals(ordSalePO.getSaleState())) continue;
                haveSupmarketPreFailed = false;
                continue;
            }
            if (!"1".equals(orderSource)) continue;
            if (UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(ordSalePO.getSaleState())) {
                canUpdateState = true;
                continue;
            }
            canUpdateState = false;
        }
        if (!canUpdateState) {
            log.info("\u8bf7\u8d2d\u5355[{}]\u4e0b\u8ba2\u5355\u8fd8\u672a\u5904\u7406\u5b8c\u6210", (Object)requestId);
            return rspBo;
        }
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        if (UocConstant.REQUEST_ORDER_STATUS.CREATED.equals(uocOrdRequestPo.getRequestStatus())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(requestId);
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
            processRunReqBO.setOrderId(requestId);
            processRunReqBO.setOperId("1");
            UocProcessRunRspBO processRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(processRunRspBO.getRespCode())) {
                throw new UocProBusinessException("102112", "\u66f4\u65b0\u8bf7\u8d2d\u5355\u72b6\u6001\u9519\u8bef\uff1a" + processRunRspBO.getRespDesc());
            }
            UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
            sendMessageBo.setSendId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
            sendMessageBo.setRecId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
            sendMessageBo.setNoticeNodeCode("20001");
            sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u8bf7\u8d2d\u5355\u7f16\u53f7#}", uocOrdRequestPo.getRequestCode()));
            this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
        }
        if (haveSupmarketPreFailed) {
            BgyRequestOrderApproveFirstReqBO approveFirstReqBO = new BgyRequestOrderApproveFirstReqBO();
            approveFirstReqBO.setEsbInfo(new EsbInfoBO());
            UocOrdRequestPo ordRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
            approveFirstReqBO.setRequestId(requestId);
            BgyKtApproveInfo approveInfo = new BgyKtApproveInfo();
            approveInfo.setApplyUserCode(ordRequestPo.getRequestManWorkNo());
            approveInfo.setStartUserCode(ordRequestPo.getRequestManWorkNo());
            JSONObject jsonObject = new JSONObject();
            UocOrdRequestAddressPo ordRequestAddressPo = new UocOrdRequestAddressPo();
            ordRequestAddressPo.setRequestId(requestId);
            ordRequestAddressPo = this.ordRequestAddressMapper.selectByPrimaryPo(ordRequestAddressPo);
            if (UocConstant.CostType.ASSET.equals(ordRequestPo.getCostType()) && !this.stockOrgList.contains(ordRequestPo.getStockOrgId())) {
                jsonObject.put("purchase_type", (Object)"1");
            } else if (!UocConstant.CostType.ASSET.equals(ordRequestPo.getCostType()) && !this.stockOrgList.contains(ordRequestPo.getStockOrgId())) {
                jsonObject.put("purchase_type", (Object)"2");
            } else if (this.stockOrgList.contains(ordRequestPo.getStockOrgId())) {
                jsonObject.put("purchase_type", (Object)"3");
            }
            approveInfo.setDataFields(jsonObject.toString());
            UmcDeptBossQryAbilityReqBO umcReqBO = new UmcDeptBossQryAbilityReqBO();
            umcReqBO.setRegAccount(ordRequestAddressPo.getContactBip());
            UmcDeptBossQryAbilityRspBO umcRspBo = this.umcDeptBossQryAbilityService.qryDeptBoss(umcReqBO);
            if (!"0000".equals(umcRspBo.getRespCode())) {
                throw new UocProBusinessException("102114", "\u4f1a\u5458\u8fd4\u56de\u9884\u7b97\u90e8\u95e8\u8d1f\u8d23\u4eba\u9519\u8bef\uff1a" + umcRspBo.getRespDesc());
            }
            if (ObjectUtil.isEmpty((Object)umcRspBo.getWorkNo())) {
                throw new UocProBusinessException("102114", "\u4f1a\u5458\u8fd4\u56de\u9884\u7b97\u90e8\u95e8\u8d1f\u8d23\u4eba\u5de5\u53f7\u4e3a\u7a7a");
            }
            JSONObject budgetDeptObject = new JSONObject();
            JSONObject approversObject = new JSONObject();
            approversObject.put("actApprover1", (Object)umcRspBo.getWorkNo());
            budgetDeptObject.put("Approvers", (Object)approversObject.toString());
            approveInfo.setFlowRoleInfo(budgetDeptObject.toString());
            approveFirstReqBO.setRequestInfo(approveInfo);
            BgyRequestOrderApproveFirstRspBO approveFirstRspBO = this.bgyRequestOrderApproveFirstAtomService.progress(approveFirstReqBO);
            if (!"A0001".equalsIgnoreCase(approveFirstRspBO.getReturnCode())) {
                throw new UocProBusinessException("102114", "\u53d1\u8d77k2\u7b2c\u4e00\u6b65\u5ba1\u6279\u9519\u8bef" + approveFirstRspBO.getReturnMsg());
            }
        }
        return rspBo;
    }

    private void validateArg(BgyRequestOrderStatusExecuteBusiReqBo reqBo) {
        if (reqBo.getRequestId() == null) {
            throw new UocProBusinessException("102112", "\u8bf7\u8d2d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

