/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.BgyOrdItemDataRspBo;
import com.tydic.uoc.common.ability.bo.BgyOrdRequestAddressRspBo;
import com.tydic.uoc.common.ability.bo.BgyOrdRequestCommodityTypeRspBo;
import com.tydic.uoc.common.ability.bo.BgyOrdRequestOrderRspBo;
import com.tydic.uoc.common.ability.bo.BgyOrdRequestRspBo;
import com.tydic.uoc.common.ability.bo.BgyRequisitionDetailsQueryReqBo;
import com.tydic.uoc.common.ability.bo.BgyRequisitionDetailsQueryRspBo;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdGoodsSaleRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdItemRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.busi.api.BgyRequisitionDetailsQueryBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestCommodityTypeMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdItemDataPo;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestCommodityTypePo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyRequisitionDetailsQueryBusiServiceImpl
implements BgyRequisitionDetailsQueryBusiService {
    @Autowired
    private UocOrdRequestMapper ordRequestMapper;
    @Autowired
    private UocOrdRequestAddressMapper ordRequestAddressMapper;
    @Autowired
    private UocOrdRequestCommodityTypeMapper ordRequestCommodityTypeMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Value(value="${requestStrideStr:\u7533\u8d2d\u5355\u5b58\u5728\u8de8\u7ec4\u7ec7\uff08\u6216\u8de8\u90e8\u95e8\uff09\u5360\u9884\u7b97}")
    private String requestStrideStr;

    @Override
    public BgyRequisitionDetailsQueryRspBo queryRequisitionDetails(BgyRequisitionDetailsQueryReqBo reqBo) {
        BgyRequisitionDetailsQueryRspBo rspBo = new BgyRequisitionDetailsQueryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (ObjectUtil.isNotEmpty((Object)reqBo.getQueryLevelList())) {
            boolean buildCommodityType = false;
            boolean item = false;
            for (Integer queryLevel : reqBo.getQueryLevelList()) {
                if (UocConstant.RequisitionQueryLevel.REQUEST.equals(queryLevel)) {
                    rspBo.setRequestRspBo(this.buildRequestRspBo(reqBo.getRequestId()));
                    if (null != rspBo.getRequestRspBo()) continue;
                    return rspBo;
                }
                if (UocConstant.RequisitionQueryLevel.REQUEST_ADDRESS.equals(queryLevel)) {
                    rspBo.setRequestAddressRspBo(this.buildRequestAddressRspBo(reqBo.getRequestId()));
                    if (null != rspBo.getRequestAddressRspBo()) continue;
                    return rspBo;
                }
                if (UocConstant.RequisitionQueryLevel.REQUEST_COMMODITY_TYPE_LIST.equals(queryLevel)) {
                    buildCommodityType = true;
                    continue;
                }
                if (!UocConstant.RequisitionQueryLevel.ORD_ITEM_LIST.equals(queryLevel)) continue;
                item = true;
            }
            if (buildCommodityType || item) {
                HashMap<Long, List<BgyOrdRequestOrderRspBo>> orderMap;
                Map<Long, List<UocOrdItemRspBO>> ordItemRspBOMap = null;
                List<OrdSalePO> ordSalePOList = this.getOrdSalePOS(reqBo);
                if (ObjectUtil.isEmpty(ordSalePOList)) {
                    return null;
                }
                ArrayList<Long> orderIdList = new ArrayList<Long>(ordSalePOList.size());
                ArrayList<Long> comTypeDataIdList = null;
                if (buildCommodityType) {
                    orderMap = new HashMap(ordSalePOList.size());
                    comTypeDataIdList = new ArrayList<Long>(ordSalePOList.size());
                } else {
                    orderMap = new HashMap<Long, List<BgyOrdRequestOrderRspBo>>(1);
                }
                ArrayList<BgyOrdRequestOrderRspBo> bgyOrdRequestOrderRspBos = new ArrayList<BgyOrdRequestOrderRspBo>(ordSalePOList.size());
                HashMap<Long, OrdSalePO> ordSalePOMap = new HashMap<Long, OrdSalePO>(ordSalePOList.size());
                for (OrdSalePO salePO : ordSalePOList) {
                    orderIdList.add(salePO.getOrderId());
                    ordSalePOMap.put(salePO.getOrderId(), salePO);
                    BgyOrdRequestOrderRspBo ordRequestOrderRspBo = new BgyOrdRequestOrderRspBo();
                    ordRequestOrderRspBo.setOrderId(salePO.getOrderId());
                    ordRequestOrderRspBo.setSaleVoucherId(salePO.getSaleVoucherId());
                    ordRequestOrderRspBo.setOrderSource(salePO.getOrderSource());
                    ordRequestOrderRspBo.setOrderSourceStr(this.dicTranslation(salePO.getOrderSource(), "SOURCE_CODE"));
                    ordRequestOrderRspBo.setSaleState(salePO.getSaleState());
                    ordRequestOrderRspBo.setSaleStateStr(this.dicTranslation(String.valueOf(salePO.getSaleState()), "SALE_ORDER_STATUS"));
                    ordRequestOrderRspBo.setSaleMoney(UocMoneyUtil.long2BigDecimal((Long)salePO.getSaleFee()));
                    ordRequestOrderRspBo.setSaleVoucherNo(salePO.getSaleVoucherNo());
                    if (buildCommodityType) {
                        if (null != salePO.getComTypeDataId() && 0L != salePO.getComTypeDataId()) {
                            ArrayList<BgyOrdRequestOrderRspBo> requestOrderRspBos;
                            if (orderMap.containsKey(salePO.getComTypeDataId())) {
                                requestOrderRspBos = (ArrayList<BgyOrdRequestOrderRspBo>)orderMap.get(salePO.getComTypeDataId());
                            } else {
                                comTypeDataIdList.add(salePO.getComTypeDataId());
                                requestOrderRspBos = new ArrayList<BgyOrdRequestOrderRspBo>();
                            }
                            requestOrderRspBos.add(ordRequestOrderRspBo);
                            orderMap.put(salePO.getComTypeDataId(), requestOrderRspBos);
                            continue;
                        }
                        bgyOrdRequestOrderRspBos.add(ordRequestOrderRspBo);
                        continue;
                    }
                    bgyOrdRequestOrderRspBos.add(ordRequestOrderRspBo);
                }
                if (!buildCommodityType) {
                    orderMap.put(null, bgyOrdRequestOrderRspBos);
                }
                if (item) {
                    ordItemRspBOMap = this.buildOrdItemRspBoList(reqBo.getRequestId(), buildCommodityType, orderIdList, ordSalePOMap);
                    rspBo.setOrdItemRspBoList(ordItemRspBOMap.get(null));
                }
                if (buildCommodityType) {
                    rspBo.setRequestCommodityTypeRspBoList(this.buildRequestCommodityTypeRspBoList(reqBo.getRequestId(), ordItemRspBOMap, orderMap, comTypeDataIdList, orderIdList));
                }
            }
        } else {
            rspBo.setRequestRspBo(this.buildRequestRspBo(reqBo.getRequestId()));
            if (null == rspBo.getRequestRspBo()) {
                return rspBo;
            }
            rspBo.setRequestAddressRspBo(this.buildRequestAddressRspBo(reqBo.getRequestId()));
            List<OrdSalePO> ordSalePOList = this.getOrdSalePOS(reqBo);
            if (ObjectUtil.isEmpty(ordSalePOList)) {
                return rspBo;
            }
            ArrayList<Long> orderIdList = new ArrayList<Long>(ordSalePOList.size());
            HashMap<Long, List<BgyOrdRequestOrderRspBo>> orderMap = new HashMap<Long, List<BgyOrdRequestOrderRspBo>>(ordSalePOList.size());
            ArrayList<Long> comTypeDataIdList = new ArrayList<Long>(ordSalePOList.size());
            ArrayList<BgyOrdRequestOrderRspBo> bgyOrdRequestOrderRspBos = new ArrayList<BgyOrdRequestOrderRspBo>(ordSalePOList.size());
            HashMap<Long, OrdSalePO> ordSalePOMap = new HashMap<Long, OrdSalePO>(ordSalePOList.size());
            for (OrdSalePO salePO : ordSalePOList) {
                orderIdList.add(salePO.getOrderId());
                ordSalePOMap.put(salePO.getOrderId(), salePO);
                BgyOrdRequestOrderRspBo ordRequestOrderRspBo = new BgyOrdRequestOrderRspBo();
                ordRequestOrderRspBo.setOrderId(salePO.getOrderId());
                ordRequestOrderRspBo.setSaleVoucherId(salePO.getSaleVoucherId());
                ordRequestOrderRspBo.setOrderSource(salePO.getOrderSource());
                ordRequestOrderRspBo.setOrderSourceStr(this.dicTranslation(salePO.getOrderSource(), "SOURCE_CODE"));
                ordRequestOrderRspBo.setSaleState(salePO.getSaleState());
                ordRequestOrderRspBo.setSaleStateStr(this.dicTranslation(String.valueOf(salePO.getSaleState()), "SALE_ORDER_STATUS"));
                ordRequestOrderRspBo.setSaleMoney(UocMoneyUtil.long2BigDecimal((Long)salePO.getSaleFee()));
                ordRequestOrderRspBo.setSaleVoucherNo(salePO.getSaleVoucherNo());
                if (null != salePO.getComTypeDataId() && 0L != salePO.getComTypeDataId()) {
                    ArrayList<BgyOrdRequestOrderRspBo> requestOrderRspBos;
                    if (orderMap.containsKey(salePO.getComTypeDataId())) {
                        requestOrderRspBos = (ArrayList<BgyOrdRequestOrderRspBo>)orderMap.get(salePO.getComTypeDataId());
                    } else {
                        comTypeDataIdList.add(salePO.getComTypeDataId());
                        requestOrderRspBos = new ArrayList<BgyOrdRequestOrderRspBo>();
                    }
                    requestOrderRspBos.add(ordRequestOrderRspBo);
                    orderMap.put(salePO.getComTypeDataId(), requestOrderRspBos);
                    continue;
                }
                bgyOrdRequestOrderRspBos.add(ordRequestOrderRspBo);
            }
            if (orderMap.size() == 0) {
                orderMap.put(null, bgyOrdRequestOrderRspBos);
            }
            Map<Long, List<UocOrdItemRspBO>> ordItemRspBOMap = this.buildOrdItemRspBoList(reqBo.getRequestId(), true, orderIdList, ordSalePOMap);
            rspBo.setOrdItemRspBoList(ordItemRspBOMap.get(null));
            rspBo.setRequestCommodityTypeRspBoList(this.buildRequestCommodityTypeRspBoList(reqBo.getRequestId(), ordItemRspBOMap, orderMap, comTypeDataIdList, orderIdList));
        }
        return rspBo;
    }

    private List<OrdSalePO> getOrdSalePOS(BgyRequisitionDetailsQueryReqBo reqBo) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setRequestId(reqBo.getRequestId());
        ordSalePO.setOrderBy("SORT_NO");
        return this.ordSaleMapper.getList(ordSalePO);
    }

    private BgyOrdRequestRspBo buildRequestRspBo(Long requestId) {
        UocOrdRequestPo ordRequestPo = this.ordRequestMapper.selectByPrimaryKey(requestId);
        if (null == ordRequestPo) {
            return null;
        }
        BgyOrdRequestRspBo requestRspBo = new BgyOrdRequestRspBo();
        BeanUtils.copyProperties((Object)ordRequestPo, (Object)requestRspBo);
        requestRspBo.setPredictMoney(UocMoneyUtil.long2BigDecimal((Long)ordRequestPo.getPredictFee()));
        requestRspBo.setCommodityTotalMoney(UocMoneyUtil.long2BigDecimal((Long)ordRequestPo.getCommodityTotalFee()));
        requestRspBo.setFreightTotalMoney(UocMoneyUtil.long2BigDecimal((Long)ordRequestPo.getFreightTotalFee()));
        requestRspBo.setRequestTotalMoney(UocMoneyUtil.long2BigDecimal((Long)ordRequestPo.getRequestTotalFee()));
        requestRspBo.setRequestStatusStr(this.dicTranslation(String.valueOf(ordRequestPo.getRequestStatus()), "REQUEST_STATUS"));
        requestRspBo.setK2FlowNo(ordRequestPo.getKtId());
        String requestDept = ordRequestPo.getRequestDept();
        String hsDeptCode = ordRequestPo.getHsDeptCode();
        if (ObjectUtil.isNotEmpty((Object)requestDept) && ObjectUtil.isNotEmpty((Object)hsDeptCode) && !(requestDept = requestDept.substring(0, 5)).equals(hsDeptCode)) {
            requestRspBo.setRequestStrideOrdDesc(this.requestStrideStr);
        }
        if (UocConstant.RequestType.CATALOG_OUT.equals(ordRequestPo.getRequestType())) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setOrderId(requestRspBo.getRequestId());
            List accessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
            if (CollectionUtil.isNotEmpty((Collection)accessoryPOList)) {
                requestRspBo.setAccessoryPOList(new ArrayList());
                for (OrdAccessoryPO accessoryPO : accessoryPOList) {
                    OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
                    BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                    requestRspBo.getAccessoryPOList().add(ordAccessoryRspBO);
                }
            }
        }
        return requestRspBo;
    }

    private BgyOrdRequestAddressRspBo buildRequestAddressRspBo(Long requestId) {
        UocOrdRequestAddressPo requestAddressPo = new UocOrdRequestAddressPo();
        requestAddressPo.setRequestId(requestId);
        requestAddressPo = this.ordRequestAddressMapper.selectByPrimaryPo(requestAddressPo);
        if (null == requestAddressPo) {
            return null;
        }
        BgyOrdRequestAddressRspBo requestAddressRspBo = new BgyOrdRequestAddressRspBo();
        BeanUtils.copyProperties((Object)requestAddressPo, (Object)requestAddressRspBo);
        return requestAddressRspBo;
    }

    private List<BgyOrdRequestCommodityTypeRspBo> buildRequestCommodityTypeRspBoList(Long requestId, Map<Long, List<UocOrdItemRspBO>> ordItemRspBOMap, Map<Long, List<BgyOrdRequestOrderRspBo>> orderMap, List<Long> comTypeDataIdList, List<Long> orderIdList) {
        ArrayList<BgyOrdRequestCommodityTypeRspBo> requestCommodityTypeRspBoList;
        UocOrdRequestCommodityTypePo requestCommodityTypePo = new UocOrdRequestCommodityTypePo();
        requestCommodityTypePo.setRequestId(requestId);
        List requestCommodityTypePoList = this.ordRequestCommodityTypeMapper.selectByPrimaryPoList(requestCommodityTypePo);
        Map<Long, UocOrdRequestCommodityTypePo> requestCommodityTypePoMap = null;
        if (ObjectUtil.isNotEmpty((Object)requestCommodityTypePoList)) {
            requestCommodityTypePoMap = requestCommodityTypePoList.stream().collect(Collectors.toMap(UocOrdRequestCommodityTypePo::getComTypeDataId, commodityTypePo -> commodityTypePo));
            requestCommodityTypeRspBoList = new ArrayList(requestCommodityTypePoMap.size());
        } else {
            requestCommodityTypeRspBoList = new ArrayList<BgyOrdRequestCommodityTypeRspBo>(1);
        }
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderIdList(orderIdList);
        List ordStakeholderPOList = this.ordStakeholderMapper.getList(ordStakeholderPO);
        Map<Long, OrdStakeholderPO> ordStakeholderPOMap = ordStakeholderPOList.stream().collect(Collectors.toMap(OrdStakeholderPO::getOrderId, stakeholderPO -> stakeholderPO));
        if (null != requestCommodityTypePoMap) {
            for (Long comTypeDataId : comTypeDataIdList) {
                BgyOrdRequestCommodityTypeRspBo commodityTypeRspBo = new BgyOrdRequestCommodityTypeRspBo();
                UocOrdRequestCommodityTypePo commodityTypePo2 = requestCommodityTypePoMap.get(comTypeDataId);
                if (ObjectUtil.isNotEmpty((Object)commodityTypePo2)) {
                    commodityTypeRspBo.setComTypeDataId(commodityTypePo2.getComTypeDataId());
                    commodityTypeRspBo.setComTypeId(commodityTypePo2.getComTypeId());
                    commodityTypeRspBo.setComTypeName(commodityTypePo2.getComTypeName());
                    commodityTypeRspBo.setRequestId(commodityTypePo2.getRequestId());
                    commodityTypeRspBo.setRequestCode(commodityTypePo2.getRequestCode());
                    commodityTypeRspBo.setRequestUsedId(commodityTypePo2.getRequestUsedId());
                    commodityTypeRspBo.setRequestUsedName(commodityTypePo2.getRequestUsedName());
                    commodityTypeRspBo.setYsResourceId(commodityTypePo2.getYsResourceId());
                    commodityTypeRspBo.setYsResourceName(commodityTypePo2.getYsResourceName());
                    commodityTypeRspBo.setPurchaseTypeId(commodityTypePo2.getPurchaseTypeId());
                    commodityTypeRspBo.setPurchaseTypeName(commodityTypePo2.getPurchaseTypeName());
                    commodityTypeRspBo.setFeeTypeId(commodityTypePo2.getFeeTypeId());
                    commodityTypeRspBo.setFeeTypeName(commodityTypePo2.getFeeTypeName());
                }
                List<BgyOrdRequestOrderRspBo> requestOrderRspBos = orderMap.get(comTypeDataId);
                for (BgyOrdRequestOrderRspBo requestOrderRspBo : requestOrderRspBos) {
                    OrdStakeholderPO stakeholderPO2 = ordStakeholderPOMap.get(requestOrderRspBo.getOrderId());
                    requestOrderRspBo.setSupNo(stakeholderPO2.getSupNo());
                    requestOrderRspBo.setSupName(stakeholderPO2.getSupName());
                    requestOrderRspBo.setOrdItemRspBOList(ordItemRspBOMap.get(requestOrderRspBo.getOrderId()));
                }
                commodityTypeRspBo.setOrderRspBoList(requestOrderRspBos);
                requestCommodityTypeRspBoList.add(commodityTypeRspBo);
            }
        } else {
            BgyOrdRequestCommodityTypeRspBo commodityTypeRspBo = new BgyOrdRequestCommodityTypeRspBo();
            List<BgyOrdRequestOrderRspBo> requestOrderRspBos = orderMap.get(null);
            for (BgyOrdRequestOrderRspBo requestOrderRspBo : requestOrderRspBos) {
                OrdStakeholderPO stakeholderPO3 = ordStakeholderPOMap.get(requestOrderRspBo.getOrderId());
                requestOrderRspBo.setSupNo(stakeholderPO3.getSupNo());
                requestOrderRspBo.setSupName(stakeholderPO3.getSupName());
                requestOrderRspBo.setOrdItemRspBOList(ordItemRspBOMap.get(requestOrderRspBo.getOrderId()));
            }
            commodityTypeRspBo.setOrderRspBoList(requestOrderRspBos);
            requestCommodityTypeRspBoList.add(commodityTypeRspBo);
        }
        return requestCommodityTypeRspBoList;
    }

    private Map<Long, List<UocOrdItemRspBO>> buildOrdItemRspBoList(Long requestId, boolean buildCommodityType, List<Long> orderIdList, Map<Long, OrdSalePO> ordSalePOMap) {
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderIdList(orderIdList);
        List ordItemPOList = this.ordItemMapper.getList(ordItemPO);
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderIdList(orderIdList);
        List ordGoodsPOList = this.ordGoodsMapper.getList(ordGoodsPO);
        Map<Long, OrdGoodsPO> ordGoodsPOMap = ordGoodsPOList.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, uocOrdGoodsPO -> uocOrdGoodsPO));
        UocOrdItemDataPo ordItemDataPo = new UocOrdItemDataPo();
        ordItemDataPo.setRequestId(requestId);
        List ordItemDataPos = this.ordItemDataMapper.selectByPrimaryPoList(ordItemDataPo);
        Map<Long, UocOrdItemDataPo> ordItemDataPoMap = ordItemDataPos.stream().collect(Collectors.toMap(UocOrdItemDataPo::getOrdItemId, uocOrdItemDataPo -> uocOrdItemDataPo));
        HashMap<Long, List<UocOrdItemRspBO>> ordItemRspBOMap = new HashMap<Long, List<UocOrdItemRspBO>>(orderIdList.size());
        ArrayList<UocOrdItemRspBO> ordItemRspBOList = new ArrayList<UocOrdItemRspBO>(ordItemPOList.size());
        for (OrdItemPO itemPO : ordItemPOList) {
            UocOrdItemRspBO ordItemRspBO = new UocOrdItemRspBO();
            OrdGoodsSaleRspBO ordGoodsRspBO = new OrdGoodsSaleRspBO();
            BgyOrdItemDataRspBo ordItemDataRspBo = new BgyOrdItemDataRspBo();
            BeanUtils.copyProperties((Object)itemPO, (Object)ordItemRspBO);
            BeanUtils.copyProperties((Object)ordGoodsPOMap.get(itemPO.getOrdItemId()), (Object)ordGoodsRspBO);
            BeanUtils.copyProperties((Object)ordItemDataPoMap.get(itemPO.getOrdItemId()), (Object)ordItemDataRspBo);
            if (ObjectUtil.isNotEmpty((Object)ordGoodsPOMap.get(itemPO.getOrdItemId()).getSkuCommodityTypeId())) {
                ordItemDataRspBo.setComTypeId(ordGoodsPOMap.get(itemPO.getOrdItemId()).getSkuCommodityTypeId().toString());
            }
            ordItemRspBO.setSalePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getSalePrice()));
            ordItemRspBO.setTotalPurchaseMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getTotalPurchaseFee()));
            ordItemRspBO.setTotalSaleMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getTotalSaleFee()));
            ordItemRspBO.setPurchasePriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getPurchasePrice()));
            ordItemRspBO.setNakedPriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getNakedPrice()));
            ordItemRspBO.setTaxPriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getTaxPrice()));
            ordItemRspBO.setDisPriceMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getDisPrice()));
            ordItemRspBO.setRedEnvelopeMoney(UocMoneyUtil.long2BigDecimal((Long)ordItemRspBO.getRedEnvelopeFee()));
            ordItemRspBO.setOrdGoodsRspBO(ordGoodsRspBO);
            ordItemRspBO.setOrdItemDataRspBo(ordItemDataRspBo);
            ordItemRspBO.setFeeTypeId(ordItemDataPoMap.get(itemPO.getOrdItemId()).getFeeTypeId());
            ordItemRspBO.setFeeTypeName(ordItemDataPoMap.get(itemPO.getOrdItemId()).getFeeTypeName());
            ordItemRspBO.setOrderSource(ordSalePOMap.get(itemPO.getOrderId()).getOrderSource());
            ordItemRspBO.setOrderSourceStr(this.dicTranslation(ordItemRspBO.getOrderSource(), "SOURCE_CODE"));
            ordItemRspBO.setSaleState(ordSalePOMap.get(itemPO.getOrderId()).getSaleState());
            ordItemRspBO.setSaleStateStr(this.dicTranslation(String.valueOf(ordSalePOMap.get(itemPO.getOrderId()).getSaleState()), "SALE_ORDER_STATUS"));
            ordItemRspBO.setSupName(ordGoodsPOMap.get(itemPO.getOrdItemId()).getSkuSupplierName());
            ordItemRspBO.setSaleMoney(UocMoneyUtil.long2BigDecimal((Long)ordSalePOMap.get(itemPO.getOrderId()).getSaleFee()));
            ordItemRspBO.setSaleVoucherNo(ordSalePOMap.get(itemPO.getOrderId()).getSaleVoucherNo());
            if (ObjectUtil.isNotEmpty((Object)ordSalePOMap.get(itemPO.getOrderId()).getIsCancel())) {
                ordItemRspBO.setIsCancel(ordSalePOMap.get(itemPO.getOrderId()).getIsCancel().toString());
            }
            ordItemRspBOList.add(ordItemRspBO);
            if (!buildCommodityType) continue;
            ArrayList<UocOrdItemRspBO> itemRspBOList = (ArrayList<UocOrdItemRspBO>)ordItemRspBOMap.get(itemPO.getOrderId());
            if (null == itemRspBOList) {
                itemRspBOList = new ArrayList<UocOrdItemRspBO>();
            }
            itemRspBOList.add(ordItemRspBO);
            ordItemRspBOMap.put(itemPO.getOrderId(), itemRspBOList);
        }
        ordItemRspBOMap.put(null, ordItemRspBOList);
        return ordItemRspBOMap;
    }

    private String dicTranslation(String code, String pCode) {
        return BgyRequisitionDetailsQueryBusiServiceImpl.getString(code, pCode, this.selectDicValByPcodeAndCode);
    }

    static String getString(String code, String pCode, SelectDicValByPcodeAndCode selectDicValByPcodeAndCode) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(code);
        dictReqBO.setPcode(pCode);
        SelectSingleDictRspBO dictRspBO = selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            return dictRspBO.getDicDictionarys().getDescrip();
        }
        return null;
    }
}

