/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.atom.api.BgyQrySapParamAtomService;
import com.tydic.uoc.common.atom.api.BgySAPBudgetOccupyAtomService;
import com.tydic.uoc.common.atom.bo.BgyQrySapParamAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyQrySapParamAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyReqBO;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyRsp;
import com.tydic.uoc.common.atom.bo.SapRequestParamBO;
import com.tydic.uoc.common.atom.bo.SapRequestParamBody;
import com.tydic.uoc.common.atom.bo.SapRequestParamHeader;
import com.tydic.uoc.common.atom.bo.UocOrdItemDataBO;
import com.tydic.uoc.common.atom.bo.UocOrdRequestBO;
import com.tydic.uoc.common.atom.bo.UocOrderItemBO;
import com.tydic.uoc.common.busi.api.BgyUpdateOrderBusiService;
import com.tydic.uoc.common.busi.bo.BgyUpdateOrderBusiRspBo;
import com.tydic.uoc.common.busi.bo.BgyUpdateOrderBusiServiceReqBo;
import com.tydic.uoc.common.comb.bo.BgyCatalogInUpdateRequestOrderCombOrderInfoReqBo;
import com.tydic.uoc.common.comb.bo.BgyCatalogInUpdateRequestOrderOrderCombReqBo;
import com.tydic.uoc.common.comb.bo.BgyCatalogInUpdateRequestOrderOrderItemCombReqBo;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestCommodityTypeMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.UocOrdItemDataPo;
import com.tydic.uoc.po.UocOrdRequestCommodityTypePo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyUpdateOrderBusiServiceImpl
implements BgyUpdateOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyUpdateOrderBusiServiceImpl.class);
    @Autowired
    private UocOrdRequestMapper ordRequestMapper;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private UocOrdRequestCommodityTypeMapper uocOrdRequestCommodityTypeMapper;
    @Autowired
    private BgyQrySapParamAtomService bgyQrySapParamAtomService;
    @Autowired
    private BgySAPBudgetOccupyAtomService bgySAPBudgetOccupyAtomService;
    @Value(value="${isSapBuggget:false}")
    private boolean isSapBuggget;
    @Value(value="${sap_lyxt}")
    private String lyxt;
    private static final String RELEASE = "4";
    private static final String OCCUPY = "1";

    @Override
    public BgyUpdateOrderBusiRspBo updateOrder(BgyUpdateOrderBusiServiceReqBo reqBo) {
        Object uocOrdRequestBO;
        BgyUpdateOrderBusiRspBo rspBo = (BgyUpdateOrderBusiRspBo)UocProRspBoUtil.success(BgyUpdateOrderBusiRspBo.class);
        BgyQrySapParamAtomReqBO bgyQrySapParamAtomReqBO = new BgyQrySapParamAtomReqBO();
        bgyQrySapParamAtomReqBO.setRequestId(reqBo.getRequestId());
        BgyQrySapParamAtomRspBO bgyQrySapParamAtomRspBO = this.bgyQrySapParamAtomService.dealQrySapParam(bgyQrySapParamAtomReqBO);
        List<UocOrdItemDataBO> orderItemDataList = bgyQrySapParamAtomRspBO.getOrderItemDataList();
        Map<Object, Object> ordItemDataBOMap = new HashMap();
        if (!CollectionUtils.isEmpty(orderItemDataList)) {
            ordItemDataBOMap = orderItemDataList.stream().collect(Collectors.toMap(UocOrdItemDataBO::getOrdItemId, o -> o));
        }
        boolean isNeedSapRelease = false;
        ArrayList<UocOrdItemDataPo> ordItemDataPoList = new ArrayList<UocOrdItemDataPo>();
        for (BgyCatalogInUpdateRequestOrderCombOrderInfoReqBo requestOrder : reqBo.getReqBoList()) {
            UocOrdRequestCommodityTypePo saveCommodityTypePo = new UocOrdRequestCommodityTypePo();
            BeanUtils.copyProperties((Object)requestOrder, (Object)saveCommodityTypePo);
            try {
                if (ObjectUtil.isNotEmpty((Object)saveCommodityTypePo.getComTypeDataId())) {
                    this.uocOrdRequestCommodityTypeMapper.updateByPrimaryKeySelective(saveCommodityTypePo);
                }
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u8be6\u60c5\u6570\u636e\u8868\u5f02\u5e38", (Throwable)e);
                throw new UocProBusinessException("8888", "\u66f4\u65b0\u5546\u54c1\u7c7b\u578b\u6570\u636e\u8868\u5f02\u5e38" + e.getMessage());
            }
            if (!ObjectUtil.isNotEmpty(requestOrder.getOrdInfoList())) continue;
            for (BgyCatalogInUpdateRequestOrderOrderCombReqBo orderInfo : requestOrder.getOrdInfoList()) {
                for (BgyCatalogInUpdateRequestOrderOrderItemCombReqBo orItem : orderInfo.getOrdItemList()) {
                    UocOrdItemDataPo ordItemDataPo = new UocOrdItemDataPo();
                    ordItemDataPo.setOrdItemId(orItem.getOrdItemId());
                    ordItemDataPo = this.ordItemDataMapper.selectByPrimaryPo(ordItemDataPo);
                    BeanUtils.copyProperties((Object)orItem, (Object)ordItemDataPo);
                    if (null != ordItemDataBOMap.get(ordItemDataPo.getOrdItemId())) {
                        if (ObjectUtil.isNotEmpty((Object)ordItemDataPo.getYsResourceId()) && !ordItemDataPo.getYsResourceId().equals(((UocOrdItemDataBO)ordItemDataBOMap.get(ordItemDataPo.getOrdItemId())).getYsResourceId())) {
                            isNeedSapRelease = true;
                        }
                    } else {
                        isNeedSapRelease = true;
                    }
                    ordItemDataPoList.add(ordItemDataPo);
                }
            }
        }
        if (this.isSapBuggget && isNeedSapRelease && !UocConstant.CostType.COST.equals(((UocOrdRequestBO)(uocOrdRequestBO = bgyQrySapParamAtomRspBO.getUocOrdRequestBO())).getCostType())) {
            this.validateYs(bgyQrySapParamAtomRspBO, RELEASE, ordItemDataPoList, reqBo.getRequestId());
            this.validateYs(bgyQrySapParamAtomRspBO, OCCUPY, ordItemDataPoList, reqBo.getRequestId());
        }
        try {
            if (ObjectUtil.isNotEmpty(ordItemDataPoList)) {
                for (UocOrdItemDataPo item : ordItemDataPoList) {
                    this.ordItemDataMapper.updateByPrimaryKeySelective(item);
                }
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u8be6\u60c5\u6570\u636e\u8868\u5f02\u5e38", (Throwable)e);
            throw new UocProBusinessException("8888", "\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u8be6\u60c5\u6570\u636e\u8868\u5f02\u5e38");
        }
        return rspBo;
    }

    private void validateYs(BgyQrySapParamAtomRspBO combReqBo, String type, List<UocOrdItemDataPo> ordItemDataPoList, Long requestId) {
        if (log.isDebugEnabled()) {
            log.debug("=====\u91ca\u653e\u9884\u7b97=====");
        }
        BgySAPBudgetOccupyRsp budgetOccupyRsp = this.bgySAPBudgetOccupyAtomService.bgySAPBudgetOccupy(this.buildSapParam(combReqBo, type, ordItemDataPoList, requestId));
        if (log.isDebugEnabled()) {
            log.debug("=====\u91ca\u653e\u9884\u7b97\uff1a{}=====", (Object)JSON.toJSONString((Object)budgetOccupyRsp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"S".equalsIgnoreCase(budgetOccupyRsp.getReturnStatus())) {
            throw new UocProBusinessException("106000", "sap\u9884\u7b97\u91ca\u653e\u5931\u8d25\uff1a" + budgetOccupyRsp.getReturnMsg());
        }
    }

    private BgySAPBudgetOccupyReqBO buildSapParam(BgyQrySapParamAtomRspBO reqBo, String type, List<UocOrdItemDataPo> ordItemDataPoList, Long requestId) {
        BgySAPBudgetOccupyReqBO sapReqBO = new BgySAPBudgetOccupyReqBO();
        sapReqBO.setRequestId(requestId);
        Map<Long, UocOrdItemDataBO> ordItemDataBOMap = reqBo.getOrderItemDataList().stream().collect(Collectors.toMap(UocOrdItemDataBO::getOrdItemId, o -> o));
        Map<Object, Object> ordItemDataPOMap = new HashMap();
        if (!CollectionUtils.isEmpty(ordItemDataPoList)) {
            ordItemDataPOMap = ordItemDataPoList.stream().collect(Collectors.toMap(UocOrdItemDataPo::getOrdItemId, o -> o));
        }
        ArrayList<SapRequestParamBody> item = new ArrayList<SapRequestParamBody>();
        for (UocOrderItemBO orderItem : reqBo.getOrderItemList()) {
            SapRequestParamBody paramBody = new SapRequestParamBody();
            paramBody.setDOCLN(Convert.toStr((Object)orderItem.getSapSkuLineNum()));
            paramBody.setDJVAL(this.long2BigDecimal(orderItem.getTotalSaleFee()).multiply(orderItem.getPurchaseCount()).toString());
            if (ObjectUtil.isNotEmpty((Object)orderItem.getNakedPrice())) {
                paramBody.setZBHSJ(this.long2BigDecimal(orderItem.getNakedPrice()).multiply(orderItem.getPurchaseCount()).toString());
            }
            if (RELEASE.equals(type)) {
                paramBody.setLDR_BUD(ordItemDataBOMap.get(orderItem.getOrdItemId()).getYsResourceId());
            } else if (null != ordItemDataPOMap.get(orderItem.getOrdItemId())) {
                paramBody.setLDR_BUD(((UocOrdItemDataPo)ordItemDataPOMap.get(orderItem.getOrdItemId())).getYsResourceId());
            }
            paramBody.setDEPART(reqBo.getUocOrdRequestBO().getYsCompanyCode());
            paramBody.setFUNDSCTR(reqBo.getUocOrdRequestBO().getYsDeptId());
            paramBody.setFYLX(ordItemDataBOMap.get(orderItem.getOrdItemId()).getFeeTypeId());
            paramBody.setTCURR("CNY");
            paramBody.setLIFNR(orderItem.getSupNo());
            item.add(paramBody);
        }
        SapRequestParamHeader header = new SapRequestParamHeader();
        header.setBUKRS(reqBo.getUocOrdRequestBO().getStockOrgId().substring(0, reqBo.getUocOrdRequestBO().getStockOrgId().length() - 1));
        header.setLYXT(this.lyxt);
        header.setZDJLX("SG20-CXX-00" + reqBo.getUocOrdRequestBO().getCostType());
        header.setDJBH(String.valueOf(reqBo.getUocOrdRequestBO().getRequestCode()));
        header.setSQRY(reqBo.getUocOrdRequestBO().getRequestManWorkNo());
        header.setBZRY(reqBo.getUocOrdRequestBO().getRequestManWorkNo());
        header.setENTRY_DATE(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setSQRQ(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setDJ_STATE(type);
        header.setPRCTR(reqBo.getUocOrdRequestBO().getProfitId());
        SapRequestParamBO requestInfo = new SapRequestParamBO();
        requestInfo.setHeader(header);
        requestInfo.setItem(item);
        sapReqBO.setRequestInfo(requestInfo);
        sapReqBO.setEsbInfo(new EsbInfoBO());
        sapReqBO.setQueryInfo(new PageInfo());
        return sapReqBO;
    }

    private BigDecimal long2BigDecimal(Long Long2) {
        try {
            return UocMoneyUtil.long2BigDecimal((Long)Long2);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u9a8c\u6536\u5355\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

