/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityRspBo;
import com.tydic.uoc.common.atom.api.UocOtherOrderSourceExecuteAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomDoBusiRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.BgyUpdateReCreateOrderBusiService;
import com.tydic.uoc.common.busi.api.UocProCancelBusiService;
import com.tydic.uoc.common.busi.bo.BgyUpdateReCreateOrderBusiRspBO;
import com.tydic.uoc.common.busi.bo.UocOtherOrderSourceExecuteAtomDoBusiDataRspBo;
import com.tydic.uoc.common.busi.bo.UocProCreateOrderBusiOrderDataRspBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import com.tydic.uoc.config.UocOtherOrderSourceManager;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BgyUpdateReCreateOrderBusiServiceImpl
implements BgyUpdateReCreateOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(BgyUpdateReCreateOrderBusiServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOtherOrderSourceManager uocOtherOrderSourceManager;
    @Autowired
    private UocProCancelBusiService uocProCancelBusiService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    private static final String CANCEL_ORDER_REASON = "\u53d6\u6d88\u8ba2\u5355";

    @Override
    public BgyUpdateReCreateOrderBusiRspBO dealReCreateOrder(UocProCreateOrderCombReqBo reqBo) {
        BgyUpdateReCreateOrderBusiRspBO rspBo = (BgyUpdateReCreateOrderBusiRspBO)UocProRspBoUtil.success(BgyUpdateReCreateOrderBusiRspBO.class);
        BgyCatalogInCancelOrderAbilityReqBo cancelOldOrderReqBo = new BgyCatalogInCancelOrderAbilityReqBo();
        cancelOldOrderReqBo.setCancelReason(CANCEL_ORDER_REASON);
        cancelOldOrderReqBo.setOrderId(reqBo.getOldOrderId());
        cancelOldOrderReqBo.setSaleVoucherId(reqBo.getOldSaleOrderId());
        cancelOldOrderReqBo.setChangeOrder(Boolean.valueOf(true));
        BgyCatalogInCancelOrderAbilityRspBo busiRspBo = this.uocProCancelBusiService.dealOrderCancelled(cancelOldOrderReqBo);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            throw new UocProBusinessException("8888", busiRspBo.getRespDesc());
        }
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        this.executeCreateOrder(reqBo, rspBo, orderItemList);
        this.updateOldOrder(reqBo, rspBo);
        this.updateNewOrderState(rspBo);
        return rspBo;
    }

    private void updateNewOrderState(BgyUpdateReCreateOrderBusiRspBO rspBo) {
        List newOrderIdList = rspBo.getOrderRspList().stream().map(UocProCreateOrderBusiOrderDataRspBo::getOrderId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newOrderIdList)) {
            this.ordSaleMapper.updateSatusToBeShipByIdList(newOrderIdList);
        }
    }

    private void runProcess(BgyUpdateReCreateOrderBusiRspBO rspBo) {
        rspBo.getOrderRspList().forEach(uocProCreateOrderBusiOrderDataRspBo -> {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(uocProCreateOrderBusiOrderDataRspBo.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setOrderId(uocProCreateOrderBusiOrderDataRspBo.getOrderId());
            processRunReqBO.setOperId("1");
            UocProcessRunRspBO processRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(processRunRspBO.getRespCode())) {
                throw new UocProBusinessException("102117", "\u4fee\u6539\u8ba2\u5355\uff1a" + processRunRspBO.getRespDesc());
            }
        });
    }

    private void updateOldOrder(UocProCreateOrderCombReqBo reqBo, BgyUpdateReCreateOrderBusiRspBO rspBo) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBo.getOldOrderId());
        List newOrderIdList = rspBo.getOrderRspList().stream().map(UocProCreateOrderBusiOrderDataRspBo::getOrderId).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (Long aLong : newOrderIdList) {
            sb.append(aLong).append(",");
        }
        ordSalePO.setNewOrderId(sb.toString());
        this.ordSaleMapper.updateById(ordSalePO);
    }

    private void executeCreateOrder(UocProCreateOrderCombReqBo reqBo, BgyUpdateReCreateOrderBusiRspBO rspBo, List<UocProCreateOrderCombOrderItemReqBo> orderItemList) {
        Map<String, List<UocProCreateOrderCombOrderItemReqBo>> sourceListMap = orderItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getOrderSource));
        for (String orderSource : sourceListMap.keySet()) {
            UocOtherOrderSourceExecuteAtomService createOrderInstance = this.uocOtherOrderSourceManager.getInstance(orderSource);
            reqBo.setOrderItemList(sourceListMap.get(orderSource));
            if ("1".equals(orderSource)) {
                reqBo.setProcKey("cnnc_el_sale_order_master_order_status");
            } else if ("2".equals(orderSource)) {
                reqBo.setProcKey("cnnc_sales_order_master_order_status");
            } else {
                reqBo.setProcKey("cnnc_self_sale_order_master_order_status");
            }
            UocOtherOrderSourceExecuteAtomDoBusiRspBo doBusiRspBo = createOrderInstance.doBusi(reqBo);
            if (!"0000".equals(doBusiRspBo.getRespCode())) {
                throw new UocProBusinessException(doBusiRspBo.getRespCode(), doBusiRspBo.getRespDesc());
            }
            for (UocOtherOrderSourceExecuteAtomDoBusiDataRspBo orderRspBo : doBusiRspBo.getOrderDataList()) {
                UocProCreateOrderBusiOrderDataRspBo busiRspOrderBo = new UocProCreateOrderBusiOrderDataRspBo();
                BeanUtils.copyProperties((Object)orderRspBo, (Object)((Object)busiRspOrderBo));
                busiRspOrderBo.setOrderSource(orderSource);
                rspBo.getOrderRspList().add(busiRspOrderBo);
            }
        }
    }
}

