/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfQryAfterServiceDetailInfoAbilityService;
import com.tydic.uoc.busibase.busi.bo.QryAfterServiceDetailInfoReqBO;
import com.tydic.uoc.busibase.busi.bo.QryAfterServiceDetailInfoRspBO;
import com.tydic.uoc.busibase.busi.bo.jddto.ServiceTrackInfoDTO;
import com.tydic.uoc.common.atom.api.GenerateOrderAfterSaleSeqAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAfterServOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.bo.GenerateOrderAfterSaleSeqRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAfterServOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAfterServOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderAsItemBO;
import com.tydic.uoc.common.atom.bo.UocOrderAsObjBO;
import com.tydic.uoc.common.busi.api.PebDealAfterByOffLineBusiService;
import com.tydic.uoc.common.busi.bo.PebDealAfterByOffLineReqBO;
import com.tydic.uoc.common.busi.bo.PebDealAfterByOffLineRspBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebDealAfterByOffLineBusiServiceImpl
implements PebDealAfterByOffLineBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebDealAfterByOffLineBusiServiceImpl.class);
    private static final String ERROR_MSG = "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u5ba2\u6237\u7533\u8bf7\u7ebf\u4e0b\u552e\u540e\u670d\u52a1\u540e\u552e\u540e\u670d\u52a1\u5355\u56de\u586b\u5931\u8d25\uff1a";
    @Autowired
    private GenerateOrderAfterSaleSeqAtomService generateOrderAfterSaleSeqAtomService;
    @Autowired
    private UocCoreCreateAfterServOrderAtomService uocCoreCreateAfterServOrderAtomService;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaAtomService;
    @Autowired
    private PebIntfQryAfterServiceDetailInfoAbilityService pebIntfQryAfterServiceDetailInfoAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;

    @Override
    public PebDealAfterByOffLineRspBO dealAfterByOffLine(PebDealAfterByOffLineReqBO reqBO) {
        PebDealAfterByOffLineRspBO rspBO = new PebDealAfterByOffLineRspBO();
        if (reqBO.getServiceId() != null) {
            OrdAfterServicePO servicePO = new OrdAfterServicePO();
            servicePO.setAfsServiceId(reqBO.getServiceId());
            servicePO.setOrderId(reqBO.getOrderId());
            int count = this.ordAfterServiceMapper.getCheckBy(servicePO);
            if (count > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8be5\u552e\u540eid\u5df2\u7ecf\u6709\u552e\u540e\u5355");
                return rspBO;
            }
        }
        Long picupPersonContackId = this.createPickupAndConsigneePerson(reqBO.getOrderId());
        Long tackContactId = this.createPickupAndConsigneePerson(reqBO.getOrderId());
        OrdGoodsPO ordGoodsPO = this.qryOrdGoodsPO(reqBO);
        OrdItemPO ordItemPO = this.qryOrdItemPO(ordGoodsPO);
        OrdShipItemPO ordShipItemPO = this.qryShipItem(ordGoodsPO);
        UocCoreCreateAfterServOrderRspBO afterServOrderRspBO = this.createAfterService(reqBO, ordGoodsPO, ordItemPO, ordShipItemPO, picupPersonContackId, tackContactId);
        OrdAfterServicePO servicePO = new OrdAfterServicePO();
        servicePO.setAfsServiceId(reqBO.getServiceId());
        servicePO.setOrderId(reqBO.getOrderId());
        int count = this.ordAfterServiceMapper.getCheckBy(servicePO);
        if (count > 1) {
            throw new UocProBusinessException("102021", "\u6539\u552e\u540e\u5355\u5df2\u7ecf\u751f\u6210");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAfterServId(afterServOrderRspBO.getAfterServId());
        return rspBO;
    }

    private OrdGoodsPO qryOrdGoodsPO(PebDealAfterByOffLineReqBO reqBO) {
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(reqBO.getOrderId());
        ordGoodsPO.setSkuExtSkuId(reqBO.getPackageId());
        List ordGoodsPOS = this.ordGoodsMapper.getList(ordGoodsPO);
        if (CollectionUtils.isEmpty((Collection)ordGoodsPOS)) {
            throw new UocProBusinessException("102021", "\u7ebf\u4e0b\u552e\u540e\u552e\u540e\u5355\u56de\u586b\u5931\u8d25!\u672a\u67e5\u8be2\u5230\u5916\u90e8\u5546\u54c1\u6240\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f");
        }
        return (OrdGoodsPO)ordGoodsPOS.get(0);
    }

    private OrdItemPO qryOrdItemPO(OrdGoodsPO ordGoodsPO) {
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(ordGoodsPO.getOrderId());
        ordItemPO.setOrdItemId(ordGoodsPO.getOrdItemId());
        ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
        if (null == ordItemPO) {
            throw new UocProBusinessException("102021", "\u7ebf\u4e0b\u552e\u540e\u552e\u540e\u5355\u56de\u586b\u5931\u8d25!\u672a\u67e5\u8be2\u5230\u9500\u552e\u660e\u7ec6\u4fe1\u606f");
        }
        return ordItemPO;
    }

    private OrdShipItemPO qryShipItem(OrdGoodsPO ordGoodsPO) {
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(ordGoodsPO.getOrderId());
        ordShipItemPO.setOrdItemId(ordGoodsPO.getOrdItemId());
        ordShipItemPO = this.ordShipItemMapper.getModelBy(ordShipItemPO);
        if (null == ordShipItemPO) {
            throw new UocProBusinessException("102021", "\u7ebf\u4e0b\u552e\u540e\u552e\u540e\u5355\u56de\u586b\u5931\u8d25!\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f");
        }
        return ordShipItemPO;
    }

    private Long createPickupAndConsigneePerson(Long orderId) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        ordLogisticsRelaPO.setOrderId(ordSalePO.getOrderId());
        ordLogisticsRelaPO.setContactId(ordSalePO.getContactId());
        ordLogisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(ordLogisticsRelaPO);
        UocCoreCreateLogisticsRelaReqBO quReqBO = new UocCoreCreateLogisticsRelaReqBO();
        quReqBO.setOrderId(orderId);
        quReqBO.setContactCountryId(ordLogisticsRelaPO.getContactCountryId());
        quReqBO.setContactCountryName(ordLogisticsRelaPO.getContactCountryName());
        quReqBO.setContactProvinceId(ordLogisticsRelaPO.getContactProvinceId());
        quReqBO.setContactProvinceName(ordLogisticsRelaPO.getContactProvinceName());
        quReqBO.setContactCityId(ordLogisticsRelaPO.getContactCityId());
        quReqBO.setContactCityName(ordLogisticsRelaPO.getContactCityName());
        quReqBO.setContactCountyId(ordLogisticsRelaPO.getContactCountyId());
        quReqBO.setContactCountyName(ordLogisticsRelaPO.getContactCountyName());
        quReqBO.setContactTownId(ordLogisticsRelaPO.getContactTownId());
        quReqBO.setContactTown(ordLogisticsRelaPO.getContactTown());
        quReqBO.setContactAddress(ordLogisticsRelaPO.getContactAddress());
        UocCoreCreateLogisticsRelaRspBO quRspBO = this.uocCoreCreateLogisticsRelaAtomService.dealCoreCreateLogisticsRela(quReqBO);
        if (!"0000".equals(quRspBO.getRespCode())) {
            throw new UocProBusinessException("102021", "\u7ebf\u4e0b\u552e\u540e\u5355\u521b\u5efa\u6536\u8d27/\u53d6\u8d27\u7269\u6d41\u8054\u7cfb\u4eba\u521b\u5efa\u5931\u8d25:" + quRspBO.getRespDesc());
        }
        return quRspBO.getContactId();
    }

    private UocCoreCreateAfterServOrderRspBO createAfterService(PebDealAfterByOffLineReqBO byOffLineReqBO, OrdGoodsPO ordGoodsPO, OrdItemPO ordItemPO, OrdShipItemPO ordShipItemPO, Long picupPersonContackId, Long tackContactId) {
        UocCoreCreateAfterServOrderReqBO atomReqBO = this.translateUocCoreCreateAfterServOrderBusiReqBO(byOffLineReqBO, ordGoodsPO, ordItemPO, ordShipItemPO, picupPersonContackId, tackContactId);
        UocCoreCreateAfterServOrderRspBO atomRspBO = this.uocCoreCreateAfterServOrderAtomService.dealCoreCreateAfterServOrder(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            log.debug("\u7535\u5b50\u8d85\u5e02\u5904\u7406\u7ebf\u4e0b\u552e\u540e\u670d\u52a1\u7533\u8bf7\u56de\u586b\u4e1a\u52a1\u670d\u52a1->\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8fd4\u56de\u4fe1\u606f" + (Object)((Object)byOffLineReqBO));
            throw new UocProBusinessException("102021", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u552e\u540e\u670d\u52a1\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8c03\u7528\u5931\u8d25:" + atomRspBO.getRespDesc());
        }
        this.updateAfsStatusAndExtAfsServId(atomRspBO.getAfterServId(), ordItemPO.getOrderId(), byOffLineReqBO.getServiceId());
        OrdShipItemPO shipItemPO = new OrdShipItemPO();
        shipItemPO.setOrderId(ordShipItemPO.getOrderId());
        shipItemPO.setShipItemId(ordShipItemPO.getShipItemId());
        shipItemPO.setReturnCount(BigDecimal.ONE);
        try {
            this.ordShipItemMapper.updateReturnCounts(shipItemPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102021", "\u552e\u540e\u670d\u52a1\u66f4\u65b0\u53d1\u8d27\u660e\u7ec6\u8868\u7684\u9000\u8d27\u6570\u91cf\u5f02\u5e38\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return atomRspBO;
    }

    private void updateAfsStatusAndExtAfsServId(Long afterServId, Long orderId, String serviceId) {
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        ordAfterServicePO.setAfterServId(afterServId);
        ordAfterServicePO.setServState(UocConstant.AFS_ORDER_STATUS.IN_PROCESS);
        ordAfterServicePO.setOrderId(orderId);
        ordAfterServicePO.setAfsServiceId(serviceId);
        try {
            this.ordAfterServiceMapper.updateById(ordAfterServicePO);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u7535\u5b50\u8d85\u5e02\u5ba2\u6237\u7533\u8bf7\u7ebf\u4e0b\u552e\u540e\u670d\u52a1\u540e\u552e\u540e\u670d\u52a1\u5355\u56de\u586b\u5931\u8d25\uff1a\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1->\u552e\u540e\u670d\u52a1\u5355\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff01");
            throw new UocProBusinessException("102021", "\u6267\u884c\u7535\u5b50\u8d85\u5e02\u5ba2\u6237\u7533\u8bf7\u7ebf\u4e0b\u552e\u540e\u670d\u52a1\u540e\u552e\u540e\u670d\u52a1\u5355\u56de\u586b\u5931\u8d25\uff1a\u7535\u5b50\u8d85\u5e02\u552e\u540e\u670d\u52a1\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1->\u552e\u540e\u670d\u52a1\u5355\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff01");
        }
    }

    private UocCoreCreateAfterServOrderReqBO translateUocCoreCreateAfterServOrderBusiReqBO(PebDealAfterByOffLineReqBO byOffLineReqBO, OrdGoodsPO ordGoodsPO, OrdItemPO ordItemPO, OrdShipItemPO ordShipItemPO, Long picupPersonContackId, Long tackContactId) {
        OrdStakeholderPO ordStakeholderPO = this.qryOrdStakeholder(ordGoodsPO);
        OrdPurchaseItemPO ordPurchaseItemPO = this.qryPurchaseItemPO(ordGoodsPO);
        QryAfterServiceDetailInfoRspBO detailInfoRspBO = this.qryThirdSupplierAfterDetail(byOffLineReqBO, ordStakeholderPO);
        try {
            Integer type;
            UocCoreCreateAfterServOrderReqBO atomReqBO = new UocCoreCreateAfterServOrderReqBO();
            atomReqBO.setAfsServiceId(byOffLineReqBO.getServiceId());
            GenerateOrderAfterSaleSeqRspBO generateOrderAfterSaleSeqRspBO = this.generateOrderAfterSaleSeqAtomService.generateOrderAfterSaleSeq();
            atomReqBO.setAfterServCode(generateOrderAfterSaleSeqRspBO.getServiceOrderId());
            UocOrderAsObjBO uocOrderAsObjBO = new UocOrderAsObjBO();
            uocOrderAsObjBO.setSaleVoucherId(ordItemPO.getSaleVoucherId());
            uocOrderAsObjBO.setPurchaseVoucherId(ordItemPO.getPurchaseVoucherId());
            uocOrderAsObjBO.setShipVoucherId(String.valueOf(ordShipItemPO.getShipVoucherId()));
            atomReqBO.setUocOrderAsObj(uocOrderAsObjBO);
            ArrayList<UocOrderAsItemBO> uocOrderAsItemList = new ArrayList<UocOrderAsItemBO>();
            UocOrderAsItemBO uocOrderAsItemBO = new UocOrderAsItemBO();
            uocOrderAsItemBO.setOrdItemId(String.valueOf(ordItemPO.getOrdItemId()));
            uocOrderAsItemBO.setPurchaseItemId(ordPurchaseItemPO.getPurchaseItemId());
            uocOrderAsItemBO.setShipItemId(String.valueOf(ordShipItemPO.getShipItemId()));
            uocOrderAsItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
            uocOrderAsItemBO.setUnitName(ordItemPO.getUnitName());
            if (StringUtils.isBlank((CharSequence)uocOrderAsItemBO.getUnitName())) {
                uocOrderAsItemBO.setUnitName("\u65e0");
            }
            uocOrderAsItemBO.setReturnCount(BigDecimal.ONE);
            uocOrderAsItemBO.setExtSkuId(ordGoodsPO.getSkuExtSkuId());
            uocOrderAsItemBO.setSkuId(ordGoodsPO.getSkuId() + "");
            uocOrderAsItemBO.setSkuName(ordGoodsPO.getSkuName());
            uocOrderAsItemBO.setRetSaleFee(BigDecimal.ONE.multiply(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice())));
            uocOrderAsItemBO.setRetPurchaseFee(BigDecimal.ONE.multiply(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getPurchasePrice())));
            uocOrderAsItemList.add(uocOrderAsItemBO);
            atomReqBO.setUocOrderAsItemList(uocOrderAsItemList);
            atomReqBO.setCreateOperId(ordStakeholderPO.getPurPlaceOrderId());
            atomReqBO.setSubmiterId(ordStakeholderPO.getPurPlaceOrderId());
            if (null != detailInfoRspBO.getResult().getServiceCustomerInfoDTO()) {
                atomReqBO.setSubCompName(detailInfoRspBO.getResult().getServiceCustomerInfoDTO().getCustomerContactName());
            }
            if (!StringUtils.isBlank((CharSequence)atomReqBO.getSubCompName())) {
                atomReqBO.setSubmiterName(ordStakeholderPO.getPurPlaceOrderName());
            }
            atomReqBO.setSubCompId(ordStakeholderPO.getPurNo());
            atomReqBO.setSubCompName(ordStakeholderPO.getPurName());
            atomReqBO.setUocOrderAsItemType(UocConstant.UOC_ORDER_AS_ITEM_TYPE.TYPE_SALE_ORDER);
            atomReqBO.setExtOrderId(byOffLineReqBO.getExtOrderId());
            atomReqBO.setUpdateOrdItem(1);
            atomReqBO.setPickupContactId(String.valueOf(picupPersonContackId));
            atomReqBO.setTakeContactId(String.valueOf(tackContactId));
            atomReqBO.setUnitNam(ordItemPO.getUnitName());
            atomReqBO.setOrderId(ordItemPO.getOrderId());
            if (!StringUtils.isBlank((CharSequence)detailInfoRspBO.getResult().getQuestionDesc())) {
                atomReqBO.setQuesionDesc(detailInfoRspBO.getResult().getQuestionDesc());
            }
            atomReqBO.setServType(detailInfoRspBO.getResult().getCustomerExpect());
            atomReqBO.setAfsReason(detailInfoRspBO.getResult().getAfsReason());
            atomReqBO.setPickupStartTime(detailInfoRspBO.getResult().getApplyTime());
            if (CollectionUtils.isNotEmpty((Collection)detailInfoRspBO.getResult().getServiceTrackInfo())) {
                atomReqBO.setPickupEndTime(((ServiceTrackInfoDTO)detailInfoRspBO.getResult().getServiceTrackInfo().get(0)).getCreateDate());
            }
            if (null != (type = detailInfoRspBO.getResult().getApprovedResult())) {
                if (PecConstant.EXT_AFTER_SERVICE_STEP_CODE.RECEIVED_BY_JD.equals(type)) {
                    atomReqBO.setPick(String.valueOf(UocConstant.PICWARE_TYPE.PICK_UP));
                } else if (PecConstant.PICK_WARE_TYPE.OUT_SEND.equals(type)) {
                    atomReqBO.setPick(String.valueOf(PecConstant.PICK_WARE_TYPE.SEND));
                } else if (PecConstant.PICK_WARE_TYPE.OUT_SHIP.equals(type)) {
                    atomReqBO.setPick(String.valueOf(PecConstant.PICK_WARE_TYPE.SHIP));
                } else {
                    atomReqBO.setPick(String.valueOf(UocConstant.PICWARE_TYPE.PICK_UP));
                }
            }
            if (null != atomReqBO.getServType()) {
                if (PecConstant.EXT_AFTER_SERVICE_TYPE_CODE.EXCHANGE.equals(atomReqBO.getServType()) || PecConstant.EXT_AFTER_SERVICE_TYPE_CODE.MAINTAIN.equals(atomReqBO.getServType())) {
                    if (StringUtils.isNotBlank((CharSequence)atomReqBO.getPick())) {
                        if (String.valueOf(UocConstant.PICWARE_TYPE.PICK_UP).equals(atomReqBO.getPick())) {
                            atomReqBO.setRetMode(String.valueOf(PecConstant.EXT_AFTER_SERVICE_RETURN_CODE.SUPPLIER_SELF_RETURN));
                        } else {
                            atomReqBO.setRetMode(String.valueOf(PecConstant.EXT_AFTER_SERVICE_RETURN_CODE.THIRD_DELIVERY));
                        }
                    } else {
                        atomReqBO.setRetMode(String.valueOf(PecConstant.EXT_AFTER_SERVICE_RETURN_CODE.SUPPLIER_SELF_RETURN));
                    }
                } else {
                    atomReqBO.setRetMode(String.valueOf(PecConstant.EXT_AFTER_SERVICE_RETURN_CODE.SUPPLIER_SELF_RETURN));
                }
            }
            if (UocConstant.SERV_TYPE.SALES_RETURN.equals(atomReqBO.getServType())) {
                OrdSalePO ordsalePO = new OrdSalePO();
                ordsalePO.setOrderId(atomReqBO.getOrderId());
                ordsalePO = this.ordSaleMapper.getModelBy(ordsalePO);
                if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(ordsalePO.getSaleState())) {
                    throw new UocProBusinessException("102021", "\u4ee5\u9a8c\u6536\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27");
                }
            }
            atomReqBO.setRetTotalSaleFee(uocOrderAsItemBO.getRetSaleFee());
            atomReqBO.setRetTotalPupchaseFee(uocOrderAsItemBO.getRetPurchaseFee());
            atomReqBO.setRemark("\u7ebf\u4e0b\u552e\u540e\u4fe1\u606f\u670d\u52a1\u5355\u4fe1\u606f\u56de\u586b");
            return atomReqBO;
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u7535\u5b50\u8d85\u5e02\u5ba2\u6237\u7533\u8bf7\u7ebf\u4e0b\u552e\u540e\u670d\u52a1\u540e\u552e\u540e\u670d\u52a1\u5355\u56de\u586b\u5931\u8d25\uff1a\u7ec4\u88c5\u552e\u540e\u670d\u52a1\u5355\u521b\u5143\u539f\u5b50\u670d\u52a1BO\u5f02\u5e38!", (Throwable)e);
            throw new UocProBusinessException("102021", ERROR_MSG + e.getMessage());
        }
    }

    private OrdStakeholderPO qryOrdStakeholder(OrdGoodsPO ordGoodsPO) {
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(ordGoodsPO.getOrderId());
        ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
        return ordStakeholderPO;
    }

    private OrdPurchaseItemPO qryPurchaseItemPO(OrdGoodsPO ordGoodsPO) {
        OrdPurchaseItemPO ordPurchaseItemPO = new OrdPurchaseItemPO();
        ordPurchaseItemPO.setOrderId(ordGoodsPO.getOrderId());
        ordPurchaseItemPO.setOrderItemId(ordGoodsPO.getOrdItemId());
        ordPurchaseItemPO = this.ordPurchaseItemMapper.getModelBy(ordPurchaseItemPO);
        return ordPurchaseItemPO;
    }

    private QryAfterServiceDetailInfoRspBO qryThirdSupplierAfterDetail(PebDealAfterByOffLineReqBO reqBO, OrdStakeholderPO ordStakeholderPO) {
        QryAfterServiceDetailInfoRspBO detailInfoRspBO;
        QryAfterServiceDetailInfoReqBO detailInfoReqBO = new QryAfterServiceDetailInfoReqBO();
        detailInfoReqBO.setSupplierId(Long.valueOf(ordStakeholderPO.getSupNo()));
        detailInfoReqBO.setServiceId(reqBO.getServiceId());
        ArrayList<Integer> appendInfoSteps = new ArrayList<Integer>();
        appendInfoSteps.add(2);
        detailInfoReqBO.setAppendInfoSteps(appendInfoSteps);
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(reqBO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            detailInfoReqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((detailInfoRspBO = this.pebIntfQryAfterServiceDetailInfoAbilityService.queryServiceDetailInfo(detailInfoReqBO)).getRespCode())) {
            throw new UocProBusinessException("102021", detailInfoRspBO.getRespDesc());
        }
        if (null == detailInfoRspBO.getResult()) {
            throw new UocProBusinessException("102021", "\u672a\u67e5\u8be2\u5230\u552e\u540e\u670d\u52a1\u5355\u4fe1\u606f");
        }
        return detailInfoRspBO;
    }
}

