/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.ppc.ability.api.PpcOrderFeedbackAbilityService;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityRspBO;
import com.tydic.ppc.ability.bo.PpcpurchasePlanSscBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.atom.api.UocCoreCommCreateIntfLogAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreCommCreateIntfLogReqBO;
import com.tydic.uoc.common.busi.api.UocCallPlanCenterBusiService;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceItemBo;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceReqBo;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceRspBo;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocCallPlanCenterBusiServiceImpl
implements UocCallPlanCenterBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocCallPlanCenterBusiServiceImpl.class);
    @Autowired
    private PpcOrderFeedbackAbilityService ppcOrderFeedbackAbilityService;
    @Autowired
    private UocCoreCommCreateIntfLogAtomService uocPebCommCreateIntfLogAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @Override
    public UocCallPlanCenterBusiServiceRspBo updatePlanData(UocCallPlanCenterBusiServiceReqBo reqBo) {
        Long orderId = reqBo.getOrderId();
        Boolean reverse = reqBo.getDirection();
        this.validateArg(reqBo);
        OrdSalePO qryOrdSale = new OrdSalePO();
        qryOrdSale.setOrderId(orderId);
        OrdSalePO ordSalePo = this.ordSaleMapper.getModelBy(qryOrdSale);
        if (ordSalePo == null) {
            throw new UocProBusinessException("100001", "\u8be5\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
        }
        List qryItem = null;
        Map<Object, Object> countMap = new HashMap();
        if (!ObjectUtil.isEmpty(reqBo.getOrderItems())) {
            qryItem = reqBo.getOrderItems().stream().map(UocCallPlanCenterBusiServiceItemBo::getOrderItemId).collect(Collectors.toList());
            countMap = reqBo.getOrderItems().stream().collect(Collectors.toMap(UocCallPlanCenterBusiServiceItemBo::getOrderItemId, UocCallPlanCenterBusiServiceItemBo::getCount));
        }
        String saleVoucherNo = ordSalePo.getSaleVoucherNo();
        OrdItemPO qryOrdItemPo = new OrdItemPO();
        qryOrdItemPo.setOrderId(orderId);
        if (!ObjectUtil.isEmpty(qryItem)) {
            qryOrdItemPo.setOrdItemIdList(qryItem);
        }
        List itemList = this.ordItemMapper.getList(qryOrdItemPo);
        PpcOrderFeedbackAbilityReqBO feedbackReqBo = new PpcOrderFeedbackAbilityReqBO();
        ArrayList<PpcpurchasePlanSscBO> feedbackList = new ArrayList<PpcpurchasePlanSscBO>();
        feedbackReqBo.setPurchasePlanSscBOS(feedbackList);
        for (OrdItemPO ordItemPO : itemList) {
            if (ordItemPO.getPlanId() == null || ordItemPO.getPlanItemId() == null) continue;
            PpcpurchasePlanSscBO tmpBo = new PpcpurchasePlanSscBO();
            feedbackList.add(tmpBo);
            tmpBo.setPurchasePlanId(ordItemPO.getPlanId());
            tmpBo.setPurchasePlanItemId(ordItemPO.getPlanItemId());
            tmpBo.setOrderId(orderId);
            tmpBo.setOrderCode(saleVoucherNo);
            if (!ObjectUtil.isEmpty(qryItem)) {
                if (reverse.booleanValue()) {
                    tmpBo.setPurchaserNumber((BigDecimal)countMap.get(ordItemPO.getOrdItemId()));
                } else {
                    tmpBo.setPurchaserNumber(((BigDecimal)countMap.get(ordItemPO.getOrdItemId())).negate());
                }
                try {
                    if (reverse.booleanValue()) {
                        tmpBo.setAllPrice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice()).multiply((BigDecimal)countMap.get(ordItemPO.getOrdItemId())));
                        continue;
                    }
                    tmpBo.setAllPrice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice()).multiply((BigDecimal)countMap.get(ordItemPO.getOrdItemId())).negate());
                    continue;
                }
                catch (Exception e) {
                    throw new UocProBusinessException("100001", "Long2BigDecimal\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (reverse.booleanValue()) {
                tmpBo.setPurchaserNumber(ordItemPO.getPurchaseCount());
            } else {
                tmpBo.setPurchaserNumber(ordItemPO.getPurchaseCount().negate());
            }
            try {
                if (reverse.booleanValue()) {
                    tmpBo.setAllPrice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getTotalSaleFee()));
                    continue;
                }
                tmpBo.setAllPrice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getTotalSaleFee()).negate());
            }
            catch (Exception e) {
                throw new UocProBusinessException("100001", "Long2BigDecimal\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        if (feedbackList.size() > 0) {
            log.info("\u8c03\u7528\u8ba1\u5212\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)feedbackReqBo));
            UocCoreCommCreateIntfLogReqBO reqBoLog = new UocCoreCommCreateIntfLogReqBO();
            reqBoLog.setCallTime(new Date());
            PpcOrderFeedbackAbilityRspBO ppcOrderFeedbackAbilityRspBO = this.ppcOrderFeedbackAbilityService.orderFeedback(feedbackReqBo);
            log.info("\u8c03\u7528\u8ba1\u5212\u4e2d\u5fc3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)ppcOrderFeedbackAbilityRspBO));
            reqBoLog.setOrderId(orderId);
            reqBoLog.setRetTime(new Date());
            reqBoLog.setCallstate(ordSalePo.getSaleState().toString());
            reqBoLog.setCreateLoginId("system");
            reqBoLog.setInContent(JSON.toJSONString((Object)feedbackReqBo));
            reqBoLog.setOutContent(JSON.toJSONString((Object)ppcOrderFeedbackAbilityRspBO));
            reqBoLog.setInterCode(PpcOrderFeedbackAbilityService.class.getSimpleName());
            this.uocPebCommCreateIntfLogAtomService.dealCommCreateIntfLog(reqBoLog);
            if (!"0000".equals(ppcOrderFeedbackAbilityRspBO.getRespCode())) {
                return (UocCallPlanCenterBusiServiceRspBo)UocProRspBoUtil.failed((String)ppcOrderFeedbackAbilityRspBO.getRespDesc(), UocCallPlanCenterBusiServiceRspBo.class);
            }
            return (UocCallPlanCenterBusiServiceRspBo)UocProRspBoUtil.success(UocCallPlanCenterBusiServiceRspBo.class);
        }
        log.info("\u8be5\u8ba2\u5355\uff08" + reqBo.getOrderId() + "\uff09\u65e0\u9700\u8c03\u7528\u8ba1\u5212\u4e2d");
        return (UocCallPlanCenterBusiServiceRspBo)UocProRspBoUtil.success(UocCallPlanCenterBusiServiceRspBo.class);
    }

    private void validateArg(UocCallPlanCenterBusiServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("100001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getDirection() == null) {
            throw new UocProBusinessException("100001", "direction\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocCallPlanCenterBusiServiceItemBo> orderItems = reqBo.getOrderItems();
        if (!ObjectUtil.isEmpty(orderItems)) {
            for (UocCallPlanCenterBusiServiceItemBo orderItem : orderItems) {
                if (orderItem == null) {
                    throw new UocProBusinessException("100001", "orderItems\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (orderItem.getOrderItemId() == null || orderItem.getOrderItemId() == 0L) {
                    throw new UocProBusinessException("100001", "orderItems\u4e2d\u5bf9\u8c61\u5c5e\u6027orderItemId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (orderItem.getCount() != null && !orderItem.getCount().equals(BigDecimal.ZERO)) continue;
                throw new UocProBusinessException("100001", "orderItems\u4e2d\u5bf9\u8c61\u5c5e\u6027count\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

