/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocProSalesRemainingTimeInfoBo;
import com.tydic.uoc.common.ability.bo.UocStatisticsFieldInfoBO;
import com.tydic.uoc.common.busi.api.UocEsQryOrderListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryOrderListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryOrderListRspBO;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="esQryOrderListBusiService")
public class UocEsQryOrderListBusiServiceImpl
implements UocEsQryOrderListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryOrderListBusiServiceImpl.class);
    private final UocEsConfig uocEsConfig;
    private final UocElasticsearchUtil uocElasticsearchUtil;
    private final UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;
    @Value(value="${es.query.log.result.enable:true}")
    private boolean qryResultLog;

    @Autowired
    public UocEsQryOrderListBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryOrderListRspBO qryEsOrderInfo(UocEsQryOrderListReqBO uocEsQryOrderListReqBO) {
        String result;
        UocEsQryOrderListRspBO rspBO = new UocEsQryOrderListRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u4fe1\u606f\u6210\u529f!");
        LOGGER.info("es\u67e5\u8be2\u5bf9\u8c61--->" + JSON.toJSONString((Object)uocEsQryOrderListReqBO));
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryOrderEsSql(uocEsQryOrderListReqBO);
        LOGGER.info("ES\u67e5\u8be2\u8ba2\u5355\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.uocEsConfig.getOrderIndexName() + "/_search";
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(qryString);
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getOrderIndexName());
                if (!index) {
                    LOGGER.error("\u81ea\u52a8\u521b\u5efa\u8ba2\u5355\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u8ba2\u5355\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    LOGGER.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("102052");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBO;
                }
            }
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("102052");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
            return rspBO;
        }
        if (this.qryResultLog) {
            LOGGER.info("ES\u67e5\u8be2\u8ba2\u5355result---->" + result);
        }
        if (null != uocEsQryOrderListReqBO.getIsQueryTab() && uocEsQryOrderListReqBO.getIsQueryTab().booleanValue()) {
            this.resolveReturnCounts(result, rspBO, uocEsQryOrderListReqBO);
        } else if (CollectionUtils.isNotEmpty(uocEsQryOrderListReqBO.getSumField())) {
            this.resolveReturnSum(result, rspBO, uocEsQryOrderListReqBO);
        } else {
            this.resolveReturnData(result, rspBO, uocEsQryOrderListReqBO.getPageSize(), uocEsQryOrderListReqBO.getPageNo(), uocEsQryOrderListReqBO.getIsRemainingTime());
        }
        return rspBO;
    }

    private void resolveReturnData(String result, UocEsQryOrderListRspBO rspBO, Integer pageSize, Integer pageNo, Boolean isRemainingTime) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f!");
            return;
        }
        ArrayList<Long> fscExpTime = null;
        HashMap<String, UocProSalesRemainingTimeInfoBo> remainingTimeInfoBoMap = null;
        if (null != isRemainingTime && isRemainingTime.booleanValue()) {
            fscExpTime = new ArrayList<Long>();
            remainingTimeInfoBoMap = new HashMap<String, UocProSalesRemainingTimeInfoBo>(listObject.size());
        }
        ArrayList<PebExtUpperOrderAbilityBO> rows = new ArrayList<PebExtUpperOrderAbilityBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            PebExtUpperOrderAbilityBO esQryOrderListSingleBO = (PebExtUpperOrderAbilityBO)JSON.toJavaObject((JSON)objJson, PebExtUpperOrderAbilityBO.class);
            rows.add(esQryOrderListSingleBO);
        }
        if (null != isRemainingTime && isRemainingTime.booleanValue()) {
            rspBO.setRemainingTimeInfoBoMap(remainingTimeInfoBoMap);
            rspBO.setFscExpTime(fscExpTime);
        }
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
    }

    public void resolveReturnCounts(String result, UocEsQryOrderListRspBO rspBO, UocEsQryOrderListReqBO reqBO) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"all_interests");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        if (StringUtils.isNotBlank((CharSequence)reqBO.getStatisticsField())) {
            if ((reqBO.getPageNo() - 1) * reqBO.getPageSize() > bucketsArray.size()) {
                rspBO.setStatisticsFieldInfo(new ArrayList<UocStatisticsFieldInfoBO>(0));
                return;
            }
            ArrayList<UocStatisticsFieldInfoBO> statisticsFieldInfo = new ArrayList<UocStatisticsFieldInfoBO>(bucketsArray.size());
            for (int i = (reqBO.getPageNo() - 1) * reqBO.getPageSize(); i < bucketsArray.size(); ++i) {
                UocStatisticsFieldInfoBO uocStatisticsFieldInfoBO = new UocStatisticsFieldInfoBO();
                JSONObject bucketsObj = bucketsArray.getJSONObject(i);
                uocStatisticsFieldInfoBO.setStatisticsFieldContent(bucketsObj.getString("key"));
                uocStatisticsFieldInfoBO.setStatisticsFieldCount(bucketsObj.getInteger("doc_count"));
                statisticsFieldInfo.add(uocStatisticsFieldInfoBO);
            }
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setStatisticsFieldInfo(statisticsFieldInfo);
        } else {
            HashMap<String, Integer> tabCountsMap = new HashMap<String, Integer>();
            for (int i = 0; i < bucketsArray.size(); ++i) {
                JSONObject bucketsObj = bucketsArray.getJSONObject(i);
                tabCountsMap.put(bucketsObj.getString("key"), bucketsObj.getInteger("doc_count"));
            }
            rspBO.setTabCountsMap(tabCountsMap);
        }
    }

    public void resolveReturnSum(String result, UocEsQryOrderListRspBO rspBO, UocEsQryOrderListReqBO reqBO) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        rspBO.setRecordsTotal(total);
        HashMap<String, Number> sumMap = new HashMap<String, Number>();
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        Iterator<String> iterator = reqBO.getSumField().iterator();
        while (iterator.hasNext()) {
            String sumField;
            JSONObject sum = (JSONObject)aggregationsObj.get((Object)(sumField = iterator.next()));
            String value = (String)sum.get((Object)"value_as_string");
            sumMap.put(sumField, value == null ? new BigDecimal("0.00") : new BigDecimal(value));
        }
        rspBO.setSumFieldInfo(sumMap);
    }
}

