/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.K2ApprovedConstants;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.UocPebAccessoryBO;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveSecondAtomService;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocZoneSpecificLinkBusiToDealAtomService;
import com.tydic.uoc.common.atom.bo.ApproveInfoBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveSecondReqBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveSecondRspBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomRspBO;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocGeneralCirculationBusiServiceImpl
implements UocGeneralCirculationBusiService {
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocZoneSpecificLinkBusiToDealAtomService uocZoneSpecificLinkBusiToDealAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private BgyRequestOrderApproveSecondAtomService bgyRequestOrderApproveSecondAtomService;
    @Value(value="${k2approver:201907057023}")
    private String k2Approver;

    @Override
    public UocGeneralCirculationRspBO dealGeneralCirculation(UocGeneralCirculationReqBO reqBO) {
        UocGeneralCirculationRspBO rspBO = new UocGeneralCirculationRspBO();
        if (reqBO.getAuthCtrl() == null) {
            reqBO.setAuthCtrl(PecConstant.AuthCtrl.NO_CTRL);
        }
        this.doCheckAuthority(reqBO);
        this.doStateCheck(reqBO);
        this.saveFile(reqBO);
        Map<String, Object> variables = this.doSpecificLinks(reqBO);
        this.doRunProcess(reqBO, variables, rspBO);
        if ("ACTPEB001".equals(reqBO.getActionCode())) {
            UocOrdRequestPo uocOrdRequestPo;
            Integer ktFlag;
            OrdSalePO qrySalePo = new OrdSalePO();
            qrySalePo.setOrderId(reqBO.getOrderId());
            OrdSalePO ordSaleRspPo = this.ordSaleMapper.getModelBy(qrySalePo);
            OrdSalePO qryAllSalePo = new OrdSalePO();
            qryAllSalePo.setRequestId(ordSaleRspPo.getRequestId());
            List orderList = this.ordSaleMapper.getList(qryAllSalePo);
            if (ObjectUtil.isEmpty((Object)orderList)) {
                throw new UocProBusinessException("100001", "\u8ba2\u5355\u53d1\u8d27\uff0c\u6839\u636e\u8bf7\u8d2d\u5355\u67e5\u8be2\u6240\u6709\u8ba2\u5355\u4e3a\u7a7a");
            }
            boolean allConfirm = true;
            for (OrdSalePO ordSalePO : orderList) {
                if (!"1".equals(ordSalePO.getOrderSource()) || UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT.equals(ordSalePO.getSaleState())) continue;
                allConfirm = false;
            }
            if (allConfirm && K2ApprovedConstants.K2_APPROVED_FLAG_TRUE.equals(ktFlag = (uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(ordSaleRspPo.getRequestId())).getKtFlag())) {
                BgyRequestOrderApproveSecondReqBO approveSecondReqBO = new BgyRequestOrderApproveSecondReqBO();
                ApproveInfoBO requestInfo = new ApproveInfoBO();
                requestInfo.setK2Id(uocOrdRequestPo.getKtId());
                requestInfo.setApproverUserCode(this.k2Approver);
                requestInfo.setActionName(0);
                requestInfo.setApproveDate(new Date());
                approveSecondReqBO.setRequestInfo(requestInfo);
                approveSecondReqBO.setEsbInfo(new EsbInfoBO());
                approveSecondReqBO.setRequestId(ordSaleRspPo.getRequestId());
                BgyRequestOrderApproveSecondRspBO approveSecondRspBO = this.bgyRequestOrderApproveSecondAtomService.progress(approveSecondReqBO);
                if (!"S".equalsIgnoreCase(approveSecondRspBO.getReturnStatus())) {
                    throw new UocProBusinessException("101030", "k2\u53d1\u8d77\u4e8c\u6b21\u5ba1\u6279\u5931\u8d25\uff1a!" + approveSecondRspBO.getReturnMsg());
                }
                UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
                processRunReqBO.setSysCode("UOC");
                processRunReqBO.setObjId(ordSaleRspPo.getRequestId());
                processRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
                processRunReqBO.setOrderId(ordSaleRspPo.getRequestId());
                processRunReqBO.setOperId("1");
                UocProcessRunRspBO requestRspBo = this.uocRunProcessAtomService.start(processRunReqBO);
                if (!"0000".equals(requestRspBo.getRespCode())) {
                    throw new UocProBusinessException(requestRspBo.getRespCode(), requestRspBo.getRespDesc());
                }
                UocOrdRequestPo updateSecondPo = new UocOrdRequestPo();
                updateSecondPo.setRequestId(ordSaleRspPo.getRequestId());
                updateSecondPo.setKtSecondFlag(K2ApprovedConstants.K2_SECOND_FLAG_TRUE);
                this.uocOrdRequestMapper.updateByPrimaryKeySelective(updateSecondPo);
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void saveFile(UocGeneralCirculationReqBO reqBO) {
        List<UocPebAccessoryBO> pebAccessoryReqBOList = reqBO.getAccessoryList();
        if (!CollectionUtils.isEmpty(pebAccessoryReqBOList)) {
            for (UocPebAccessoryBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(reqBO.getObjType());
                uocCoreCreateAccessoryReqBO.setObjectId(reqBO.getObjId());
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }

    private void doCheckAuthority(UocGeneralCirculationReqBO reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)permissionsCheckingAtomReqBO));
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }

    private void doStateCheck(UocGeneralCirculationReqBO reqBO) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getObjId());
        uocCoreStateCheckAtomReqBO.setObjType(reqBO.getObjType());
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u64cd\u4f5c\u5f02\u5e38:" + uocCoreStateCheck.getRespDesc());
        }
    }

    private Map<String, Object> doSpecificLinks(UocGeneralCirculationReqBO reqBO) {
        UocZoneSpecificLinkBusiToDealAtomReqBO specificLinkReq = new UocZoneSpecificLinkBusiToDealAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)specificLinkReq));
        UocZoneSpecificLinkBusiToDealAtomRspBO specificLinkRsp = this.uocZoneSpecificLinkBusiToDealAtomService.dealSpecificLinkBusi(specificLinkReq);
        if (!"0000".equals(specificLinkRsp.getRespCode())) {
            throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7279\u5b9a\u73af\u8282\u4e1a\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + specificLinkRsp.getRespDesc());
        }
        return specificLinkRsp.getVariables();
    }

    private void doRunProcess(UocGeneralCirculationReqBO reqBO, Map<String, Object> map, UocGeneralCirculationRspBO rspBO) {
        rspBO.setAuto(this.run(map, reqBO));
    }

    private boolean run(Map<String, Object> map, UocGeneralCirculationReqBO reqBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setVariables(map);
        processRunReqBO.setOperId(reqBO.getUserId() + "");
        processRunReqBO.setSysCode("eb_el_sale_order_master_order_status");
        processRunReqBO.setObjId(reqBO.getObjId());
        processRunReqBO.setObjType(reqBO.getObjType());
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setActionCode(reqBO.getActionCode());
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102034", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        return uocProcessRunRspBO.getAuto();
    }
}

