/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.fsc.util.TaxUtils;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.busi.api.UocPebBuildFscBillOrderAutoCreateParamBusiService;
import com.tydic.uoc.common.busi.bo.UocInvoiceBO;
import com.tydic.uoc.common.busi.bo.UocOrderInfoBO;
import com.tydic.uoc.common.busi.bo.UocToFscInfoBO;
import com.tydic.uoc.common.busi.bo.UocToFscOrderItemBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocPebBuildFscBillOrderAutoCreateParamBusiServiceImpl
implements UocPebBuildFscBillOrderAutoCreateParamBusiService {
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;

    @Override
    public UocToFscInfoBO buildFscBillOrderAutoCreateParam(Long orderId) {
        OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
        ordInvoicePO.setOrderId(orderId);
        ordInvoicePO = this.ordInvoiceMapper.getModelByPO(ordInvoicePO);
        if (Objects.isNull(ordInvoicePO)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (Objects.isNull(ordSalePO)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u5355\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        ordInspectionPO.setOrderId(orderId);
        List ordInspectionPOList = this.ordInspectionMapper.getList(ordInspectionPO);
        if (CollectionUtils.isEmpty((Collection)ordInspectionPOList)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u9a8c\u6536\u5355\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        ordLogisticsRelaPO.setOrderId(orderId);
        List ordLogisticsRelaPOList = this.ordLogisticsRelaMapper.getList(ordLogisticsRelaPO);
        if (CollectionUtils.isEmpty((Collection)ordLogisticsRelaPOList)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u6d41\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        Map<Long, OrdLogisticsRelaPO> ordLogisticsRelaPOMap = ordLogisticsRelaPOList.stream().collect(Collectors.toMap(OrdLogisticsRelaPO::getContactId, entity -> entity));
        OrdPayConfPO ordPayConfPO = new OrdPayConfPO();
        ordPayConfPO.setOrderId(orderId);
        List ordPayConfPOList = this.ordPayConfMapper.selectByCondition(ordPayConfPO);
        if (CollectionUtils.isEmpty((Collection)ordPayConfPOList)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u652f\u4ed8\u8ba2\u5355\u914d\u7f6e! \u8ba2\u5355id:" + orderId);
        }
        OrdPurchasePO ordPurchasePO = new OrdPurchasePO();
        ordPurchasePO.setOrderId(orderId);
        ordPurchasePO = this.ordPurchaseMapper.getModelBy(ordPurchasePO);
        if (Objects.isNull(ordPurchasePO)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u5355\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
        if (Objects.isNull(ordStakeholderPO)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e70\u65b9\u3001\u5356\u65b9\u3001\u5e73\u53f0\u4e09\u65b9\u4fe1\u606f\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        if (Objects.isNull(orderPO)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(orderId);
        List ordItemPOList = this.ordItemMapper.getList(ordItemPO);
        if (CollectionUtils.isEmpty((Collection)ordItemPOList)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u8be6\u60c5\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        Map<Long, OrdItemPO> ordItemPOMap = ordItemPOList.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, entity -> entity));
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(orderId);
        List ordGoodsPOList = this.ordGoodsMapper.getList(ordGoodsPO);
        if (CollectionUtils.isEmpty((Collection)ordGoodsPOList)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u573a\u9891\u8be6\u60c5\u4fe1\u606f! \u8ba2\u5355id:" + orderId);
        }
        Map<Long, OrdGoodsPO> ordGoodsPOMap = ordGoodsPOList.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, entity -> entity));
        OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
        ordInspectionItemPO.setOrderId(orderId);
        List ordInspectionItemPOList = this.ordInspectionItemMapper.getList(ordInspectionItemPO);
        if (CollectionUtils.isEmpty((Collection)ordInspectionItemPOList)) {
            throw new UocProBusinessException("102073", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u9a8c\u6536\u5355\u8be6\u60c5\u4fe1\u606f \u8ba2\u5355id:" + orderId);
        }
        UocToFscInfoBO rspBO = new UocToFscInfoBO();
        this.buildInvoiceInfo(rspBO, ordInvoicePO);
        this.buildInspectionInfo(rspBO, ordInvoicePO, ordSalePO, ordInspectionPOList, ordLogisticsRelaPOMap, ordPayConfPOList, ordPurchasePO, ordStakeholderPO, orderPO, ordItemPOMap, ordGoodsPOMap, ordInspectionItemPOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildInspectionInfo(UocToFscInfoBO uocToFscInfoBO, OrdInvoicePO ordInvoicePO, OrdSalePO ordSalePO, List<OrdInspectionPO> ordInspectionPOList, Map<Long, OrdLogisticsRelaPO> ordLogisticsRelaPOMap, List<OrdPayConfPO> ordPayConfPOList, OrdPurchasePO ordPurchasePO, OrdStakeholderPO ordStakeholderPO, OrderPO orderPO, Map<Long, OrdItemPO> ordItemPOMap, Map<Long, OrdGoodsPO> ordGoodsPOMap, List<OrdInspectionItemPO> ordInspectionItemPOList) {
        ArrayList<UocOrderInfoBO> uocOrderInfoBOList = new ArrayList<UocOrderInfoBO>(ordInspectionPOList.size());
        for (OrdInspectionPO ordInspectionPO : ordInspectionPOList) {
            UocOrderInfoBO uocOrderInfoBO = new UocOrderInfoBO();
            uocOrderInfoBO.setOrderId(ordSalePO.getOrderId());
            uocOrderInfoBO.setAcceptOrderId(ordInspectionPO.getInspectionVoucherId());
            uocOrderInfoBO.setOrderNo(ordSalePO.getSaleVoucherNo());
            uocOrderInfoBO.setPurchaseOrderId(String.valueOf(ordPurchasePO.getPurchaseVoucherId()));
            uocOrderInfoBO.setPurchaseOrderNo(ordPurchasePO.getPurchaseVoucherNo());
            uocOrderInfoBO.setSaleOrderNo(ordSalePO.getSaleVoucherNo());
            uocOrderInfoBO.setSaleOrderId(String.valueOf(ordSalePO.getSaleVoucherId()));
            uocOrderInfoBO.setExtOrderNo(ordSalePO.getOutOrderId());
            uocOrderInfoBO.setSupplierName(ordStakeholderPO.getSupName());
            uocOrderInfoBO.setSupplierId(ordStakeholderPO.getSupNo());
            uocOrderInfoBO.setPurchaserId(ordStakeholderPO.getPurNo());
            uocOrderInfoBO.setPurchaserName(ordStakeholderPO.getPurName());
            uocOrderInfoBO.setProOrgId(ordStakeholderPO.getProNo());
            uocOrderInfoBO.setProOrgName(ordStakeholderPO.getProName());
            uocOrderInfoBO.setAcceptOrderNo(ordInspectionPO.getInspectionVoucherCode());
            uocOrderInfoBO.setOrderSource(ordSalePO.getOrderSource());
            uocOrderInfoBO.setTradeMode(ordSalePO.getModelSettle());
            uocOrderInfoBO.setPurPlaceOrderName(ordStakeholderPO.getPurPlaceOrderName());
            if (Objects.nonNull(ordSalePO.getContactId()) && null != ordLogisticsRelaPOMap.get(ordSalePO.getContactId())) {
                uocOrderInfoBO.setReceiverName(ordLogisticsRelaPOMap.get(ordSalePO.getContactId()).getContactName());
            }
            uocOrderInfoBO.setInspectionOper(ordInspectionPO.getInspectionOper());
            uocOrderInfoBO.setPayRule(ordPayConfPOList.get(0).getPayRule());
            uocOrderInfoBO.setPayBreakScale(ordPayConfPOList.get(0).getPayBreakScale());
            uocOrderInfoBO.setPayAccountDayRule(ordPayConfPOList.get(0).getPayAccountDayRule());
            uocOrderInfoBO.setPayNodeRule(ordPayConfPOList.get(0).getPayNodeRule());
            uocOrderInfoBO.setPayAccountDay(ordPayConfPOList.get(0).getPayAccountDay());
            uocOrderInfoBO.setPayNodeAccountDays(ordPayConfPOList.get(0).getPaymentDays());
            uocOrderInfoBO.setOutInvoiceId(ordInvoicePO.getOutInvoiceId());
            uocOrderInfoBO.setBuyerName(ordInvoicePO.getBuyerName());
            uocOrderInfoBO.setPurLogName(ordStakeholderPO.getPurLogName());
            uocOrderInfoBO.setPayType(Integer.valueOf(orderPO.getPayType()));
            uocOrderInfoBO.setOrderCreateTime(orderPO.getCreateTime());
            uocOrderInfoBO.setInspectionTime(ordInspectionPO.getInspectionTime());
            try {
                uocOrderInfoBO.setInspTotalMoney(UocMoneyUtil.long2BigDecimal((Long)ordInspectionPO.getInspTotalSaleFee()));
                uocOrderInfoBO.setInspTotalSaleMoney(UocMoneyUtil.long2BigDecimal((Long)ordInspectionPO.getInspTotalSaleFee()));
                uocOrderInfoBO.setInspTotalPurchaseMoney(UocMoneyUtil.long2BigDecimal((Long)ordInspectionPO.getInspTotalPurchaseFee()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("102073", "\u8f6c\u6362\u91d1\u989d\u5f02\u5e38");
            }
            uocOrderInfoBO.setModelContractNo(ordPayConfPOList.get(0).getModelContractNo());
            uocOrderInfoBO.setModelContractId(ordPayConfPOList.get(0).getModelContractId());
            uocOrderInfoBO.setCompanyId(ordStakeholderPO.getCompanyId());
            uocOrderInfoBO.setCompanyName(ordStakeholderPO.getCompanyName());
            uocOrderInfoBO.setBusiMode(ordSalePO.getModelSettle());
            uocOrderInfoBO.setAccountSetId(Long.parseLong(ordStakeholderPO.getPurAccount()));
            uocOrderInfoBO.setAccountSetName(ordStakeholderPO.getPurAccountName());
            List<OrdInspectionItemPO> ordInspectionItemPOS = ordInspectionItemPOList.stream().filter(entity -> ordInspectionPO.getInspectionVoucherId().equals(entity.getInspectionVoucherId())).collect(Collectors.toList());
            ArrayList<UocToFscOrderItemBO> uocToFscOrderItemBOS = new ArrayList<UocToFscOrderItemBO>(ordInspectionItemPOS.size());
            this.buildInspectionItemInfo(uocToFscOrderItemBOS, ordGoodsPOMap, ordInspectionPO, ordItemPOMap, orderPO, ordInspectionItemPOS, ordSalePO);
            uocOrderInfoBO.setUocToFscOrderItemBOS(uocToFscOrderItemBOS);
            uocOrderInfoBOList.add(uocOrderInfoBO);
        }
        uocToFscInfoBO.setUocOrderInfoBOS(uocOrderInfoBOList);
    }

    private void buildInspectionItemInfo(List<UocToFscOrderItemBO> uocToFscOrderItemBOS, Map<Long, OrdGoodsPO> ordGoodsPOMap, OrdInspectionPO ordInspectionPO, Map<Long, OrdItemPO> ordItemPOMap, OrderPO orderPO, List<OrdInspectionItemPO> ordInspectionItemPOS, OrdSalePO ordSalePO) {
        for (OrdInspectionItemPO ordInspectionItemPO : ordInspectionItemPOS) {
            UocToFscOrderItemBO uocToFscOrderItemBO = new UocToFscOrderItemBO();
            uocToFscOrderItemBO.setOrderId(ordSalePO.getOrderId());
            uocToFscOrderItemBO.setOrderItemId(ordInspectionItemPO.getOrdItemId());
            uocToFscOrderItemBO.setAcceptOrderId(ordInspectionPO.getInspectionVoucherId());
            if (Objects.nonNull(ordGoodsPOMap.get(ordInspectionItemPO.getOrdItemId()))) {
                OrdGoodsPO ordGoodsPO = ordGoodsPOMap.get(ordInspectionItemPO.getOrdItemId());
                uocToFscOrderItemBO.setSkuId(Long.parseLong(ordGoodsPO.getSkuId()));
                uocToFscOrderItemBO.setSkuIdExt(ordGoodsPO.getSkuExtSkuId());
                uocToFscOrderItemBO.setSkuName(ordGoodsPO.getSkuName());
                uocToFscOrderItemBO.setSkuNo(ordGoodsPO.getSkuCode());
                uocToFscOrderItemBO.setSpec(ordGoodsPO.getSpec());
                uocToFscOrderItemBO.setModel(ordGoodsPO.getModel());
            }
            if (Objects.nonNull(ordItemPOMap.get(ordInspectionItemPO.getOrdItemId()))) {
                OrdItemPO ordItemPO = ordItemPOMap.get(ordInspectionItemPO.getOrdItemId());
                try {
                    uocToFscOrderItemBO.setPrice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice()));
                    uocToFscOrderItemBO.setSalePrice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice()));
                    uocToFscOrderItemBO.setPurchasePrice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getPurchasePrice()));
                    uocToFscOrderItemBO.setTaxRate(new BigDecimal(ordItemPO.getTax()).divide(new BigDecimal(100), 2, 4));
                    uocToFscOrderItemBO.setTaxCode(ordItemPO.getTaxId());
                }
                catch (Exception e) {
                    throw new UocProBusinessException("102073", "\u8f6c\u6362\u91d1\u989d\u5f02\u5e38");
                }
            }
            try {
                uocToFscOrderItemBO.setAmt(UocMoneyUtil.long2BigDecimal((Long)ordInspectionItemPO.getInspSaleFee()));
                uocToFscOrderItemBO.setSaleAmt(UocMoneyUtil.long2BigDecimal((Long)ordInspectionItemPO.getInspSaleFee()));
                uocToFscOrderItemBO.setPurchaseAmt(UocMoneyUtil.long2BigDecimal((Long)ordInspectionItemPO.getInspPurchaseFee()));
                uocToFscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)uocToFscOrderItemBO.getAmt(), (BigDecimal)uocToFscOrderItemBO.getTaxRate()));
                uocToFscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)uocToFscOrderItemBO.getSaleAmt(), (BigDecimal)uocToFscOrderItemBO.getTaxRate()));
                uocToFscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)uocToFscOrderItemBO.getPurchaseAmt(), (BigDecimal)uocToFscOrderItemBO.getTaxRate()));
                uocToFscOrderItemBO.setUntaxAmt(TaxUtils.calTaxAmt((BigDecimal)uocToFscOrderItemBO.getAmt(), (BigDecimal)uocToFscOrderItemBO.getTaxRate()));
                uocToFscOrderItemBO.setSaleUntaxAmt(uocToFscOrderItemBO.getSaleAmt().subtract(uocToFscOrderItemBO.getSaleTaxAmt()));
                uocToFscOrderItemBO.setPurchaseUntaxAmt(uocToFscOrderItemBO.getPurchaseAmt().subtract(uocToFscOrderItemBO.getPurchaseTaxAmt()));
                uocToFscOrderItemBO.setUnit(ordInspectionItemPO.getUnitName());
                uocToFscOrderItemBO.setNum(ordInspectionItemPO.getInspectionCount());
                uocToFscOrderItemBO.setInspSaleMoney(UocMoneyUtil.long2BigDecimal((Long)ordInspectionItemPO.getInspSaleFee()));
                uocToFscOrderItemBO.setInspPurchaseMoney(UocMoneyUtil.long2BigDecimal((Long)ordInspectionItemPO.getInspPurchaseFee()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            uocToFscOrderItemBOS.add(uocToFscOrderItemBO);
        }
    }

    private void buildInvoiceInfo(UocToFscInfoBO uocToFscInfoBO, OrdInvoicePO ordInvoicePO) {
        UocInvoiceBO uocInvoiceBO = new UocInvoiceBO();
        uocInvoiceBO.setInvoiceTitle(ordInvoicePO.getBuyerName());
        uocInvoiceBO.setInvoiceType(String.valueOf(ordInvoicePO.getInvoiceType()));
        uocInvoiceBO.setInvoiceClass(String.valueOf(ordInvoicePO.getInvoceCategory()));
        uocInvoiceBO.setTaxpayerId(ordInvoicePO.getInvoiceNo());
        uocInvoiceBO.setBank(ordInvoicePO.getDepositBank());
        uocInvoiceBO.setAccount(ordInvoicePO.getBankAccount());
        uocInvoiceBO.setPhone(ordInvoicePO.getRelaPhone());
        uocInvoiceBO.setAddress(ordInvoicePO.getCompanyAddress());
        uocToFscInfoBO.setUocInvoiceBo(uocInvoiceBO);
    }
}

