/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.pay.ability.api.FscShouldPayTerminationAbilityService;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfApplyCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfConfirmCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfApplyCancelOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfApplyCancelOrderRspBO;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityRspBo;
import com.tydic.uoc.common.atom.api.BgyCancelOrderToNcAtomService;
import com.tydic.uoc.common.atom.api.UocQrySupIdAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyCancelOrderToNcAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyCancelOrderToNcAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.busi.api.UocCallPlanCenterBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocProCancelBusiService;
import com.tydic.uoc.common.busi.api.UocProEcCancelBusiService;
import com.tydic.uoc.common.busi.bo.UocProEcCancelBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocProEcCancelBusiRspBo;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdFscShouldPayMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocProCancelBusiServiceImpl
implements UocProCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocProCancelBusiServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private PebIntfApplyCancelOrderAbilityService pebIntfApplyCancelOrderAbilityService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocCallPlanCenterBusiService uocCallPlanCenterBusiService;
    @Autowired
    private UocOrdFscShouldPayMapper ordFscShouldPayMapper;
    @Autowired
    private FscShouldPayTerminationAbilityService fscShouldPayTerminationAbilityService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocProEcCancelBusiService uocProEcCancelBusiService;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private PebIntfConfirmCancelOrderAbilityService pebIntfConfirmCancelOrderAbilityService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private UocQrySupIdAtomService uocQrySupIdAtomService;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private BgyCancelOrderToNcAtomService bgyCancelOrderToNcAtomService;

    @Override
    public BgyCatalogInCancelOrderAbilityRspBo dealOrderCancelled(BgyCatalogInCancelOrderAbilityReqBo reqBO) {
        boolean needAudit;
        BgyCatalogInCancelOrderAbilityRspBo rspBo = (BgyCatalogInCancelOrderAbilityRspBo)UocProRspBoUtil.success(BgyCatalogInCancelOrderAbilityRspBo.class);
        log.debug("\u6267\u884c\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c\uff0c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdItemPO qryItemPo = new OrdItemPO();
        qryItemPo.setOrderId(reqBO.getOrderId());
        List ordItemList = this.ordItemMapper.getList(qryItemPo);
        boolean startShip = false;
        for (OrdItemPO ordItemPO : ordItemList) {
            if (ordItemPO.getSendCount().compareTo(BigDecimal.ZERO) <= 0) continue;
            startShip = true;
            break;
        }
        boolean isPush = false;
        String orderSource = salePO.getOrderSource();
        Integer saleState = salePO.getSaleState();
        OrdCancelPO cancelPo = new OrdCancelPO();
        cancelPo.setId(Long.valueOf(this.idUtil.nextId()));
        cancelPo.setOrderId(reqBO.getOrderId());
        if ("1".equals(orderSource)) {
            if (UocConstant.SALE_ORDER_STATUS.CREATE.equals(saleState) || UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT.equals(saleState) || UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(saleState)) {
                needAudit = false;
            } else if (UocConstant.SALE_ORDER_STATUS.ZONE_TO_BE_SHIP.equals(saleState)) {
                needAudit = reqBO.getChangeOrder() == null || reqBO.getChangeOrder() == false;
                if (startShip) {
                    throw new UocProBusinessException("102035", "\u8be5\u8ba2\u5355\u5df2\u53d1\u8d27\u4e86\uff0c\u4e0d\u80fd\u53d6\u6d88");
                }
            } else {
                throw new UocProBusinessException("102035", "\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            if (needAudit) {
                this.audit(reqBO, cancelPo);
            }
        } else if ("2".equals(orderSource)) {
            if (UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT.equals(saleState) || UocConstant.SALE_ORDER_STATUS.CONFIRM_PRE_ORDER_FAILED.equals(saleState)) {
                needAudit = false;
            } else if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleState)) {
                needAudit = reqBO.getChangeOrder() == null || reqBO.getChangeOrder() == false;
                if (startShip) {
                    throw new UocProBusinessException("102035", "\u8be5\u8ba2\u5355\u5df2\u53d1\u8d27\u4e86\uff0c\u4e0d\u80fd\u53d6\u6d88");
                }
            } else {
                throw new UocProBusinessException("102035", "\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            if (needAudit) {
                this.sendApplyCancel(salePO);
            } else {
                UocProEcCancelBusiReqBo cancelReqBO = new UocProEcCancelBusiReqBo();
                BeanUtils.copyProperties((Object)reqBO, (Object)((Object)cancelReqBO));
                cancelReqBO.setCancelDesc(reqBO.getCancelReason());
                cancelReqBO.setCancelDesc(reqBO.getCancelReason());
                cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
                UocProEcCancelBusiRspBo ecCancelRspBo = this.uocProEcCancelBusiService.dealOrderCancel(cancelReqBO);
                if (!"0000".equals(ecCancelRspBo.getRespCode())) {
                    throw new UocProBusinessException("102035", "\u7535\u5546\u8ba2\u5355\u53d6\u6d88\u9519\u8bef\uff1a" + ecCancelRspBo.getRespDesc());
                }
            }
        } else {
            throw new UocProBusinessException("102035", "\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u6765\u6e90\uff08" + orderSource + "\uff09\u53d6\u6d88\u8ba2\u5355");
        }
        this.saveCancelData(salePO, reqBO, cancelPo);
        if (!needAudit) {
            this.runCancelOrderStatus(reqBO, cancelPo);
        }
        this.updateOrderCancelInfo(reqBO);
        this.saveAccessory(reqBO, cancelPo.getId());
        this.run(reqBO, needAudit);
        rspBo.setSaleId(salePO.getSaleVoucherId());
        if (needAudit && UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleState)) {
            this.sendMessage(salePO);
        }
        return rspBo;
    }

    private void sendMessage(OrdSalePO ordSalePO) {
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
        OrdPurchasePO ordPurchasePO = new OrdPurchasePO();
        ordPurchasePO.setOrderId(ordSalePO.getOrderId());
        ordPurchasePO.setPurchaseVoucherId(ordSalePO.getPurchaseVoucherId());
        ordPurchasePO = this.ordPurchaseMapper.getModelBy(ordPurchasePO);
        UocQrySupIdAtomReqBo uocQrySupIdAtomReqBo = new UocQrySupIdAtomReqBo();
        uocQrySupIdAtomReqBo.setSupNo(stakeholderPO.getSupNo());
        UocQrySupIdAtomRspBo uocQrySupIdAtomRspBo = this.uocQrySupIdAtomService.getSupIds(uocQrySupIdAtomReqBo);
        List<Long> supUserIds = uocQrySupIdAtomRspBo.getSupUserIds();
        for (Long supUserId : supUserIds) {
            UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
            sendMessageBo.setSendId(supUserId);
            sendMessageBo.setRecId(supUserId);
            sendMessageBo.setNoticeNodeCode("20018");
            sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7#}", ordPurchasePO.getPurchaseVoucherNo()));
            this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
        }
    }

    private void runCancelOrderStatus(BgyCatalogInCancelOrderAbilityReqBo reqBO, OrdCancelPO cancelPo) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(cancelPo.getId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("approve", "0");
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void updateOrderCancelInfo(BgyCatalogInCancelOrderAbilityReqBo reqBO) {
        OrderPO orderPO = new OrderPO();
        orderPO.setCancelReason(reqBO.getCancelReason());
        orderPO.setCancelDesc(reqBO.getCancelDesc());
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setCancelOperId(reqBO.getUsername());
        orderPO.setCancelTime(new Date());
        this.orderMapper.updateById(orderPO);
    }

    private void saveAccessory(BgyCatalogInCancelOrderAbilityReqBo reqBO, Long cancelId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        Long orderId = reqBO.getOrderId();
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.CANCEL);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(cancelId);
            ordAccessoryPO.setRemark("\u53d6\u6d88\u7533\u8bf7");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void run(BgyCatalogInCancelOrderAbilityReqBo reqBO, boolean needAudit) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        if (needAudit) {
            map.put("cancelFlag", "1");
        } else {
            map.put("auditFlag", "1");
            BgyCancelOrderToNcAtomReqBO cancelNcBo = new BgyCancelOrderToNcAtomReqBO();
            cancelNcBo.setOrderId(reqBO.getOrderId());
            BgyCancelOrderToNcAtomRspBO bgyCancelOrderToNcAtomRspBO = this.bgyCancelOrderToNcAtomService.cancelOrder(cancelNcBo);
            if (!"S".equalsIgnoreCase(bgyCancelOrderToNcAtomRspBO.getReturnStatus())) {
                throw new UocProBusinessException("102035", "\u8c03\u7528NC\u5904\u7406\u5931\u8d25\uff1a" + bgyCancelOrderToNcAtomRspBO.getReturnMsg());
            }
        }
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void audit(BgyCatalogInCancelOrderAbilityReqBo reqBO, OrdCancelPO cancelPO) {
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        noTaskAuditCreateReqBO.setCreateOperName(reqBO.getUsername());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        infoReqBO.setUsername(reqBO.getUsername());
        infoReqBO.setRemark("\u8ba2\u5355\u53d6\u6d88\u9700\u8981\u8fdb\u884c\u5ba1\u6279");
        infoReqBO.setOrderId(reqBO.getOrderId());
        infoReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        noTaskAuditCreateReqBO.setProcDefKey("cancelOrder");
        approvalObjBO.setObjId(String.valueOf(cancelPO.getId()));
        approvalObjBO.setOrderId(cancelPO.getOrderId());
        ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
        objBOS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBOS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBOS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        cancelPO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
    }

    private void sendApplyCancel(OrdSalePO salePO) {
        PebIntfApplyCancelOrderRspBO rspBO;
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(salePO.getOrderId().longValue());
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setOrderId(salePO.getOrderId());
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        indexPO.setObjId(salePO.getSaleVoucherId());
        indexPO = this.ordQueryIndexMapper.getModelBy(indexPO);
        PebIntfApplyCancelOrderReqBO reqBO = new PebIntfApplyCancelOrderReqBO();
        reqBO.setOrderId(indexPO.getOutOrderNo());
        reqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(salePO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            reqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((rspBO = this.pebIntfApplyCancelOrderAbilityService.applyCancel(reqBO)).getRespCode())) {
            throw new UocProBusinessException("102035", rspBO.getRespDesc());
        }
    }

    private void saveCancelData(OrdSalePO salePO, BgyCatalogInCancelOrderAbilityReqBo reqBO, OrdCancelPO cancelPo) {
        cancelPo.setCancelNo(this.biuldNo("", "QXSQ", "ORDER_CANCEL_NO", salePO.getOrderSource()));
        cancelPo.setCancelReason(reqBO.getCancelReason());
        cancelPo.setOrderId(salePO.getOrderId());
        cancelPo.setSaleVoucherId(salePO.getSaleVoucherId());
        if (reqBO.getUserId() != null) {
            cancelPo.setCreateOperId(String.valueOf(reqBO.getUserId()));
        }
        cancelPo.setCreateOperName(reqBO.getUsername());
        cancelPo.setCreateTime(new Date());
        cancelPo.setOrderStatus(salePO.getSaleState());
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        String orderSource = salePO.getOrderSource();
        if ("1".equals(orderSource)) {
            processStartReqBO.setProcDefKey("UOC_ORDER_CANCEL_AGR_KEY");
        } else if ("2".equals(orderSource)) {
            processStartReqBO.setProcDefKey("UOC_ORDER_CANCEL_EC_KEY");
        } else {
            throw new UocProBusinessException("102035", "\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u6765\u6e90\uff08" + orderSource + "\uff09\u53d6\u6d88\u8ba2\u5355(\u6d41\u7a0b\u56fekey)");
        }
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setOrderId(salePO.getOrderId());
        processStartReqBO.setObjId(cancelPo.getId());
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        UocProcessStartRspBO uocProcessStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(uocProcessStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101030", "\u6279\u91cf\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5931\u8d25!" + uocProcessStartRspBO.getRespDesc());
        }
        cancelPo.setStatus(Integer.valueOf(uocProcessStartRspBO.getStepId()));
        cancelPo.setDealOperId(reqBO.getUserId() != null ? reqBO.getUserId().toString() : null);
        cancelPo.setDealOperName(reqBO.getName());
        cancelPo.setDealTime(new Date());
        this.ordCancelMapper.insert(cancelPo);
    }

    private String biuldNo(String planNo, String pro, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102035", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.biuldNo(planNo, pro);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdCancelPO cancelPO = new OrdCancelPO();
        cancelPO.setCancelNo(no);
        int count = this.ordCancelMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }
}

