/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveFirstAtomService;
import com.tydic.uoc.common.atom.api.UocOtherOrderSourceExecuteAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstReqBO;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomDoBusiRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessStartReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessStartRspBO;
import com.tydic.uoc.common.busi.api.UocProCreateOrderBusiService;
import com.tydic.uoc.common.busi.bo.UocOtherOrderSourceExecuteAtomDoBusiDataRspBo;
import com.tydic.uoc.common.busi.bo.UocProCreateOrderBusiOrderDataRspBo;
import com.tydic.uoc.common.busi.bo.UocProCreateOrderBusiRspBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderAddressReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombCommodityTypeReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCompanyReqBo;
import com.tydic.uoc.config.UocOtherOrderSourceManager;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestCommodityTypeMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestCommodityTypePo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocProCreateOrderBusiServiceImpl
implements UocProCreateOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocProCreateOrderBusiServiceImpl.class);
    @Autowired
    private UocOtherOrderSourceManager uocOtherOrderSourceManager;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdRequestAddressMapper uocOrdRequestAddressMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private UocOrdRequestCommodityTypeMapper uocOrdRequestCommodityTypeMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private BgyRequestOrderApproveFirstAtomService bgyRequestOrderApproveFirstAtomService;

    @Override
    public UocProCreateOrderBusiRspBo createOrder(UocProCreateOrderCombReqBo reqBo) {
        UocProCreateOrderBusiRspBo rspBo = (UocProCreateOrderBusiRspBo)UocProRspBoUtil.success(UocProCreateOrderBusiRspBo.class);
        Long requestId = 0L;
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestId())) {
            requestId = this.sequence.nextId();
            reqBo.setRequestId(requestId);
        } else {
            requestId = reqBo.getRequestId();
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRequestCode())) {
            reqBo.setRequestCode(this.genRequestCode());
        }
        this.buildAndSaveRequestOrderInfo(reqBo);
        this.buildAndSaveAddressInfo(reqBo);
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        this.saveCommodityType(reqBo);
        this.executeCreateOrder(reqBo, rspBo, orderItemList);
        rspBo.setRequestId(requestId);
        rspBo.setRequestCode(reqBo.getRequestCode());
        rspBo.setTotalMoney(reqBo.getTotalFee());
        return rspBo;
    }

    private BgyRequestOrderApproveFirstReqBO buildAtomParam(UocProCreateOrderCombReqBo reqBO) {
        BgyRequestOrderApproveFirstReqBO atomReq = new BgyRequestOrderApproveFirstReqBO();
        atomReq.setRequestId(reqBO.getRequestId());
        atomReq.getRequestInfo().setApplyUserCode(String.valueOf(reqBO.getUserId()));
        atomReq.getRequestInfo().setStartUserCode(String.valueOf(reqBO.getUserId()));
        return atomReq;
    }

    private String genRequestCode() {
        String requestCode = "";
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode("ORDER_QGD_NO");
        getBo.setOrgType("-1");
        log.info("\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getBo));
        try {
            CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
            log.info("\u83b7\u53d6\u7f16\u53f7\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)encodedSerial));
            requestCode = (String)encodedSerial.getSerialNoList().get(0);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage());
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return requestCode;
    }

    private void executeCreateOrder(UocProCreateOrderCombReqBo reqBo, UocProCreateOrderBusiRspBo rspBo, List<UocProCreateOrderCombOrderItemReqBo> orderItemList) {
        Map<String, List<UocProCreateOrderCombOrderItemReqBo>> sourceListMap = orderItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getOrderSource));
        for (String orderSource : sourceListMap.keySet()) {
            UocOtherOrderSourceExecuteAtomService createOrderInstance = this.uocOtherOrderSourceManager.getInstance(orderSource);
            reqBo.setOrderItemList(sourceListMap.get(orderSource));
            if ("1".equals(orderSource)) {
                reqBo.setProcKey("cnnc_el_sale_order_master_order_status");
            } else if ("2".equals(orderSource)) {
                reqBo.setProcKey("cnnc_sales_order_master_order_status");
            } else {
                reqBo.setProcKey("cnnc_self_sale_order_master_order_status");
            }
            log.info("\u8c03\u7528\u4e0d\u540c\u8ba2\u5355\u6765\u6e90(" + orderSource + ")\u4e0b\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)((Object)reqBo)));
            UocOtherOrderSourceExecuteAtomDoBusiRspBo doBusiRspBo = createOrderInstance.doBusi(reqBo);
            if (!"0000".equals(doBusiRspBo.getRespCode())) {
                throw new UocProBusinessException(doBusiRspBo.getRespCode(), doBusiRspBo.getRespDesc());
            }
            for (UocOtherOrderSourceExecuteAtomDoBusiDataRspBo orderRspBo : doBusiRspBo.getOrderDataList()) {
                UocProCreateOrderBusiOrderDataRspBo busiRspOrderBo = new UocProCreateOrderBusiOrderDataRspBo();
                BeanUtils.copyProperties((Object)orderRspBo, (Object)((Object)busiRspOrderBo));
                busiRspOrderBo.setOrderSource(orderSource);
                rspBo.getOrderRspList().add(busiRspOrderBo);
            }
        }
    }

    private void saveCommodityType(UocProCreateOrderCombReqBo reqBo) {
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        HashMap<String, UocProCreateOrderCombCommodityTypeReqBo> cacheComTypeMap = new HashMap<String, UocProCreateOrderCombCommodityTypeReqBo>();
        for (UocProCreateOrderCombOrderItemReqBo combOrderItemReqBo : orderItemList) {
            UocProCreateOrderCombCommodityTypeReqBo commodityTypeReqBo = combOrderItemReqBo.getCommodityTypeReqBo();
            if (commodityTypeReqBo == null) continue;
            cacheComTypeMap.put(commodityTypeReqBo.getComTypeId(), commodityTypeReqBo);
        }
        if (!ObjectUtil.isEmpty(cacheComTypeMap)) {
            HashMap<String, Long> savedComTypeMap = new HashMap<String, Long>();
            for (String commTypeId : cacheComTypeMap.keySet()) {
                UocProCreateOrderCombCommodityTypeReqBo combCommodityTypeReqBo = (UocProCreateOrderCombCommodityTypeReqBo)cacheComTypeMap.get(commTypeId);
                UocOrdRequestCommodityTypePo saveCommodityTypePo = new UocOrdRequestCommodityTypePo();
                BeanUtils.copyProperties((Object)combCommodityTypeReqBo, (Object)saveCommodityTypePo);
                Long commodityDataId = this.sequence.nextId();
                saveCommodityTypePo.setComTypeDataId(commodityDataId);
                saveCommodityTypePo.setRequestId(reqBo.getRequestId());
                saveCommodityTypePo.setRequestCode(reqBo.getRequestCode());
                this.uocOrdRequestCommodityTypeMapper.insert(saveCommodityTypePo);
                savedComTypeMap.put(commTypeId, commodityDataId);
            }
            for (UocProCreateOrderCombOrderItemReqBo combOrderItemReqBo : orderItemList) {
                UocProCreateOrderCombCommodityTypeReqBo commodityTypeReqBo = combOrderItemReqBo.getCommodityTypeReqBo();
                if (commodityTypeReqBo == null) continue;
                combOrderItemReqBo.setComTypeDataId((Long)savedComTypeMap.get(commodityTypeReqBo.getComTypeId()));
            }
        }
    }

    private void buildAndSaveAddressInfo(UocProCreateOrderCombReqBo reqBo) {
        Long addressId = this.sequence.nextId();
        reqBo.getAddressBo().setRequestAddressId(addressId);
        reqBo.setRequestAddressId(addressId);
        UocProCreateOrderAddressReqBo addressBo = reqBo.getAddressBo();
        UocOrdRequestAddressPo addAddrPo = new UocOrdRequestAddressPo();
        BeanUtils.copyProperties((Object)addressBo, (Object)addAddrPo);
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactTown(addressBo.getReceiverTown());
        addAddrPo.setContactTownId(addressBo.getReceiverTownId());
        addAddrPo.setContactAddress(addressBo.getReceiverAddress());
        addAddrPo.setContactCompany(addressBo.getReceiverCompany());
        addAddrPo.setContactFixPhone(addressBo.getReceiverFixPhone());
        addAddrPo.setContactMobile(addressBo.getReceiverMobileNumber());
        addAddrPo.setContactName(addressBo.getReceiverName());
        addAddrPo.setContactEmail(addressBo.getReceiverEmail());
        addAddrPo.setContactCountryName(addressBo.getReceiverCountryName());
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactProvinceName(addressBo.getReceiverProvinceName());
        addAddrPo.setContactProvinceId(addressBo.getReceiverProvinceId());
        addAddrPo.setContactCityName(addressBo.getReceiverCityName());
        addAddrPo.setContactCityId(addressBo.getReceiverCityId());
        addAddrPo.setContactCountyName(addressBo.getReceiverCountyName());
        addAddrPo.setContactBip(addressBo.getCertName());
        addAddrPo.setOrgType(addressBo.getOrgType());
        addAddrPo.setRequestAddressId(addressId);
        addAddrPo.setRequestId(reqBo.getRequestId());
        addAddrPo.setRequestCode(reqBo.getRequestCode());
        this.uocOrdRequestAddressMapper.insert(addAddrPo);
    }

    private void buildAndSaveRequestOrderInfo(UocProCreateOrderCombReqBo reqBo) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefKey("BGY_REQUEST_ORDER_STATUS");
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setOrderId(reqBo.getRequestId());
        processStartReqBO.setObjId(reqBo.getRequestId());
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        UocProcessStartRspBO uocProcessStartRspBO = this.uocStartProcessAtomService.start(processStartReqBO);
        if (!"0000".equals(uocProcessStartRspBO.getRespCode())) {
            throw new UocProBusinessException("101030", "\u6279\u91cf\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5931\u8d25!" + uocProcessStartRspBO.getRespDesc());
        }
        UocProCreateOrderCompanyReqBo companyInfoBo = reqBo.getCompanyInfoBo();
        UocOrdRequestPo saveRequestPo = new UocOrdRequestPo();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)saveRequestPo);
        BeanUtils.copyProperties((Object)companyInfoBo, (Object)saveRequestPo);
        saveRequestPo.setRequestTime(new Date());
        saveRequestPo.setRequestStatus(Integer.valueOf(uocProcessStartRspBO.getStepId()));
        saveRequestPo.setRequestManWorkNo(reqBo.getWorkNo());
        if (reqBo.getOrgIdIn() != null) {
            saveRequestPo.setRequestDeptId(reqBo.getOrgIdIn().toString());
        }
        saveRequestPo.setRequestDeptName(reqBo.getOrgName());
        saveRequestPo.setOrgTreePath(reqBo.getOrgPath());
        if (reqBo.getOrgId() != null) {
            saveRequestPo.setRequestDeptId(reqBo.getOrgId().toString());
        }
        saveRequestPo.setRequestDeptName(reqBo.getOrgName());
        saveRequestPo.setAccountId(reqBo.getPurchaserAccount());
        saveRequestPo.setAccountName(reqBo.getPurchaserAccountName());
        saveRequestPo.setYsDeptId(companyInfoBo.getYsDeptId());
        saveRequestPo.setYsDeptName(companyInfoBo.getYsDeptName());
        saveRequestPo.setProfitId(companyInfoBo.getProfitId());
        saveRequestPo.setProfitName(companyInfoBo.getProfitName());
        saveRequestPo.setRequestManId(reqBo.getUserId().toString());
        saveRequestPo.setRequestManName(reqBo.getName());
        saveRequestPo.setRequestDeptId(companyInfoBo.getRequestDeptId());
        saveRequestPo.setRequestDeptName(companyInfoBo.getRequestDeptName());
        saveRequestPo.setRequestDept(companyInfoBo.getRequestDept());
        saveRequestPo.setRequestManDeptId(reqBo.getOrgIdIn() != null ? reqBo.getOrgIdIn().toString() : null);
        saveRequestPo.setRequestManDeptName(reqBo.getOrgName());
        saveRequestPo.setRequestManBip(reqBo.getUsername());
        if (!ObjectUtil.isEmpty((Object)companyInfoBo.getIsFix())) {
            saveRequestPo.setIsFix(Integer.valueOf(companyInfoBo.getIsFix()));
        }
        if (!ObjectUtil.isEmpty((Object)companyInfoBo.getFitmentStandard())) {
            saveRequestPo.setFitmentStandard(Integer.valueOf(companyInfoBo.getFitmentStandard()));
        }
        if (ObjectUtil.isEmpty((Object)saveRequestPo.getRequestOrgId()) || ObjectUtil.isEmpty((Object)saveRequestPo.getRequestOrgName())) {
            saveRequestPo.setRequestOrgId(reqBo.getOrderItemList().get(0).getPurchasId());
            saveRequestPo.setRequestOrgName(reqBo.getOrderItemList().get(0).getPurchasName());
        }
        try {
            saveRequestPo.setPredictFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getTotalFee()));
            saveRequestPo.setCommodityTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getCommodityTotalFee()));
            saveRequestPo.setRequestTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getTotalFee()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        this.uocOrdRequestMapper.insert(saveRequestPo);
    }
}

