/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.atom.api.UocCoreChgVoucherStateAtomService;
import com.tydic.uoc.common.atom.api.UocCoreQryTacheIntfAtomService;
import com.tydic.uoc.common.atom.api.UocPebRefundAtomService;
import com.tydic.uoc.common.atom.api.UocPebUniCallIntfAtomService;
import com.tydic.uoc.common.atom.api.UocQrySaleOrderAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.uoc.common.atom.bo.VoucherStateBO;
import com.tydic.uoc.common.busi.api.UocCreateOrderReflectManagerExcuteBusiService;
import com.tydic.uoc.common.busi.api.UocPayOrderReFundBusiService;
import com.tydic.uoc.common.busi.api.UocProEcCancelBusiService;
import com.tydic.uoc.common.busi.bo.UocCreateOrderReflectManagerExcuteBusiServiceReqBo;
import com.tydic.uoc.common.busi.bo.UocCreateOrderReflectManagerExcuteBusiServiceRspBo;
import com.tydic.uoc.common.busi.bo.UocProEcCancelBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocProEcCancelBusiRspBo;
import com.tydic.uoc.dao.OrdPayApplyMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocProEcCancelBusiServiceImpl
implements UocProEcCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocProEcCancelBusiServiceImpl.class);
    @Autowired
    private UocPebRefundAtomService uocPebRefundAtomService;
    @Autowired
    private UocQrySaleOrderAtomService saleOrderAtomService;
    @Autowired
    private UocPebUniCallIntfAtomService uocPebUniCallIntfAtomService;
    @Autowired
    private UocCoreQryTacheIntfAtomService uocCoreQryTacheIntfAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Value(value="${UOC_ORDER_CANCEL_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CANCEL_TAG}")
    private String tag;
    @Resource(name="uocPebOrderCancelMsgProvider")
    private ProxyMessageProducer uocPebOrderCancelMsgProvider;
    @Value(value="${uoc.reverse:false}")
    private Boolean reverse;
    @Autowired
    private UocPayOrderReFundBusiService uocPayOrderReFundBusiService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdPayApplyMapper ordPayApplyMapper;
    @Autowired
    private UocCreateOrderReflectManagerExcuteBusiService uocCreateOrderReflectManagerExcuteBusiService;

    @Override
    public UocProEcCancelBusiRspBo dealOrderCancel(UocProEcCancelBusiReqBo reqBO) {
        UocProEcCancelBusiRspBo rspBo = (UocProEcCancelBusiRspBo)UocProRspBoUtil.success(UocProEcCancelBusiRspBo.class);
        this.validateArg(reqBO);
        rspBo.setSaleId(reqBO.getSaleVoucherId());
        UocCreateOrderReflectManagerExcuteBusiServiceReqBo callReqBo = new UocCreateOrderReflectManagerExcuteBusiServiceReqBo();
        callReqBo.setOrderId(reqBO.getOrderId());
        callReqBo.setObjId(reqBO.getSaleVoucherId());
        callReqBo.setObjType(UocConstant.OBJ_TYPE.SALE);
        callReqBo.setInterCode("ElcOrderCancel");
        UocCreateOrderReflectManagerExcuteBusiServiceRspBo callRetBo = this.uocCreateOrderReflectManagerExcuteBusiService.dealMethod(callReqBo);
        if (!"0000".equals(callRetBo.getRespCode())) {
            throw new UocProBusinessException(callRetBo.getRespCode(), "\u7535\u5546\u8ba2\u5355\u8c03\u7528\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3\u5931\u8d25\uff1a" + callRetBo.getRespDesc());
        }
        return rspBo;
    }

    private void updateOrder(UocProEcCancelBusiReqBo reqBO, OrderPO orderPO) {
        orderPO.setCancelDesc(reqBO.getCancelDesc() == null ? "\u8ba2\u5355\u53d6\u6d88" : reqBO.getCancelDesc());
        orderPO.setCancelReason(reqBO.getCancelReason());
        orderPO.setCancelTime(new Date());
        if (reqBO.getCancelOperId() != null) {
            orderPO.setCancelOperId(reqBO.getCancelOperId());
        } else {
            orderPO.setCancelOperId(reqBO.getUserId() == null ? orderPO.getCreateOperId() : String.valueOf(reqBO.getUserId()));
        }
        orderPO.setProcState(reqBO.getFailCode());
        orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.CANCEL);
        try {
            this.orderMapper.updateById(orderPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355\u53d6\u6d88\u66f4\u6539\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
    }

    private void updateStatus(UocProEcCancelBusiReqBo reqBO, OrdSaleRspBO saleRspBO, OrderPO orderPO) {
        UocCoreChgVoucherStateReqBO voucherStateReqBO = new UocCoreChgVoucherStateReqBO();
        voucherStateReqBO.setDealDesc("\u8ba2\u5355\u53d6\u6d88");
        if (reqBO.getCancelOperId() != null) {
            voucherStateReqBO.setOperId(reqBO.getCancelOperId());
        } else {
            voucherStateReqBO.setOperId(orderPO.getCreateOperId());
        }
        voucherStateReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<VoucherStateBO> voucherStateBOS = new ArrayList<VoucherStateBO>();
        VoucherStateBO voucherStateBO = new VoucherStateBO();
        voucherStateBO.setAfterState(UocConstant.SALE_ORDER_STATUS.CANCEL);
        voucherStateBO.setObjId(saleRspBO.getSaleVoucherId());
        voucherStateBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        voucherStateBOS.add(voucherStateBO);
        voucherStateReqBO.setVoucherStateList(voucherStateBOS);
        UocCoreChgVoucherStateRspBO rspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(voucherStateReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("102078", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u72b6\u6001\u673a\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u66f4\u65b0\u72b6\u6001\u5931\u8d25," + rspBO.getRespDesc());
        }
    }

    private void validateArg(UocProEcCancelBusiReqBo reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCancelOperId()) && reqBO.getUserId() != null) {
            reqBO.setCancelOperId(reqBO.getUserId().toString());
        }
    }
}

