/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfConfirmCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfConfirmCancelOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfConfirmCancelOrderRspBO;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderRevocationAccessBo;
import com.tydic.uoc.common.ability.bo.UocProOrderCancelOperationAblityOrderReqBo;
import com.tydic.uoc.common.atom.api.BgyCancelOrderToNcAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyCancelOrderToNcAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyCancelOrderToNcAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.busi.api.UocProOrderCancelOperationBusiService;
import com.tydic.uoc.common.busi.bo.UocProOrderCancelOperationBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocProOrderCancelOperationBusiRspBo;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocProOrderCancelOperationBusiServiceImpl
implements UocProOrderCancelOperationBusiService {
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private PebIntfConfirmCancelOrderAbilityService pebIntfConfirmCancelOrderAbilityService;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Autowired
    private BgyCancelOrderToNcAtomService bgyCancelOrderToNcAtomService;

    @Override
    public UocProOrderCancelOperationBusiRspBo cancelOrder(UocProOrderCancelOperationBusiReqBo reqBo) {
        this.validateArg(reqBo);
        UocProOrderCancelOperationBusiRspBo rspBo = (UocProOrderCancelOperationBusiRspBo)UocProRspBoUtil.success(UocProOrderCancelOperationBusiRspBo.class);
        List<UocProOrderCancelOperationAblityOrderReqBo> orderInfo = reqBo.getOrderInfo();
        String operation = reqBo.getOperation();
        for (UocProOrderCancelOperationAblityOrderReqBo orderBo : orderInfo) {
            OrdCancelPO cancelPO = this.ordCancelMapper.getModelById(orderBo.getCancelId().longValue());
            if (cancelPO == null) {
                throw new UocProBusinessException("102115", "\u8be5\u53d6\u6d88\u5355\uff1a" + orderBo.getCancelId() + "\u4e0d\u5b58\u5728");
            }
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderBo.getOrderId());
            ordSalePO.setSaleVoucherId(orderBo.getSaleVoucherId());
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            if (ordSalePO == null) {
                throw new UocProBusinessException("102115", "\u8be5\u8ba2\u5355\uff1a" + orderBo.getOrderId() + "\u4e0d\u5b58\u5728");
            }
            if (!CollectionUtils.isEmpty(reqBo.getAccessoryList())) {
                this.saveAccessory(reqBo, cancelPO.getId(), orderBo.getOrderId());
            }
            String orderSource = ordSalePO.getOrderSource();
            Integer saleState = ordSalePO.getSaleState();
            Integer cancelStatus = cancelPO.getStatus();
            if ("1".equals(operation) || "2".equals(operation) || "3".equals(operation)) {
                boolean finish;
                if (!UocConstant.SALE_ORDER_STATUS.CANCEL_ORDER_REQUEST.equals(saleState)) {
                    throw new UocProBusinessException("102115", "\u8ba2\u5355\u5fc5\u987b\u4e3a\u53d6\u6d88\u7533\u8bf7\u4e2d\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c");
                }
                if (!UocConstant.CANCEL_ORDER_STATUS.CANCEL_AUDIT.equals(cancelStatus)) {
                    throw new UocProBusinessException("102115", "\u53d6\u6d88\u5355\u5fc5\u987b\u4e3a\u5ba1\u6279\u4e2d\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c");
                }
                boolean approved = false;
                boolean cancelOrder = false;
                boolean needRunSaleState = true;
                if ("1".equals(operation)) {
                    cancelOrder = true;
                    approved = true;
                    this.cancelNcOrder(orderBo);
                } else if (!"2".equals(orderSource) && "2".equals(operation)) {
                    needRunSaleState = false;
                }
                if (!"2".equals(orderSource) && !(finish = this.dealAudit(orderBo, cancelPO, reqBo, approved))) continue;
                if (needRunSaleState) {
                    this.run(ordSalePO, cancelOrder, reqBo);
                }
                Map<String, Object> map = this.getMap(operation);
                this.runCancel(reqBo, cancelPO, map);
                if ("1".equals(operation) || "2".equals(operation)) {
                    OrdCancelPO updateSupPo = new OrdCancelPO();
                    updateSupPo.setId(cancelPO.getId());
                    updateSupPo.setSupOperId(reqBo.getUserId() != null ? reqBo.getUserId().toString() : null);
                    updateSupPo.setSupOperName(reqBo.getName());
                    updateSupPo.setSupOperContent(reqBo.getDealDesc());
                    updateSupPo.setSupReplyDate(new Date());
                    this.ordCancelMapper.updateById(updateSupPo);
                }
                if ("2".equals(orderSource)) {
                    this.confirmOrder(reqBo, ordSalePO);
                }
                if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleState)) continue;
                this.sendMessage(ordSalePO, approved);
                continue;
            }
            if (!UocConstant.SALE_ORDER_STATUS.CANCEL_ORDER_REQUEST.equals(saleState)) {
                throw new UocProBusinessException("102115", "\u8ba2\u5355\u5fc5\u987b\u4e3a\u53d6\u6d88\u8ba2\u5355\u7533\u8bf7\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c");
            }
            if (("4".equals(operation) || "5".equals(operation)) && !UocConstant.CANCEL_ORDER_STATUS.CANCEL_FAILED.equals(cancelStatus)) {
                throw new UocProBusinessException("102115", "\u53d6\u6d88\u5355\u5fc5\u987b\u4e3a\u5ba1\u6279\u9a73\u56de\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c");
            }
            if ("6".equals(operation) || "7".equals(operation)) {
                if (!UocConstant.CANCEL_ORDER_STATUS.REQUEST_MAN_INTERVENE.equals(cancelStatus)) {
                    throw new UocProBusinessException("102115", "\u53d6\u6d88\u5355\u5fc5\u987b\u4e3a\u91c7\u8d2d\u5458\u4ecb\u5165\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c");
                }
                OrdCancelPO updateSupPo = new OrdCancelPO();
                updateSupPo.setId(cancelPO.getId());
                updateSupPo.setBuyerOperId(reqBo.getUserId() != null ? reqBo.getUserId().toString() : null);
                updateSupPo.setBuyerOperName(reqBo.getName());
                updateSupPo.setBuyerReplyContent(reqBo.getDealDesc());
                updateSupPo.setBuyerReplyDate(new Date());
                this.ordCancelMapper.updateById(updateSupPo);
            }
            if ("4".equals(operation) || "6".equals(operation)) {
                this.run(ordSalePO, true, reqBo);
            } else if ("7".equals(operation)) {
                this.run(ordSalePO, false, reqBo);
            }
            Map<String, Object> map = this.getMap(operation);
            this.runCancel(reqBo, cancelPO, map);
            if (!"6".equals(operation)) continue;
            this.cancelNcOrder(orderBo);
        }
        return rspBo;
    }

    private void cancelNcOrder(UocProOrderCancelOperationAblityOrderReqBo orderBo) {
        BgyCancelOrderToNcAtomReqBO cancelNcBo = new BgyCancelOrderToNcAtomReqBO();
        cancelNcBo.setOrderId(orderBo.getOrderId());
        BgyCancelOrderToNcAtomRspBO bgyCancelOrderToNcAtomRspBO = this.bgyCancelOrderToNcAtomService.cancelOrder(cancelNcBo);
        if (!"S".equalsIgnoreCase(bgyCancelOrderToNcAtomRspBO.getReturnStatus())) {
            throw new UocProBusinessException("102035", "\u8c03\u7528NC\u5904\u7406\u5931\u8d25\uff1a" + bgyCancelOrderToNcAtomRspBO.getReturnMsg());
        }
    }

    private void saveAccessory(UocProOrderCancelOperationBusiReqBo reqBO, Long cancelId, Long orderId) {
        if (CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (BgyCatalogInCancelOrderRevocationAccessBo accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER_SUP);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.CANCEL);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(cancelId);
            ordAccessoryPO.setRemark("\u53d6\u6d88\u7533\u8bf7");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private void sendMessage(OrdSalePO ordSalePO, Boolean isSuccess) {
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(ordSalePO.getRequestId());
        UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
        sendMessageBo.setSendId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setRecId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        if (isSuccess.booleanValue()) {
            sendMessageBo.setNoticeNodeCode("20019");
        } else {
            sendMessageBo.setNoticeNodeCode("20020");
        }
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u8bf7\u8d2d\u5355\u7f16\u53f7#}", uocOrdRequestPo.getRequestCode()));
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", ordSalePO.getSaleVoucherNo()));
        this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
    }

    private Map<String, Object> getMap(String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        if ("1".equals(operation)) {
            map.put("approve", "0");
        } else if ("2".equals(operation)) {
            map.put("approve", "1");
        } else if ("3".equals(operation)) {
            map.put("approve", "2");
        } else if ("4".equals(operation)) {
            map.put("reject", "1");
        } else if ("5".equals(operation)) {
            map.put("reject", "0");
        } else if ("6".equals(operation)) {
            map.put("approve", "1");
        } else if ("7".equals(operation)) {
            map.put("approve", "0");
        }
        return map;
    }

    private void confirmOrder(UocProOrderCancelOperationBusiReqBo reqBO, OrdSalePO ordSalePO) {
        PebIntfConfirmCancelOrderRspBO rspBO;
        String operation = reqBO.getOperation();
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setOrderId(ordSalePO.getOrderId());
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        indexPO.setObjId(ordSalePO.getSaleVoucherId());
        indexPO = this.ordQueryIndexMapper.getModelBy(indexPO);
        PebIntfConfirmCancelOrderReqBO orderReqBO = new PebIntfConfirmCancelOrderReqBO();
        orderReqBO.setOrderId(indexPO.getOutOrderNo());
        orderReqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
        if ("2".equals(operation) || "3".equals(operation)) {
            orderReqBO.setCancelFlag(Integer.valueOf(1));
        } else {
            orderReqBO.setCancelFlag(Integer.valueOf(0));
        }
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(ordSalePO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            orderReqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((rspBO = this.pebIntfConfirmCancelOrderAbilityService.confirmCancelOrder(orderReqBO)).getRespCode())) {
            throw new UocProBusinessException("102013", rspBO.getRespDesc());
        }
    }

    private void runCancel(UocProOrderCancelOperationBusiReqBo reqBo, OrdCancelPO cancelPO, Map<String, Object> map) {
        UocProcessRunRspBO uocProcessRunRspBO;
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(cancelPO.getId());
        processRunReqBO.setOrderId(cancelPO.getOrderId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        processRunReqBO.setOperId(String.valueOf(reqBo.getUserId()));
        if (!ObjectUtil.isEmpty(map)) {
            processRunReqBO.setVariables(map);
        }
        if (!"0000".equals((uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO)).getRespCode())) {
            throw new UocProBusinessException("102013", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void run(OrdSalePO ordSalePO, boolean approved, UocProOrderCancelOperationBusiReqBo reqBo) {
        UocProcessRunRspBO uocProcessRunRspBO;
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(ordSalePO.getSaleVoucherId());
        processRunReqBO.setOrderId(ordSalePO.getOrderId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOperId(String.valueOf(reqBo.getUserId()));
        if (approved) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("auditFlag", "1");
            processRunReqBO.setVariables(map);
        }
        if (!"0000".equals((uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO)).getRespCode())) {
            throw new UocProBusinessException("102013", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private boolean dealAudit(UocProOrderCancelOperationAblityOrderReqBo orderInfo, OrdCancelPO cancelPO, UocProOrderCancelOperationBusiReqBo reqBo, boolean approved) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        uacNoTaskAuditOrderAuditReqBO.setStepId(cancelPO.getStepId());
        if (cancelPO.getStepId() == null) {
            throw new UocProBusinessException("102013", "\u5ba1\u6279\u5df2\u7ed3\u675f");
        }
        if (approved) {
            uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(0));
        } else {
            uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(1));
        }
        uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBo.getUserId()));
        uacNoTaskAuditOrderAuditReqBO.setUsername(reqBo.getUsername());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBo.getDealDesc());
        uacNoTaskAuditOrderAuditReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        ArrayList<Long> objIds = new ArrayList<Long>();
        objIds.add(cancelPO.getId());
        uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("102013", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
        }
        if (!uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
            cancelPO.setStepId(uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId());
            this.ordCancelMapper.updateById(cancelPO);
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }

    private void validateArg(UocProOrderCancelOperationBusiReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocProOrderCancelOperationAblityOrderReqBo> orderInfo = reqBo.getOrderInfo();
        if (ObjectUtil.isEmpty(orderInfo)) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderInfo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOperation())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[operation]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocProOrderCancelOperationAblityOrderReqBo order : orderInfo) {
            this.validateOrder(order);
        }
        String operations = "1,2,3,4,5,6,7";
        if (!operations.contains(reqBo.getOperation())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[operation]\u9519\u8bef");
        }
    }

    private void validateOrder(UocProOrderCancelOperationAblityOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleVoucherId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[cancelId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

