/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.atom.api.BgyQrySapParamAtomService;
import com.tydic.uoc.common.atom.api.BgySAPBudgetOccupyAtomService;
import com.tydic.uoc.common.atom.api.UocOtherOrderSourceExecuteAtomService;
import com.tydic.uoc.common.atom.api.UocStartProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstRspBO;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyReqBO;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyRsp;
import com.tydic.uoc.common.atom.bo.SapRequestParamBO;
import com.tydic.uoc.common.atom.bo.SapRequestParamBody;
import com.tydic.uoc.common.atom.bo.SapRequestParamHeader;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomDoBusiRspBo;
import com.tydic.uoc.common.busi.api.UocProUpdateOrderBusiService;
import com.tydic.uoc.common.busi.bo.UocOtherOrderSourceExecuteAtomDoBusiDataRspBo;
import com.tydic.uoc.common.busi.bo.UocProCreateOrderBusiOrderDataRspBo;
import com.tydic.uoc.common.busi.bo.UocProCreateOrderBusiRspBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderAddressReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombCommodityTypeReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCompanyReqBo;
import com.tydic.uoc.common.comb.bo.UocProUpdateOrderCombReqBo;
import com.tydic.uoc.config.UocOtherOrderSourceManager;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestCommodityTypeMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestCommodityTypePo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocProUpdateOrderBusiServiceImpl
implements UocProUpdateOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocProUpdateOrderBusiServiceImpl.class);
    @Autowired
    private UocOtherOrderSourceManager uocOtherOrderSourceManager;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private UocOrdRequestAddressMapper uocOrdRequestAddressMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private UocOrdRequestCommodityTypeMapper uocOrdRequestCommodityTypeMapper;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private BgySAPBudgetOccupyAtomService bgySAPBudgetOccupyAtomService;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private BgyQrySapParamAtomService bgyQrySapParamAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${isSapBuggget:false}")
    private boolean isSapBuggget;
    @Value(value="${sap_lyxt}")
    private String lyxt;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @Override
    public UocProCreateOrderBusiRspBo updateOrder(UocProUpdateOrderCombReqBo reqBo) {
        UocProCreateOrderBusiRspBo rspBo = (UocProCreateOrderBusiRspBo)UocProRspBoUtil.success(UocProCreateOrderBusiRspBo.class);
        BgyRequestOrderApproveFirstRspBO approveFirstRspBO = new BgyRequestOrderApproveFirstRspBO();
        Long requestId = reqBo.getRequestId();
        this.buildAndSaveRequestOrderInfo(reqBo);
        this.buildAndSaveAddressInfo(reqBo);
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        this.saveCommodityType(reqBo);
        if (ObjectUtil.isNotEmpty(orderItemList)) {
            this.validateSupplierLimit(orderItemList);
            Integer maxNum = 0;
            Integer oldMaxNum = this.ordItemMapper.getMaxNum(requestId);
            maxNum = ObjectUtil.isNotEmpty((Object)oldMaxNum) ? Integer.valueOf(oldMaxNum + 10) : Integer.valueOf(10);
            for (UocProCreateOrderCombOrderItemReqBo element : orderItemList) {
                element.setSapSkuLineNum(maxNum);
                maxNum = maxNum + 10;
            }
            if (this.isSapBuggget) {
                UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
                if (!UocConstant.CostType.COST.equals(reqBo.getCostType())) {
                    this.validateYs(reqBo, requestId, uocOrdRequestPo);
                }
            }
            this.executeCreateOrder(reqBo, rspBo, orderItemList);
        }
        rspBo.setRequestId(requestId);
        rspBo.setRequestCode(reqBo.getRequestCode());
        rspBo.setTotalMoney(reqBo.getTotalFee());
        return rspBo;
    }

    private void validateSupplierLimit(List<UocProCreateOrderCombOrderItemReqBo> orderItemList) {
        Map<String, List<UocProCreateOrderCombOrderItemReqBo>> supplierMap = orderItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getGoodsSupplierId));
        for (String supplier : supplierMap.keySet()) {
            Long limit;
            Long totalPrice = 0L;
            List<UocProCreateOrderCombOrderItemReqBo> uocProCreateOrderCombOrderItemReqBos = supplierMap.get(supplier);
            String supName = uocProCreateOrderCombOrderItemReqBos.get(0).getSupplierName();
            for (UocProCreateOrderCombOrderItemReqBo uocProCreateOrderCombOrderItemReqBo : uocProCreateOrderCombOrderItemReqBos) {
                BigDecimal salePrice = uocProCreateOrderCombOrderItemReqBo.getSkuSalePrice().multiply(uocProCreateOrderCombOrderItemReqBo.getPurchaseCount());
                totalPrice = totalPrice + salePrice.longValue();
            }
            System.out.println("\u4f9b\u5e94\u5546[" + supName + "]\u4ef7\u683c\uff1a" + totalPrice);
            ConfSupplierPO qrySup = new ConfSupplierPO();
            qrySup.setSupNo(Long.valueOf(supplier));
            qrySup.setLimitStatus(Integer.valueOf(0));
            ConfSupplierPO modelBy = this.confSupplierMapper.getModelBy(qrySup);
            if (modelBy == null || (limit = modelBy.getOrderLimit()) == null || limit <= 0L || limit <= totalPrice) continue;
            String money = null;
            try {
                money = UocMoneyUtil.long2BigDecimal((Long)limit).toString();
            }
            catch (Exception e) {
                throw new UocProBusinessException("102107", "\u4f9b\u5e94\u5546\u6700\u4f4e\u9650\u989d\u6821\u9a8c\u524d\uff0c\u91d1\u989d\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            throw new UocProBusinessException("102107", "\u4f9b\u5e94\u5546\uff1a" + supName + "\uff0c\u6700\u4f4e\u4e0b\u5355\u91d1\u989d\u4e3a\uff1a" + money + "\u5143");
        }
    }

    private void executeCreateOrder(UocProUpdateOrderCombReqBo reqBo, UocProCreateOrderBusiRspBo rspBo, List<UocProCreateOrderCombOrderItemReqBo> orderItemList) {
        Map<String, List<UocProCreateOrderCombOrderItemReqBo>> sourceListMap = orderItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getOrderSource));
        for (String orderSource : sourceListMap.keySet()) {
            UocOtherOrderSourceExecuteAtomService createOrderInstance = this.uocOtherOrderSourceManager.getInstance(orderSource);
            reqBo.setOrderItemList(sourceListMap.get(orderSource));
            if ("1".equals(orderSource)) {
                reqBo.setProcKey("cnnc_el_sale_order_master_order_status");
            } else if ("2".equals(orderSource)) {
                reqBo.setProcKey("cnnc_sales_order_master_order_status");
            } else {
                reqBo.setProcKey("cnnc_self_sale_order_master_order_status");
            }
            UocProCreateOrderCombReqBo busiReqbo = new UocProCreateOrderCombReqBo();
            BeanUtils.copyProperties((Object)((Object)reqBo), (Object)((Object)busiReqbo));
            UocOtherOrderSourceExecuteAtomDoBusiRspBo doBusiRspBo = createOrderInstance.doBusi(busiReqbo);
            if (!"0000".equals(doBusiRspBo.getRespCode())) {
                throw new UocProBusinessException(doBusiRspBo.getRespCode(), doBusiRspBo.getRespDesc());
            }
            for (UocOtherOrderSourceExecuteAtomDoBusiDataRspBo orderRspBo : doBusiRspBo.getOrderDataList()) {
                UocProCreateOrderBusiOrderDataRspBo busiRspOrderBo = new UocProCreateOrderBusiOrderDataRspBo();
                BeanUtils.copyProperties((Object)orderRspBo, (Object)((Object)busiRspOrderBo));
                busiRspOrderBo.setOrderSource(orderSource);
                rspBo.getOrderRspList().add(busiRspOrderBo);
            }
        }
    }

    private void saveCommodityType(UocProUpdateOrderCombReqBo reqBo) {
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        HashMap<String, UocProCreateOrderCombCommodityTypeReqBo> cacheComTypeMap = new HashMap<String, UocProCreateOrderCombCommodityTypeReqBo>();
        for (UocProCreateOrderCombOrderItemReqBo combOrderItemReqBo : orderItemList) {
            UocProCreateOrderCombCommodityTypeReqBo commodityTypeReqBo = combOrderItemReqBo.getCommodityTypeReqBo();
            if (commodityTypeReqBo == null) continue;
            cacheComTypeMap.put(commodityTypeReqBo.getComTypeId(), commodityTypeReqBo);
        }
        if (!ObjectUtil.isEmpty(cacheComTypeMap)) {
            HashMap<String, Long> savedComTypeMap = new HashMap<String, Long>();
            for (String commTypeId : cacheComTypeMap.keySet()) {
                Long commodityDataId = this.sequence.nextId();
                UocProCreateOrderCombCommodityTypeReqBo combCommodityTypeReqBo = (UocProCreateOrderCombCommodityTypeReqBo)cacheComTypeMap.get(commTypeId);
                UocOrdRequestCommodityTypePo saveCommodityTypePo = new UocOrdRequestCommodityTypePo();
                BeanUtils.copyProperties((Object)combCommodityTypeReqBo, (Object)saveCommodityTypePo);
                saveCommodityTypePo.setRequestId(reqBo.getRequestId());
                saveCommodityTypePo.setRequestCode(reqBo.getRequestCode());
                List commodityTypePoList = this.uocOrdRequestCommodityTypeMapper.selectByPrimaryPoList(saveCommodityTypePo);
                if (ObjectUtil.isEmpty((Object)commodityTypePoList)) {
                    saveCommodityTypePo.setComTypeDataId(commodityDataId);
                    this.uocOrdRequestCommodityTypeMapper.insert(saveCommodityTypePo);
                }
                savedComTypeMap.put(commTypeId, combCommodityTypeReqBo.getComTypeDataId());
                for (UocProCreateOrderCombOrderItemReqBo combOrderItemReqBo : orderItemList) {
                    UocProCreateOrderCombCommodityTypeReqBo commodityTypeReqBo = combOrderItemReqBo.getCommodityTypeReqBo();
                    if (commodityTypeReqBo == null) continue;
                    combOrderItemReqBo.setComTypeDataId(commodityDataId);
                }
            }
        }
    }

    private void buildAndSaveAddressInfo(UocProUpdateOrderCombReqBo reqBo) {
        reqBo.setRequestAddressId(reqBo.getAddressBo().getRequestAddressId());
        UocProCreateOrderAddressReqBo addressBo = reqBo.getAddressBo();
        UocOrdRequestAddressPo addAddrPo = new UocOrdRequestAddressPo();
        BeanUtils.copyProperties((Object)addressBo, (Object)addAddrPo);
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactTown(addressBo.getReceiverTown());
        addAddrPo.setContactTownId(addressBo.getReceiverTownId());
        addAddrPo.setContactAddress(addressBo.getReceiverAddress());
        addAddrPo.setContactCompany(addressBo.getReceiverCompany());
        addAddrPo.setContactFixPhone(addressBo.getReceiverFixPhone());
        addAddrPo.setContactMobile(addressBo.getReceiverMobileNumber());
        addAddrPo.setContactName(addressBo.getReceiverName());
        addAddrPo.setContactEmail(addressBo.getReceiverEmail());
        addAddrPo.setContactCountryName(addressBo.getReceiverCountryName());
        addAddrPo.setContactCountyId(addressBo.getReceiverCountyId());
        addAddrPo.setContactProvinceName(addressBo.getReceiverProvinceName());
        addAddrPo.setContactProvinceId(addressBo.getReceiverProvinceId());
        addAddrPo.setContactCityName(addressBo.getReceiverCityName());
        addAddrPo.setContactCityId(addressBo.getReceiverCityId());
        addAddrPo.setContactCountyName(addressBo.getReceiverCountyName());
        addAddrPo.setContactBip(addressBo.getCertName());
        addAddrPo.setOrgType(addressBo.getOrgType());
        addAddrPo.setRequestAddressId(reqBo.getAddressBo().getRequestAddressId());
        addAddrPo.setRequestId(reqBo.getRequestId());
        addAddrPo.setRequestCode(reqBo.getRequestCode());
        this.uocOrdRequestAddressMapper.updateByPrimaryKeySelective(addAddrPo);
    }

    private void buildAndSaveRequestOrderInfo(UocProUpdateOrderCombReqBo reqBo) {
        UocProCreateOrderCompanyReqBo companyInfoBo = reqBo.getCompanyInfoBo();
        UocOrdRequestPo saveRequestPo = new UocOrdRequestPo();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)saveRequestPo);
        BeanUtils.copyProperties((Object)companyInfoBo, (Object)saveRequestPo);
        saveRequestPo.setAccountId(reqBo.getPurchaserAccount());
        saveRequestPo.setAccountName(reqBo.getPurchaserAccountName());
        try {
            saveRequestPo.setPredictFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getTotalFee()));
            saveRequestPo.setCommodityTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getCommodityTotalFee()));
            saveRequestPo.setRequestTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBo.getTotalFee()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        this.uocOrdRequestMapper.updateByPrimaryKeySelective(saveRequestPo);
    }

    private void validateYs(UocProUpdateOrderCombReqBo reqBo, Long requestId, UocOrdRequestPo uocOrdRequestPo) {
        if (log.isDebugEnabled()) {
            log.debug("=====\u5360\u7528\u9884\u7b97=====");
        }
        BgySAPBudgetOccupyRsp budgetOccupyRsp = this.bgySAPBudgetOccupyAtomService.bgySAPBudgetOccupy(this.buildSapParam(reqBo, requestId, uocOrdRequestPo));
        if (log.isDebugEnabled()) {
            log.debug("=====\u5360\u7528\u9884\u7b97\uff1a{}=====", (Object)JSON.toJSONString((Object)budgetOccupyRsp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"S".equalsIgnoreCase(budgetOccupyRsp.getReturnStatus())) {
            throw new UocProBusinessException("106000", "sap\u9884\u7b97\u5360\u7528\u5931\u8d25\uff1a" + budgetOccupyRsp.getReturnMsg());
        }
    }

    private BgySAPBudgetOccupyReqBO buildSapParam(UocProUpdateOrderCombReqBo reqBo, Long requestId, UocOrdRequestPo uocOrdRequestPo) {
        BgySAPBudgetOccupyReqBO sapReqBO = new BgySAPBudgetOccupyReqBO();
        sapReqBO.setRequestId(requestId);
        ArrayList<SapRequestParamBody> item = new ArrayList<SapRequestParamBody>();
        for (UocProCreateOrderCombOrderItemReqBo orderItem : reqBo.getOrderItemList()) {
            SapRequestParamBody paramBody = new SapRequestParamBody();
            paramBody.setDOCLN(Convert.toStr((Object)orderItem.getSapSkuLineNum()));
            paramBody.setDJVAL(orderItem.getSkuSalePrice().divide(new BigDecimal(10000), 2, 1).multiply(orderItem.getPurchaseCount()).toString());
            if (ObjectUtil.isNotEmpty((Object)orderItem.getNakedPrice())) {
                paramBody.setZBHSJ(this.long2BigDecimal(orderItem.getNakedPrice()).multiply(orderItem.getPurchaseCount()).toString());
            }
            paramBody.setLDR_BUD(orderItem.getYsResourceId());
            paramBody.setDEPART(uocOrdRequestPo.getYsCompanyCode());
            paramBody.setFUNDSCTR(uocOrdRequestPo.getYsDeptId());
            paramBody.setFYLX(orderItem.getFeeTypeId());
            paramBody.setTCURR("CNY");
            paramBody.setLIFNR(orderItem.getGoodsSupplierId());
            item.add(paramBody);
        }
        SapRequestParamHeader header = new SapRequestParamHeader();
        header.setBUKRS(reqBo.getCompanyInfoBo().getStockOrgId().toString().substring(0, reqBo.getCompanyInfoBo().getStockOrgId().toString().length() - 1));
        header.setLYXT(this.lyxt);
        header.setZDJLX("SG20-CXX-00" + String.valueOf(reqBo.getCostType()));
        header.setDJBH(String.valueOf(reqBo.getRequestCode()));
        header.setSQRY(reqBo.getWorkNo());
        header.setBZRY(reqBo.getWorkNo());
        header.setENTRY_DATE(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setSQRQ(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setDJ_STATE("1");
        header.setPRCTR(uocOrdRequestPo.getProfitId());
        SapRequestParamBO requestInfo = new SapRequestParamBO();
        requestInfo.setHeader(header);
        requestInfo.setItem(item);
        sapReqBO.setRequestInfo(requestInfo);
        sapReqBO.setEsbInfo(new EsbInfoBO());
        sapReqBO.setQueryInfo(new PageInfo());
        return sapReqBO;
    }

    private BigDecimal long2BigDecimal(Long Long2) {
        try {
            return UocMoneyUtil.long2BigDecimal((Long)Long2);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u9a8c\u6536\u5355\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

