/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryEnterpriseAccountDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.ability.bo.UocEnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.BgySAPBudgetOccupyAtomService;
import com.tydic.uoc.common.atom.api.UocProCreateOrderSaveDataAtomService;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyReqBO;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyRsp;
import com.tydic.uoc.common.atom.bo.SapRequestParamBO;
import com.tydic.uoc.common.atom.bo.SapRequestParamBody;
import com.tydic.uoc.common.atom.bo.SapRequestParamHeader;
import com.tydic.uoc.common.atom.bo.UocProCreateOrderSaveDataAtomRspBo;
import com.tydic.uoc.common.busi.api.BgyCatalogOutCostCreateOrderBusiService;
import com.tydic.uoc.common.busi.bo.BgyCatalogOutBusiRspBO;
import com.tydic.uoc.common.comb.api.BgyCatalogOutCostCombService;
import com.tydic.uoc.common.comb.bo.UocCatalogOutCreateRequestOrderCombReqBO;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatalogOutCostCombServiceImpl
implements BgyCatalogOutCostCombService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogOutCostCombServiceImpl.class);
    @Autowired
    private BgyCatalogOutCostCreateOrderBusiService bgyCatalogOutCostCreateOrderBusiService;
    @Value(value="${order.maxFee:100000}")
    private BigDecimal maxFee;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private PebIntfQryEnterpriseAccountDetailAbilityService pebIntfQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Autowired
    private UocProCreateOrderSaveDataAtomService uocProCreateOrderSaveDataAtomService;
    @Autowired
    private BgySAPBudgetOccupyAtomService bgySAPBudgetOccupyAtomService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${isSapBuggget:false}")
    private boolean isSapBuggget;
    @Value(value="${sap_lyxt}")
    private String lyxt;

    @Override
    public BgyCatalogOutBusiRspBO createOrder(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        BgyCatalogOutBusiRspBO busiRspBO;
        BgyCatalogOutBusiRspBO rspBo = (BgyCatalogOutBusiRspBO)UocProRspBoUtil.success(BgyCatalogOutBusiRspBO.class);
        this.validateArg(reqBo);
        Long requestId = this.sequence.nextId();
        reqBo.setRequestId(requestId);
        EnterpriseAccountBO umcEnterpriseAccountBO = this.qryEnterpriseAccountDetail(reqBo);
        this.qryOrgEffAccount(umcEnterpriseAccountBO.getDeliveryCenterId(), reqBo);
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(new EnterpriseOrgDetailReqBO(umcEnterpriseAccountBO.getDeliveryCenterId()));
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4e3a\u7a7a");
        }
        reqBo.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        if (this.isSapBuggget && !UocConstant.CostType.COST.equals(reqBo.getCostType())) {
            this.validateYs(reqBo);
        }
        if (!"0000".equals((busiRspBO = this.bgyCatalogOutCostCreateOrderBusiService.creatOrder(reqBo)).getRespCode())) {
            throw new UocProBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        UocProCreateOrderCombReqBo saveDataAtomReqBo = (UocProCreateOrderCombReqBo)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)), UocProCreateOrderCombReqBo.class));
        saveDataAtomReqBo.setProcKey("BGY_ORDER_OUT_STATUS");
        UocProCreateOrderSaveDataAtomRspBo saveDataAtomRspBo = this.uocProCreateOrderSaveDataAtomService.saveOrderData(saveDataAtomReqBo);
        if (!"0000".equals(saveDataAtomRspBo.getRespCode())) {
            throw new UocProBusinessException(saveDataAtomRspBo.getRespCode(), saveDataAtomRspBo.getRespDesc());
        }
        UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
        combReqBO.setOrderId(busiRspBO.getRequestId());
        combReqBO.setObjId(busiRspBO.getRequestId());
        combReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        combReqBO.setIsStatistics(Boolean.valueOf(false));
        UocPebOrdIdxSyncReqBO sendMsgBo = new UocPebOrdIdxSyncReqBO();
        sendMsgBo.setObjId(Long.valueOf(saveDataAtomRspBo.getSaleVoucherId().toString()));
        sendMsgBo.setObjType(UocConstant.OBJ_TYPE.SALE);
        sendMsgBo.setOrderId(saveDataAtomRspBo.getOrderId());
        sendMsgBo.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)sendMsgBo)));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        rspBo.setRequestCode(busiRspBO.getRequestCode());
        rspBo.setRequestId(busiRspBO.getRequestId());
        rspBo.setKtUrl(busiRspBO.getKtUrl());
        return rspBo;
    }

    private void validateYs(UocCatalogOutCreateRequestOrderCombReqBO combReqBo) {
        BgySAPBudgetOccupyRsp budgetOccupyRsp = this.bgySAPBudgetOccupyAtomService.bgySAPBudgetOccupy(this.buildSapParam(combReqBo));
        if (!"S".equalsIgnoreCase(budgetOccupyRsp.getReturnStatus())) {
            throw new UocProBusinessException("106000", "sap\u9884\u7b97\u5360\u7528\u5931\u8d25\uff1a" + budgetOccupyRsp.getReturnMsg());
        }
    }

    private BgySAPBudgetOccupyReqBO buildSapParam(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        BgySAPBudgetOccupyReqBO sapReqBO = new BgySAPBudgetOccupyReqBO();
        ArrayList<SapRequestParamBody> item = new ArrayList<SapRequestParamBody>();
        for (UocProCreateOrderCombOrderItemReqBo orderItem : reqBo.getOrderItemList()) {
            SapRequestParamBody paramBody = new SapRequestParamBody();
            paramBody.setDOCLN(Convert.toStr((Object)orderItem.getSapSkuLineNum()));
            paramBody.setDJVAL(orderItem.getSkuSalePrice().multiply(orderItem.getPurchaseCount()).toString());
            if (ObjectUtil.isNotEmpty((Object)orderItem.getNakedPrice())) {
                paramBody.setDJVAL(orderItem.getSkuSalePrice().multiply(orderItem.getPurchaseCount()).toString());
            }
            paramBody.setLDR_BUD(orderItem.getYsResourceId());
            paramBody.setDEPART(reqBo.getCompanyInfoBo().getYsDeptId());
            paramBody.setFUNDSCTR(reqBo.getCompanyInfoBo().getFundCenterId());
            paramBody.setFYLX(orderItem.getFeeTypeId());
            paramBody.setTCURR("CNY");
            paramBody.setLIFNR(orderItem.getGoodsSupplierId());
            item.add(paramBody);
        }
        SapRequestParamHeader header = new SapRequestParamHeader();
        header.setBUKRS(reqBo.getCompanyInfoBo().getStockOrgId().toString().substring(0, reqBo.getCompanyInfoBo().getStockOrgId().toString().length() - 1));
        header.setLYXT(this.lyxt);
        header.setZDJLX("SG20-CXX-00" + String.valueOf(reqBo.getCostType()));
        header.setDJBH(String.valueOf(reqBo.getRequestId()));
        header.setSQRY(reqBo.getWorkNo());
        header.setBZRY(reqBo.getWorkNo());
        header.setENTRY_DATE(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setSQRQ(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setDJ_STATE("1");
        header.setPRCTR(reqBo.getCompanyInfoBo().getProfitId());
        SapRequestParamBO requestInfo = new SapRequestParamBO();
        requestInfo.setHeader(header);
        requestInfo.setItem(item);
        sapReqBO.setRequestInfo(requestInfo);
        sapReqBO.setEsbInfo(new EsbInfoBO());
        sapReqBO.setQueryInfo(new PageInfo());
        return sapReqBO;
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        QryEnterpriseAccountDetailReqBO account = new QryEnterpriseAccountDetailReqBO();
        account.setAccountId(reqBo.getPurchaserAccount());
        try {
            log.debug("\u8d26\u5957\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)account));
            QryEnterpriseAccountDetailRspBO rspBO = this.pebIntfQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
            log.debug("\u8d26\u5957\u4fe1\u606f\u56de\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
            }
            EnterpriseAccountBO accountBO = rspBO.getUmcEnterpriseAccountBO();
            if (accountBO == null) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
            }
            reqBo.setProfessionalOrganizationId(accountBO.getDeliveryCenterId());
            reqBo.setPurchaserAccountOrgId(accountBO.getOrgId());
            UocEnterpriseAccountBO uocEnterpriseAccountBO = new UocEnterpriseAccountBO();
            BeanUtils.copyProperties((Object)accountBO, (Object)uocEnterpriseAccountBO);
            reqBo.setAccountBO(uocEnterpriseAccountBO);
            reqBo.setEnterpriseAccountBO(accountBO);
            reqBo.setPurchaserAccountName(accountBO.getAccountName());
            return accountBO;
        }
        catch (Exception e) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }

    private void qryOrgEffAccount(Long deliveryCenterId, UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        QryOrgEffAccountRspBO rspBO;
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(deliveryCenterId);
        try {
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
            rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)rspBO));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            reqBo.setAccountName(((EnterpriseAccountBO)rspBO.getRows().get(0)).getAccountName());
            reqBo.setAccountId(reqBo.getAccountId());
            reqBo.setProAccount(((EnterpriseAccountBO)rspBO.getRows().get(0)).getAccountId());
        }
    }

    private void validateArg(UocCatalogOutCreateRequestOrderCombReqBO reqBo) {
        if (this.maxFee.compareTo(reqBo.getTotalFee()) < 0) {
            throw new UocProBusinessException("103030", "\u8bf7\u8d2d\u91d1\u989d\u8d8510w\uff0c\u9700\u8fdb\u884c\u62db\u6295\u6807\u4e0b\u5355");
        }
    }
}

