/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.BgyCancelRequestOrderReqBO;
import com.tydic.uoc.common.ability.bo.BgyCancelRequestOrderRspBO;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.atom.api.BgyCancelRequestOrderAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyCancelRequestOrderAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyCancelRequestOrderInfo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.comb.api.BgyCatelogOutCancelRequestOrderCombService;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCatelogOutCancelRequestOrderCombServiceImpl
implements BgyCatelogOutCancelRequestOrderCombService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatelogOutCancelRequestOrderCombServiceImpl.class);
    @Autowired
    private BgyCancelRequestOrderAtomService bgyCancelRequestOrderAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocOrdRequestMapper requestMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Value(value="${k2_request_order_source_id}")
    private String sourceId;

    @Override
    public BgyCancelRequestOrderRspBO cancelRequestOrder(BgyCancelRequestOrderReqBO reqBO) {
        BgyCancelRequestOrderRspBO rspBO = (BgyCancelRequestOrderRspBO)UocProRspBoUtil.success(BgyCancelRequestOrderRspBO.class);
        Long requestId = reqBO.getRequestId();
        UocOrdRequestPo uocOrdRequestPo = this.requestMapper.selectByPrimaryKey(requestId);
        if (ObjectUtil.isEmpty((Object)uocOrdRequestPo)) {
            throw new UocProBusinessException("104047", "\u8be5\u8bf7\u8d2d\u5355" + requestId + "\u4e0d\u5b58\u5728");
        }
        if (ObjectUtil.isEmpty((Object)uocOrdRequestPo.getKtId())) {
            throw new UocProBusinessException("100002", "\u8be5\u8bf7\u8d2d\u5355[" + uocOrdRequestPo.getRequestCode() + "]\u6ca1\u6709\u5bf9\u5e94\u7684k2Id");
        }
        Integer requestStatus = uocOrdRequestPo.getRequestStatus();
        if (!UocConstant.REQUEST_ORDER_STATUS.REJECT.equals(requestStatus)) {
            throw new UocProBusinessException("104047", "\u8be5\u8bf7\u8d2d\u5355\u72b6\u6001(" + requestStatus + ")\u4e0d\u5141\u8bb8\u64a4\u9500");
        }
        BgyCancelRequestOrderAtomReqBO atomReqBO = new BgyCancelRequestOrderAtomReqBO();
        BgyCancelRequestOrderInfo cancelKtProcessRequestInfo = new BgyCancelRequestOrderInfo();
        cancelKtProcessRequestInfo.setK2Id(uocOrdRequestPo.getKtId());
        cancelKtProcessRequestInfo.setOperateUserCode(uocOrdRequestPo.getKtFirstApproveCode());
        cancelKtProcessRequestInfo.setActivityName(uocOrdRequestPo.getKtActivityName());
        cancelKtProcessRequestInfo.setApproveDate(new Date());
        cancelKtProcessRequestInfo.setSourceId(this.sourceId);
        cancelKtProcessRequestInfo.setComment("\u4e3b\u52a8\u53d6\u6d88");
        atomReqBO.setRequestInfo(cancelKtProcessRequestInfo);
        atomReqBO.setEsbInfo(new EsbInfoBO());
        UocOrdRequestPo updateRequestPo = new UocOrdRequestPo();
        updateRequestPo.setRequestId(reqBO.getRequestId());
        updateRequestPo.setCancelDate(this.orderMapper.getDbDate());
        updateRequestPo.setCancelDesc(reqBO.getCancelReason());
        updateRequestPo.setCancelOperName(reqBO.getCancelOperName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getCancelOperId())) {
            updateRequestPo.setCancelOperId(Long.valueOf(reqBO.getCancelOperId()));
        }
        int i = this.requestMapper.updateByPrimaryKeySelective(updateRequestPo);
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(requestId);
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        processRunReqBO.setOrderId(requestId);
        processRunReqBO.setOperId(reqBO.getUsername());
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("auditFlag", "1");
        processRunReqBO.setVariables(map);
        log.info("\u53d6\u6d88\u8bf7\u8d2d\u5355processRunReqBO\uff1a{}", (Object)JSON.toJSONString((Object)((Object)processRunReqBO)));
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102035", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        return rspBO;
    }
}

