/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.umc.supplier.ability.api.UmcVatTaxRangeQryAbilityService;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.atom.api.BgyPushOrderToNcAtomService;
import com.tydic.uoc.common.atom.bo.BgyPushOrderToNcAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyPushOrderToNcAtomRspBO;
import com.tydic.uoc.common.atom.bo.PushOrderHeader;
import com.tydic.uoc.common.atom.bo.PushOrderItem;
import com.tydic.uoc.common.atom.bo.PushOrderReqBody;
import com.tydic.uoc.common.atom.bo.PushOrderReqInfo;
import com.tydic.uoc.common.comb.api.BgyPushOrderToNcCombService;
import com.tydic.uoc.common.comb.bo.BgyPushOrderToNcCombReqBO;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdItemDataPo;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyPushOrderToNcCombServiceImpl
implements BgyPushOrderToNcCombService {
    private static final Logger log = LoggerFactory.getLogger(BgyPushOrderToNcCombServiceImpl.class);
    @Autowired
    private BgyPushOrderToNcAtomService bgyPushOrderToNcAtomService;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocOrdRequestMapper ordRequestMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocOrdRequestAddressMapper ordRequestAddressMapper;
    @Autowired
    private OrdGoodsMapper goodsMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private UmcVatTaxRangeQryAbilityService umcVatTaxRangeQryAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${nc_lyxt:CGSC}")
    private String sourceSystem;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Value(value="${isNeedReplace:true}")
    private boolean isNeedReplace;

    @Override
    public BgyPushOrderToNcAtomRspBO pushOrdertoNc(BgyPushOrderToNcCombReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getOrderId())) {
            return this.getBgyPushOrderToNcAtomRspBO(reqBO);
        }
        UocOrdItemDataPo uocOrdItemDataPo = new UocOrdItemDataPo();
        uocOrdItemDataPo.setRequestId(reqBO.getRequestId());
        List uocOrdItemDataPos = this.ordItemDataMapper.selectByPrimaryPoList(uocOrdItemDataPo);
        List orderIds = uocOrdItemDataPos.stream().map(UocOrdItemDataPo::getOrderId).distinct().collect(Collectors.toList());
        BgyPushOrderToNcAtomRspBO atomRspBO = new BgyPushOrderToNcAtomRspBO();
        for (Long orderId : orderIds) {
            reqBO.setOrderId(orderId);
            atomRspBO = this.getBgyPushOrderToNcAtomRspBO(reqBO);
        }
        return atomRspBO;
    }

    private BgyPushOrderToNcAtomRspBO getBgyPushOrderToNcAtomRspBO(BgyPushOrderToNcCombReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        OrderPO orderPO = new OrderPO();
        BgyPushOrderToNcAtomRspBO atomRspBO = this.bgyPushOrderToNcAtomService.pushOrdertoNc(this.buildAtomParam(reqBO));
        if (!"S".equalsIgnoreCase(atomRspBO.getReturnStatus())) {
            orderPO.setOrderId(orderId);
            orderPO.setPushNcSuccess("F");
            try {
                this.orderMapper.updateById(orderPO);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0NC\u8ba2\u5355\u63a8\u9001\u5931\u8d25\u6807\u5fd7\u5f02\u5e38: {}", (Throwable)e);
                throw new UocProBusinessException("8888", "\u66f4\u65b0NC\u8ba2\u5355\u63a8\u9001\u5931\u8d25\u6807\u5fd7\u5f02\u5e38: " + e.getMessage());
            }
            throw new UocProBusinessException("8888", "NC\u63a8\u9001\u8ba2\u5355\u9519\u8bef:" + atomRspBO.getReturnMsg());
        }
        orderPO.setPushNcSuccess("T");
        orderPO.setNcOrderCode(atomRspBO.getNcOrderCode());
        orderPO.setNcOrderPk(atomRspBO.getNcOrderPk());
        orderPO.setOrderId(orderId);
        try {
            this.orderMapper.updateById(orderPO);
        }
        catch (Exception e) {
            log.error("NC\u63a8\u9001\u8ba2\u5355\u540e\u66f4\u65b0NC\u8ba2\u5355\u7f16\u7801\u5f02\u5e38: {}", (Throwable)e);
            throw new UocProBusinessException("8888", "NC\u63a8\u9001\u8ba2\u5355\u540e\u66f4\u65b0NC\u8ba2\u5355\u7f16\u7801\u5f02\u5e38: " + e.getMessage());
        }
        OrdSalePO qryPo = new OrdSalePO();
        qryPo.setOrderId(orderId);
        OrdSalePO modelBy = this.ordSaleMapper.getModelBy(qryPo);
        if (modelBy != null) {
            PebExtOrdIdxSyncReqBO syncReqBO = new PebExtOrdIdxSyncReqBO();
            syncReqBO.setObjId(modelBy.getSaleVoucherId());
            syncReqBO.setOrderId(orderId);
            syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            syncReqBO.setIsStatistics(false);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)syncReqBO))));
        } else {
            log.error("\u540c\u6b65nc\u8ba2\u5355\u6210\u529f\u540e\uff0c\u5165\u5e93es\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4e3a\u7a7a\u4e86");
        }
        return atomRspBO;
    }

    private BgyPushOrderToNcAtomReqBO buildAtomParam(BgyPushOrderToNcCombReqBO reqBO) {
        BgyPushOrderToNcAtomReqBO rsp = new BgyPushOrderToNcAtomReqBO();
        rsp.setOrderId(reqBO.getOrderId());
        OrdAgreementPO ordAgreementPO = new OrdAgreementPO();
        ordAgreementPO.setOrderId(reqBO.getOrderId());
        List agreementPOS = this.ordAgreementMapper.selectByCondition(ordAgreementPO);
        AgrQryAgreementSubjectDetailsAbilityReqBO agrBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        UocOrdRequestPo ordRequestPo = this.ordRequestMapper.selectByPrimaryKey(reqBO.getRequestId());
        UocOrdRequestAddressPo uocOrdRequestAddressPo = new UocOrdRequestAddressPo();
        uocOrdRequestAddressPo.setRequestId(reqBO.getRequestId());
        uocOrdRequestAddressPo = this.ordRequestAddressMapper.selectByPrimaryPo(uocOrdRequestAddressPo);
        PushOrderHeader orderHeader = new PushOrderHeader();
        PushOrderReqBody requestInfo = new PushOrderReqBody();
        PushOrderReqInfo requestjson = new PushOrderReqInfo();
        ArrayList<PushOrderItem> item = new ArrayList<PushOrderItem>();
        UocOrdItemDataPo ordItemDataPo = new UocOrdItemDataPo();
        ordItemDataPo.setOrderId(reqBO.getOrderId());
        List ordItemDataPos = this.ordItemDataMapper.selectByPrimaryPoList(ordItemDataPo);
        List ordItemIds = ordItemDataPos.stream().map(UocOrdItemDataPo::getOrdItemId).collect(Collectors.toList());
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdPurchasePO ordPurchasePO = new OrdPurchasePO();
        ordPurchasePO.setOrderId(reqBO.getOrderId());
        ordPurchasePO = this.ordPurchaseMapper.getModelBy(ordPurchasePO);
        orderHeader.setVdef48(this.sourceSystem);
        orderHeader.setPk_org(((UocOrdItemDataPo)ordItemDataPos.get(0)).getRequestOrgId());
        orderHeader.setDbilldate(sdf.format(orderPO.getCreateTime()));
        orderHeader.setPk_supplier(((UocOrdItemDataPo)ordItemDataPos.get(0)).getNcSupplierCode());
        orderHeader.setPk_bankdoc("");
        orderHeader.setPk_dept(ordRequestPo.getYsDeptId());
        orderHeader.setCemployeeid(ordRequestPo.getRequestManBip());
        if ("1".equalsIgnoreCase(((UocOrdItemDataPo)ordItemDataPos.get(0)).getPurchaseTypeId())) {
            orderHeader.setVtrantypecode("21-Cxx-002");
        } else if ("2".equalsIgnoreCase(((UocOrdItemDataPo)ordItemDataPos.get(0)).getPurchaseTypeId())) {
            orderHeader.setVtrantypecode("21-Cxx-003");
        } else if ("3".equalsIgnoreCase(((UocOrdItemDataPo)ordItemDataPos.get(0)).getPurchaseTypeId())) {
            orderHeader.setVtrantypecode("21-Cxx-001");
        }
        orderHeader.setPk_invcsupllier(((UocOrdItemDataPo)ordItemDataPos.get(0)).getNcSupplierCode());
        orderHeader.setBillmaker("BGYCGSC");
        orderHeader.setDmakedate(sdf.format(orderPO.getCreateTime()));
        orderHeader.setApprover(ordRequestPo.getKtApproveOper());
        orderHeader.setVmemo(reqBO.getOrderId().toString());
        orderHeader.setVdef3(ordRequestPo.getYsDeptId());
        orderHeader.setVdef10("DKF01");
        orderHeader.setVdef11(ordStakeholderPO.getSupRelaName() + ordStakeholderPO.getSupRelaMobile());
        orderHeader.setCreationtime(sdf.format(orderPO.getCreateTime()));
        orderHeader.setTaudittime(sdf.format(ordRequestPo.getKtApproveTime()));
        orderHeader.setNtotalorigmny(UocMoneyUtil.long2BigDecimal((Long)orderPO.getTotalSaleFee()));
        orderHeader.setCreator(ordRequestPo.getRequestManBip());
        orderHeader.setVdef50(ordRequestPo.getHsCompanyId());
        orderHeader.setVdef51(uocOrdRequestAddressPo.getContactName());
        orderHeader.setDef6(uocOrdRequestAddressPo.getContactAddress());
        orderHeader.setVdef54(uocOrdRequestAddressPo.getContactMobile());
        orderHeader.setVdef49(ordPurchasePO.getPurchaseVoucherNo());
        orderHeader.setVdef20(ordRequestPo.getNcRequestPk());
        if (ObjectUtil.isNotEmpty((Object)ordRequestPo.getHsDeptCode())) {
            orderHeader.setVdef57(ordRequestPo.getHsDeptCode());
        }
        OrdSalePO qryPo = new OrdSalePO();
        qryPo.setOrderId(reqBO.getOrderId());
        OrdSalePO modelBy = this.ordSaleMapper.getModelBy(qryPo);
        BigDecimal ntotalastnum = new BigDecimal(0);
        Integer i = 0;
        for (Long ordItemId : ordItemIds) {
            OrdItemPO ordItemPO = this.ordItemMapper.getModelById(ordItemId.longValue());
            UocOrdItemDataPo itemDataPo = new UocOrdItemDataPo();
            itemDataPo.setOrdItemId(ordItemId);
            itemDataPo = this.ordItemDataMapper.selectByPrimaryPo(itemDataPo);
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrdItemId(ordItemId);
            ordGoodsPO = this.goodsMapper.getModelBy(ordGoodsPO);
            PushOrderItem pushOrderItem = new PushOrderItem();
            pushOrderItem.setChandler(ordRequestPo.getRequestManBip());
            pushOrderItem.setVbdef37(itemDataPo.getOrdItemId().toString());
            pushOrderItem.setCrowno(String.valueOf(i));
            pushOrderItem.setCtaxcodeid(ordItemPO.getRateCode());
            pushOrderItem.setDbilldate(sdf.format(orderPO.getCreateTime()));
            pushOrderItem.setDplanarrvdate(sdf.format(itemDataPo.getOfferDate()));
            pushOrderItem.setNastnum(ordItemPO.getPurchaseCount());
            pushOrderItem.setNqttaxprice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice()));
            pushOrderItem.setNqttaxnetprice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice()));
            pushOrderItem.setNqtprice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getNakedPrice()));
            pushOrderItem.setNqtnetprice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getNakedPrice()));
            pushOrderItem.setNtax(UocMoneyUtil.long2BigDecimal((Long)(ordItemPO.getSalePrice() - ordItemPO.getNakedPrice())));
            pushOrderItem.setNtaxrate(ordItemPO.getTax());
            pushOrderItem.setPk_apfinanceorg(uocOrdRequestAddressPo.getHsCompanyId());
            pushOrderItem.setPk_arrvstoorg(ordRequestPo.getStockOrgId());
            if (3 == ordRequestPo.getCostType()) {
                pushOrderItem.setPk_material(ordGoodsPO.getNcMaterialCode());
            } else {
                pushOrderItem.setPk_material(ordGoodsPO.getSkuMaterialId());
            }
            pushOrderItem.setPk_org(itemDataPo.getRequestOrgId());
            pushOrderItem.setPk_psfinanceorg(uocOrdRequestAddressPo.getHsCompanyId());
            pushOrderItem.setPk_recvstordoc(ordRequestPo.getNeedStockId());
            pushOrderItem.setPk_reqstoorg(ordRequestPo.getStockOrgId());
            pushOrderItem.setPk_reqstordoc(ordRequestPo.getNeedStockId());
            pushOrderItem.setPk_supplier(itemDataPo.getNcSupplierCode());
            pushOrderItem.setVbdef7(modelBy.getSaleVoucherNo());
            pushOrderItem.setVbdef26(ordGoodsPO.getEnterpriseCode());
            pushOrderItem.setVbdef27(ordItemPO.getQuotationLineNum());
            pushOrderItem.setVbdef33(ordGoodsPO.getQuotedUrl());
            if (ObjectUtil.isNotEmpty((Object)itemDataPo.getFeeTypeId())) {
                if (this.isNeedReplace) {
                    String feeTypeId = itemDataPo.getFeeTypeId();
                    String substringPrefix = feeTypeId.substring(0, 2);
                    String substringSuffix = feeTypeId.substring(2);
                    String feeTypeIdNc = substringSuffix + substringPrefix;
                    pushOrderItem.setVbdef2(feeTypeIdNc);
                } else {
                    pushOrderItem.setVbdef2(itemDataPo.getFeeTypeId());
                }
            }
            pushOrderItem.setCsourceid(ordRequestPo.getNcRequestPk());
            pushOrderItem.setNexchangerate(1);
            pushOrderItem.setNmny(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getNakedPrice()).multiply(ordItemPO.getPurchaseCount()));
            pushOrderItem.setNtaxmny(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getSalePrice()).multiply(ordItemPO.getPurchaseCount()));
            item.add(pushOrderItem);
            ntotalastnum = ntotalastnum.add(ordItemPO.getPurchaseCount());
            i = i + 10;
        }
        orderHeader.setNtotalastnum(ntotalastnum.toString());
        requestjson.setItem(item);
        rsp.setEsbInfo(new EsbInfoBO());
        rsp.setQueryInfo(new PageInfo());
        requestjson.setHeader(orderHeader);
        requestInfo.setRequestjson(requestjson);
        rsp.setRequestinfo(requestInfo);
        return rsp;
    }
}

