/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.umc.general.ability.api.UmcDeptBossQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDeptBossQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDeptBossQryAbilityRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.BgyPushRequestOrderToNcAtomService;
import com.tydic.uoc.common.atom.bo.BgyPushRequestOrderToNcAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyPushRequestOrderToNcAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgyPushRequestOrderToNcAtomRspInfo;
import com.tydic.uoc.common.atom.bo.PushRequestOrderBody;
import com.tydic.uoc.common.atom.bo.PushRequestOrderHeader;
import com.tydic.uoc.common.atom.bo.PushRequestOrderItem;
import com.tydic.uoc.common.atom.bo.PushRequestOrderReqInfo;
import com.tydic.uoc.common.comb.api.BgyPushRequestOrderToNcCombService;
import com.tydic.uoc.common.comb.bo.BgyPushRequestOrderToNcCombReqBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdItemDataMapper;
import com.tydic.uoc.dao.UocOrdRequestAddressMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.UocOrdItemDataPo;
import com.tydic.uoc.po.UocOrdRequestAddressPo;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyPushRequestOrderToNcCombServiceImpl
implements BgyPushRequestOrderToNcCombService {
    private static final Logger log = LoggerFactory.getLogger(BgyPushRequestOrderToNcCombServiceImpl.class);
    @Autowired
    private UocOrdRequestMapper ordRequestMapper;
    @Autowired
    private UocOrdRequestAddressMapper ordRequestAddressMapper;
    @Autowired
    private UocOrdItemDataMapper ordItemDataMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdGoodsMapper goodsMapper;
    @Autowired
    private UmcDeptBossQryAbilityService umcDeptBossQryAbilityService;
    @Autowired
    private BgyPushRequestOrderToNcAtomService bgyPushRequestOrderToNcAtomService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;

    @Override
    public BgyPushRequestOrderToNcAtomRspBO pushRequestOrdertoNc(BgyPushRequestOrderToNcCombReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new UocProBusinessException("100001", "\u8bf7\u8d2d\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        UocOrdRequestPo ordRequestPo = new UocOrdRequestPo();
        UocOrdRequestPo uocOrdRequestPo = this.ordRequestMapper.selectByPrimaryKey(reqBO.getRequestId());
        UmcDeptBossQryAbilityReqBO umcDeptBossQryAbilityReqBO = new UmcDeptBossQryAbilityReqBO();
        umcDeptBossQryAbilityReqBO.setRegAccount(uocOrdRequestPo.getRequestManBip());
        UmcDeptBossQryAbilityRspBO umcDeptBossQryAbilityRspBO = this.umcDeptBossQryAbilityService.qryDeptBoss(umcDeptBossQryAbilityReqBO);
        if (!"0000".equals(umcDeptBossQryAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u90e8\u95e8\u8d1f\u8d23\u4eba\u5931\u8d25" + umcDeptBossQryAbilityRspBO.getRespDesc());
        }
        reqBO.setDeptBossAccount(umcDeptBossQryAbilityRspBO.getDeptBossAccount());
        BgyPushRequestOrderToNcAtomRspBO atomRspBO = this.bgyPushRequestOrderToNcAtomService.pushOrdertoNc(this.buildAtomParam(reqBO));
        if (!"S".equalsIgnoreCase(atomRspBO.getReturnStatus())) {
            ordRequestPo.setPushNcSuccess("F");
            ordRequestPo.setRequestId(reqBO.getRequestId());
            try {
                this.ordRequestMapper.updateByPrimaryKeySelective(ordRequestPo);
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u66f4\u65b0\u8bf7\u8d2d\u5355NC\u63a8\u9001\u5931\u8d25\u6807\u5fd7\u5f02\u5e38:" + e.getMessage());
            }
            throw new UocProBusinessException("8888", "NC\u63a8\u9001\u8bf7\u8d2d\u5355\u9519\u8bef:" + atomRspBO.getReturnMsg());
        }
        log.info("****\u63a8\u9001\u8bf7\u8d2d\u5355\u5230NC\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)atomRspBO));
        BgyPushRequestOrderToNcAtomRspInfo ncAtomRspInfo = atomRspBO.getInfoList().get(0);
        ordRequestPo.setPushNcSuccess("T");
        ordRequestPo.setNcRequestCode(ncAtomRspInfo.getNcCode());
        ordRequestPo.setNcRequestPk(ncAtomRspInfo.getNcId());
        ordRequestPo.setKtApproveOper(reqBO.getKtApproveId());
        ordRequestPo.setKtApproveTime(reqBO.getKtAprroveTime());
        ordRequestPo.setRequestId(reqBO.getRequestId());
        try {
            this.ordRequestMapper.updateByPrimaryKeySelective(ordRequestPo);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8bf7\u8d2d\u5355\u8868nc\u8bf7\u8d2d\u5355\u4fe1\u606f\u5f02\u5e38: {}", (Throwable)e);
            throw new UocProBusinessException("8888", "\u66f4\u65b0\u8bf7\u8d2d\u5355\u8868nc\u8bf7\u8d2d\u5355\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
        combReqBO.setOrderId(reqBO.getRequestId());
        combReqBO.setObjId(reqBO.getRequestId());
        combReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        combReqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        return atomRspBO;
    }

    private BgyPushRequestOrderToNcAtomReqBO buildAtomParam(BgyPushRequestOrderToNcCombReqBO reqBO) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BgyPushRequestOrderToNcAtomReqBO rsp = new BgyPushRequestOrderToNcAtomReqBO();
        rsp.setRequestId(reqBO.getRequestId());
        PushRequestOrderBody requsetInfo = new PushRequestOrderBody();
        PushRequestOrderReqInfo requestJson = new PushRequestOrderReqInfo();
        ArrayList<PushRequestOrderReqInfo> requestJsons = new ArrayList<PushRequestOrderReqInfo>();
        ArrayList<PushRequestOrderItem> item = new ArrayList<PushRequestOrderItem>();
        PushRequestOrderHeader requestOrderHeader = new PushRequestOrderHeader();
        UocOrdRequestAddressPo ordRequestAddressPo = new UocOrdRequestAddressPo();
        ordRequestAddressPo.setRequestId(reqBO.getRequestId());
        ordRequestAddressPo = this.ordRequestAddressMapper.selectByPrimaryPo(ordRequestAddressPo);
        UocOrdRequestPo uocOrdRequestPo = this.ordRequestMapper.selectByPrimaryKey(reqBO.getRequestId());
        requestOrderHeader.setVdef41(uocOrdRequestPo.getRequestManBip());
        requestOrderHeader.setVdef42(uocOrdRequestPo.getRequestManBip());
        requestOrderHeader.setVdef43(ordRequestAddressPo.getContactBip());
        requestOrderHeader.setVdef44(reqBO.getDeptBossAccount());
        requestOrderHeader.setBillmaker("BGYCGSC");
        requestOrderHeader.setVdef11(ordRequestAddressPo.getContactBip());
        requestOrderHeader.setVdef33(uocOrdRequestPo.getRequestManBip() + "\u53d1\u8d77\u7684\u7269\u6599\u8bf7\u8d2d\u6d41\u7a0b" + uocOrdRequestPo.getRequestCode() + uocOrdRequestPo.getRequestReason());
        if (uocOrdRequestPo.getCostType() == 1) {
            requestOrderHeader.setVtrantypecode("20-Cxx-002");
        } else if (uocOrdRequestPo.getCostType() == 2) {
            requestOrderHeader.setVtrantypecode("20-Cxx-003");
        } else if (uocOrdRequestPo.getCostType() == 3) {
            requestOrderHeader.setVtrantypecode("20-Cxx-001");
        }
        requestOrderHeader.setVdef45(sdf.format(reqBO.getKtAprroveTime()));
        requestOrderHeader.setVdef6(ordRequestAddressPo.getContactAddress());
        requestOrderHeader.setTaudittime(sdf.format(reqBO.getKtAprroveTime()));
        requestOrderHeader.setPk_org(uocOrdRequestPo.getStockOrgId());
        requestOrderHeader.setVdef13(ordRequestAddressPo.getContactMobile());
        requestOrderHeader.setDmakedate(sdf.format(reqBO.getKtAprroveTime()));
        requestOrderHeader.setVmemo(uocOrdRequestPo.getRequestCode());
        requestOrderHeader.setApprover(reqBO.getKtApproveId());
        requestOrderHeader.setPk_planpsn(uocOrdRequestPo.getRequestManBip());
        requestOrderHeader.setPk_plandept(uocOrdRequestPo.getYsDeptId());
        requestOrderHeader.setVdef12(reqBO.getDeptBossAccount());
        requestOrderHeader.setDbilldate(sdf.format(uocOrdRequestPo.getRequestTime()));
        if (ObjectUtil.isNotEmpty((Object)uocOrdRequestPo.getHsDeptCode())) {
            requestOrderHeader.setVdef57(uocOrdRequestPo.getHsDeptCode());
        }
        UocOrdItemDataPo uocOrdItemDataPo = new UocOrdItemDataPo();
        uocOrdItemDataPo.setRequestId(reqBO.getRequestId());
        List ordItemDataPoList = this.ordItemDataMapper.selectByPrimaryPoList(uocOrdItemDataPo);
        int i = 0;
        for (UocOrdItemDataPo e : ordItemDataPoList) {
            PushRequestOrderItem requestOrderItem = new PushRequestOrderItem();
            OrdItemPO ordItemPO = this.ordItemMapper.getModelById(e.getOrdItemId().longValue());
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrdItemId(e.getOrdItemId());
            ordGoodsPO = this.goodsMapper.getModelBy(ordGoodsPO);
            requestOrderItem.setDreqdate(sdf.format(uocOrdRequestPo.getGiveTime()));
            requestOrderItem.setVbdef26(ordItemPO.getUnitName());
            requestOrderItem.setVbdef9(e.getProjectUsedId());
            requestOrderItem.setPk_purchaseorg(e.getRequestOrgId());
            requestOrderItem.setNtaxprice(UocMoneyUtil.long2BigDecimal((Long)ordItemPO.getNakedPrice()));
            requestOrderItem.setCrowno(i);
            requestOrderItem.setVbdef1(e.getMaterialDesc());
            requestOrderItem.setVmemo(uocOrdRequestPo.getRequestCode());
            requestOrderItem.setPk_reqstor(uocOrdRequestPo.getNeedStockId());
            requestOrderItem.setNastnum(ordItemPO.getPurchaseCount());
            if (3 == uocOrdRequestPo.getCostType()) {
                requestOrderItem.setPk_material(ordGoodsPO.getNcMaterialCode());
            } else {
                requestOrderItem.setPk_material(ordGoodsPO.getSkuMaterialId());
            }
            requestOrderItem.setVbdef20(e.getYsResourceId());
            requestOrderItem.setVbdef31(e.getBuildingNo());
            requestOrderItem.setVbdef32(e.getProjectUsedName());
            requestOrderItem.setVbdef33(e.getIsFix());
            requestOrderItem.setVbdef34(e.getBjZy());
            requestOrderItem.setVbdef35(e.getGoodsTypeId());
            requestOrderItem.setVbdef36(e.getProductId());
            requestOrderItem.setPk_org(uocOrdRequestPo.getStockOrgId());
            requestOrderItem.setVbmemo(ordItemPO.getOrdItemId().toString());
            String vbdef21 = e.getProductTypeBig();
            if (ObjectUtil.isNotEmpty((Object)e.getProductTypeMin()) && ObjectUtil.isNotEmpty((Object)vbdef21)) {
                vbdef21 = vbdef21 + "-" + e.getProductTypeMin();
            }
            requestOrderItem.setVbdef21(vbdef21);
            i += 10;
            item.add(requestOrderItem);
        }
        requestJson.setCsourceid(uocOrdRequestPo.getRequestCode());
        requestJson.setHeader(requestOrderHeader);
        requestJson.setCsourceid(uocOrdRequestPo.getRequestCode());
        requestJson.setDr("0");
        requestJson.setItem(item);
        requestJsons.add(requestJson);
        requsetInfo.setRequestjson(requestJsons);
        rsp.setEsbInfo(new EsbInfoBO());
        rsp.setQueryInfo(new PageInfo());
        rsp.setRequestinfo(requsetInfo);
        return rsp;
    }
}

