/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuOrderQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.UmcNcOrgQryListAbilityService;
import com.tydic.umc.general.ability.bo.UmcNcOrgQryListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcNcOrgQryListAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcPurOrgNcBO;
import com.tydic.umc.supplier.ability.api.UmcSupplierLinkManQryListAbilityService;
import com.tydic.umc.supplier.ability.api.UmcVatTaxRangeQryAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierLinkManBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierLinkManQryListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierLinkManQryListAbilityRspBO;
import com.tydic.umc.supplier.ability.bo.UmcVatTaxRangeQryAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcVatTaxRangeQryAbilityRspBO;
import com.tydic.umc.supplier.ability.bo.UmcVatTaxRangeQryBO;
import com.tydic.umc.supplier.ability.bo.UmcVatTaxRangeQryRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfMemDetailQueryAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryAgreementDetailsAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryEnterpriseAccountDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryReqBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryRspBO;
import com.tydic.uoc.busibase.busi.bo.QryAgreementDetailsReqBO;
import com.tydic.uoc.busibase.busi.bo.QryAgreementDetailsRspBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.ability.bo.UocEnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.UocOrdAgreementBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.BgySAPBudgetOccupyAtomService;
import com.tydic.uoc.common.atom.api.UocCreateOrderQryCommodityAtomService;
import com.tydic.uoc.common.atom.api.UocOtherOrderSourceExecuteAtomService;
import com.tydic.uoc.common.atom.api.UocQrySupIdAtomService;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyReqBO;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyRsp;
import com.tydic.uoc.common.atom.bo.SapRequestParamBO;
import com.tydic.uoc.common.atom.bo.SapRequestParamBody;
import com.tydic.uoc.common.atom.bo.SapRequestParamHeader;
import com.tydic.uoc.common.atom.bo.UocCreateOrderQryCommodityAtomServiceReqBo;
import com.tydic.uoc.common.atom.bo.UocCreateOrderQryCommodityAtomServiceRspBo;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomConsumeReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.busi.api.UocProCreateOrderBusiService;
import com.tydic.uoc.common.busi.bo.UocProCreateOrderBusiOrderDataRspBo;
import com.tydic.uoc.common.busi.bo.UocProCreateOrderBusiRspBo;
import com.tydic.uoc.common.comb.api.UocProCreateOrderCombService;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderAddressReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombRspBo;
import com.tydic.uoc.config.UocOtherOrderSourceManager;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.ConfSupplierPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocProCreateOrderCombServiceImpl
implements UocProCreateOrderCombService {
    private static final Logger log = LoggerFactory.getLogger(UocProCreateOrderCombServiceImpl.class);
    @Autowired
    private UocProCreateOrderBusiService uocProCreateOrderBusiService;
    @Autowired
    private UocCreateOrderQryCommodityAtomService uocCreateOrderQryCommodityAtomService;
    @Autowired
    private UocOtherOrderSourceManager uocOtherOrderSourceManager;
    @Autowired
    private PebIntfQryAgreementDetailsAbilityService pebIntfQryAgreementDetailsAbilityService;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private PebIntfQryEnterpriseAccountDetailAbilityService pebIntfQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    private static final Byte AGR_YES = 4;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private OrderGenerateIdUtil sequence;
    @Autowired
    private BgySAPBudgetOccupyAtomService bgySAPBudgetOccupyAtomService;
    @Value(value="${sap_lyxt}")
    private String lyxt;
    @Autowired
    private UmcNcOrgQryListAbilityService umcNcOrgQryListAbilityService;
    @Value(value="${isSapBuggget:false}")
    private boolean isSapBuggget;
    @Autowired
    private UmcSupplierLinkManQryListAbilityService umcSupplierLinkManQryListAbilityService;
    @Value(value="${order.maxFee:100000}")
    private BigDecimal maxFee;
    @Value(value="${order.offerCycle:7}")
    private Integer offerCycle;
    @Autowired
    private UmcVatTaxRangeQryAbilityService umcVatTaxRangeQryAbilityService;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private UocQrySupIdAtomService uocQrySupIdAtomService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${maxReason:600}")
    private Integer maxReason;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;

    @Override
    public UocProCreateOrderCombRspBo createOrder(UocProCreateOrderCombReqBo reqBo) {
        UocProCreateOrderBusiRspBo busiOrderRsp;
        this.validateArg(reqBo);
        UocProCreateOrderCombRspBo rspBo = (UocProCreateOrderCombRspBo)UocProRspBoUtil.success(UocProCreateOrderCombRspBo.class);
        Long requestId = this.sequence.nextId();
        reqBo.setRequestId(requestId);
        reqBo.setRequestCode(this.genRequestCode());
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        EnterpriseAccountBO umcEnterpriseAccountBO = this.qryEnterpriseAccountDetail(reqBo);
        this.qryOrgEffAccount(umcEnterpriseAccountBO.getDeliveryCenterId(), reqBo);
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(new EnterpriseOrgDetailReqBO(umcEnterpriseAccountBO.getDeliveryCenterId()));
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4e3a\u7a7a");
        }
        reqBo.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        UocCreateOrderQryCommodityAtomServiceRspBo qryCommodityRspBo = this.uocCreateOrderQryCommodityAtomService.qryCommodity(this.buildQryCommodityReqBo(reqBo));
        if (!"0000".equals(qryCommodityRspBo.getRespCode())) {
            throw new UocProBusinessException("103031", "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25!" + qryCommodityRspBo.getRespDesc());
        }
        UmcVatTaxRangeQryAbilityReqBO umcVatTaxRangeQryAbilityReqBO = this.builTaxRangeReqBo(qryCommodityRspBo, reqBo.getOrderItemList());
        log.info("\u67e5\u8be2\u7a0e\u7801\u5165\u53c2\uff1a {}", (Object)JSON.toJSONString((Object)umcVatTaxRangeQryAbilityReqBO));
        UmcVatTaxRangeQryAbilityRspBO umcVatTaxRangeQryAbilityRspBO = this.umcVatTaxRangeQryAbilityService.qryVatTaxRange(umcVatTaxRangeQryAbilityReqBO);
        log.info("\u67e5\u8be2\u7a0e\u7801\u51fa\u53c2 \uff1a {}", (Object)umcVatTaxRangeQryAbilityRspBO);
        if (!"0000".equals(umcVatTaxRangeQryAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException("103031", "\u5546\u54c1\u7a0e\u7801\u67e5\u8be2\u5931\u8d25!" + umcVatTaxRangeQryAbilityRspBO.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)umcVatTaxRangeQryAbilityRspBO.getUmcVatTaxRangeQryRspBOS())) {
            throw new UocProBusinessException("103031", "\u5546\u54c1\u7a0e\u7801\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!" + umcVatTaxRangeQryAbilityReqBO);
        }
        for (UmcVatTaxRangeQryRspBO item : umcVatTaxRangeQryAbilityRspBO.getUmcVatTaxRangeQryRspBOS()) {
            if (!ObjectUtil.isEmpty((Object)item.getSupTaxCode())) continue;
            throw new UocProBusinessException("103031", "\u5546\u54c1!" + item.getSkuId() + "\u7a0e\u7801\u4e3a\u7a7a");
        }
        Map<Long, UmcSupplierLinkManBO> supplierMap = this.qrySupplierInfo(reqBo);
        this.dealDataWithUccReturn(qryCommodityRspBo, reqBo, supplierMap, umcVatTaxRangeQryAbilityRspBO);
        this.validateSupplierLimit(orderItemList);
        this.qryAgrInfo(reqBo);
        if (this.isSapBuggget && !UocConstant.CostType.COST.equals(reqBo.getCostType())) {
            this.validateYs(reqBo, requestId);
        }
        if (!"0000".equals((busiOrderRsp = this.uocProCreateOrderBusiService.createOrder(reqBo)).getRespCode())) {
            throw new UocProBusinessException(busiOrderRsp.getRespCode(), busiOrderRsp.getRespDesc());
        }
        for (UocProCreateOrderBusiOrderDataRspBo orderRspData : busiOrderRsp.getOrderRspList()) {
            UocOtherOrderSourceExecuteAtomService instance = this.uocOtherOrderSourceManager.getInstance(orderRspData.getOrderSource());
            UocOtherOrderSourceExecuteAtomConsumeReqBo sendMsgReqBo = new UocOtherOrderSourceExecuteAtomConsumeReqBo();
            sendMsgReqBo.setConsumerObject(orderRspData.getConsumerObject());
            sendMsgReqBo.setOrderId(orderRspData.getOrderId());
            sendMsgReqBo.setSaleVoucherId(orderRspData.getSaleVoucherId());
            instance.sendMessage(sendMsgReqBo);
            rspBo.getOrderIdList().add(orderRspData.getOrderId());
            rspBo.getSupplierList().add(orderRspData.getSupplierName());
        }
        this.senMessage(busiOrderRsp);
        UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
        combReqBO.setOrderId(busiOrderRsp.getRequestId());
        combReqBO.setObjId(busiOrderRsp.getRequestId());
        combReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        combReqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        BeanUtils.copyProperties((Object)((Object)busiOrderRsp), (Object)((Object)rspBo));
        return rspBo;
    }

    private void validateSupplierLimit(List<UocProCreateOrderCombOrderItemReqBo> orderItemList) {
        Map<String, List<UocProCreateOrderCombOrderItemReqBo>> supplierMap = orderItemList.stream().collect(Collectors.groupingBy(UocProCreateOrderCombOrderItemReqBo::getGoodsSupplierId));
        for (String supplier : supplierMap.keySet()) {
            Long limit;
            Long totalPrice = 0L;
            List<UocProCreateOrderCombOrderItemReqBo> uocProCreateOrderCombOrderItemReqBos = supplierMap.get(supplier);
            String supName = uocProCreateOrderCombOrderItemReqBos.get(0).getSupplierName();
            for (UocProCreateOrderCombOrderItemReqBo uocProCreateOrderCombOrderItemReqBo : uocProCreateOrderCombOrderItemReqBos) {
                BigDecimal salePrice = uocProCreateOrderCombOrderItemReqBo.getSkuSalePrice().multiply(uocProCreateOrderCombOrderItemReqBo.getPurchaseCount());
                totalPrice = totalPrice + salePrice.longValue();
            }
            System.out.println("\u4f9b\u5e94\u5546[" + supName + "]\u4ef7\u683c\uff1a" + totalPrice);
            ConfSupplierPO qrySup = new ConfSupplierPO();
            qrySup.setSupNo(Long.valueOf(supplier));
            qrySup.setLimitStatus(Integer.valueOf(0));
            ConfSupplierPO modelBy = this.confSupplierMapper.getModelBy(qrySup);
            if (modelBy == null || (limit = modelBy.getOrderLimit()) == null || limit <= 0L || limit <= totalPrice) continue;
            String money = null;
            try {
                money = UocMoneyUtil.long2BigDecimal((Long)limit).toString();
            }
            catch (Exception e) {
                throw new UocProBusinessException("102107", "\u4f9b\u5e94\u5546\u6700\u4f4e\u9650\u989d\u6821\u9a8c\u524d\uff0c\u91d1\u989d\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            throw new UocProBusinessException("102107", "\u4f9b\u5e94\u5546\uff1a" + supName + "\uff0c\u6700\u4f4e\u4e0b\u5355\u91d1\u989d\u4e3a\uff1a" + money + "\u5143");
        }
    }

    private String genRequestCode() {
        String requestCode = "";
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode("ORDER_QGD_NO");
        getBo.setOrgType("-1");
        log.info("\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getBo));
        try {
            CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
            log.info("\u83b7\u53d6\u7f16\u53f7\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)encodedSerial));
            requestCode = (String)encodedSerial.getSerialNoList().get(0);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage());
            throw new UocProBusinessException("101076", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return requestCode;
    }

    private UmcVatTaxRangeQryAbilityReqBO builTaxRangeReqBo(UocCreateOrderQryCommodityAtomServiceRspBo qryCommodityRspBo, List<UocProCreateOrderCombOrderItemReqBo> orderItemList) {
        UmcVatTaxRangeQryAbilityReqBO reqBO = new UmcVatTaxRangeQryAbilityReqBO();
        ArrayList<UmcVatTaxRangeQryBO> umcVatTaxRangeQryBOList = new ArrayList<UmcVatTaxRangeQryBO>();
        for (UocProCreateOrderCombOrderItemReqBo e : orderItemList) {
            for (UccMallSpuOrderListQueryBO item : qryCommodityRspBo.getOrderSpuList()) {
                UmcVatTaxRangeQryBO umcVatTaxRangeQryBO = new UmcVatTaxRangeQryBO();
                umcVatTaxRangeQryBO.setSupplierId(item.getVendorId());
                umcVatTaxRangeQryBO.setSupTaxRate(item.getRate());
                for (UccMallSkuDetailInfoBO uccItem : item.getOrderSkuList()) {
                    if (!uccItem.getSkuId().toString().equals(e.getSkuId())) continue;
                    umcVatTaxRangeQryBO.setSkuId(uccItem.getSkuId());
                    umcVatTaxRangeQryBOList.add(umcVatTaxRangeQryBO);
                }
            }
        }
        reqBO.setUmcVatTaxRangeQryBOList(umcVatTaxRangeQryBOList);
        return reqBO;
    }

    private Map<Long, UmcSupplierLinkManBO> qrySupplierInfo(UocProCreateOrderCombReqBo reqBo) {
        LinkedHashSet<Long> supplierSet = new LinkedHashSet<Long>();
        for (UocProCreateOrderCombOrderItemReqBo itemReqBo : reqBo.getOrderItemList()) {
            supplierSet.add(Long.parseLong(itemReqBo.getGoodsSupplierId()));
        }
        UmcSupplierLinkManQryListAbilityReqBO qrySupplierReqBo = new UmcSupplierLinkManQryListAbilityReqBO();
        ArrayList supplierList = new ArrayList(supplierSet);
        qrySupplierReqBo.setSupplierIds(supplierList);
        log.info("\u4e0b\u5355\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)qrySupplierReqBo));
        UmcSupplierLinkManQryListAbilityRspBO umcSupplierLinkManQryListAbilityRspBO = this.umcSupplierLinkManQryListAbilityService.qrySupplierLinkMan(qrySupplierReqBo);
        log.info("\u4e0b\u5355\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcSupplierLinkManQryListAbilityRspBO));
        if (!"0000".equals(umcSupplierLinkManQryListAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException("103031", "\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25!" + umcSupplierLinkManQryListAbilityRspBO.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)umcSupplierLinkManQryListAbilityRspBO.getRows())) {
            throw new UocProBusinessException("103031", "\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u9519\u8bef\uff0c\u8fd4\u56de\u4f9b\u5e94\u5546\u6570\u636e\u4e3a\u7a7a");
        }
        if (supplierList.size() != umcSupplierLinkManQryListAbilityRspBO.getRows().size()) {
            throw new UocProBusinessException("103031", "\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u9519\u8bef\uff0c\u67e5\u8be2\u6570\u91cf(" + supplierList.size() + ")\uff0c\u4e0d\u7b49\u4e8e\u67e5\u5230\u5f97\u6570\u91cf(" + umcSupplierLinkManQryListAbilityRspBO.getRows().size() + ")");
        }
        for (UmcSupplierLinkManBO row : umcSupplierLinkManQryListAbilityRspBO.getRows()) {
            if (ObjectUtil.isEmpty((Object)row)) {
                throw new UocProBusinessException("103031", "\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff1a\u884c\u6570\u636e\u4e3a\u7a7a\u4e86");
            }
            if (ObjectUtil.isEmpty((Object)row.getLinkMan())) {
                throw new UocProBusinessException("103031", "\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff1a\u8054\u7cfb\u4eba\u4e3a\u7a7a\u4e86");
            }
            if (ObjectUtil.isEmpty((Object)row.getOrgCode())) {
                throw new UocProBusinessException("103031", "\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff1a\u673a\u6784\u7f16\u7801\u4e3a\u7a7a\u4e86");
            }
            if (!ObjectUtil.isEmpty((Object)row.getPhone())) continue;
            throw new UocProBusinessException("103031", "\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fe1\u606f\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff1a\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a\u4e86");
        }
        return umcSupplierLinkManQryListAbilityRspBO.getRows().stream().collect(Collectors.toMap(UmcSupplierLinkManBO::getOrgId, item -> item));
    }

    private void validateYs(UocProCreateOrderCombReqBo combReqBo, Long requestId) {
        BgySAPBudgetOccupyRsp budgetOccupyRsp = this.bgySAPBudgetOccupyAtomService.bgySAPBudgetOccupy(this.buildSapParam(combReqBo, requestId));
        if (!"S".equalsIgnoreCase(budgetOccupyRsp.getReturnStatus())) {
            throw new UocProBusinessException("106000", "sap\u9884\u7b97\u5360\u7528\u5931\u8d25\uff1a" + budgetOccupyRsp.getReturnMsg());
        }
    }

    private BgySAPBudgetOccupyReqBO buildSapParam(UocProCreateOrderCombReqBo reqBo, Long requestId) {
        BgySAPBudgetOccupyReqBO sapReqBO = new BgySAPBudgetOccupyReqBO();
        sapReqBO.setRequestId(requestId);
        ArrayList<SapRequestParamBody> item = new ArrayList<SapRequestParamBody>();
        for (UocProCreateOrderCombOrderItemReqBo orderItem : reqBo.getOrderItemList()) {
            SapRequestParamBody paramBody = new SapRequestParamBody();
            paramBody.setDOCLN(Convert.toStr((Object)orderItem.getSapSkuLineNum()));
            paramBody.setDJVAL(UocMoneyUtil.long2BigDecimal((Long)orderItem.getSkuSalePrice().multiply(orderItem.getPurchaseCount()).longValue()).toString());
            if (ObjectUtil.isNotEmpty((Object)orderItem.getNakedPrice())) {
                paramBody.setZBHSJ(UocMoneyUtil.long2BigDecimal((Long)new BigDecimal(orderItem.getNakedPrice()).multiply(orderItem.getPurchaseCount()).longValue()).toString());
            }
            paramBody.setLDR_BUD(orderItem.getYsResourceId());
            paramBody.setDEPART(reqBo.getCompanyInfoBo().getYsCompanyCode());
            paramBody.setFUNDSCTR(reqBo.getCompanyInfoBo().getYsDeptId());
            paramBody.setFYLX(orderItem.getFeeTypeId());
            paramBody.setTCURR("CNY");
            paramBody.setLIFNR(orderItem.getGoodsSupplierId());
            item.add(paramBody);
        }
        SapRequestParamHeader header = new SapRequestParamHeader();
        header.setBUKRS(reqBo.getCompanyInfoBo().getStockOrgId().toString().substring(0, reqBo.getCompanyInfoBo().getStockOrgId().toString().length() - 1));
        header.setLYXT(this.lyxt);
        header.setZDJLX("SG20-CXX-00" + String.valueOf(reqBo.getCostType()));
        header.setDJBH(String.valueOf(reqBo.getRequestCode()));
        header.setSQRY(reqBo.getWorkNo());
        header.setBZRY(reqBo.getWorkNo());
        header.setENTRY_DATE(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setSQRQ(new SimpleDateFormat("YYYYMMDD").format(new Date()));
        header.setDJ_STATE("1");
        header.setPRCTR(reqBo.getCompanyInfoBo().getProfitId());
        SapRequestParamBO requestInfo = new SapRequestParamBO();
        requestInfo.setHeader(header);
        requestInfo.setItem(item);
        sapReqBO.setRequestInfo(requestInfo);
        sapReqBO.setEsbInfo(new EsbInfoBO());
        sapReqBO.setQueryInfo(new PageInfo());
        return sapReqBO;
    }

    private void validateArg(UocProCreateOrderCombReqBo reqBo) {
        List<UocProCreateOrderCombOrderItemReqBo> orderItemList = reqBo.getOrderItemList();
        for (UocProCreateOrderCombOrderItemReqBo itemReqBo : orderItemList) {
            if ("1".equals(itemReqBo.getOrderSource()) && ObjectUtil.isEmpty((Object)itemReqBo.getAgrId())) {
                throw new UocProBusinessException("103030", "\u534f\u8bae\u5546\u54c1\u534f\u8baeid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)itemReqBo.getGoodsSupplierId())) continue;
            throw new UocProBusinessException("103030", "goodsSupplierId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.maxFee.compareTo(reqBo.getTotalFee()) < 0) {
            throw new UocProBusinessException("103030", "\u8bf7\u8d2d\u91d1\u989d\u8d8510w\uff0c\u9700\u8fdb\u884c\u62db\u6295\u6807\u4e0b\u5355");
        }
        if (reqBo.getRequestReason().length() > this.maxReason) {
            throw new UocProBusinessException("103030", "\u8bf7\u8d2d\u539f\u56e0\u8f93\u5165\u4e0d\u80fd\u8d85\u8fc7:" + this.maxReason + " \u4e2a\u5b57");
        }
    }

    private void qryOrgEffAccount(Long deliveryCenterId, UocProCreateOrderCombReqBo reqBo) {
        QryOrgEffAccountRspBO rspBO;
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(deliveryCenterId);
        try {
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
            rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)rspBO));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            reqBo.setAccountName(((EnterpriseAccountBO)rspBO.getRows().get(0)).getAccountName());
            reqBo.setAccountId(reqBo.getAccountId());
            reqBo.setProAccount(((EnterpriseAccountBO)rspBO.getRows().get(0)).getAccountId());
        }
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(UocProCreateOrderCombReqBo reqBo) {
        QryEnterpriseAccountDetailReqBO account = new QryEnterpriseAccountDetailReqBO();
        account.setAccountId(reqBo.getPurchaserAccount());
        try {
            log.debug("\u8d26\u5957\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)account));
            QryEnterpriseAccountDetailRspBO rspBO = this.pebIntfQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
            log.debug("\u8d26\u5957\u4fe1\u606f\u56de\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
            }
            EnterpriseAccountBO accountBO = rspBO.getUmcEnterpriseAccountBO();
            if (accountBO == null) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
            }
            reqBo.setProfessionalOrganizationId(accountBO.getDeliveryCenterId());
            reqBo.setPurchaserAccountOrgId(accountBO.getOrgId());
            UocEnterpriseAccountBO uocEnterpriseAccountBO = new UocEnterpriseAccountBO();
            BeanUtils.copyProperties((Object)accountBO, (Object)uocEnterpriseAccountBO);
            reqBo.setAccountBO(uocEnterpriseAccountBO);
            reqBo.setEnterpriseAccountBO(accountBO);
            reqBo.setPurchaserAccountName(accountBO.getAccountName());
            return accountBO;
        }
        catch (Exception e) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
    }

    private void qryAgrInfo(UocProCreateOrderCombReqBo reqBo) {
        for (UocProCreateOrderCombOrderItemReqBo agreementSkuInfo : reqBo.getOrderItemList()) {
            if (ObjectUtil.isEmpty((Object)agreementSkuInfo.getAgrId()) || "2".equals(agreementSkuInfo.getOrderSource())) continue;
            QryAgreementDetailsReqBO agreementDetailsReqBO = new QryAgreementDetailsReqBO();
            agreementDetailsReqBO.setAgreementId(agreementSkuInfo.getAgrId());
            QryAgreementDetailsRspBO qryAgreementDetailsRspBO = this.pebIntfQryAgreementDetailsAbilityService.qryAgreementDetails(agreementDetailsReqBO);
            log.debug("\u534f\u8bae\u67e5\u8be2\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)qryAgreementDetailsRspBO));
            if (!"0000".equals(qryAgreementDetailsRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\u67e5\u8be2\u51fa\u9519" + qryAgreementDetailsRspBO.getRespDesc());
            }
            if (qryAgreementDetailsRspBO.getAgrAgreementBO() == null) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\uff1a" + agreementSkuInfo.getPlaAgreeMentCode() + "\u4e0d\u5b58\u5728");
            }
            UocOrdAgreementBO agreementBO = (UocOrdAgreementBO)JSON.parseObject((String)JSON.toJSONString((Object)qryAgreementDetailsRspBO.getAgrAgreementBO()), UocOrdAgreementBO.class);
            if (!AGR_YES.equals(agreementBO.getAgreementStatus())) {
                throw new UocProBusinessException("100001", "\u534f\u8bae\uff1a" + agreementSkuInfo.getPlaAgreeMentCode() + "\u672a\u542f\u7528");
            }
            if (agreementBO.getSupplierId() != null) {
                EnterpriseOrgDetailReqBO queryReqBO = new EnterpriseOrgDetailReqBO();
                queryReqBO.setOrgIdWeb(agreementBO.getVendorDepartmentId());
                EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(queryReqBO);
                if (!detailRspBO.getRespCode().equals("0000")) {
                    throw new UocProBusinessException("102105", "\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + detailRspBO.getRespDesc());
                }
                if (detailRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
                    agreementBO.setVendorContactWay(detailRspBO.getUmcEnterpriseOrgAbilityBO().getPhone());
                    agreementBO.setVendorContactPerson(detailRspBO.getUmcEnterpriseOrgAbilityBO().getLinkMan());
                    agreementBO.setVendorContactAddress(detailRspBO.getUmcEnterpriseOrgAbilityBO().getAddress());
                }
            }
            if (agreementBO.getProducerId() != null) {
                MemDetailQueryReqBO detailQueryReqBO = new MemDetailQueryReqBO();
                detailQueryReqBO.setMemId(agreementBO.getProducerId());
                MemDetailQueryRspBO detailQueryRspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(detailQueryReqBO);
                if ("0000".equals(detailQueryRspBO.getRespCode()) && detailQueryRspBO.getUmcMemDetailInfoAbilityRspBO() != null) {
                    agreementBO.setProducerPhone(detailQueryRspBO.getUmcMemDetailInfoAbilityRspBO().getRegMobile());
                }
            }
            agreementSkuInfo.setExtField2(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField2());
            agreementSkuInfo.setExtField3(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField3());
            agreementSkuInfo.setExtField1(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField1());
            agreementSkuInfo.setExtField1Str(qryAgreementDetailsRspBO.getAgrAgreementBO().getExtField1Str());
            if (agreementBO.getPrePaySup() == null) {
                agreementBO.setPrePaySup(BigDecimal.ZERO);
            }
            if (agreementBO.getVerPaySup() == null) {
                agreementBO.setVerPaySup(BigDecimal.ZERO);
            }
            if (agreementBO.getPilPaySup() == null) {
                agreementBO.setPilPaySup(BigDecimal.ZERO);
            }
            if (agreementBO.getQuaPaySup() == null) {
                agreementBO.setQuaPaySup(BigDecimal.ZERO);
            }
            if (qryAgreementDetailsRspBO.getAgrAgreementBO().getAgreementMode() != null) {
                agreementSkuInfo.setAgreementMode(String.valueOf(qryAgreementDetailsRspBO.getAgrAgreementBO().getAgreementMode()));
            }
            agreementSkuInfo.setAgreementBO(agreementBO);
        }
    }

    private void dealDataWithUccReturn(UocCreateOrderQryCommodityAtomServiceRspBo qryCommodityRspBo, UocProCreateOrderCombReqBo reqBo, Map<Long, UmcSupplierLinkManBO> supplierMap, UmcVatTaxRangeQryAbilityRspBO umcTaxRspBo) {
        BigDecimal total = new BigDecimal(0);
        List<UccMallSpuOrderListQueryBO> orderSpuList = qryCommodityRspBo.getOrderSpuList();
        HashMap<String, UccMallSkuDetailInfoBO> uccReturnSkuMap = new HashMap<String, UccMallSkuDetailInfoBO>();
        HashMap<Long, UccMallSpuOrderListQueryBO> uccReturnSpuMap = new HashMap<Long, UccMallSpuOrderListQueryBO>();
        HashSet<String> purOrdNameSet = new HashSet<String>();
        HashSet<Long> purSet = new HashSet<Long>();
        for (UccMallSpuOrderListQueryBO uccSpuBO : orderSpuList) {
            for (UccMallSkuDetailInfoBO uccSkuBo : uccSpuBO.getOrderSkuList()) {
                if (ObjectUtil.isEmpty((Object)uccSkuBo.getCommodityTypeId())) {
                    throw new UocProBusinessException("102106", "\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56deskuId(" + uccSkuBo.getCommodityTypeId() + ")\u5546\u54c1\u7c7b\u578bid\u4e3a\u7a7a\u4e86");
                }
                uccReturnSkuMap.put(uccSkuBo.getSkuId().toString(), uccSkuBo);
            }
            if (ObjectUtil.isEmpty((Object)uccSpuBO.getPurchasName())) {
                throw new UocProBusinessException("102106", "\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56de\u5546\u54c1(" + uccSpuBO.getCommodityName() + ")\u7684\u91c7\u8d2d\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
            }
            purOrdNameSet.add(uccSpuBO.getPurchasName());
            purSet.add(uccSpuBO.getPurchasId());
            uccReturnSpuMap.put(uccSpuBO.getCommodityId(), uccSpuBO);
        }
        UmcNcOrgQryListAbilityReqBO umcQryPurhcaseOrg = new UmcNcOrgQryListAbilityReqBO();
        umcQryPurhcaseOrg.setOrgIdList(new ArrayList(purSet));
        UmcNcOrgQryListAbilityRspBO umcNcOrgQryListAbilityRspBO = this.umcNcOrgQryListAbilityService.qryListNcOrg(umcQryPurhcaseOrg);
        if (!"0000".equals(umcNcOrgQryListAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException("102106", "\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u7ec4\u7ec7\u5931\u8d25\uff1a" + umcNcOrgQryListAbilityRspBO.getRespDesc());
        }
        List umcPurOrgList = umcNcOrgQryListAbilityRspBO.getRows();
        if (ObjectUtil.isEmpty((Object)umcPurOrgList)) {
            throw new UocProBusinessException("102106", "\u4f1a\u5458\u8fd4\u56de\u91c7\u8d2d\u7ec4\u7ec7\u4e3a\u7a7a");
        }
        if (umcPurOrgList.size() != purOrdNameSet.size()) {
            throw new UocProBusinessException("102106", "\u4f1a\u5458\u8fd4\u56de\u91c7\u8d2d\u7ec4\u7ec7\u6570\u91cf\u8ddf\u67e5\u8be2\u6570\u91cf\u4e0d\u7b49");
        }
        Map<Long, String> purOrgMap = umcPurOrgList.stream().collect(Collectors.toMap(UmcPurOrgNcBO::getOrgId, UmcPurOrgNcBO::getPkPurorg));
        for (UocProCreateOrderCombOrderItemReqBo skuInfo : reqBo.getOrderItemList()) {
            UccMallSkuDetailInfoBO uccRspSkuBo = (UccMallSkuDetailInfoBO)uccReturnSkuMap.get(skuInfo.getSkuId());
            UccMallSpuOrderListQueryBO uccRspSpuBo = (UccMallSpuOrderListQueryBO)uccReturnSpuMap.get(uccRspSkuBo.getCommodityId());
            BigDecimal itemFee = skuInfo.getPurchaseCount().multiply(UocMoneyUtil.long2BigDecimal((Long)uccRspSkuBo.getSalePrice()));
            total = total.add(itemFee);
            if (!new BigDecimal(-1).equals(uccRspSkuBo.getSkuStock()) && skuInfo.getPurchaseCount().compareTo(uccRspSkuBo.getSkuStock()) > 0) {
                throw new UocProBusinessException("102106", "\u5546\u54c1\u3010" + uccRspSkuBo.getSkuName() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
            }
            for (UmcVatTaxRangeQryRspBO item : umcTaxRspBo.getUmcVatTaxRangeQryRspBOS()) {
                if (!skuInfo.getSkuId().equals(item.getSkuId().toString())) continue;
                skuInfo.setRateCode(item.getSupTaxCode());
            }
            this.copyUccRetDataToUocSkuData(uccRspSkuBo, uccRspSpuBo, skuInfo, purOrgMap, supplierMap);
        }
        log.info("\u5916\u90e8\u4f20\u5165\u4ef7\u683c\uff1a" + reqBo.getCommodityTotalFee());
        log.info("\u5185\u90e8\u8ba1\u7b97\u4ef7\u683c\uff1a" + total);
        if (total.compareTo(reqBo.getCommodityTotalFee()) != 0) {
            throw new UocProBusinessException("102106", "\u67d0\u4e9b\u5546\u54c1\u4ef7\u683c\u53ef\u80fd\u5df2\u7ecf\u53d8\u5316\uff0c\u8bf7\u8fd4\u56de\u91cd\u65b0\u4e0b\u5355");
        }
    }

    private void copyUccRetDataToUocSkuData(UccMallSkuDetailInfoBO skuSource, UccMallSpuOrderListQueryBO spuSource, UocProCreateOrderCombOrderItemReqBo reqSkuInfo, Map<Long, String> purOrgMap, Map<Long, UmcSupplierLinkManBO> supplierMap) {
        BeanUtils.copyProperties((Object)skuSource, (Object)reqSkuInfo);
        reqSkuInfo.setSupplierName(spuSource.getSupplierName());
        reqSkuInfo.setContact(spuSource.getContact());
        reqSkuInfo.setRelPhone(spuSource.getRelPhone());
        reqSkuInfo.setArrivalTime("15");
        reqSkuInfo.setExchangeAllow(spuSource.getExchangeAllow());
        reqSkuInfo.setExchangeAllowDate(spuSource.getExchangeAllowDate());
        reqSkuInfo.setMaintainAllow(spuSource.getMaintainAllow());
        reqSkuInfo.setMaintainAllowDate(spuSource.getMaintainAllowDate());
        reqSkuInfo.setRejectAllow(spuSource.getRejectAllow());
        reqSkuInfo.setRejectAllowDate(spuSource.getRejectAllowDate());
        reqSkuInfo.setMeasureName(skuSource.getMeasureName());
        reqSkuInfo.setModel(skuSource.getModel());
        reqSkuInfo.setSelfSkuSupplierName(reqSkuInfo.getSkuSupplierName());
        reqSkuInfo.setSettlementUnit(skuSource.getSettlementUnit());
        reqSkuInfo.setSkuBrandName(skuSource.getBrandName());
        reqSkuInfo.setCommodityTypeId(skuSource.getCommodityTypeId());
        reqSkuInfo.setSkuCurrencyType("0");
        reqSkuInfo.setSkuCommodityTypeId(skuSource.getCommodityTypeId());
        reqSkuInfo.setSkuLocation(1);
        reqSkuInfo.setSupplierShopName(skuSource.getShopName());
        reqSkuInfo.setSkuUpcCode(skuSource.getUpcCode());
        reqSkuInfo.setTaxCode(spuSource.getTaxCode());
        reqSkuInfo.setSupplierId(spuSource.getVendorId());
        reqSkuInfo.setSupplierShopName(spuSource.getSupplierName());
        reqSkuInfo.setSkuSupplierId(spuSource.getVendorId());
        reqSkuInfo.setSupplierShopId(spuSource.getSupplierId());
        reqSkuInfo.setAddCoefficient(new BigDecimal(0));
        reqSkuInfo.setBrandId(spuSource.getBrandId());
        reqSkuInfo.setSkuExtSkuId(skuSource.getExtSkuId());
        reqSkuInfo.setSkuMarketPrice(new BigDecimal(skuSource.getMarketPrice()));
        reqSkuInfo.setSkuAgreementPrice(new BigDecimal(skuSource.getAgreementPrice()));
        reqSkuInfo.setSkuSalePrice(new BigDecimal(skuSource.getSalePrice()));
        reqSkuInfo.setTax(spuSource.getRate().longValue());
        reqSkuInfo.setSkuMainPicUrl(skuSource.getSkuMainPic());
        reqSkuInfo.setPurchasName(spuSource.getPurchasName());
        reqSkuInfo.setPurchasId(purOrgMap.get(spuSource.getPurchasId()));
        reqSkuInfo.setTax(spuSource.getRate().longValue());
        reqSkuInfo.setNakedPrice(skuSource.getUnRatePrice());
        reqSkuInfo.setSkuMaterialId(skuSource.getMaterialCode());
        reqSkuInfo.setSkuMaterialName(skuSource.getMaterialName());
        reqSkuInfo.setSupplierName(spuSource.getSupplierName());
        reqSkuInfo.setSkuSupplierName(spuSource.getSupplierName());
        reqSkuInfo.setNcSupplierCode(supplierMap.get(reqSkuInfo.getSupplierId()).getOrgCode());
        reqSkuInfo.setModel(skuSource.getModel());
        reqSkuInfo.setRelPhone(supplierMap.get(reqSkuInfo.getSupplierId()).getPhone());
        reqSkuInfo.setContact(supplierMap.get(reqSkuInfo.getSupplierId()).getLinkMan());
        reqSkuInfo.setL3catalog(spuSource.getCatalogId());
        reqSkuInfo.setMaterialCodeId(skuSource.getMaterialId());
        reqSkuInfo.setL3catalogName(spuSource.getCatalogName());
        reqSkuInfo.setOfferCycle(skuSource.getPreDeliverDay());
        if (reqSkuInfo.getOfferCycle() != null) {
            reqSkuInfo.setOfferDate(new DateTime((Object)new Date()).plusDays(reqSkuInfo.getOfferCycle().intValue()).toDate());
        } else {
            reqSkuInfo.setOfferCycle(this.offerCycle);
            reqSkuInfo.setOfferDate(new DateTime((Object)new Date()).plusDays(this.offerCycle.intValue()).toDate());
        }
        reqSkuInfo.setQuotationNum(spuSource.getAgrCode());
        reqSkuInfo.setQuotationLineNum(spuSource.getAgreeLine());
        reqSkuInfo.setNcMaterialCode(spuSource.getNcCode());
        reqSkuInfo.setEnterpriseCode(spuSource.getEnterpriseCode());
        reqSkuInfo.setQuotedUrl(spuSource.getQuotedUrl());
    }

    private UocCreateOrderQryCommodityAtomServiceReqBo buildQryCommodityReqBo(UocProCreateOrderCombReqBo reqBO) {
        UocCreateOrderQryCommodityAtomServiceReqBo qryCommReqBo = new UocCreateOrderQryCommodityAtomServiceReqBo();
        qryCommReqBo.setOrgId(reqBO.getOrgIdIn());
        UocProCreateOrderAddressReqBo addr = reqBO.getAddressBo();
        qryCommReqBo.setProvince(Long.parseLong(addr.getReceiverProvinceId()));
        qryCommReqBo.setCity(Long.parseLong(addr.getReceiverCityId()));
        qryCommReqBo.setCounty(Long.parseLong(addr.getReceiverCountyId()));
        qryCommReqBo.setTown(Long.parseLong(addr.getReceiverTownId()));
        qryCommReqBo.setCompanyId(reqBO.getCompanyId());
        qryCommReqBo.setIsprofess(reqBO.getIsprofess());
        qryCommReqBo.setPsDiscountRate(reqBO.getPsDiscountRate());
        qryCommReqBo.setOrgIdIn(reqBO.getOrgIdIn());
        qryCommReqBo.setCostType(reqBO.getCostType());
        List<UocProCreateOrderCombOrderItemReqBo> saleOrderItemList = reqBO.getOrderItemList();
        for (UocProCreateOrderCombOrderItemReqBo skuItemBo : saleOrderItemList) {
            UccMallSkuOrderQryReqBO commTmpBo = new UccMallSkuOrderQryReqBO();
            commTmpBo.setSkuId(Long.valueOf(Long.parseLong(skuItemBo.getSkuId())));
            commTmpBo.setSupplierShopId(skuItemBo.getSupplierShopId());
            commTmpBo.setNum(skuItemBo.getPurchaseCount());
            commTmpBo.setCommodityId(skuItemBo.getSpuId());
            qryCommReqBo.getSkuOrderList().add(commTmpBo);
        }
        return qryCommReqBo;
    }

    private void senMessage(UocProCreateOrderBusiRspBo reqOrderBo) {
        List<UocProCreateOrderBusiOrderDataRspBo> orderRspList = reqOrderBo.getOrderRspList();
        for (UocProCreateOrderBusiOrderDataRspBo uocProCreateOrderBusiOrderDataRspBo : orderRspList) {
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(uocProCreateOrderBusiOrderDataRspBo.getOrderId().longValue());
            UocQrySupIdAtomReqBo uocQrySupIdAtomReqBo = new UocQrySupIdAtomReqBo();
            uocQrySupIdAtomReqBo.setSupNo(stakeholderPO.getSupNo());
            UocQrySupIdAtomRspBo uocQrySupIdAtomRspBo = this.uocQrySupIdAtomService.getSupIds(uocQrySupIdAtomReqBo);
            OrdSalePO modelById = this.ordSaleMapper.getModelById(uocProCreateOrderBusiOrderDataRspBo.getSaleVoucherId().longValue());
            List<Long> supUserIds = uocQrySupIdAtomRspBo.getSupUserIds();
            for (Long supUserId : supUserIds) {
                UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
                sendMessageBo.setSendId(supUserId);
                sendMessageBo.setRecId(supUserId);
                sendMessageBo.setNoticeNodeCode("20005");
                sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", modelById.getSaleVoucherNo()));
                this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
            }
        }
    }
}

