/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.bo.other.UocProStationWebBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.uoc.busibase.busi.bo.QryOrgByUserStationReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgByUserStationRspBO;
import com.tydic.uoc.common.ability.bo.PebExtChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocTabsNumberQueryBO;
import com.tydic.uoc.common.busi.api.UocEsQryOrderListBusiService;
import com.tydic.uoc.common.busi.api.UocProSalesRemainingTimeQueryBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryOrderListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryOrderListRspBO;
import com.tydic.uoc.common.busi.bo.UocProSalesRemainingTimeQueryBusiReqBo;
import com.tydic.uoc.common.busi.bo.UocProSalesRemainingTimeQueryBusiRspBo;
import com.tydic.uoc.common.comb.api.UocSalesSingleDetailsListQueryCombService;
import com.tydic.uoc.common.comb.bo.AuthorityInfoBO;
import com.tydic.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.uoc.po.ConfTabOrdStatePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uocSalesSingleDetailsListQueryCombService")
public class UocSalesSingleDetailsListQueryCombServiceImpl
implements UocSalesSingleDetailsListQueryCombService {
    private static final Logger log = LoggerFactory.getLogger(UocSalesSingleDetailsListQueryCombServiceImpl.class);
    @Autowired
    private UocEsQryOrderListBusiService esQryOrderListBusiService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;
    @Autowired
    private UocProSalesRemainingTimeQueryBusiService salesRemainingTimeQueryBusiService;

    @Override
    public UocSalesSingleDetailsListQueryRspBO getSalesSingleDetailsListQuery(UocSalesSingleDetailsListQueryReqBO reqBO) {
        Map<Integer, ConfTabOrdStatePO> tabInfoMap;
        UocSalesSingleDetailsListQueryRspBO rspBO = new UocSalesSingleDetailsListQueryRspBO();
        Boolean isPermission = this.controlPermission(reqBO);
        UocEsQryOrderListReqBO esQryOrderListReqBO = (UocEsQryOrderListReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocEsQryOrderListReqBO.class);
        UocEsQryOrderListRspBO esQryOrderListRspBO = new UocEsQryOrderListRspBO();
        if (null != reqBO.getTabId()) {
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getSaleStateList())) {
                ArrayList<Integer> saleStateQuery = new ArrayList<Integer>(reqBO.getSaleStateList());
                if (null != reqBO.getSaleState()) {
                    saleStateQuery.add(reqBO.getSaleState());
                }
                esQryOrderListReqBO.setSaleStateQuery(saleStateQuery);
            } else if (null != reqBO.getSaleState()) {
                esQryOrderListReqBO.setSaleStateQuery(Collections.singletonList(reqBO.getSaleState()));
            }
            esQryOrderListReqBO.setSaleStateList(this.getStatueList(Collections.singletonList(reqBO.getTabId())).get(reqBO.getTabId()).getStatueList());
            if (isPermission.booleanValue() && !"0000".equals((esQryOrderListRspBO = this.esQryOrderListBusiService.qryEsOrderInfo(esQryOrderListReqBO)).getRespCode())) {
                throw new UocProBusinessException(esQryOrderListRspBO.getRespCode(), esQryOrderListRspBO.getRespDesc());
            }
            this.transEsQryOrderListRspBO(esQryOrderListRspBO, rspBO, isPermission, reqBO);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getTabIdList())) {
            esQryOrderListReqBO.setIsQueryTab(true);
            esQryOrderListReqBO.setStatisticsField(null);
            tabInfoMap = this.getStatueList(reqBO.getTabIdList());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getSaleStateList())) {
                ArrayList<Integer> saleStateQuery = new ArrayList<Integer>(reqBO.getSaleStateList());
                if (null != reqBO.getSaleState()) {
                    saleStateQuery.add(reqBO.getSaleState());
                }
                esQryOrderListReqBO.setSaleStateQuery(saleStateQuery);
            } else if (null != reqBO.getSaleState()) {
                esQryOrderListReqBO.setSaleStateQuery(Collections.singletonList(reqBO.getSaleState()));
            }
            esQryOrderListReqBO.setSaleStateList(tabInfoMap.get(0).getStatueList());
            if (isPermission.booleanValue() && !"0000".equals((esQryOrderListRspBO = this.esQryOrderListBusiService.qryEsOrderInfo(esQryOrderListReqBO)).getRespCode())) {
                throw new UocProBusinessException(esQryOrderListRspBO.getRespCode(), esQryOrderListRspBO.getRespDesc());
            }
            this.transOrderTabInfo(esQryOrderListRspBO, rspBO, tabInfoMap, isPermission);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getStatisticsField())) {
            esQryOrderListReqBO.setIsQueryTab(true);
            esQryOrderListReqBO.setStatisticsField(reqBO.getStatisticsField());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getTabIdList())) {
                tabInfoMap = this.getStatueList(reqBO.getTabIdList());
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getSaleStateList())) {
                    esQryOrderListReqBO.setSaleStateList(reqBO.getSaleStateList());
                } else if (null != reqBO.getSaleState()) {
                    esQryOrderListReqBO.setSaleStateList(Collections.singletonList(reqBO.getSaleState()));
                } else {
                    esQryOrderListReqBO.setSaleStateList(tabInfoMap.get(0).getStatueList());
                }
            }
            if (isPermission.booleanValue()) {
                esQryOrderListRspBO = this.esQryOrderListBusiService.qryEsOrderInfo(esQryOrderListReqBO);
                rspBO.setStatisticsFieldInfo(esQryOrderListRspBO.getStatisticsFieldInfo());
                if (!"0000".equals(esQryOrderListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esQryOrderListRspBO.getRespCode(), esQryOrderListRspBO.getRespDesc());
                }
            }
        }
        return rspBO;
    }

    private Map<Integer, ConfTabOrdStatePO> getStatueList(List<Integer> tabIds) {
        ConfTabOrdStatePO tabOrdStatePO = new ConfTabOrdStatePO();
        LinkedHashMap<Integer, ConfTabOrdStatePO> tabInfoMap = new LinkedHashMap<Integer, ConfTabOrdStatePO>(tabIds.size());
        tabOrdStatePO.setTabIdList(tabIds);
        List confTabOrdStatePOList = this.confTabOrdStateMapper.getList(tabOrdStatePO);
        Map<Integer, ConfTabOrdStatePO> tabOrdStatePOMap = confTabOrdStatePOList.stream().collect(Collectors.toMap(ConfTabOrdStatePO::getTabId, confTabOrdStatePO -> confTabOrdStatePO));
        ArrayList<Integer> statueList = new ArrayList<Integer>();
        if (CollectionUtils.isNotEmpty((Collection)confTabOrdStatePOList)) {
            for (Integer tabId : tabIds) {
                ConfTabOrdStatePO confTabOrdStatePO2 = tabOrdStatePOMap.get(tabId);
                if (null == confTabOrdStatePO2) continue;
                String statueStr = confTabOrdStatePO2.getOrderStatusCode();
                ArrayList<Integer> statueItemList = new ArrayList<Integer>();
                if (StringUtils.hasText((String)statueStr)) {
                    if (statueStr.contains(",")) {
                        String[] statue;
                        for (String state : statue = statueStr.split(",")) {
                            statueItemList.add(Integer.valueOf(state));
                            statueList.add(Integer.valueOf(state));
                        }
                    } else {
                        statueItemList.add(Integer.valueOf(statueStr));
                        statueList.add(Integer.valueOf(statueStr));
                    }
                }
                confTabOrdStatePO2.setStatueList(statueItemList);
                tabInfoMap.put(confTabOrdStatePO2.getTabId(), confTabOrdStatePO2);
            }
        } else {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u9875\u7b7e\uff08tabId\uff09\u914d\u7f6e\u4fe1\u606f");
        }
        ConfTabOrdStatePO confTabOrdStatePO3 = new ConfTabOrdStatePO();
        confTabOrdStatePO3.setStatueList(statueList.stream().distinct().collect(Collectors.toList()));
        tabInfoMap.put(0, confTabOrdStatePO3);
        return tabInfoMap;
    }

    private void transEsQryOrderListRspBO(UocEsQryOrderListRspBO esQryOrderListRspBO, UocSalesSingleDetailsListQueryRspBO rspBO, Boolean isPermission, UocSalesSingleDetailsListQueryReqBO reqBO) {
        if (isPermission.booleanValue()) {
            if (null != reqBO.getIsRemainingTime() && reqBO.getIsRemainingTime().booleanValue()) {
                this.getRemainingTimeInfo(esQryOrderListRspBO);
                if (MapUtils.isEmpty(esQryOrderListRspBO.getRemainingTimeInfoBoMap())) {
                    reqBO.setIsRemainingTime(Boolean.valueOf(false));
                }
            } else {
                reqBO.setIsRemainingTime(Boolean.valueOf(false));
            }
            rspBO.setPageNo(esQryOrderListRspBO.getPageNo());
            rspBO.setTotal(esQryOrderListRspBO.getTotal());
            rspBO.setRecordsTotal(esQryOrderListRspBO.getRecordsTotal());
            if (CollectionUtils.isNotEmpty((Collection)esQryOrderListRspBO.getRows())) {
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getTaskOperIdList()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                    ArrayList<String> taskOperIdList = new ArrayList<String>(reqBO.getTaskOperIdList().size() + 1);
                    taskOperIdList.addAll(reqBO.getTaskOperIdList());
                    taskOperIdList.add(reqBO.getTaskUserId());
                    this.judgeShowApproval(esQryOrderListRspBO, taskOperIdList);
                } else if (CollectionUtils.isNotEmpty((Collection)reqBO.getPriceTaskOperIdList()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
                    ArrayList<String> taskOperIdList = new ArrayList<String>(reqBO.getPriceTaskOperIdList().size() + 1);
                    taskOperIdList.addAll(reqBO.getPriceTaskOperIdList());
                    taskOperIdList.add(reqBO.getPriceTaskUserId());
                    this.judgeShowApproval(esQryOrderListRspBO, taskOperIdList);
                } else if (CollectionUtils.isNotEmpty((Collection)reqBO.getCancelTaskOperIdList()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getCancelTaskUserId())) {
                    ArrayList<String> taskOperIdList = new ArrayList<String>(reqBO.getCancelTaskOperIdList().size() + 1);
                    taskOperIdList.addAll(reqBO.getCancelTaskOperIdList());
                    taskOperIdList.add(reqBO.getCancelTaskUserId());
                    this.judgeShowApproval(esQryOrderListRspBO, taskOperIdList);
                } else {
                    for (PebExtUpperOrderAbilityBO upperOrderAbilityBO : esQryOrderListRspBO.getRows()) {
                        if (!reqBO.getIsRemainingTime().booleanValue()) continue;
                        ((PebExtChildOrderAbilityBO)upperOrderAbilityBO.getChildOrderList().get(0)).setRemainingTimeInfoBo(esQryOrderListRspBO.getRemainingTimeInfoBoMap().get(((PebExtChildOrderAbilityBO)upperOrderAbilityBO.getChildOrderList().get(0)).getOrderId()));
                    }
                }
            }
            rspBO.setRows(esQryOrderListRspBO.getRows());
        } else {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
    }

    private void transOrderTabInfo(UocEsQryOrderListRspBO esQryOrderListRspBO, UocSalesSingleDetailsListQueryRspBO rspBO, Map<Integer, ConfTabOrdStatePO> tabInfoMap, Boolean isPermission) {
        ArrayList<UocTabsNumberQueryBO> saleTabCountList = new ArrayList<UocTabsNumberQueryBO>();
        Map<String, Integer> tabCountsMap = esQryOrderListRspBO.getTabCountsMap();
        for (Map.Entry<Integer, ConfTabOrdStatePO> next : tabInfoMap.entrySet()) {
            if (next.getKey().equals(0)) continue;
            ConfTabOrdStatePO tabOrdStatePO = next.getValue();
            UocTabsNumberQueryBO tabsNumberQueryBO = new UocTabsNumberQueryBO();
            tabsNumberQueryBO.setTabId(tabOrdStatePO.getTabId() + "");
            tabsNumberQueryBO.setTabName(tabOrdStatePO.getTabName());
            int tabsCount = 0;
            if (isPermission.booleanValue()) {
                for (Integer statue : tabOrdStatePO.getStatueList()) {
                    Integer tabMapCounts = tabCountsMap.get(String.valueOf(statue));
                    if (tabMapCounts == null) continue;
                    tabsCount += tabMapCounts.intValue();
                }
            }
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(tabsCount));
            saleTabCountList.add(tabsNumberQueryBO);
        }
        rspBO.setSaleTabCountList(saleTabCountList);
    }

    private Boolean controlPermission(UocSalesSingleDetailsListQueryReqBO reqBO) {
        if (null != reqBO.getIsControlData() && reqBO.getIsControlData().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u5c97\u4f4d\u4fe1\u606f[umcStationsListWebExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> orderSourceList = new ArrayList<String>();
            for (UocProStationWebBO stationWebBO : reqBO.getUmcStationsListWebExt()) {
                if ("cs:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("2");
                } else if ("zq:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("1");
                }
                if (orderSourceList.size() != 2) continue;
                break;
            }
            if (orderSourceList.size() == 0) {
                return false;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderSourceList())) {
                reqBO.getOrderSourceList().removeIf(orderSource -> !orderSourceList.contains(orderSource));
            } else if (orderSourceList.size() < 2) {
                reqBO.setOrderSourceList(orderSourceList);
            }
        }
        if (null != reqBO.getIsControlPermission() && reqBO.getIsControlPermission().booleanValue()) {
            AuthorityInfoBO authorityInfoBO = this.getOrgInfo(reqBO);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getIsProfessionalOrgExt())) {
                if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
                    if (!authorityInfoBO.getViewAllFlag().booleanValue()) {
                        if (!CollectionUtils.isEmpty(authorityInfoBO.getOrgList()) || !CollectionUtils.isEmpty(authorityInfoBO.getOrgListThrough())) {
                            reqBO.setPurNo(null);
                            reqBO.setOrgList(authorityInfoBO.getOrgList());
                            reqBO.setOrgListThrough(authorityInfoBO.getOrgListThrough());
                        }
                        if (null == reqBO.getApporveFlag() || !reqBO.getApporveFlag().booleanValue()) {
                            reqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
                        }
                    } else {
                        reqBO.setPurNo(null);
                        reqBO.setPurNoList(null);
                        reqBO.setCreateOperId(null);
                    }
                } else if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                    if (!authorityInfoBO.getViewAllFlag().booleanValue()) {
                        reqBO.setOrgListPro(authorityInfoBO.getOrgList());
                        reqBO.setOrgListThroughPro(authorityInfoBO.getOrgListThrough());
                        if (null == reqBO.getApporveFlag() || !reqBO.getApporveFlag().booleanValue()) {
                            reqBO.setProDeliveryIdList(Collections.singletonList(String.valueOf(reqBO.getMemIdExt())));
                        }
                    } else {
                        reqBO.setProNoList(null);
                        reqBO.setProDeliveryIdList(null);
                    }
                } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                    reqBO.setSupNo(String.valueOf(reqBO.getSupId()));
                }
            } else if (!authorityInfoBO.getViewAllFlag().booleanValue()) {
                if (!CollectionUtils.isEmpty(authorityInfoBO.getOrgList()) || !CollectionUtils.isEmpty(authorityInfoBO.getOrgListThrough())) {
                    reqBO.setOrgList(authorityInfoBO.getOrgList());
                    reqBO.setOrgListThrough(authorityInfoBO.getOrgListThrough());
                    reqBO.setPurNo(null);
                }
                if (null == reqBO.getApporveFlag() || !reqBO.getApporveFlag().booleanValue()) {
                    reqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
                }
            } else {
                reqBO.setPurNo(null);
                reqBO.setPurNoList(null);
                reqBO.setCreateOperId(null);
            }
        }
        return true;
    }

    private AuthorityInfoBO getOrgInfo(UocSalesSingleDetailsListQueryReqBO reqBO) {
        QryOrgByUserStationReqBO qryOrgReqBO = new QryOrgByUserStationReqBO();
        if (null == reqBO.getMemIdExt() || 0L == reqBO.getMemIdExt()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        qryOrgReqBO.setMemIdExt(reqBO.getMemIdExt());
        qryOrgReqBO.setStationType("ORDER_QRY_ORG_AUTH");
        QryOrgByUserStationRspBO qryOrgRspBO = this.pebIntfQryOrgByUserStationAbilityService.qryOrgTreePathByUserStation(qryOrgReqBO);
        log.debug("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u673a\u6784\u5217\u8868\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString((Object)qryOrgRspBO));
        if (!"0000".equals(qryOrgRspBO.getRespCode())) {
            throw new UocProBusinessException(qryOrgRspBO.getRespCode(), qryOrgRspBO.getRespDesc());
        }
        AuthorityInfoBO authorityInfoBO = new AuthorityInfoBO();
        if (!qryOrgRspBO.getViewAllFlag().booleanValue()) {
            authorityInfoBO.setOrgList(qryOrgRspBO.getOrgList());
            authorityInfoBO.setOrgListThrough(qryOrgRspBO.getOrgListThrough());
        }
        authorityInfoBO.setViewAllFlag(qryOrgRspBO.getViewAllFlag());
        return authorityInfoBO;
    }

    private void judgeShowApproval(UocEsQryOrderListRspBO esQryOrderListRspBO, List<String> taskOperIdList) {
        block0: for (PebExtUpperOrderAbilityBO esQryOrderListSingleBO : esQryOrderListRspBO.getRows()) {
            PebExtChildOrderAbilityBO childOrderAbilityBO;
            Iterator iterator = esQryOrderListSingleBO.getChildOrderList().iterator();
            block1: while (iterator.hasNext() && (null == (childOrderAbilityBO = (PebExtChildOrderAbilityBO)iterator.next()).getIsShowApproval() || !childOrderAbilityBO.getIsShowApproval().booleanValue())) {
                if (CollectionUtils.isNotEmpty((Collection)childOrderAbilityBO.getTaskOperIdList())) {
                    block2: for (String taskOperId : taskOperIdList) {
                        if (null != childOrderAbilityBO.getIsShowApproval() && childOrderAbilityBO.getIsShowApproval().booleanValue()) continue block1;
                        for (String taskOperIdRsp : childOrderAbilityBO.getTaskOperIdList()) {
                            if (!taskOperId.equals(taskOperIdRsp)) continue;
                            childOrderAbilityBO.setIsShowApproval(Boolean.valueOf(true));
                            continue block2;
                        }
                    }
                    continue;
                }
                childOrderAbilityBO.setIsShowApproval(Boolean.valueOf(false));
                continue block0;
            }
        }
    }

    private void getRemainingTimeInfo(UocEsQryOrderListRspBO esQryOrderListRspBO) {
        UocProSalesRemainingTimeQueryBusiReqBo remainingTimeQueryBusiReqBo = new UocProSalesRemainingTimeQueryBusiReqBo();
        remainingTimeQueryBusiReqBo.setRemainingTimeInfoBoMap(esQryOrderListRspBO.getRemainingTimeInfoBoMap());
        remainingTimeQueryBusiReqBo.setFscExpTime(esQryOrderListRspBO.getFscExpTime());
        UocProSalesRemainingTimeQueryBusiRspBo salesRemainingTimeQueryBusiRspBo = this.salesRemainingTimeQueryBusiService.querySalesRemainingTime(remainingTimeQueryBusiReqBo);
        if (!"0000".equals(salesRemainingTimeQueryBusiRspBo.getRespCode())) {
            throw new UocProBusinessException(salesRemainingTimeQueryBusiRspBo.getRespCode(), salesRemainingTimeQueryBusiRspBo.getRespDesc());
        }
        esQryOrderListRspBO.setRemainingTimeInfoBoMap(esQryOrderListRspBO.getRemainingTimeInfoBoMap());
    }
}

