/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.config;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocOtherOrderSourceExecuteAtomService;
import com.tydic.uoc.common.atom.bo.UocOtherOrderSourceExecuteAtomGetCodeReqBo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UocOtherOrderSourceManager {
    private static final Logger log = LoggerFactory.getLogger(UocOtherOrderSourceManager.class);
    private final Map<String, UocOtherOrderSourceExecuteAtomService> manageMap = new ConcurrentHashMap<String, UocOtherOrderSourceExecuteAtomService>();

    public UocOtherOrderSourceExecuteAtomService getInstance(String orderSource) {
        UocOtherOrderSourceExecuteAtomService interObj = this.manageMap.get(orderSource);
        if (interObj == null) {
            throw new UocProBusinessException("107777", "\u4e0d\u540c\u8ba2\u5355\u6765\u6e90\u5b9e\u73b0\u7c7b\u7f16\u7801\uff08" + orderSource + "\uff09\u672a\u627e\u5230\u5b9e\u73b0\u7c7b");
        }
        return interObj;
    }

    protected void registerObj(UocOtherOrderSourceExecuteAtomService intObj) {
        Assert.notNull((Object)intObj, (String)"intObj can not be null");
        String orderSource = intObj.getSourceCode(new UocOtherOrderSourceExecuteAtomGetCodeReqBo()).getOrderSource();
        Assert.notNull((Object)orderSource, (String)"orderSource can not be null");
        UocOtherOrderSourceExecuteAtomService intRet = this.manageMap.get(orderSource);
        if (intRet != null) {
            throw new UocProBusinessException("107777", "\u4e0d\u540c\u8ba2\u5355\u6765\u6e90\u5b9e\u73b0\u7c7b\u7f16\u7801(" + orderSource + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info("UocOtherOrderSourceManager.registerObj\u6ce8\u518c\u4e86\u4e0d\u540c\u8ba2\u5355\u6765\u6e90\u5b9e\u73b0\u7c7b\uff1a" + orderSource);
        this.manageMap.put(orderSource, intObj);
    }
}

