/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.estore.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductReqBO;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductRspBO;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.CommodityAttrRspBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocEnterpriseAccountBO;
import com.tydic.uoc.common.atom.api.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreatePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateSaleOrderAtomService;
import com.tydic.uoc.common.atom.bo.AtomUocCoreCreateOrderReqBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsAttrBO;
import com.tydic.uoc.common.atom.bo.OrdGoodsBO;
import com.tydic.uoc.common.atom.bo.UocCoreAddOrdSaleCouponInfoBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateSaleOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderItemBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.uoc.common.atom.impl.UocProGetVoucherNoAtomService;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.ConfSupplierMapper;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdItemMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderReqBO;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderRspBO;
import com.tydic.uoc.estore.busi.api.PebExtThirdSupplierCreateOrderBusiService;
import com.tydic.uoc.po.ConfSupplierPO;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdItemMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtThirdSupplierCreateOrderBusiServiceImpl
implements PebExtThirdSupplierCreateOrderBusiService {
    @Autowired
    private UocCoreCreateOrderAtomService uocCoreCreateOrderAtomService;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private UocCoreCreateSaleOrderAtomService uocCoreCreateSaleOrderAtomService;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    private Logger log = LoggerFactory.getLogger(PebExtThirdSupplierCreateOrderBusiServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${SALE_NO_PRE:noValue}")
    private String saleNoPre;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Value(value="${SUPPLIER_JD_ID}")
    private String supplierJdId;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Value(value="${uoc.saveJdOrgId:false}")
    private Boolean saveJdOrgId;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    @Override
    public PebExtThirdSupplierCreateOrderRspBO dealPebExtThirdSupplierCreateOrder(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        List ordItemList;
        Long limit;
        PebExtThirdSupplierCreateOrderRspBO rspBO = new PebExtThirdSupplierCreateOrderRspBO();
        Long orderId = this.orderGenerateIdUtil.nextId();
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getAddressInfo());
        UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("102109", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = this.buildCreateSaleOrderParam(orderId, reqBO, uocCoreCreateLogisticsRelaRspBO.getContactId());
        uocCoreCreateSaleOrderReqBO.setProcKey(reqBO.getProcKey());
        this.log.debug("3.\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u9500\u552e\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2:" + uocCoreCreateSaleOrderReqBO.toString());
        Long saleFee = uocCoreCreateSaleOrderReqBO.getSaleFee();
        Long skuSupplierId = ((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierId();
        String supplierName = ((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierName();
        ConfSupplierPO qrySup = new ConfSupplierPO();
        qrySup.setSupNo(skuSupplierId);
        qrySup.setLimitStatus(Integer.valueOf(0));
        ConfSupplierPO modelBy = this.confSupplierMapper.getModelBy(qrySup);
        if (modelBy != null && (limit = modelBy.getOrderLimit()) != null && limit > 0L && limit > saleFee) {
            String money = null;
            try {
                money = UocMoneyUtil.long2BigDecimal((Long)limit).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new UocProBusinessException("102109", supplierName + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3" + money + "\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002");
        }
        UocCoreCreateSaleOrderRspBO uocCoreCreateSaleOrderRspBO = this.uocCoreCreateSaleOrderAtomService.dealCoreCreateSaleOrder(uocCoreCreateSaleOrderReqBO);
        if (!"0000".equals(uocCoreCreateSaleOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102109", uocCoreCreateSaleOrderRspBO.getRespDesc());
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(orderId);
        try {
            ordItemList = this.ordItemMapper.getList(ordItemPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102109", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5931\u8d25!");
        }
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = this.buildCreatePayOrderParm(ordItemList, reqBO, orderId, reqBO.getUserId(), uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        UocCoreCreatePayOrderRspBO uocCoreCreatePayOrderRspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
        if (!"0000".equals(uocCoreCreatePayOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102109", "\u652f\u4ed8\u5355\u521b\u5efa\u5931\u8d25!" + uocCoreCreatePayOrderRspBO.getRespDesc());
        }
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = this.buildCreateOrderParam(orderId, reqBO.getUserId(), reqBO);
        UocCoreCreateOrderRspBO uocCoreCreateOrderRspBO = this.uocCoreCreateOrderAtomService.dealCoreCreateOrder(uocCoreCreateOrderReqBO);
        if (!"0000".equals(uocCoreCreateOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("102109", "\u6838\u5fc3\u8ba2\u5355\u521b\u5efa\u5931\u8d25!" + uocCoreCreateOrderRspBO.getRespDesc());
        }
        this.saveAccessory(reqBO, orderId);
        this.saveExt(reqBO, orderId, ordItemList, rspBO);
        this.saveInvoice(reqBO, orderId, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        this.saveVendorOrderType(orderId, uocCoreCreateSaleOrderRspBO.getSaleVoucherId(), ordItemList);
        rspBO.setGoodsSupplierId(uocCoreCreateOrderReqBO.getSupId());
        rspBO.setGoodSupplierName(uocCoreCreateOrderReqBO.getSupName());
        rspBO.setSaleOrderId(String.valueOf(uocCoreCreateSaleOrderRspBO.getSaleVoucherId()));
        rspBO.setSaleOrderCode(uocCoreCreateSaleOrderReqBO.getSaleVoucherNo());
        rspBO.setOrderId(orderId);
        rspBO.setFee(reqBO.getTotalAmount());
        rspBO.setTotalfee(reqBO.getTotalAmount());
        this.savePay(reqBO, orderId, rspBO.getFee(), rspBO);
        return rspBO;
    }

    private void editOrgAmount(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        SgOrgAmountDeductReqBO sgOrgAmountDeductReqBO = new SgOrgAmountDeductReqBO();
        sgOrgAmountDeductReqBO.setAmount(reqBO.getTotalAmount().toString());
        sgOrgAmountDeductReqBO.setOrgId(reqBO.getOrgId());
        sgOrgAmountDeductReqBO.setBalanceType(PebExtConstant.BalanceType.ND);
        sgOrgAmountDeductReqBO.setOperType("2");
        SgOrgAmountDeductRspBO sgOrgAmountDeductRspBO = this.pebIntfSgOrgAmountDeductAbilityService.editOrgAmount(sgOrgAmountDeductReqBO);
        if (!("2".equals(reqBO.getMemUserType()) || "1".equals(reqBO.getMemUserType()) || "0000".equals(sgOrgAmountDeductRspBO.getRespCode()))) {
            throw new UocProBusinessException("102109", sgOrgAmountDeductRspBO.getRespDesc());
        }
    }

    private void saveInvoice(PebExtThirdSupplierCreateOrderReqBO reqBO, Long orderId, Long saleId) {
        if (reqBO.getInvoiceBO() != null) {
            Long contactId;
            if (reqBO.getInvoiceAddressInfo() != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getInvoiceAddressInfo());
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("102109", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
                contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
            } else {
                contactId = saleId;
            }
            Long id = this.idUtil.nextId();
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setInvoiceType(reqBO.getInvoiceBO().getInvoiceType());
            ordInvoicePO.setRelaEmail(reqBO.getInvoiceBO().getRelaEmail());
            ordInvoicePO.setInvoiceUrl(reqBO.getInvoiceBO().getInvoiceUrl());
            ordInvoicePO.setBankAccount(reqBO.getInvoiceBO().getBankAccount());
            ordInvoicePO.setBuyerName(reqBO.getInvoiceBO().getBuyerName());
            ordInvoicePO.setRelaPhone(reqBO.getInvoiceBO().getRelaPhone());
            ordInvoicePO.setOrderId(orderId);
            ordInvoicePO.setId(id);
            ordInvoicePO.setSaleVoucherId(contactId);
            ordInvoicePO.setCompanyAddress(reqBO.getInvoiceBO().getCompanyAddress());
            ordInvoicePO.setDepositBank(reqBO.getInvoiceBO().getDepositBank());
            ordInvoicePO.setFixPhone(reqBO.getInvoiceBO().getFixPhone());
            ordInvoicePO.setInvoiceNo(reqBO.getInvoiceBO().getInvoiceNo());
            ordInvoicePO.setInvoiceSn(reqBO.getInvoiceBO().getInvoiceSn());
            ordInvoicePO.setOutInvoiceId(reqBO.getInvoiceBO().getUmcInvoiceId());
            ordInvoicePO.setInvoceCategory(reqBO.getInvoiceBO().getInvoceCategory());
            this.ordInvoiceMapper.insert(ordInvoicePO);
        }
    }

    private void saveVendorOrderType(Long orderId, Long saleId, List<OrdItemPO> ordItemList) {
        HashSet<String> set = new HashSet<String>();
        for (OrdItemPO ordItemPO : ordItemList) {
            if (StringUtils.isBlank((CharSequence)ordItemPO.getUsedCompany())) {
                return;
            }
            set.add(ordItemPO.getUsedCompany());
        }
        if (set.size() == 1) {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            extMapPO.setFieldName("\u4f9b\u5e94\u5546\u8ba2\u5355\u7c7b\u578b");
            extMapPO.setFieldCode("vendorOrderType");
            extMapPO.setFieldValue(ordItemList.get(0).getUsedCompany());
            extMapPO.setOrderId(orderId);
            extMapPO.setObjId(saleId);
            extMapPO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.ordExtMapMapper.insert(extMapPO);
        }
    }

    private boolean isLast(BigDecimal used, BigDecimal pay) {
        return used.add(pay).compareTo(new BigDecimal(100)) == 0;
    }

    private long fee(BigDecimal total, BigDecimal use) {
        return total.multiply(use).multiply(new BigDecimal(100)).longValue();
    }

    private void savePay(PebExtThirdSupplierCreateOrderReqBO reqBO, Long orderId, BigDecimal fee, PebExtThirdSupplierCreateOrderRspBO rspBO) {
        if (reqBO.getPayConfig() == null) {
            return;
        }
        long prePayFee = 0L;
        long verPayFee = 0L;
        long pilPayFee = 0L;
        long quaPayFee = 0L;
        if (reqBO.getPayConfig().getDwnPaymentRatio() == null) {
            reqBO.getPayConfig().setDwnPaymentRatio(BigDecimal.ZERO);
        }
        if (reqBO.getPayConfig().getCheckPaymentRatio() == null) {
            reqBO.getPayConfig().setCheckPaymentRatio(BigDecimal.ZERO);
        }
        OrdPayConfPO confPo = new OrdPayConfPO();
        confPo.setId(Long.valueOf(this.idUtil.nextId()));
        confPo.setOrderId(orderId);
        confPo.setPaySubClass(reqBO.getPayConfig().getPaySubClass());
        confPo.setPaySubClassStr(reqBO.getPayConfig().getPaySubClassStr());
        confPo.setPaySubType(reqBO.getPayConfig().getPaySubType());
        try {
            confPo.setPayType(Integer.valueOf(Integer.parseInt(reqBO.getPayConfig().getPayType())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (reqBO.getPayConfig().getPayConfigDetailId() != null) {
            confPo.setPaySubTypeStr(reqBO.getPayConfig().getPayConfigDetailId().toString());
        }
        switch (reqBO.getPayConfig().getPayType()) {
            case "2": {
                confPo.setVerPaySup(new BigDecimal(100));
                break;
            }
            default: {
                confPo.setPrePaySup(reqBO.getPayConfig().getDwnPaymentRatio());
                confPo.setPilPaySup(reqBO.getPayConfig().getCheckPaymentRatio());
            }
        }
        if (confPo.getPrePaySup() != null) {
            BigDecimal pre = fee.multiply(confPo.getPrePaySup()).divide(new BigDecimal(100), 2, 0);
            try {
                prePayFee = UocMoneyUtil.bigDecimal2Long((BigDecimal)pre);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rspBO.setPayFee(pre);
        }
        confPo.setPrePayFee(Long.valueOf(prePayFee));
        confPo.setVerPayFee(Long.valueOf(verPayFee));
        confPo.setPilPayFee(Long.valueOf(pilPayFee));
        confPo.setQuaPayFee(Long.valueOf(quaPayFee));
        confPo.setPaymentDays(reqBO.getPayConfig().getDays());
        this.ordPayConfMapper.insert(confPo);
    }

    private void saveExt(PebExtThirdSupplierCreateOrderReqBO reqBO, Long orderId, List<OrdItemPO> ordItemList, PebExtThirdSupplierCreateOrderRspBO rspBO) {
        OrdExtMapPO transactionNoticeNo;
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        ArrayList<OrdItemMapPO> itemMapPOS = new ArrayList<OrdItemMapPO>();
        for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            if (skuInfo.getChannel() == null) continue;
            for (OrdItemPO itemPO : ordItemList) {
                if (!skuInfo.getSkuId().equals(itemPO.getSkuId())) continue;
                OrdExtMapPO extMapPO = new OrdExtMapPO();
                extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                extMapPO.setFieldValue(skuInfo.getChannel().toString());
                extMapPO.setFieldName("\u5546\u54c1\u9891\u9053");
                extMapPO.setFieldCode("channel");
                extMapPO.setOrderId(orderId);
                extMapPO.setObjId(itemPO.getOrdItemId());
                extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
                list.add(extMapPO);
                OrdItemMapPO mapPO = new OrdItemMapPO();
                mapPO.setOrderId(orderId);
                mapPO.setId(Long.valueOf(this.idUtil.nextId()));
                mapPO.setOrderItemId(itemPO.getOrdItemId());
                mapPO.setFieldValue(String.valueOf(skuInfo.getSoldNumber()));
                mapPO.setFieldName("\u5e93\u5b58");
                mapPO.setFieldCode("stock");
                itemMapPOS.add(mapPO);
            }
        }
        if (CollectionUtils.isNotEmpty(itemMapPOS)) {
            this.ordItemMapMapper.insertBatch(itemMapPOS);
        }
        String isMro = PebExtConstant.IsMro.YES.equals(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getIsMro()) && OrderPropertiesUtil.getProperty((String)"SUPPLIER_DELI_ID").equals(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGoodsSupplierId()) ? "2" : "1";
        rspBO.setIsMro(isMro);
        OrdExtMapPO mro = new OrdExtMapPO();
        mro.setId(Long.valueOf(this.idUtil.nextId()));
        mro.setFieldValue(isMro);
        mro.setFieldName("\u662f\u5426mro");
        mro.setFieldCode("contractType");
        mro.setOrderId(orderId);
        mro.setObjId(orderId);
        mro.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(mro);
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
        extMapPO.setFieldValue(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getPurchType().toString());
        extMapPO.setFieldName("\u91c7\u8d2d\u6a21\u5f0f");
        extMapPO.setFieldCode("purType");
        extMapPO.setOrderId(orderId);
        extMapPO.setObjId(orderId);
        extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
        list.add(extMapPO);
        OrdExtMapPO orderCategory = new OrdExtMapPO();
        orderCategory.setId(Long.valueOf(this.idUtil.nextId()));
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            orderCategory.setFieldValue("1");
        } else {
            orderCategory.setFieldValue("0");
        }
        orderCategory.setFieldName("\u5458\u5de5\u798f\u5229");
        orderCategory.setFieldCode("orderCategory");
        orderCategory.setOrderId(orderId);
        orderCategory.setObjId(orderId);
        orderCategory.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(orderCategory);
        if (reqBO.getPayConfig() != null && reqBO.getPayConfig().getPayType() != null) {
            OrdExtMapPO payType = new OrdExtMapPO();
            payType.setId(Long.valueOf(this.idUtil.nextId()));
            payType.setFieldValue(reqBO.getPayConfig().getPayType());
            payType.setFieldName("\u652f\u4ed8\u7c7b\u578b");
            payType.setFieldCode("payType");
            payType.setOrderId(orderId);
            payType.setObjId(orderId);
            payType.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(payType);
        }
        if (reqBO.getPayConfig() != null && reqBO.getPayConfig().getDays() != null && reqBO.getPayConfig().getDays() != null && reqBO.getPayConfig().getDays() != 0) {
            OrdExtMapPO paymentDays = new OrdExtMapPO();
            paymentDays.setId(Long.valueOf(this.idUtil.nextId()));
            paymentDays.setFieldValue(String.valueOf(reqBO.getPayConfig().getDays()));
            paymentDays.setFieldName("\u8d26\u671f\u5929\u6570");
            paymentDays.setFieldCode("paymentDays");
            paymentDays.setOrderId(orderId);
            paymentDays.setObjId(orderId);
            paymentDays.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(paymentDays);
        }
        OrdExtMapPO payBusiType = new OrdExtMapPO();
        payBusiType.setId(Long.valueOf(this.idUtil.nextId()));
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            payBusiType.setFieldValue("3");
        } else {
            payBusiType.setFieldValue("0");
        }
        payBusiType.setFieldName("\u4e1a\u52a1\u7c7b\u578b");
        payBusiType.setFieldCode("payBusiType");
        payBusiType.setOrderId(orderId);
        payBusiType.setObjId(orderId);
        payBusiType.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(payBusiType);
        OrdExtMapPO ecpPurType = new OrdExtMapPO();
        ecpPurType.setId(Long.valueOf(this.idUtil.nextId()));
        ecpPurType.setFieldValue(reqBO.getEcpPurType());
        ecpPurType.setFieldName("ecp\u91c7\u8d2d\u7c7b\u578b");
        ecpPurType.setFieldCode("ecpPurType");
        ecpPurType.setOrderId(orderId);
        ecpPurType.setObjId(orderId);
        ecpPurType.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(ecpPurType);
        OrdExtMapPO comOrgId = new OrdExtMapPO();
        comOrgId.setId(Long.valueOf(this.idUtil.nextId()));
        comOrgId.setFieldValue(reqBO.getCompanyId().toString());
        comOrgId.setFieldName("\u516c\u53f8id");
        comOrgId.setFieldCode("companyId");
        comOrgId.setOrderId(orderId);
        comOrgId.setObjId(orderId);
        comOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(comOrgId);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionNoticeNo())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldValue(reqBO.getTransactionNoticeNo());
            transactionNoticeNo.setFieldName("\u6210\u4ea4\u901a\u77e5\u4e66\u7f16\u53f7");
            transactionNoticeNo.setFieldCode("transactionNoticeNo");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionNoticeName())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldValue(reqBO.getTransactionNoticeName());
            transactionNoticeNo.setFieldName("\u6210\u4ea4\u901a\u77e5\u4e66\u540d\u79f0");
            transactionNoticeNo.setFieldCode("transactionNoticeName");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getComplianceTime())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldValue(reqBO.getComplianceTime());
            transactionNoticeNo.setFieldName("\u627f\u8bfa\u5230\u8d27\u65e5");
            transactionNoticeNo.setFieldCode("complianceTime");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryRequestMethod())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldValue(reqBO.getDeliveryRequestMethod());
            transactionNoticeNo.setFieldName("\u4ea4\u8d27\u671f\u8981\u6c42\u65b9\u5f0f");
            transactionNoticeNo.setFieldCode("deliveryRequestMethod");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (list.size() > 0) {
            this.ordExtMapMapper.insertBatch(list);
        }
    }

    private void saveAccessory(PebExtThirdSupplierCreateOrderReqBO reqBO, Long orderId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("\u53d6\u6d88\u7533\u8bf7");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private AtomUocCoreCreateOrderReqBO buildCreateOrderParam(Long orderId, Long userId, PebExtThirdSupplierCreateOrderReqBO reqBO) {
        Long saleFee;
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = new AtomUocCoreCreateOrderReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uocCoreCreateOrderReqBO);
        uocCoreCreateOrderReqBO.setUpperOrderId(reqBO.getPrOrderId());
        uocCoreCreateOrderReqBO.setName(reqBO.getName());
        uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getName());
        uocCoreCreateOrderReqBO.setUserId(reqBO.getUserId());
        uocCoreCreateOrderReqBO.setOrgId(reqBO.getOrgId());
        uocCoreCreateOrderReqBO.setCompanyId(reqBO.getCompanyId());
        uocCoreCreateOrderReqBO.setCompanyName(reqBO.getCompanyName());
        uocCoreCreateOrderReqBO.setOrderId(orderId);
        uocCoreCreateOrderReqBO.setOrderNo(ElUtils.long2String((Long)orderId));
        if (reqBO.getOrderType() == null) {
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.FL);
            } else {
                uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.TH);
            }
        } else {
            uocCoreCreateOrderReqBO.setOrderType(reqBO.getOrderType());
        }
        if (PebExtConstant.OrderType.DA.equals(reqBO.getOrderType())) {
            uocCoreCreateOrderReqBO.setOrderName(reqBO.getOrderName() + "\u7684\u91c7\u8d2d\u8ba2\u5355");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLoginSource())) {
            uocCoreCreateOrderReqBO.setExtField2(reqBO.getLoginSource());
        }
        if (((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getContractId() != null) {
            uocCoreCreateOrderReqBO.setExtField3(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getContractId().toString());
        }
        uocCoreCreateOrderReqBO.setPayType(ElUtils.integer2String((Integer)reqBO.getPayType()));
        uocCoreCreateOrderReqBO.setPayOrderId(reqBO.getPayOrderId());
        try {
            saleFee = UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBO.getTotalAmount());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102109", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
        }
        uocCoreCreateOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateOrderReqBO.setCreateOperId(ElUtils.long2String((Long)userId));
        uocCoreCreateOrderReqBO.setOrderDesc(reqBO.getComment());
        uocCoreCreateOrderReqBO.setPurId(reqBO.getPurchaserId());
        uocCoreCreateOrderReqBO.setPurName(reqBO.getPurchaserName());
        uocCoreCreateOrderReqBO.setPurAccount(ElUtils.long2String((Long)reqBO.getPurchaserAccount()));
        uocCoreCreateOrderReqBO.setPurPlaceOrderId(ElUtils.long2String((Long)userId));
        uocCoreCreateOrderReqBO.setPurPlaceOrderName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setUserType(reqBO.getMemUserType());
        if (reqBO.getOrgLevel() != null) {
            uocCoreCreateOrderReqBO.setOrgLevel(reqBO.getOrgLevel());
        }
        uocCoreCreateOrderReqBO.setPurOrgId(ElUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurOrgPath(reqBO.getOrgPath());
        if (StringUtils.isNotBlank((CharSequence)((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGoodsSupplierId())) {
            uocCoreCreateOrderReqBO.setSupId(Long.valueOf(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getGoodsSupplierId()));
        }
        uocCoreCreateOrderReqBO.setSupName(((PebExtThirdSupplierSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierName());
        uocCoreCreateOrderReqBO.setProId(ElUtils.long2String((Long)reqBO.getProfessionalOrganizationId()));
        uocCoreCreateOrderReqBO.setPurAccountOwnId(ElUtils.long2String((Long)reqBO.getPurchaserAccountOrgId()));
        UocEnterpriseAccountBO accountBO = reqBO.getAccountBO();
        if (accountBO != null) {
            uocCoreCreateOrderReqBO.setPurMobile(accountBO.getTelephone());
            uocCoreCreateOrderReqBO.setProName(accountBO.getDeliveryCenterName());
            uocCoreCreateOrderReqBO.setPurName(accountBO.getOrgName());
            uocCoreCreateOrderReqBO.setPurAccountName(accountBO.getAccountName());
        }
        uocCoreCreateOrderReqBO.setProAccountOwnName(reqBO.getProPath());
        if (reqBO.getAccountId() != null) {
            uocCoreCreateOrderReqBO.setProAccount(String.valueOf(reqBO.getAccountId()));
        }
        uocCoreCreateOrderReqBO.setPurLogName(reqBO.getCreateName());
        return uocCoreCreateOrderReqBO;
    }

    private UocCoreCreatePayOrderReqBO buildCreatePayOrderParm(List<OrdItemPO> ordItemList, PebExtThirdSupplierCreateOrderReqBO reqBO, Long orderId, Long userId, Long saleOrderId) {
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        Integer saleOrderClassify = reqBO.getSaleOrderClassify();
        uocCoreCreatePayOrderReqBO.setPayVoucherNo(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd") + orderId);
        uocCoreCreatePayOrderReqBO.setOrderId(orderId);
        uocCoreCreatePayOrderReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        uocCoreCreatePayOrderReqBO.setObjId(saleOrderId);
        uocCoreCreatePayOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        uocCoreCreatePayOrderReqBO.setPayType(reqBO.getPayType());
        uocCoreCreatePayOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        try {
            uocCoreCreatePayOrderReqBO.setTotalFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBO.getTotalAmount()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102109", "\u603b\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        try {
            uocCoreCreatePayOrderReqBO.setPayFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBO.getTotalAmount()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102109", "\u652f\u4ed8\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        uocCoreCreatePayOrderReqBO.setCreateOperId(ElUtils.long2String((Long)userId));
        if (saleOrderClassify.intValue() == PecConstant.SALE_ORDER_CLASSIFY_PERSONAGE.intValue()) {
            uocCoreCreatePayOrderReqBO.setPayState(PecConstant.PAY_STAT_WAIT);
        } else {
            uocCoreCreatePayOrderReqBO.setPayState(PecConstant.PAY_STAT_WAIT);
        }
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>();
        if (!CollectionUtils.isEmpty(ordItemList)) {
            OrdItemPO ordItemPO = null;
            UocOrderPayItemBO uocOrderPayItemBO = null;
            for (int i = 0; i < ordItemList.size(); ++i) {
                ordItemPO = ordItemList.get(i);
                uocOrderPayItemBO = new UocOrderPayItemBO();
                uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjId(ordItemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
                uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
                uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
                uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
                uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
                uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
                uocOrderPayItemBO.setPayCount(ordItemPO.getPurchaseCount());
                uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
                uocOrderPayItemBO.setPayFee(ordItemPO.getTotalSaleFee());
                uocOrderPayItemBOList.add(uocOrderPayItemBO);
            }
        }
        uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        return uocCoreCreatePayOrderReqBO;
    }

    private UocCoreCreateSaleOrderReqBO buildCreateSaleOrderParam(Long orderId, PebExtThirdSupplierCreateOrderReqBO reqBO, Long contactId) {
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = new UocCoreCreateSaleOrderReqBO();
        uocCoreCreateSaleOrderReqBO.setPayOrderId(reqBO.getPayOrderId());
        ArrayList<UocOrderItemBO> uocOrderItemList = new ArrayList<UocOrderItemBO>();
        List orderSaleItemList = reqBO.getSaleOrderItemList();
        if (CollectionUtils.isEmpty((Collection)orderSaleItemList)) {
            throw new UocProBusinessException("102109", "orderSaleItemList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long purchaseFee = 0L;
        BigDecimal totalAm = BigDecimal.ZERO;
        for (PebExtThirdSupplierSkuInfo skuInfo : orderSaleItemList) {
            UocOrderItemBO uocOrderItemBO = new UocOrderItemBO();
            uocOrderItemBO.setTaxId(skuInfo.getTaxCode());
            if (!ObjectUtil.isEmpty((Object)skuInfo.getPlanItemNo())) {
                uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
            }
            if (this.supplierJdId.equals(String.valueOf(skuInfo.getGoodsSupplierId()))) {
                uocOrderItemBO.setUsedCompany(skuInfo.getVendorOrderType());
            }
            uocOrderItemBO.setItemType(PecConstant.ORD_SALE_ITEM_TYPE_SKU);
            uocOrderItemBO.setSkuId(skuInfo.getSkuId() + "");
            uocOrderItemBO.setTaxId(skuInfo.getTaxCode());
            uocOrderItemBO.setSkuName(skuInfo.getSkuName());
            uocOrderItemBO.setSkuSimpleName(skuInfo.getSkuName());
            uocOrderItemBO.setSupNo(String.valueOf(skuInfo.getGoodsSupplierId()));
            uocOrderItemBO.setSupplierShopId(skuInfo.getSupplierShopId());
            Long skuSalePrice = 0L;
            Long skupurchasePrice = 0L;
            Long skuSaleFee = 0L;
            Long skuPurchaseFee = 0L;
            try {
                skuSalePrice = UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice());
                skupurchasePrice = UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice());
                BigDecimal divide = skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount());
                skuSaleFee = UocMoneyUtil.bigDecimalToLong((BigDecimal)divide);
                BigDecimal multiply = skuInfo.getSkuAgreementPrice().multiply(skuInfo.getPurchaseCount());
                skuPurchaseFee = UocMoneyUtil.bigDecimalToLong((BigDecimal)multiply);
                purchaseFee = purchaseFee + skuPurchaseFee;
                totalAm = totalAm.add(UocMoneyUtil.long2BigDecimal((Long)skuSaleFee));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("102109", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            uocOrderItemBO.setSalePrice(skuSalePrice);
            uocOrderItemBO.setPurchasePrice(skupurchasePrice);
            uocOrderItemBO.setTotalSaleFee(skuSaleFee);
            uocOrderItemBO.setTotalPurchaseFee(skuPurchaseFee);
            uocOrderItemBO.setCurrencyType(skuInfo.getSkuCurrencyType());
            uocOrderItemBO.setRecvAddr(skuInfo.getComparisonGoodsNo());
            uocOrderItemBO.setUnitName(skuInfo.getMeasureName());
            uocOrderItemBO.setSettleUnit(skuInfo.getSettlementUnit());
            uocOrderItemBO.setPurchaseCount(skuInfo.getPurchaseCount());
            if (skuInfo.getPlanItemId() != null) {
                uocOrderItemBO.setPlanItemId(skuInfo.getPlanItemId());
            }
            if (skuInfo.getPlanId() != null) {
                uocOrderItemBO.setPlanId(skuInfo.getPlanId());
            }
            OrdGoodsBO ordGoodsBO = new OrdGoodsBO();
            BeanUtils.copyProperties((Object)skuInfo, (Object)ordGoodsBO);
            ordGoodsBO.setSkuId(skuInfo.getSkuId() + "");
            ordGoodsBO.setSkuName(skuInfo.getSkuName());
            ordGoodsBO.setSkuSupplierId(skuInfo.getSkuSupplierId());
            ordGoodsBO.setSkuSupplierName(skuInfo.getSkuSupplierName());
            ordGoodsBO.setSkuMaterialId(skuInfo.getSkuMaterialId());
            ordGoodsBO.setSkuMaterialName(skuInfo.getSkuMaterialName());
            ordGoodsBO.setSkuExtSkuId(skuInfo.getSkuExtSkuId());
            ordGoodsBO.setSkuUpcCode(skuInfo.getSkuUpcCode());
            ordGoodsBO.setSkuCommodityTypeId(skuInfo.getSkuCommodityTypeId());
            ordGoodsBO.setSkuLocation(skuInfo.getSkuLocation());
            ordGoodsBO.setSkuMainPicUrl(skuInfo.getSkuMainPicUrl());
            ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
            ordGoodsBO.setSkuSaleArea(skuInfo.getSkuSaleArea());
            ordGoodsBO.setSkuStatus(skuInfo.getSkuStatus());
            ordGoodsBO.setSkuBrandId(ElUtils.string2Long((String)skuInfo.getBrandId()));
            ordGoodsBO.setSkuBrandName(skuInfo.getSkuBrandName());
            ordGoodsBO.setSkuIsSupplierAgreement(skuInfo.getSkuIsSupplierAgreement());
            try {
                ordGoodsBO.setSkuMarketPrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuMarketPrice()));
                ordGoodsBO.setSkuAgreementPrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice()));
                ordGoodsBO.setSkuMemberPrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuMemberPrice()));
                ordGoodsBO.setSkuSalePrice(UocMoneyUtil.bigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ordGoodsBO.setSkuCurrencyType(skuInfo.getSkuCurrencyType());
            ordGoodsBO.setSupplierShopId(skuInfo.getSupplierShopId());
            ArrayList<OrdGoodsAttrBO> ordGoodsAttrBOList = new ArrayList<OrdGoodsAttrBO>();
            if (CollectionUtils.isNotEmpty((Collection)skuInfo.getCommodityAttrList())) {
                for (CommodityAttrRspBO commodityAttrRspBO : skuInfo.getCommodityAttrList()) {
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(commodityAttrRspBO.getSkuCommodityPropGrpId());
                    ordGoodsAttrBO.setSkuCommoditySpecId(commodityAttrRspBO.getSkuCommoditySpecId());
                    ordGoodsAttrBO.setSkuPropName(commodityAttrRspBO.getSkuPropName());
                    ordGoodsAttrBO.setSkuPropShowName(commodityAttrRspBO.getSkuPropShowName());
                    ordGoodsAttrBO.setSkuPropValue(commodityAttrRspBO.getSkuPropValue());
                    ordGoodsAttrBO.setSkuPropValueListId(commodityAttrRspBO.getSkuPropValueListId());
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
            }
            ordGoodsBO.setOrdGoodsAttrBOList(ordGoodsAttrBOList);
            uocOrderItemBO.setOrdGoodsBO(ordGoodsBO);
            uocOrderItemBO.setSpuId(skuInfo.getSpuId() + "");
            uocOrderItemList.add(uocOrderItemBO);
        }
        reqBO.setTotalAmount(totalAm);
        uocCoreCreateSaleOrderReqBO.setSaleVoucherNo(this.buildNoNew("SALE_ORDER_NO", reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setPurchaseNo(this.buildNoNew("PUR_ORDER_NO", reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setOrderId(orderId);
        uocCoreCreateSaleOrderReqBO.setOrderLevel(reqBO.getSaleOrderClassify());
        uocCoreCreateSaleOrderReqBO.setOrderSource(reqBO.getOrderSource());
        uocCoreCreateSaleOrderReqBO.setPurchaseType(ElUtils.string2Integer((String)reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setIsDispatch(PecConstant.IS_DISPATCH_YES);
        Long base = 0L;
        Long remote = 0L;
        Long total = 0L;
        Long original = 0L;
        Long saleFee = 0L;
        try {
            total = UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBO.getTatleTransportationFee());
            saleFee = UocMoneyUtil.bigDecimal2Long((BigDecimal)reqBO.getTotalAmount());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("102109", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
        }
        uocCoreCreateSaleOrderReqBO.setBaseTransFee(base);
        uocCoreCreateSaleOrderReqBO.setRemoteTransFee(remote);
        uocCoreCreateSaleOrderReqBO.setTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setOldTotalTransFee(original);
        uocCoreCreateSaleOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateSaleOrderReqBO.setGiveTime(reqBO.getGiveTime());
        uocCoreCreateSaleOrderReqBO.setContactId(contactId);
        PebExtAddressInfoIntfceReqBO addressInfo = reqBO.getAddressInfo();
        uocCoreCreateSaleOrderReqBO.setAccNbr(addressInfo.getReceiverMobileNumber());
        uocCoreCreateSaleOrderReqBO.setProvinceId(addressInfo.getReceiverProvinceId());
        uocCoreCreateSaleOrderReqBO.setCityId(addressInfo.getReceiverCityId());
        uocCoreCreateSaleOrderReqBO.setAreaId(addressInfo.getReceiverCountyId());
        uocCoreCreateSaleOrderReqBO.setAddress(addressInfo.getReceiverAddress());
        uocCoreCreateSaleOrderReqBO.setPurchaseFee(purchaseFee);
        uocCoreCreateSaleOrderReqBO.setUocOrderItemList(uocOrderItemList);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            ArrayList<UocCoreAddOrdSaleCouponInfoBO> list = new ArrayList<UocCoreAddOrdSaleCouponInfoBO>();
            for (UocCoreActiveReqBO activeReqBO : reqBO.getActiveBOList()) {
                UocCoreAddOrdSaleCouponInfoBO infoBO = new UocCoreAddOrdSaleCouponInfoBO();
                infoBO.setCouponGranter("");
                infoBO.setCouponName(activeReqBO.getActiveName());
                infoBO.setCouponNo(activeReqBO.getActiveId());
                infoBO.setCouponValue(uocCoreCreateSaleOrderReqBO.getSaleFee());
                infoBO.setTypeName(activeReqBO.getTypeName());
                infoBO.setType("11111");
                list.add(infoBO);
            }
            uocCoreCreateSaleOrderReqBO.setUocCoreAddOrdSaleCouponInfoBOList(list);
            uocCoreCreateSaleOrderReqBO.setTotalIntegralFee(uocCoreCreateSaleOrderReqBO.getSaleFee());
            uocCoreCreateSaleOrderReqBO.setTotalUsedIntegral(uocCoreCreateSaleOrderReqBO.getSaleFee());
        }
        uocCoreCreateSaleOrderReqBO.setMergeOrderId(reqBO.getMergeOrderId());
        return uocCoreCreateSaleOrderReqBO;
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, PebExtAddressInfoIntfceReqBO addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        return uocCoreCreateLogisticsRelaReqBO;
    }

    private String buildNoNew(String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("102109", voucherNoRsp.getRespDesc());
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        String judgeExistPre = "noValue";
        if (!judgeExistPre.equals(this.saleNoPre) && StringUtils.isNotBlank((CharSequence)this.saleNoPre)) {
            no = no + this.saleNoPre;
        }
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherNo(no);
        int count = this.ordSaleMapper.getCheckBy(salePO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }
}

