/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.estore.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfGoodsListDelAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryEnterpriseAccountDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.QryEnterpriseAccountDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountRspBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.GoodsInfoIdBO;
import com.tydic.uoc.common.ability.bo.GoodsListDelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocEnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderReqBO;
import com.tydic.uoc.estore.ability.bo.PebExtThirdSupplierCreateOrderRspBO;
import com.tydic.uoc.estore.busi.api.PebExtThCreateOrderCheckBusiService;
import com.tydic.uoc.estore.busi.api.PebExtThirdSupplierCreateOrderBusiService;
import com.tydic.uoc.estore.comb.api.PebExtThirdSupplierCreateOrderCombService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtThirdSupplierCreateOrderCombServiceImpl
implements PebExtThirdSupplierCreateOrderCombService {
    @Autowired
    private PebExtThCreateOrderCheckBusiService pebExtThCreateOrderCheckBusiService;
    private static final Logger log = LoggerFactory.getLogger(PebExtThirdSupplierCreateOrderCombServiceImpl.class);
    @Autowired
    private PebIntfQryEnterpriseAccountDetailAbilityService pebIntfQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    @Autowired
    private PebExtThirdSupplierCreateOrderBusiService pebExtThirdSupplierCreateOrderBusiService;
    @Autowired
    private PebIntfGoodsListDelAbilityService pebIntfGoodsListDelAbilityService;
    @Resource(name="uocCreateOrderMsgProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_ORDER_CREATE_TAG}")
    private String tag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Value(value="${busiMode:0}")
    private String initBusiMode;
    @Value(value="${staff.welfare.pay.config.enable:false}")
    private boolean payConfig;
    @Value(value="${uoc.pay.notifyUrl}")
    private String notifyUrl;
    @Value(value="${uoc.pay.redirectUrl}")
    private String redirectUrl;
    @Value(value="${uoc.pay.wb.redirectUrl}")
    private String wbRedirectUrl;
    @Value(value="${uoc.pay.wb.dept.redirectUrl}")
    private String wbDeptRedirectUrl;

    @Override
    public PebExtThirdSupplierCreateOrderRspBO dealPebExtThirdSupplierCreateOrder(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSource())) {
            reqBO.setOrderSource(UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString());
        }
        EnterpriseAccountBO umcEnterpriseAccountBO = this.qryEnterpriseAccountDetail(reqBO);
        reqBO.setProfessionalOrganizationId(umcEnterpriseAccountBO.getDeliveryCenterId());
        reqBO.setPurchaserAccountOrgId(umcEnterpriseAccountBO.getOrgId());
        UocEnterpriseAccountBO uocEnterpriseAccountBO = new UocEnterpriseAccountBO();
        BeanUtils.copyProperties((Object)umcEnterpriseAccountBO, (Object)uocEnterpriseAccountBO);
        reqBO.setAccountBO(uocEnterpriseAccountBO);
        EnterpriseAccountBO enterpriseAccountBO = this.qryOrgEffAccount(umcEnterpriseAccountBO);
        if (enterpriseAccountBO != null) {
            reqBO.setAccountName(enterpriseAccountBO.getAccountName());
            reqBO.setAccountId(enterpriseAccountBO.getAccountId());
        }
        EnterpriseOrgDetailReqBO detailReqBO = new EnterpriseOrgDetailReqBO();
        detailReqBO.setOrgIdWeb(umcEnterpriseAccountBO.getDeliveryCenterId());
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4e3a\u7a7a");
        }
        reqBO.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        this.validateParams(reqBO);
        PebExtThirdSupplierCreateOrderRspBO rspBO = this.pebExtThCreateOrderCheckBusiService.dealPebCreateOrderCheck(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        ArrayList<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem = new ArrayList<PebExtThirdSupplierSubmitOrderSaleItemRspBO>();
        rspBO.setSubmitOrderSaleItem(submitOrderSaleItem);
        this.create(submitOrderSaleItem, reqBO.getSplitGoods(), reqBO, rspBO);
        this.create(submitOrderSaleItem, reqBO.getJcSplitGoods(), reqBO, rspBO);
        this.create(submitOrderSaleItem, reqBO.getMroSplitGoods(), reqBO, rspBO);
        this.create(submitOrderSaleItem, reqBO.getMroPlanSplitGoods(), reqBO, rspBO);
        this.jcCreate(submitOrderSaleItem, reqBO.getPlanSplitGoods(), reqBO, rspBO);
        this.jcCreate(submitOrderSaleItem, reqBO.getJcPlanSplitGoods(), reqBO, rspBO);
        this.jcCreate(submitOrderSaleItem, reqBO.getJcMroSplitGoods(), reqBO, rspBO);
        this.jcCreate(submitOrderSaleItem, reqBO.getJcMroPlanSplitGoods(), reqBO, rspBO);
        for (PebExtThirdSupplierSubmitOrderSaleItemRspBO tempBo : submitOrderSaleItem) {
            Boolean success = tempBo.getSuccess();
            String failMsg = tempBo.getFailMsg();
            if (success == null || success.booleanValue()) continue;
            rspBO = (PebExtThirdSupplierCreateOrderRspBO)UocProRspBoUtil.failed((String)failMsg, PebExtThirdSupplierCreateOrderRspBO.class);
            return rspBO;
        }
        return rspBO;
    }

    private void jcCreate(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, Map<String, List<PebExtThirdSupplierSkuInfo>> splitGoods, PebExtThirdSupplierCreateOrderReqBO reqBO, PebExtThirdSupplierCreateOrderRspBO rspBO) {
        for (String key : splitGoods.keySet()) {
            Map<Long, List<PebExtThirdSupplierSkuInfo>> skuInfo = splitGoods.get(key).stream().filter(item -> !ObjectUtil.isEmpty((Object)item.getPlanId())).collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getPlanId));
            for (Long planId : skuInfo.keySet()) {
                List<PebExtThirdSupplierSkuInfo> goods = skuInfo.get(planId);
                if (goods.get(0).getContractId() != null) {
                    Map<Long, List<PebExtThirdSupplierSkuInfo>> info = goods.stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getContractId));
                    for (Long contractId : info.keySet()) {
                        this.createPlanOrder(submitOrderSaleItem, reqBO, info.get(contractId));
                    }
                    continue;
                }
                this.createPlanOrder(submitOrderSaleItem, reqBO, goods);
            }
        }
    }

    private void create(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, Map<String, List<PebExtThirdSupplierSkuInfo>> splitGoods, PebExtThirdSupplierCreateOrderReqBO reqBO, PebExtThirdSupplierCreateOrderRspBO rspBO) {
        for (String key : splitGoods.keySet()) {
            List<PebExtThirdSupplierSkuInfo> goods = splitGoods.get(key);
            if (goods.get(0).getContractId() != null) {
                Map<Long, List<PebExtThirdSupplierSkuInfo>> skuInfo = goods.stream().collect(Collectors.groupingBy(PebExtThirdSupplierSkuInfo::getContractId));
                for (Long contractId : skuInfo.keySet()) {
                    this.createOrder(submitOrderSaleItem, reqBO, skuInfo.get(contractId));
                }
                continue;
            }
            this.createOrder(submitOrderSaleItem, reqBO, goods);
        }
    }

    private void createPlanOrder(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, PebExtThirdSupplierCreateOrderReqBO reqBO, List<PebExtThirdSupplierSkuInfo> goods) {
        reqBO.setSaleOrderItemList(goods);
        reqBO.setProcKey("cnnc_sales_order_master_order_status");
        reqBO.setJc(Boolean.valueOf(true));
        reqBO.setEcpPurType("1");
        PebExtThirdSupplierCreateOrderRspBO orderRspBO = this.pebExtThirdSupplierCreateOrderBusiService.dealPebExtThirdSupplierCreateOrder(reqBO);
        PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO = new PebExtThirdSupplierSubmitOrderSaleItemRspBO();
        if (!"0000".equals(orderRspBO.getRespCode())) {
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg(orderRspBO.getRespDesc());
            itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
            itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
        } else {
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setToken(reqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(reqBO.getUserId());
            itemRspBO.setOrgId(reqBO.getOrgId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setSaleOrderItemList(goods);
            itemRspBO.setCreateName(reqBO.getCreateName());
            this.savePlan(reqBO.getSaleOrderItemList());
            itemRspBO.setEcpPurType(reqBO.getEcpPurType());
            itemRspBO.setOrgPath(reqBO.getOrgPath());
            itemRspBO.setCompanyId(reqBO.getCompanyId());
            itemRspBO.setMemId(reqBO.getMemId());
            itemRspBO.setPayConfig(reqBO.getPayConfig());
            itemRspBO.setAccountId(reqBO.getPurchaserAccount());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            for (PebExtThirdSupplierSkuInfo info : reqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
                goodsInfoIdBO.setSkuId(info.getSkuId());
                goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
                goodsListDelReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
            }
            if (reqBO.getPayOrderId() == null) {
                this.uocPebOrdIdxSync(orderRspBO);
                this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
            } else {
                itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
            }
        }
        submitOrderSaleItem.add(itemRspBO);
    }

    private void createOrder(List<PebExtThirdSupplierSubmitOrderSaleItemRspBO> submitOrderSaleItem, PebExtThirdSupplierCreateOrderReqBO reqBO, List<PebExtThirdSupplierSkuInfo> goods) {
        reqBO.setSaleOrderItemList(goods);
        reqBO.setProcKey("cnnc_sales_order_master_order_status");
        reqBO.setJc(Boolean.valueOf(false));
        reqBO.setEcpPurType("1");
        PebExtThirdSupplierCreateOrderRspBO orderRspBO = this.pebExtThirdSupplierCreateOrderBusiService.dealPebExtThirdSupplierCreateOrder(reqBO);
        PebExtThirdSupplierSubmitOrderSaleItemRspBO itemRspBO = new PebExtThirdSupplierSubmitOrderSaleItemRspBO();
        if (!"0000".equals(orderRspBO.getRespCode())) {
            itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
            itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
            itemRspBO.setSuccess(Boolean.valueOf(false));
            itemRspBO.setFailMsg(orderRspBO.getRespDesc());
        } else {
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(reqBO.getUserId());
            itemRspBO.setOrgId(reqBO.getOrgId());
            itemRspBO.setToken(reqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setEcpPurType(reqBO.getEcpPurType());
            itemRspBO.setCreateName(reqBO.getCreateName());
            itemRspBO.setSaleOrderItemList(reqBO.getSaleOrderItemList());
            itemRspBO.setOrgPath(reqBO.getOrgPath());
            itemRspBO.setCompanyId(reqBO.getCompanyId());
            itemRspBO.setMemId(reqBO.getMemId());
            itemRspBO.setPayConfig(reqBO.getPayConfig());
            itemRspBO.setAccountId(reqBO.getPurchaserAccount());
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)reqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            for (PebExtThirdSupplierSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
                goodsListDelReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
                goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
            }
            if (reqBO.getPayOrderId() == null) {
                this.uocPebOrdIdxSync(orderRspBO);
                this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
                try {
                    log.debug("\u5220\u9664\u8d2d\u7269\u8f66" + JSON.toJSONString((Object)goodsListDelReqBO));
                    this.pebIntfGoodsListDelAbilityService.delGoodsList(goodsListDelReqBO);
                }
                catch (Exception e) {
                    log.debug("\u5220\u9664\u8d2d\u7269\u8f66\u5931\u8d25" + e);
                }
            } else {
                itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
            }
        }
        submitOrderSaleItem.add(itemRspBO);
    }

    private void savePlan(List<PebExtThirdSupplierSkuInfo> saleOrderItemList) {
    }

    private void uocPebOrdIdxSync(PebExtThirdSupplierCreateOrderRspBO rspBO) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setObjId(Long.valueOf(rspBO.getSaleOrderId()));
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        reqBO.setOrderId(rspBO.getOrderId());
        reqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }

    private EnterpriseAccountBO qryOrgEffAccount(EnterpriseAccountBO enterpriseAccountBO) {
        QryOrgEffAccountRspBO rspBO;
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(enterpriseAccountBO.getDeliveryCenterId());
        try {
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
            rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
            log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)rspBO));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("103030", "\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return null;
        }
        return (EnterpriseAccountBO)rspBO.getRows().get(0);
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        QryEnterpriseAccountDetailReqBO account = new QryEnterpriseAccountDetailReqBO();
        account.setAccountId(reqBO.getPurchaserAccount());
        log.debug("\u8d26\u5957\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)account));
        QryEnterpriseAccountDetailRspBO rspBO = this.pebIntfQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
        log.debug("\u8d26\u5957\u4fe1\u606f\u56de\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
        if (!"0000".equals(rspBO.getRespCode())) {
            log.error("\u8be5\u7ec4\u7ec7\u673a\u6784\u65e0\u53ef\u7528\u8d26\u5957,\u8bf7\u8054\u7cfb\u8be5\u673a\u6784\u7ba1\u7406\u5458\u521b\u5efa\u8d26\u5957" + rspBO.getRespDesc());
            throw new UocProBusinessException("103030", "\u8be5\u7ec4\u7ec7\u673a\u6784\u65e0\u53ef\u7528\u8d26\u5957,\u8bf7\u8054\u7cfb\u8be5\u673a\u6784\u7ba1\u7406\u5458\u521b\u5efa\u8d26\u5957");
        }
        EnterpriseAccountBO accountBO = rspBO.getUmcEnterpriseAccountBO();
        if (accountBO == null) {
            throw new UocProBusinessException("103030", "\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u673a\u6784\u7ba1\u7406\u5458\u521b\u5efa\u8d26\u5957\u8be6\u60c5");
        }
        return accountBO;
    }

    private void validateParams(PebExtThirdSupplierCreateOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalAmount()) {
            throw new UocProBusinessException("100002", "\u7ed3\u7b97\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserAccount()) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u8d26\u5957\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getGiveTime())) {
            throw new UocProBusinessException("100002", "\u9001\u8d27\u65f6\u95f4\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getUsername())) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgId()) {
            throw new UocProBusinessException("100002", "\u91c7\u8d2d\u4eba\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAddressInfo()) {
            throw new UocProBusinessException("100002", "\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverProvinceId())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u7701\u4efd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverProvinceName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCityId())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u57ce\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCityName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u57ce\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCountyId())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverCountyName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverName())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverMobileNumber())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverEmail())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAddressInfo().getReceiverAddress())) {
            throw new UocProBusinessException("100002", "\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderClassify()) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u6807\u5fd7[SaleOrderClassify]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List saleOrderInfoList = reqBO.getSaleOrderItemList();
        for (PebExtThirdSupplierSkuInfo skuInfo : saleOrderInfoList) {
            if (null == skuInfo.getGoodsSupplierId()) {
                throw new UocProBusinessException("100002", "\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuInfo.getSkuId()) {
                throw new UocProBusinessException("100002", "skuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuInfo.getPurchaseCount()) {
                throw new UocProBusinessException("100002", "\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != skuInfo.getSkuSalePrice()) continue;
            throw new UocProBusinessException("100002", "\u9500\u552e\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

