/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.task.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.common.ability.api.UccSyncSpuBuyItemAbilityService;
import com.tydic.commodity.common.ability.bo.UccSyncSpuBuyItemAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSyncSpuBuyItemAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSyncSpuBuyItemBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.bo.BgyDataKanbanQueryDaoReqBo;
import com.tydic.uoc.bo.BgyDataKanbanQueryDaoRspBo;
import com.tydic.uoc.common.ability.bo.BgyCommodityPurchaseRecordInfoBo;
import com.tydic.uoc.common.ability.bo.BgyCommodityPurchaseRecordListQueryReqBo;
import com.tydic.uoc.common.ability.bo.BgyCommodityPurchaseRecordListQueryRspBo;
import com.tydic.uoc.common.busi.api.BgyCommodityPurchaseRecordListQueryBusiService;
import com.tydic.uoc.config.ApplicationContextProvider;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.task.ability.api.BgyCommodityPurchaseRecordSyncAbilityService;
import com.tydic.uoc.task.ability.bo.BgyCommodityPurchaseRecordSyncAbilityReqBo;
import com.tydic.uoc.task.ability.bo.BgyCommodityPurchaseRecordSyncAbilityRspBo;
import com.tydic.uoc.task.busi.api.BgyCommodityPurchaseRecordSyncBusiService;
import com.tydic.uoc.task.busi.bo.BgyCommodityPurchaseRecordSyncBusiReqBo;
import com.tydic.uoc.task.busi.bo.BgyCommodityPurchaseRecordSyncBusiRspBo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BgyCommodityPurchaseRecordSyncAbilityServiceImpl
implements BgyCommodityPurchaseRecordSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyCommodityPurchaseRecordSyncAbilityServiceImpl.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private BgyCommodityPurchaseRecordSyncBusiService commodityPurchaseRecordSyncBusiService;
    @Autowired
    private BgyCommodityPurchaseRecordListQueryBusiService commodityPurchaseRecordListQueryBusiService;
    @Autowired
    private UccSyncSpuBuyItemAbilityService uccSyncSpuBuyItemAbilityService;

    @Override
    public BgyCommodityPurchaseRecordSyncAbilityRspBo syncCommodityPurchaseRecord(BgyCommodityPurchaseRecordSyncAbilityReqBo reqBo) {
        if (null == reqBo) {
            reqBo = new BgyCommodityPurchaseRecordSyncAbilityReqBo();
        }
        this.validateArgs(reqBo);
        BgyCommodityPurchaseRecordSyncAbilityRspBo rspBo = new BgyCommodityPurchaseRecordSyncAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        BgyDataKanbanQueryDaoReqBo toBeSyncCommodityQuantityReqBo = new BgyDataKanbanQueryDaoReqBo();
        LocalDateTime createTimeEff = LocalDateTime.now().withHour(0).withMinute(0).withSecond(0);
        toBeSyncCommodityQuantityReqBo.setCreateTimeEff(dateTimeFormatter.format(createTimeEff.minusDays(reqBo.getSyncDays().intValue())));
        toBeSyncCommodityQuantityReqBo.setCreateTimeExp(dateTimeFormatter.format(createTimeEff));
        toBeSyncCommodityQuantityReqBo.setSaleState(UocConstant.SALE_ORDER_STATUS.RECEIVED);
        toBeSyncCommodityQuantityReqBo.setRequestType(UocConstant.RequestType.CATALOG_IN);
        Integer toBeSyncCommodityQuantity = this.orderMapper.queryToBeSyncCommodityQuantity(toBeSyncCommodityQuantityReqBo);
        if (null != toBeSyncCommodityQuantity && toBeSyncCommodityQuantity > 0) {
            this.syncCommodity(reqBo, toBeSyncCommodityQuantity, toBeSyncCommodityQuantityReqBo);
            this.syncDataWithCommodityCenter(reqBo);
        }
        return rspBo;
    }

    private void syncDataWithCommodityCenter(BgyCommodityPurchaseRecordSyncAbilityReqBo reqBo) {
        int pageNo = 1;
        int total = 0;
        do {
            BgyCommodityPurchaseRecordListQueryReqBo commodityPurchaseRecordListQueryReqBo = new BgyCommodityPurchaseRecordListQueryReqBo();
            commodityPurchaseRecordListQueryReqBo.setPageNo(pageNo);
            commodityPurchaseRecordListQueryReqBo.setPageSize(reqBo.getCommoditySyncSize().intValue());
            BgyCommodityPurchaseRecordListQueryRspBo commodityPurchaseRecordListQueryRspBo = this.commodityPurchaseRecordListQueryBusiService.queryCommodityPurchaseRecordList(commodityPurchaseRecordListQueryReqBo);
            if (!"0000".equals(commodityPurchaseRecordListQueryRspBo.getRespCode())) {
                throw new UocProBusinessException(commodityPurchaseRecordListQueryRspBo.getRespCode(), commodityPurchaseRecordListQueryRspBo.getRespDesc());
            }
            UccSyncSpuBuyItemAbilityReqBO uccSyncSpuBuyItemAbilityReqBO = new UccSyncSpuBuyItemAbilityReqBO();
            if (0 == total) {
                total = commodityPurchaseRecordListQueryRspBo.getTotal();
            }
            uccSyncSpuBuyItemAbilityReqBO.setCount(Integer.valueOf(pageNo));
            ArrayList<UccSyncSpuBuyItemBO> uccSyncSpuBuyItemBOS = new ArrayList<UccSyncSpuBuyItemBO>(commodityPurchaseRecordListQueryRspBo.getRows().size());
            for (BgyCommodityPurchaseRecordInfoBo row : commodityPurchaseRecordListQueryRspBo.getRows()) {
                UccSyncSpuBuyItemBO uccSyncSpuBuyItemBO = new UccSyncSpuBuyItemBO();
                uccSyncSpuBuyItemBO.setSkuId(row.getSkuId());
                uccSyncSpuBuyItemBO.setItem(row.getProjectQuantity());
                uccSyncSpuBuyItemBO.setItemName(row.getProjectName());
                uccSyncSpuBuyItemBOS.add(uccSyncSpuBuyItemBO);
            }
            uccSyncSpuBuyItemAbilityReqBO.setItemList(uccSyncSpuBuyItemBOS);
            UccSyncSpuBuyItemAbilityRspBO uccSyncSpuBuyItemAbilityRspBO = this.uccSyncSpuBuyItemAbilityService.dealSyncSpuBuyItem(uccSyncSpuBuyItemAbilityReqBO);
            if ("0000".equals(uccSyncSpuBuyItemAbilityRspBO.getRespCode())) continue;
            throw new UocProBusinessException(uccSyncSpuBuyItemAbilityRspBO.getRespCode(), uccSyncSpuBuyItemAbilityRspBO.getRespDesc());
        } while (total >= ++pageNo);
    }

    private void validateArgs(BgyCommodityPurchaseRecordSyncAbilityReqBo reqBo) {
        if (null == reqBo.getSyncThreads() || reqBo.getSyncThreads() <= 0) {
            reqBo.setSyncThreads(4);
        }
        if (null == reqBo.getSyncDays() || reqBo.getSyncDays() <= 0) {
            reqBo.setSyncDays(30);
        }
        if (null == reqBo.getCommodityShardSize() || reqBo.getCommodityShardSize() <= 0) {
            reqBo.setSyncDays(10);
        }
    }

    private void syncCommodity(BgyCommodityPurchaseRecordSyncAbilityReqBo reqBo, Integer toBeSyncCommodityQuantity, BgyDataKanbanQueryDaoReqBo toBeSyncCommodityQuantityReqBo) {
        BgyCommodityPurchaseRecordSyncBusiReqBo commodityPurchaseRecordSyncBusiReqBo = new BgyCommodityPurchaseRecordSyncBusiReqBo();
        commodityPurchaseRecordSyncBusiReqBo.setOperationType(1);
        BgyCommodityPurchaseRecordSyncBusiRspBo commodityPurchaseRecordSyncBusiRspBo = this.commodityPurchaseRecordSyncBusiService.syncCommodityPurchaseRecord(commodityPurchaseRecordSyncBusiReqBo);
        if (!"0000".equals(commodityPurchaseRecordSyncBusiRspBo.getRespCode())) {
            throw new UocProBusinessException(commodityPurchaseRecordSyncBusiRspBo.getRespCode(), commodityPurchaseRecordSyncBusiRspBo.getRespDesc());
        }
        if (toBeSyncCommodityQuantity < reqBo.getSyncThreads()) {
            reqBo.setSyncThreads(toBeSyncCommodityQuantity);
        }
        log.info("-------\u591a\u7ebf\u7a0b\u540c\u6b65\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u6570\u636e\u5f00\u59cb\uff0c\u542f\u52a8\u7ebf\u7a0b\u6570\uff1a{}\uff0c\u5f85\u540c\u6b65\u5546\u54c1\u6570\u91cf\uff1a{}--------------", (Object)reqBo.getSyncThreads(), (Object)toBeSyncCommodityQuantity);
        CountDownLatch countDownLatch = new CountDownLatch(reqBo.getSyncThreads());
        int baseNum = toBeSyncCommodityQuantity / reqBo.getSyncThreads();
        int remainderNum = toBeSyncCommodityQuantity % reqBo.getSyncThreads();
        int end = 0;
        String toBeSyncCommodityString = JSON.toJSONString((Object)toBeSyncCommodityQuantityReqBo);
        for (int i = 0; i < reqBo.getSyncThreads(); ++i) {
            int start = end;
            end = start + baseNum;
            if (i == reqBo.getSyncThreads() - 1) {
                end = toBeSyncCommodityQuantity;
            } else if (i < remainderNum) {
                ++end;
            }
            HandleThread thread = new HandleThread(toBeSyncCommodityString, start, end, reqBo.getCommodityShardSize(), countDownLatch);
            thread.start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new UocProBusinessException("8888", "\u8ba1\u65f6\u5668\u7b49\u5f85\u5f02\u5e38\uff1a" + e.getMessage());
        }
        log.info("-------\u591a\u7ebf\u7a0b\u540c\u6b65\u5546\u54c1\u8d2d\u4e70\u8bb0\u5f55\u6570\u636e\u7ed3\u675f\uff0c\u51c6\u5907\u8fc1\u79fb\u5907\u4efd\u7d22\u5f15\u6570\u636e--------------");
        commodityPurchaseRecordSyncBusiReqBo.setOperationType(3);
        commodityPurchaseRecordSyncBusiRspBo = this.commodityPurchaseRecordSyncBusiService.syncCommodityPurchaseRecord(commodityPurchaseRecordSyncBusiReqBo);
        if (!"0000".equals(commodityPurchaseRecordSyncBusiRspBo.getRespCode())) {
            throw new UocProBusinessException(commodityPurchaseRecordSyncBusiRspBo.getRespCode(), commodityPurchaseRecordSyncBusiRspBo.getRespDesc());
        }
    }

    private static class HandleThread
    extends Thread {
        private final String toBeSyncCommodityString;
        private final Integer start;
        private final Integer end;
        private final Integer commodityShardSize;
        private final CountDownLatch countDownLatch;
        private final OrderMapper orderMapper;
        private final BgyCommodityPurchaseRecordSyncBusiService commodityPurchaseRecordSyncBusiService;

        public HandleThread(String toBeSyncCommodityString, Integer start, Integer end, Integer commodityShardSize, CountDownLatch countDownLatch) {
            this.toBeSyncCommodityString = toBeSyncCommodityString;
            this.start = start;
            this.end = end;
            this.commodityShardSize = commodityShardSize;
            this.countDownLatch = countDownLatch;
            this.orderMapper = (OrderMapper)ApplicationContextProvider.getBean(OrderMapper.class);
            this.commodityPurchaseRecordSyncBusiService = (BgyCommodityPurchaseRecordSyncBusiService)ApplicationContextProvider.getBean(BgyCommodityPurchaseRecordSyncBusiService.class);
        }

        @Override
        public void run() {
            BgyDataKanbanQueryDaoReqBo toBeSyncCommodityDataReqBo = (BgyDataKanbanQueryDaoReqBo)JSON.parseObject((String)this.toBeSyncCommodityString, BgyDataKanbanQueryDaoReqBo.class);
            toBeSyncCommodityDataReqBo.setStart(this.start);
            toBeSyncCommodityDataReqBo.setEnd(this.end);
            List skuIdList = this.orderMapper.queryToBeSyncSkuId(toBeSyncCommodityDataReqBo);
            int fromIndex = 0;
            int toIndex = skuIdList.size() < this.commodityShardSize ? skuIdList.size() - 1 : this.commodityShardSize;
            while (skuIdList.size() > toIndex) {
                List subList = skuIdList.subList(fromIndex, toIndex);
                int thisFromIndex = fromIndex;
                fromIndex = toIndex;
                if (skuIdList.size() <= (toIndex += this.commodityShardSize.intValue())) {
                    subList = skuIdList.subList(thisFromIndex, skuIdList.size());
                }
                toBeSyncCommodityDataReqBo.setSkuIdList(subList);
                toBeSyncCommodityDataReqBo.setQueryType(Integer.valueOf(1));
                List shardToBeSyncRequestManDataBos = this.orderMapper.queryToBeSyncRequestManOrProjectData(toBeSyncCommodityDataReqBo);
                toBeSyncCommodityDataReqBo.setQueryType(Integer.valueOf(2));
                List shardToBeSyncProjectDataBos = this.orderMapper.queryToBeSyncRequestManOrProjectData(toBeSyncCommodityDataReqBo);
                Map shardToBeSyncRequestManDataMap = shardToBeSyncRequestManDataBos.stream().collect(Collectors.groupingBy(BgyDataKanbanQueryDaoRspBo::getSkuId, Collectors.mapping(BgyDataKanbanQueryDaoRspBo::getRequestManName, Collectors.toList())));
                Map shardToBeSyncProjectDataMap = shardToBeSyncProjectDataBos.stream().collect(Collectors.groupingBy(BgyDataKanbanQueryDaoRspBo::getSkuId, Collectors.mapping(BgyDataKanbanQueryDaoRspBo::getProjectName, Collectors.toList())));
                for (Long skuId : toBeSyncCommodityDataReqBo.getSkuIdList()) {
                    BgyCommodityPurchaseRecordSyncBusiReqBo commodityPurchaseRecordSyncBusiReqBo = new BgyCommodityPurchaseRecordSyncBusiReqBo();
                    commodityPurchaseRecordSyncBusiReqBo.setOperationType(2);
                    commodityPurchaseRecordSyncBusiReqBo.setSkuId(skuId);
                    commodityPurchaseRecordSyncBusiReqBo.setRequestManList(shardToBeSyncRequestManDataMap.get(skuId));
                    commodityPurchaseRecordSyncBusiReqBo.setProjectList(shardToBeSyncProjectDataMap.get(skuId));
                    commodityPurchaseRecordSyncBusiReqBo.setProjectQuantity(commodityPurchaseRecordSyncBusiReqBo.getProjectList().size());
                    commodityPurchaseRecordSyncBusiReqBo.setProjectName((String)commodityPurchaseRecordSyncBusiReqBo.getProjectList().get(0));
                    this.commodityPurchaseRecordSyncBusiService.syncCommodityPurchaseRecord(commodityPurchaseRecordSyncBusiReqBo);
                }
            }
            this.countDownLatch.countDown();
        }
    }
}

