/*
 * Decompiled with CFR 0.152.
 */
package com.bjzw.datasync.controller;

import com.alibaba.fastjson.JSON;
import com.bjzw.datasync.api.SyncServiceApi;
import com.bjzw.datasync.api.bo.SMattersTabBO;
import com.bjzw.datasync.api.bo.SOrgInfoBO;
import com.bjzw.datasync.bo.QueryCondition;
import com.bjzw.datasync.utils.SyncUtils;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sync"})
public class MattersController {
    private static final Logger log = LoggerFactory.getLogger(MattersController.class);
    @Resource
    private SyncServiceApi syncServiceApi;
    @Resource
    SyncUtils syncUtils;

    @PostMapping(value={"remote/query"})
    public Rsp queryOrgList(@RequestBody QueryCondition req) {
        log.info("\u8fdc\u7a0b\u63a5\u53e3\u8c03\u7528 :{}", (Object)JSON.toJSONString((Object)req));
        String res = this.syncUtils.invokeRemoteApi(req.getRemoteUrl(), null);
        return BaseRspUtils.createSuccessRsp((Object)res);
    }

    @PostMapping(value={"org/query"})
    public RspList query(@RequestBody SOrgInfoBO req) {
        return this.syncServiceApi.queryOrgList(req);
    }

    @PostMapping(value={"matters/query"})
    public RspList query(@RequestBody SMattersTabBO req) {
        return this.syncServiceApi.queryMatters(req);
    }
}

