/*
 * Decompiled with CFR 0.152.
 */
package com.bjzw.datasync.utils;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(AesUtils.class);

    public static String base64decode(byte[] bytes) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64((byte[])bytes), "UTF-8");
    }

    public static String aesDecrypt(String content, String aesKey) {
        try {
            Key key = AesUtils.initKeyForAES(aesKey);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] encrypted = Base64.decodeBase64((String)content);
            byte[] result = cipher.doFinal(encrypted);
            String str = new String(result, "utf-8");
            return str;
        }
        catch (Exception e) {
            LOGGER.error("AES\u89e3\u5bc6\u5931\u8d25:" + e);
            return null;
        }
    }

    static Key initKeyForAES(String key) throws NoSuchAlgorithmException {
        SecretKeySpec key2 = null;
        try {
            if (null == key || key.length() == 0) {
                throw new NullPointerException("key not is null");
            }
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key.getBytes());
            try {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128, random);
                SecretKey secretKey = kgen.generateKey();
                byte[] enCodeFormat = secretKey.getEncoded();
                key2 = new SecretKeySpec(enCodeFormat, "AES");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new NoSuchAlgorithmException();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return key2;
    }
}

